/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.impl.DataDescriptorImpl;
import oracle.bali.dbUI.util.sql.SQLGenerator;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;
import oracle.bali.share.util.IntegerUtils;

public class JDBCModel
implements TwoDModel,
DataDescriptorProvider,
Constrainable,
Sortable {
    private ArrayTwoDModel _data;
    private DataDescriptor[] _descriptors;
    private DataConstraint _constraint;
    private String _originalQuery;
    private String _constraintQuery;
    private String _sortQuery;
    private Connection _connection;
    ResultSetMetaData _metaData;
    private DataTask _task;
    private TaskScheduler _scheduler;
    private Column[] _columns;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;

    public JDBCModel(Connection connection, Column[] columnArray, DataConstraint dataConstraint, Relationship[] relationshipArray, OuterJoin[] outerJoinArray) throws SQLException {
        String string = SQLGenerator.getSQLGenerator().getSQLString(columnArray, dataConstraint, relationshipArray, outerJoinArray);
        this._data = new ArrayTwoDModel(0, 0);
        if (columnArray != null) {
            this._columns = new Column[columnArray.length];
            System.arraycopy(columnArray, 0, this._columns, 0, columnArray.length);
        }
        this._connection = connection;
        this._originalQuery = string;
        this._scheduler = new TaskScheduler();
        if (string != null) {
            this._originalQuery = string;
            this._query();
        }
    }

    public JDBCModel(Connection connection, String string) throws SQLException {
        this._data = new ArrayTwoDModel(0, 0);
        this._connection = connection;
        this._originalQuery = string;
        this._scheduler = new TaskScheduler();
        if (string != null) {
            this._originalQuery = string;
            this._query();
        }
    }

    public int getColumnCount() {
        return this._data.getColumnCount();
    }

    public int getRowCount() {
        return this._data.getRowCount();
    }

    public Object getData(int n, int n2) {
        return this._data.getData(n, n2);
    }

    public void setData(int n, int n2, Object object) {
        throw new RuntimeException("setData not supported.");
    }

    public void addModelListener(TwoDModelListener twoDModelListener) {
        this._data.addModelListener(twoDModelListener);
    }

    public void removeModelListener(TwoDModelListener twoDModelListener) {
        this._data.removeModelListener(twoDModelListener);
    }

    public void setDataConstraint(DataConstraint dataConstraint) {
        String string = SQLGenerator.getSQLGenerator().getSQLString(null, dataConstraint, null, null);
        if (string == null && this._constraintQuery == null) {
            return;
        }
        if (string != null && this._constraintQuery != null && string.equals(this._constraintQuery)) {
            return;
        }
        this._constraintQuery = string;
        try {
            this._query();
        }
        catch (SQLException sQLException) {
            System.err.println("An exception occurred in setDataConstraint: " + sQLException);
        }
    }

    public DataConstraint getDataConstraint() {
        return this._constraint;
    }

    public void sort(int n, boolean bl) {
        try {
            String string = this.getDescriptor(n).getName();
            this._sortQuery = string + " " + (bl ? "ASC" : "DESC");
            this._query();
        }
        catch (SQLException sQLException) {
            System.err.println("An exception occurred in sort: " + sQLException);
        }
    }

    public int getDescriptorCount() {
        return this.getColumnCount();
    }

    public DataDescriptor getDescriptor(int n) {
        if (this._descriptors == null) {
            this._createDescriptors();
        }
        return this._descriptors[n];
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    void _setData(int n, int n2, Object object) {
        this._data.setData(n, n2, object);
    }

    private DataDescriptor _createDescriptor(int n) {
        Object object;
        boolean bl;
        Class clazz;
        String string;
        String string2;
        try {
            if (this._columns != null) {
                Column column = this._columns[n];
                string2 = column.getName();
                if (string2.indexOf(".") == -1) {
                    string2 = column.getTable().getName() + "." + string2;
                }
                string = column.getDisplayName(Locale.getDefault());
                clazz = column.getDataType();
                bl = column.isNullAllowed();
                object = column.getDefaultValue();
            } else {
                String string3 = this._metaData.getTableName(++n);
                string2 = this._metaData.getColumnName(n);
                if (string3 != null && string3 != "") {
                    string2 = string3 + "." + string2;
                }
                string = this._metaData.getColumnLabel(n);
                int n2 = this._metaData.getScale(n);
                clazz = this._getColumnDataType(n, n2);
                int n3 = this._metaData.isNullable(n);
                bl = n3 == 1;
                object = null;
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
            return null;
        }
        return new DataDescriptorImpl(clazz, string2, string, bl, object);
    }

    private void _createDescriptors() {
        int n = this.getColumnCount();
        this._descriptors = new DataDescriptor[n];
        int n2 = 0;
        while (n2 < n) {
            this._descriptors[n2] = this._createDescriptor(n2);
            ++n2;
        }
    }

    private Class _getColumnDataType(int n, int n2) throws SQLException {
        Class clazz;
        int n3 = this._metaData.getColumnType(n);
        switch (n3) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                clazz = class$java$lang$Integer == null ? (class$java$lang$Integer = JDBCModel.class$("java.lang.Integer")) : class$java$lang$Integer;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                clazz = class$java$lang$Object == null ? (class$java$lang$Object = JDBCModel.class$("java.lang.Object")) : class$java$lang$Object;
                break;
            }
            case -7: {
                clazz = class$java$lang$Boolean == null ? (class$java$lang$Boolean = JDBCModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                break;
            }
            case 91: {
                clazz = class$java$sql$Date == null ? (class$java$sql$Date = JDBCModel.class$("java.sql.Date")) : class$java$sql$Date;
                break;
            }
            case 92: {
                clazz = class$java$sql$Time == null ? (class$java$sql$Time = JDBCModel.class$("java.sql.Time")) : class$java$sql$Time;
                break;
            }
            case 93: {
                clazz = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JDBCModel.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (n2 == 0) {
                    clazz = class$java$lang$Long == null ? (class$java$lang$Long = JDBCModel.class$("java.lang.Long")) : class$java$lang$Long;
                    break;
                }
                clazz = class$java$lang$Double == null ? (class$java$lang$Double = JDBCModel.class$("java.lang.Double")) : class$java$lang$Double;
                break;
            }
            case 6: {
                clazz = class$java$lang$Float == null ? (class$java$lang$Float = JDBCModel.class$("java.lang.Float")) : class$java$lang$Float;
                break;
            }
            case 1: {
                clazz = class$java$lang$Character == null ? (class$java$lang$Character = JDBCModel.class$("java.lang.Character")) : class$java$lang$Character;
                break;
            }
            case -1: 
            case 12: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = JDBCModel.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz;
    }

    private void _query() throws SQLException {
        if (this._originalQuery == null) {
            return;
        }
        if (this._task != null) {
            this._scheduler.cancel((Task)this._task);
            this._task.cancel();
        }
        this._task = null;
        String string = this._originalQuery;
        if (this._constraintQuery != null) {
            string = this._originalQuery.toUpperCase().indexOf("WHERE") == -1 ? string + " WHERE " + this._constraintQuery : string + " AND (" + this._constraintQuery + ")";
        }
        if (this._sortQuery != null) {
            string = string + " order by " + this._sortQuery;
        }
        PreparedStatement preparedStatement = this._connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        this._metaData = resultSet.getMetaData();
        int n = this._metaData.getColumnCount();
        int n2 = this.getColumnCount();
        if (n2 != n) {
            if (n2 != 0) {
                this._data.removeColumns(0, n2);
            }
            this._data.addColumns(0, n);
        }
        if (this._columns == null && this._descriptors == null) {
            this._createDescriptors();
        }
        this._task = new DataTask(resultSet, preparedStatement);
        this._scheduler.schedule((Task)this._task, 0);
    }

    Object _getColumnData(ResultSet resultSet, int n) throws SQLException {
        Object object;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        int n3 = resultSetMetaData.getScale(n);
        switch (n2) {
            case 91: {
                object = resultSet.getDate(n);
                break;
            }
            case 92: {
                object = resultSet.getTime(n);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(n);
                break;
            }
            case -7: {
                boolean bl = resultSet.getBoolean(n);
                object = resultSet.wasNull() ? null : (bl ? Boolean.TRUE : Boolean.FALSE);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                int n4 = resultSet.getInt(n);
                object = resultSet.wasNull() ? null : IntegerUtils.getInteger((int)n4);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                object = resultSet.getObject(n);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (n3 == 0) {
                    long l = resultSet.getLong(n);
                    object = resultSet.wasNull() ? null : new Long(l);
                    break;
                }
                double d = resultSet.getDouble(n);
                object = resultSet.wasNull() ? null : new Double(d);
                break;
            }
            case 6: {
                float f = resultSet.getFloat(n);
                object = resultSet.wasNull() ? null : new Float(f);
                break;
            }
            default: {
                object = resultSet.getString(n);
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DataTask
    implements Task {
        private boolean _running;
        private ResultSet _results;
        private PreparedStatement _statement;

        public DataTask(ResultSet resultSet, PreparedStatement preparedStatement) {
            this._results = resultSet;
            this._statement = preparedStatement;
        }

        public void runTask(TaskEvent taskEvent) {
            this._running = true;
            try {
                int n = JDBCModel.this.getRowCount();
                if (n != 0) {
                    JDBCModel.this._data.removeRows(0, n);
                }
                ResultSetMetaData resultSetMetaData = this._results.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                int n3 = 0;
                Object object = null;
                while (this._running && this._results.next()) {
                    JDBCModel.this._data.addRows(n3, 1);
                    int n4 = 0;
                    while (n4 < n2) {
                        object = JDBCModel.this._getColumnData(this._results, n4 + 1);
                        JDBCModel.this._setData(n4, n3, object);
                        ++n4;
                    }
                    ++n3;
                }
                this._statement.close();
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException);
            }
        }

        public void cancel() {
            this._running = false;
        }
    }
}

