/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.tableComponent;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Locale;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.TwoDSelection;

class ColumnSelectInputHandler
extends BooleanInputHandler {
    private static final long _KEY_TIME = 750L;
    private long _currentTime;
    private TableComponent _parent;
    private StringBuffer _buffer;

    public ColumnSelectInputHandler(TableComponent tableComponent) {
        this._parent = tableComponent;
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyTyped(keyEvent, grid, n, n2);
        if (this._checkTime(750L)) {
            this._buffer = null;
        }
        StringBuffer stringBuffer = this._getBuffer();
        stringBuffer.append(keyEvent.getKeyChar());
        TwoDSelection twoDSelection = grid.getSelection();
        int n3 = twoDSelection.getSingleRow();
        int n4 = n3 == -1 ? 0 : n3;
        n4 = this._findItem(n4, stringBuffer.toString());
        if (n4 != -1 && n4 != n3) {
            this._parent.selectRow(n4, keyEvent);
        }
        this._storeTime();
    }

    private void _storeTime() {
        this._currentTime = System.currentTimeMillis();
    }

    private boolean _checkTime(long l) {
        long l2 = System.currentTimeMillis();
        return l2 - this._currentTime > l;
    }

    private StringBuffer _getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        return this._buffer;
    }

    private int _findItem(int n, String string) {
        String string2;
        int n2 = this._parent.getTable().getColumnCount();
        Locale locale = ((Component)((Object)this._parent)).getLocale();
        string = string.toUpperCase(locale);
        int n3 = n;
        while (n3 < n2) {
            string2 = this._parent.getColumn(n3).getDisplayName(locale).toUpperCase(locale);
            if (string2.startsWith(string)) {
                return n3;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            string2 = this._parent.getColumn(n3).getDisplayName(locale).toUpperCase(locale);
            if (string2.startsWith(string)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }
}

