/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.resultsTable;

import java.text.Collator;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;

class SortableWrapper
extends AbstractTwoDModel
implements Sortable {
    ArrayOneDModel _comparators;
    int _lastColumn;
    boolean _lastOrder;
    private TwoDModel _model;
    private ArrayOneDModel _sortedData;
    private Comparator _defaultComparator;
    private RowComparator _sorter;

    public SortableWrapper() {
        this(null);
    }

    public SortableWrapper(TwoDModel twoDModel) {
        if (twoDModel == null) {
            twoDModel = NullTwoDModel.getTwoDModel();
        }
        this._model = twoDModel;
        this._model.addModelListener((TwoDModelListener)new Listen());
        this._sorter = new RowComparator();
        this._lastColumn = -1;
        this._sortedData = new ArrayOneDModel(0);
    }

    public TwoDModel getModel() {
        return this._model;
    }

    public int getColumnCount() {
        return this.getModel().getColumnCount();
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public Object getData(int n, int n2) {
        n2 = this._getRowIndex(n2);
        return this.getModel().getData(n, n2);
    }

    public void setData(int n, int n2, Object object) {
        n2 = this._getRowIndex(n2);
        this.getModel().setData(n, n2, object);
    }

    public void setColumnComparator(int n, Comparator comparator) {
        if (this._comparators == null) {
            this._comparators = new ArrayOneDModel(this.getColumnCount());
        }
        this._comparators.setData(n, (Object)comparator);
    }

    public Comparator getColumnComparator(int n) {
        Comparator comparator;
        if (this._comparators != null && (comparator = (Comparator)this._comparators.getData(n)) != null) {
            return comparator;
        }
        return this.getDefaultComparator();
    }

    public Comparator getDefaultComparator() {
        if (this._defaultComparator == null) {
            this._defaultComparator = new StringComparator(Collator.getInstance());
        }
        return this._defaultComparator;
    }

    public void setDefaultComparator(Comparator comparator) {
        this._defaultComparator = comparator;
    }

    public void sort(int n, boolean bl) {
        Comparator comparator = this.getColumnComparator(n);
        this._sorter.setComparisonData(comparator, bl);
        int n2 = this.getRowCount();
        Object[] objectArray = new Row[n2];
        int n3 = 0;
        while (n3 < n2) {
            objectArray[n3] = new Row(this._model.getData(n, n3), n3);
            ++n3;
        }
        Sort.qSort((Object[])objectArray, (int)objectArray.length, (Comparator)this._sorter);
        this._sortedData.removeItems(0, n2);
        this._sortedData.addItems(0, objectArray);
        this._lastColumn = n;
        this._lastOrder = bl;
        this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
    }

    void fireEvent(int n, int n2, int n3) {
        this.fireModelEvent(n, n2, n3);
    }

    void resort() {
        if (this._lastColumn == -1) {
            this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
        } else {
            this.sort(this._lastColumn, this._lastOrder);
        }
    }

    private int _getRowIndex(int n) {
        if (this._lastColumn == -1) {
            return n;
        }
        Row row = (Row)this._sortedData.getData(n);
        return row.getIndex();
    }

    private class RowComparator
    implements Comparator {
        private boolean _ascending;
        private Comparator _compare;

        private RowComparator() {
        }

        public int compare(Object object, Object object2) {
            Row row = (Row)object;
            Row row2 = (Row)object2;
            Object object3 = row.getData();
            Object object4 = row2.getData();
            if (this._ascending) {
                return this._compare.compare(object3, object4);
            }
            return this._compare.compare(object4, object3);
        }

        public void setComparisonData(Comparator comparator, boolean bl) {
            this._compare = comparator;
            this._ascending = bl;
        }
    }

    class Listen
    extends TwoDModelAdapter {
        Listen() {
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            if (n <= SortableWrapper.this._lastColumn) {
                SortableWrapper.this._lastColumn += n2;
            }
            if (SortableWrapper.this._comparators != null) {
                SortableWrapper.this._comparators.addItems(n, n2);
            }
            SortableWrapper.this.fireEvent(2001, n, n2);
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            if (SortableWrapper.this._comparators != null) {
                SortableWrapper.this._comparators.removeItems(n, n2);
            }
            SortableWrapper.this.fireEvent(2002, n, n2);
            if (n <= SortableWrapper.this._lastColumn) {
                if (n + n2 >= SortableWrapper.this._lastColumn) {
                    SortableWrapper.this._lastColumn = -1;
                    SortableWrapper.this.resort();
                } else {
                    SortableWrapper.this._lastColumn -= n2;
                }
            }
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getRowStartIndex();
            int n2 = twoDModelEvent.getRowCount();
            SortableWrapper.this.fireEvent(2004, n, n2);
            SortableWrapper.this.resort();
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getRowStartIndex();
            int n2 = twoDModelEvent.getRowCount();
            SortableWrapper.this.fireEvent(2005, n, n2);
            SortableWrapper.this.resort();
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            SortableWrapper.this.resort();
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            if (n <= SortableWrapper.this._lastColumn && n + n2 >= SortableWrapper.this._lastColumn) {
                SortableWrapper.this.resort();
            }
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            int n = twoDModelEvent.getColumnStartIndex();
            int n2 = twoDModelEvent.getColumnCount();
            if (n <= SortableWrapper.this._lastColumn && n + n2 >= SortableWrapper.this._lastColumn) {
                SortableWrapper.this.resort();
            }
        }
    }

    private class Row {
        private Object _data;
        private int _index;

        public Row(Object object, int n) {
            this._data = object;
            this._index = n;
        }

        public Object getData() {
            return this._data;
        }

        public int getIndex() {
            return this._index;
        }
    }
}

