/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.resultsTable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapper;
import oracle.bali.dbUI.columnPropertyEditor.VisualColumn;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.ConstrainableModel;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.impl.ColumnImpl;
import oracle.bali.dbUI.header.CBHeaderInputHandler;
import oracle.bali.dbUI.header.CBHeaderItemPainter;
import oracle.bali.dbUI.header.ConstraintSortHandler;
import oracle.bali.dbUI.resultsTable.ModelFactory;
import oracle.bali.dbUI.resultsTable.ResultsSpreadTable;
import oracle.bali.dbUI.resultsTable.ResultsTableCustomizer;
import oracle.bali.dbUI.resultsTable.SortableWrapper;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridDataToolTipManager;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.RowGroupingAppearance;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.table.TableResizeAdapter;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.util.LocaleUtils;

public class ResultsTable
extends LWComponent
implements Accessible {
    private static final int _DEFAULT_WIDTH = 100;
    private SpreadTable _table;
    private JScrollPane _scrollBox;
    private CBHeaderInputHandler _inputHandler;
    private DataConstraint _filterConstraint;
    private ColumnWrapper[] _wrappers;
    private DataConstraint _constraint;
    private Relationship[] _relationships;
    private OuterJoin[] _outerJoins;
    private ModelFactory _factory;
    private ResultsTableCustomizer _customizer;
    private SortableWrapper _sortable;
    boolean _wrappersDirty;

    public ResultsTable() {
        this(null, null, null, null, null);
    }

    public ResultsTable(ModelFactory modelFactory, ColumnWrapper[] columnWrapperArray) {
        this(modelFactory, columnWrapperArray, null, null, null);
    }

    public ResultsTable(ModelFactory modelFactory, ColumnWrapper[] columnWrapperArray, DataConstraint dataConstraint, Relationship[] relationshipArray) {
        this(modelFactory, columnWrapperArray, dataConstraint, relationshipArray, null);
    }

    public ResultsTable(ModelFactory modelFactory, ColumnWrapper[] columnWrapperArray, DataConstraint dataConstraint, Relationship[] relationshipArray, OuterJoin[] outerJoinArray) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this._table = new ResultsSpreadTable();
        UIListener uIListener = new UIListener();
        this._table.addResizeListener((TableResizeListener)uIListener);
        this._table.addMoveListener((TableMoveListener)uIListener);
        Grid grid = this._table.getGrid();
        RowGroupingAppearance rowGroupingAppearance = new RowGroupingAppearance();
        Color color = UIManager.getColor("normalIntensity");
        if (color != null) {
            rowGroupingAppearance.setColor(ColorUtils.lighterShadeColor((Color)color));
        }
        rowGroupingAppearance.setRows(1);
        grid.setAppearanceManager((AppearanceManager)rowGroupingAppearance);
        grid.setToolTipManager((GridToolTipManager)new GridDataToolTipManager());
        this._scrollBox = new JScrollPane((Component)this._table);
        JDesktopPane jDesktopPane = new JDesktopPane();
        jDesktopPane.setLayout(new Layout());
        jDesktopPane.add("content", this._scrollBox);
        ((Container)((Object)this)).add("Center", jDesktopPane);
        this.setRelationships(relationshipArray);
        this.setColumnWrappers(columnWrapperArray);
        this.setDataConstraint(dataConstraint);
        this.setOuterJoins(outerJoinArray);
        this.setModelFactory(modelFactory);
        this.updateResults();
    }

    public void setModelFactory(ModelFactory modelFactory) {
        if (this._factory != modelFactory) {
            this._factory = modelFactory;
        }
    }

    public ModelFactory getModelFactory() {
        return this._factory;
    }

    public void setColumnWrappers(ColumnWrapper[] columnWrapperArray) {
        this._wrappersDirty = false;
        this._wrappers = null;
        if (columnWrapperArray != null) {
            this._wrappers = new ColumnWrapper[columnWrapperArray.length];
            System.arraycopy(columnWrapperArray, 0, this._wrappers, 0, columnWrapperArray.length);
        }
    }

    public ColumnWrapper[] getColumnWrappers() {
        ColumnWrapper[] columnWrapperArray = null;
        if (this._wrappersDirty) {
            int n;
            int n2 = n = this._wrappers == null ? 0 : this._wrappers.length;
            if (n != 0) {
                columnWrapperArray = new ColumnWrapper[n];
                int n3 = 0;
                while (n3 < n) {
                    if (this._wrappers[n3] instanceof VisualColumn) {
                        VisualColumn visualColumn = (VisualColumn)this._wrappers[n3];
                        visualColumn.setWidth(this.getSpreadTable().getColumnWidth(n3));
                    }
                    int n4 = this.getSpreadTable().getGrid().getColumnVisibleIndex(n3);
                    columnWrapperArray[n4] = this._wrappers[n3];
                    ++n3;
                }
            }
        } else if (this._wrappers != null) {
            columnWrapperArray = new ColumnWrapper[this._wrappers.length];
            System.arraycopy(this._wrappers, 0, columnWrapperArray, 0, columnWrapperArray.length);
        }
        return columnWrapperArray;
    }

    public void setDataConstraint(DataConstraint dataConstraint) {
        if (this._constraint != dataConstraint) {
            this._constraint = dataConstraint;
        }
    }

    public DataConstraint getDataConstraint() {
        return this._constraint;
    }

    public void setRelationships(Relationship[] relationshipArray) {
        this._relationships = null;
        if (relationshipArray != null) {
            this._relationships = new Relationship[relationshipArray.length];
            System.arraycopy(relationshipArray, 0, this._relationships, 0, relationshipArray.length);
        }
    }

    public Relationship[] getRelationships() {
        Relationship[] relationshipArray = null;
        if (this._relationships != null) {
            relationshipArray = new Relationship[this._relationships.length];
            System.arraycopy(this._relationships, 0, relationshipArray, 0, relationshipArray.length);
        }
        return relationshipArray;
    }

    public void setOuterJoins(OuterJoin[] outerJoinArray) {
        this._outerJoins = null;
        if (outerJoinArray != null) {
            this._outerJoins = new OuterJoin[outerJoinArray.length];
            System.arraycopy(outerJoinArray, 0, this._outerJoins, 0, outerJoinArray.length);
        }
    }

    public OuterJoin[] getOuterJoins() {
        OuterJoin[] outerJoinArray = null;
        if (this._outerJoins != null) {
            outerJoinArray = new OuterJoin[this._outerJoins.length];
            System.arraycopy(this._outerJoins, 0, outerJoinArray, 0, outerJoinArray.length);
        }
        return outerJoinArray;
    }

    public void updateResults() {
        int n;
        Header header;
        this.cleanupResults();
        this._wrappersDirty = false;
        ModelFactory modelFactory = this.getModelFactory();
        if (modelFactory == null) {
            return;
        }
        Relationship[] relationshipArray = this._relationships;
        DataConstraint dataConstraint = this._constraint;
        ColumnWrapper[] columnWrapperArray = this._wrappers;
        Column[] columnArray = ColumnWrapper.getColumns(columnWrapperArray);
        OuterJoin[] outerJoinArray = this._outerJoins;
        boolean bl = columnWrapperArray != null && columnWrapperArray.length > 0;
        Object object = null;
        OneDModel oneDModel = null;
        if (bl) {
            object = modelFactory.createModel(columnArray, dataConstraint, relationshipArray, outerJoinArray);
            oneDModel = this._createColumnModel(columnWrapperArray);
        }
        WrapperProvider wrapperProvider = null;
        if (bl) {
            wrapperProvider = new WrapperProvider(columnWrapperArray);
        }
        Constrainable constrainable = null;
        Sortable sortable = null;
        if (object != null) {
            if (!(object instanceof Constrainable)) {
                object = new ConstrainableModel((TwoDModel)object, wrapperProvider);
            }
            constrainable = (Constrainable)object;
            if (object instanceof Sortable) {
                this._sortable = null;
            } else {
                this._sortable = new SortableWrapper((TwoDModel)object);
                object = this._sortable;
            }
            sortable = (Sortable)object;
        }
        this._table.setModels(object, oneDModel, null);
        this._updateUI();
        this._table.setScrollByColumn(false);
        if (oneDModel != null) {
            header = this._table.getColumnHeader();
            n = 0;
            while (n < header.getItemCount()) {
                header.setPainter(n, (Painter)new CBHeaderItemPainter());
                ++n;
            }
            ConstraintSortHandler constraintSortHandler = new ConstraintSortHandler(header, constrainable, null, wrapperProvider, sortable);
            constraintSortHandler.addPropertyChangeListener(new DCListen());
            header.setItemInputHandler((HeaderItemInputHandler)constraintSortHandler);
            this._inputHandler = constraintSortHandler;
            if (this._filterConstraint != null) {
                this._inputHandler.setDataConstraint(this._filterConstraint);
                this._filterConstraint = null;
            }
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        }
        if ((n = (header = this._table.getGrid()).getNextVisibleColumn(-1)) != -1) {
            this._table.setFirstColumnOnScreen(n);
        }
        if (header.getRowCount() > 0) {
            this._table.setFirstRowOnScreen(0);
        }
        ((Container)((Object)this)).invalidate();
        ((Component)((Object)this)).repaint();
    }

    public void setCustomizer(ResultsTableCustomizer resultsTableCustomizer) {
        if (this._customizer != resultsTableCustomizer) {
            this._customizer = resultsTableCustomizer;
        }
    }

    public ResultsTableCustomizer getCustomizer() {
        if (this._customizer == null) {
            this._customizer = ResultsTableCustomizer.getResultsTableCustomizer();
        }
        return this._customizer;
    }

    public void setFilterDataConstraint(DataConstraint dataConstraint) {
        if (this._inputHandler != null) {
            this._inputHandler.setDataConstraint(dataConstraint);
        } else {
            this._filterConstraint = dataConstraint;
        }
    }

    public DataConstraint getFilterDataConstraint() {
        if (this._inputHandler != null) {
            return this._inputHandler.getDataConstraint();
        }
        return this._filterConstraint;
    }

    public SpreadTable getSpreadTable() {
        return this._table;
    }

    public void cleanupResults() {
        if (this._table.getColumnHeader() != null) {
            this._table.getColumnHeader().setItemInputHandler(null);
        }
        if (this._inputHandler != null) {
            this._inputHandler.setHeader(null);
            this._inputHandler = null;
        }
        this._table.setModels(null, null, null);
        this._table.setColumnHeaderVisible(true);
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._scrollBox.setEnabled(bl);
        this._table.setEnabled(bl);
    }

    public void requestFocus() {
        this._table.requestFocus();
    }

    void firePropertyChange(DataConstraint dataConstraint) {
        ((Component)((Object)this)).firePropertyChange("dataConstraint", null, dataConstraint);
    }

    private OneDModel _createColumnModel(ColumnWrapper[] columnWrapperArray) {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        Object[] objectArray = new String[columnWrapperArray.length];
        if (columnWrapperArray[0] instanceof VisualColumn) {
            int n = 0;
            while (n < columnWrapperArray.length) {
                VisualColumn visualColumn = (VisualColumn)columnWrapperArray[n];
                objectArray[n] = visualColumn.getDisplayName(locale);
                ++n;
            }
        } else {
            int n = 0;
            while (n < columnWrapperArray.length) {
                objectArray[n] = columnWrapperArray[n].getColumn().getDisplayName(locale);
                ++n;
            }
        }
        return new ArrayOneDModel(objectArray);
    }

    private void _updateUI() {
        block8: {
            ColumnWrapper[] columnWrapperArray = this._wrappers;
            ResultsTableCustomizer resultsTableCustomizer = this.getCustomizer();
            SpreadTable spreadTable = this.getSpreadTable();
            Grid grid = spreadTable.getGrid();
            int n = grid.getColumnCount();
            if (columnWrapperArray == null || columnWrapperArray.length <= 0 || columnWrapperArray.length != n) break block8;
            if (columnWrapperArray[0] instanceof VisualColumn) {
                int n2 = 0;
                while (n2 < columnWrapperArray.length) {
                    VisualColumn visualColumn = (VisualColumn)columnWrapperArray[n2];
                    Column column = visualColumn.getColumn();
                    grid.setColumnPainter(n2, resultsTableCustomizer.getPainter(column));
                    grid.setColumnCellInputHandler(n2, resultsTableCustomizer.getCellInputHandler(column));
                    spreadTable.setColumnVisible(n2, visualColumn.isVisible());
                    spreadTable.setColumnWidth(n2, visualColumn.getWidth());
                    if (this._sortable != null) {
                        this._sortable.setColumnComparator(n2, resultsTableCustomizer.getComparator(column));
                    }
                    ++n2;
                }
            } else {
                Font font = ((Component)((Object)this)).getFont();
                FontMetrics fontMetrics = font == null ? null : ((Component)((Object)this)).getFontMetrics(font);
                int n3 = 0;
                while (n3 < columnWrapperArray.length) {
                    Column column = columnWrapperArray[n3].getColumn();
                    grid.setColumnPainter(n3, resultsTableCustomizer.getPainter(column));
                    grid.setColumnCellInputHandler(n3, resultsTableCustomizer.getCellInputHandler(column));
                    spreadTable.setColumnVisible(n3, resultsTableCustomizer.displayColumn(column));
                    if (fontMetrics != null) {
                        spreadTable.setColumnWidth(n3, resultsTableCustomizer.getColumnWidth(column, fontMetrics));
                    } else {
                        spreadTable.setColumnWidth(n3, 100);
                    }
                    if (this._sortable != null) {
                        this._sortable.setColumnComparator(n3, resultsTableCustomizer.getComparator(column));
                    }
                    ++n3;
                }
            }
        }
    }

    private class Layout
    implements LayoutManager {
        private Component _content;

        private Layout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("content".equals(string)) {
                this._content = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (this._content == component) {
                this._content = null;
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this._content == null ? new Dimension(0, 0) : this._content.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this._content == null ? new Dimension(0, 0) : this._content.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            if (this._content != null) {
                Dimension dimension = container.getSize();
                this._content.setBounds(0, 0, dimension.width, dimension.height);
            }
        }
    }

    private class WrapperProvider
    implements DataDescriptorProvider {
        private Column[] _columns;

        public WrapperProvider(ColumnWrapper[] columnWrapperArray) {
            this._columns = this._getColumns(columnWrapperArray);
        }

        public int getDescriptorCount() {
            return this._columns == null ? 0 : this._columns.length;
        }

        public DataDescriptor getDescriptor(int n) {
            return this._columns[n];
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        private Column[] _getColumns(ColumnWrapper[] columnWrapperArray) {
            if (columnWrapperArray == null || columnWrapperArray.length == 0) {
                return null;
            }
            if (!(columnWrapperArray[0] instanceof VisualColumn)) {
                return ColumnWrapper.getColumns(columnWrapperArray);
            }
            int n = columnWrapperArray.length;
            Column[] columnArray = new Column[n];
            int n2 = 0;
            while (n2 < n) {
                VisualColumn visualColumn = (VisualColumn)columnWrapperArray[n2];
                Column column = visualColumn.getColumn();
                columnArray[n2] = new ColumnImpl(column.getName(), visualColumn.getDisplayName(), column.getDataType(), column.getTable());
                ++n2;
            }
            return columnArray;
        }
    }

    private class DCListen
    implements PropertyChangeListener {
        private DCListen() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ResultsTable.this.firePropertyChange((DataConstraint)propertyChangeEvent.getNewValue());
        }
    }

    private class UIListener
    extends TableResizeAdapter
    implements TableMoveListener {
        private UIListener() {
        }

        public void columnResized(TableEvent tableEvent) {
            ResultsTable.this._wrappersDirty = true;
        }

        public void columnMoving(TableEvent tableEvent) {
        }

        public void columnMoved(TableEvent tableEvent) {
            ResultsTable.this._wrappersDirty = true;
        }

        public void rowMoving(TableEvent tableEvent) {
        }

        public void rowMoved(TableEvent tableEvent) {
        }
    }
}

