/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.propertyTable;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.UIManager;
import oracle.bali.dbUI.propertyTable.PTModel;
import oracle.bali.dbUI.propertyTable.PTValidateEvent;
import oracle.bali.dbUI.propertyTable.PropertyTableCustomizer;
import oracle.bali.dbUI.propertyTable.PropertyTableEvent;
import oracle.bali.dbUI.propertyTable.PropertyTableListener;
import oracle.bali.dbUI.propertyTable.SortHandler;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.RowGroupingAppearance;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.NullOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.Comparator;

public class PropertyTable
extends SpreadTable {
    private PTModel _model = new PTModel(this);
    private PropertyTableCustomizer _customizer;
    private NullOneDModel _rowHeaderDS = new NullOneDModel(0);
    private Object[] _objects;
    private boolean _dirty;
    private ListenerManager _listeners;
    static /* synthetic */ Class class$java$lang$Boolean;

    public PropertyTable() {
        this(null);
    }

    public PropertyTable(Object[] objectArray) {
        super.setModels((TwoDModel)this._model, (OneDModel)this._model, (OneDModel)this._rowHeaderDS);
        super.setRowHeaderWidth(30);
        Grid grid = super.getGrid();
        grid.setGridSelectionManager(GeneralGridSelectionManager.getNullGridSelectionManager());
        grid.setDrawFocusCellHighlite(true);
        grid.setAppearanceManager((AppearanceManager)new Appear());
        Header header = super.getRowHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header = super.getColumnHeader();
        header.setHeaderKeyHandler((HeaderKeyHandler)new KeySort());
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)new SortHandler(this, this._model));
        this.setObjects(objectArray);
    }

    public Object[] getObjects() {
        return this._model.getObjects();
    }

    public void setObjects(Object[] objectArray) {
        this.freezeRepaints();
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        int n = objectArray.length;
        this._objects = new Object[n];
        System.arraycopy(objectArray, 0, this._objects, 0, n);
        Grid grid = super.getGrid();
        this._model.setObjects(this._objects);
        int n2 = this._rowHeaderDS.getItemCount();
        int n3 = n - n2;
        if (n3 > 0) {
            this._rowHeaderDS.addItems(0, n3);
        } else {
            this._rowHeaderDS.removeItems(0, -n3);
        }
        if (n == 0) {
            this.unfreezeRepaints();
            return;
        }
        this._dirty = true;
        this._setUI();
        this.unfreezeRepaints();
    }

    public void setCustomizer(PropertyTableCustomizer propertyTableCustomizer) {
        this._customizer = propertyTableCustomizer;
        this._setUI();
    }

    public PropertyTableCustomizer getCustomizer() {
        if (this._customizer == null) {
            this._customizer = PropertyTableCustomizer.getPropertyTableCustomizer();
        }
        return this._customizer;
    }

    public PropertyDescriptor getPropertyAt(int n) {
        return this._model.getDescriptor(n);
    }

    public int getPropertyIndex(PropertyDescriptor propertyDescriptor) {
        return this._model.getIndex(propertyDescriptor);
    }

    public void sort(int n, boolean bl) {
        if (!super.isColumnVisible(n)) {
            throw new IllegalArgumentException("Can't sort a hidden property");
        }
        this._model.sort(n, bl);
    }

    public void addPropertyTableListener(PropertyTableListener propertyTableListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)propertyTableListener);
    }

    public void removePropertyTableListener(PropertyTableListener propertyTableListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)propertyTableListener);
        }
    }

    public void addNotify() {
        super.addNotify();
        this._setUI();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PropertyTableEvent) {
            this.processPropertyTableEvent((PropertyTableEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processPropertyTableEvent(PropertyTableEvent propertyTableEvent) {
        if (this._listeners == null) {
            return;
        }
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration == null) {
            return;
        }
        int n = propertyTableEvent.getID();
        switch (n) {
            case 2000: {
                while (enumeration.hasMoreElements()) {
                    ((PropertyTableListener)enumeration.nextElement()).columnSorting(propertyTableEvent);
                }
                break;
            }
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((PropertyTableListener)enumeration.nextElement()).columnSorted(propertyTableEvent);
                }
                break;
            }
        }
    }

    String getPropertyDisplayName(PropertyDescriptor propertyDescriptor) {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        return this.getCustomizer().getDisplayName(propertyDescriptor, locale);
    }

    boolean isBoolean(int n) {
        PropertyDescriptor propertyDescriptor = this.getPropertyAt(n);
        Class<?> clazz = propertyDescriptor.getPropertyType();
        return clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyTable.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    boolean fireCancelablePropertyTableEvent(int n) {
        int n2 = 2000;
        PTValidateEvent pTValidateEvent = new PTValidateEvent(this, n2, n);
        this.processEvent(pTValidateEvent);
        return pTValidateEvent.isCancelled();
    }

    void firePropertyTableEvent(int n) {
        int n2 = 2001;
        PropertyTableEvent propertyTableEvent = new PropertyTableEvent(this, n2, n);
        this.processEvent(propertyTableEvent);
    }

    private void _setUI() {
        Font font = ((Component)((Object)this)).getFont();
        if (!this._dirty || font == null) {
            return;
        }
        this._dirty = false;
        this.freezeRepaints();
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
        Grid grid = super.getGrid();
        PropertyTableCustomizer propertyTableCustomizer = this.getCustomizer();
        int n = grid.getColumnCount();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propertyDescriptor = this.getPropertyAt(n2);
            boolean bl = propertyTableCustomizer.displayProperty(propertyDescriptor);
            super.setColumnVisible(n2, bl);
            if (bl) {
                Comparator comparator = propertyTableCustomizer.getComparator(propertyDescriptor);
                this._model.setComparator(n2, comparator);
                Painter painter = propertyTableCustomizer.getPainter(propertyDescriptor);
                grid.setColumnPainter(n2, painter);
                CellInputHandler cellInputHandler = propertyTableCustomizer.getCellInputHandler(propertyDescriptor);
                grid.setColumnCellInputHandler(n2, cellInputHandler);
                int n3 = propertyTableCustomizer.getColumnWidth(propertyDescriptor, fontMetrics, locale);
                super.setColumnWidth(n2, n3);
            }
            ++n2;
        }
        int n4 = grid.getNextVisibleRow(-1);
        super.setFirstRowOnScreen(n4);
        n4 = grid.getNextVisibleColumn(-1);
        super.setFirstColumnOnScreen(n4);
        this.unfreezeRepaints();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class KeySort
    extends StandardHeaderKeyHandler {
        private KeySort() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 32) {
                HeaderItemInputHandler headerItemInputHandler;
                int n;
                if (keyEvent.getID() == 401 && (n = header.getFocusItem()) != -1 && (headerItemInputHandler = header.getItemInputHandler()) instanceof SortHandler) {
                    ((SortHandler)headerItemInputHandler).sort(n);
                }
                keyEvent.consume();
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }

    private class Appear
    extends RowGroupingAppearance {
        private Appearance _a1;
        private Appearance _a2;

        public Appear() {
            Color color = UIManager.getColor("normalIntensity");
            if (color != null) {
                color = ColorUtils.lighterShadeColor((Color)color);
                this.setColor(color);
            }
            this.setRows(1);
        }

        public Appearance getCellPaintingAppearance(int n, int n2) {
            Appearance appearance = super.getCellPaintingAppearance(n, n2);
            if (PropertyTable.this.isBoolean(n)) {
                if (n2 % 2 == 0) {
                    if (this._a1 == null) {
                        this._a1 = appearance.copy();
                        this._a1.setBackground(UIManager.getColor("control"));
                    }
                    appearance = this._a1;
                } else {
                    if (this._a2 == null) {
                        this._a2 = appearance.copy();
                        this._a2.setBackground(UIManager.getColor("control"));
                    }
                    appearance = this._a2;
                }
            }
            return appearance;
        }
    }
}

