/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.propertyTable;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.dbUI.propertyTable.PropertyTable;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.beans.JavaIntrospector;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.Comparator;

class PTModel
implements TwoDModel,
OneDModel,
Sortable {
    private PropertyTable _parent;
    private PropertyDescriptor[] _desc;
    private int _columnCount;
    private ListenerManager _twoDDSManager;
    private ListenerManager _oneDDSManager;
    private SortableTwoDModel _store;

    public PTModel(PropertyTable propertyTable) {
        this._parent = propertyTable;
    }

    public void setObjects(Object[] objectArray) {
        int n = this._store == null ? 0 : this._store.getRowCount();
        int n2 = objectArray == null ? 0 : objectArray.length;
        int n3 = n2 - n;
        int n4 = this._columnCount;
        this._columnCount = this._analizeColumns(objectArray);
        int n5 = this._columnCount - n4;
        this._store = new SortableTwoDModel(this._columnCount + 1, n2);
        int n6 = 0;
        while (n6 < n2) {
            this._store.setData(this._columnCount, n6, objectArray[n6]);
            ++n6;
        }
        this._sendRowsChangedEvent(n2 - n);
        this._sendColumnsChangedEvent(n5);
        this._sendItemsChangedEvent(n5);
    }

    public PropertyDescriptor getDescriptor(int n) {
        return this._desc == null ? null : this._desc[n];
    }

    public int getIndex(PropertyDescriptor propertyDescriptor) {
        if (this._desc == null) {
            return -1;
        }
        int n = 0;
        while (n < this._desc.length) {
            if (((Object)this._desc[n]).equals(propertyDescriptor)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Comparator getComparator(int n) {
        return this._store == null ? null : this._store.getColumnComparator(n);
    }

    public void setComparator(int n, Comparator comparator) {
        if (this._store != null) {
            this._store.setColumnComparator(n, comparator);
        }
    }

    public Object[] getObjects() {
        int n = this.getRowCount();
        if (n == 0) {
            return null;
        }
        int n2 = this.getColumnCount();
        Object[] objectArray = new Object[n];
        int n3 = 0;
        while (n3 < n) {
            objectArray[n3] = this._store.getData(n2, n3);
            ++n3;
        }
        return objectArray;
    }

    public int getRowCount() {
        return this._store == null ? 0 : this._store.getRowCount();
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public Object getData(int n, int n2) {
        if (this._store == null) {
            return null;
        }
        Object object = this._store.getData(n, n2);
        if (object == null) {
            object = this._getData(n, n2);
            this._store.setData(n, n2, object);
        }
        return object;
    }

    public void setData(int n, int n2, Object object) {
        Method method;
        if (this._store == null) {
            throw new IllegalStateException("There are no columns");
        }
        if (!this._isEditable(n)) {
            throw new IllegalArgumentException("Column " + n + " is not editable");
        }
        if (this._desc != null && (method = this._desc[n].getWriteMethod()) != null) {
            try {
                Object object2 = this._store.getData(this.getColumnCount(), n2);
                method.invoke(object2, object);
                this._store.setData(n, n2, object);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        this._invalidateCells(n, 1, n2, 1);
    }

    public void addModelListener(TwoDModelListener twoDModelListener) {
        if (this._twoDDSManager == null) {
            this._twoDDSManager = new ListenerManager();
        }
        this._twoDDSManager.addListener((EventListener)twoDModelListener);
    }

    public void removeModelListener(TwoDModelListener twoDModelListener) {
        if (this._twoDDSManager != null) {
            this._twoDDSManager.removeListener((EventListener)twoDModelListener);
        }
    }

    public int getItemCount() {
        return this._columnCount;
    }

    public Object getData(int n) {
        String string = null;
        if (this._desc != null) {
            string = this._parent.getPropertyDisplayName(this._desc[n]);
        }
        return string;
    }

    public void setData(int n, Object object) {
    }

    public void addModelListener(OneDModelListener oneDModelListener) {
        if (this._oneDDSManager == null) {
            this._oneDDSManager = new ListenerManager();
        }
        this._oneDDSManager.addListener((EventListener)oneDModelListener);
    }

    public void removeModelListener(OneDModelListener oneDModelListener) {
        if (this._oneDDSManager != null) {
            this._oneDDSManager.removeListener((EventListener)oneDModelListener);
        }
    }

    public void sort(int n, boolean bl) {
        if (this._store == null || this.getComparator(n) == null) {
            return;
        }
        this._parent.freezeRepaints();
        int n2 = this.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            Object object = this._getData(n, n3);
            this._store.setData(n, n3, object);
            this._parent.setRowVisibleIndex(n3, n3);
            ++n3;
        }
        this._store.sort(n, bl);
        this._invalidateCells(0, this.getColumnCount(), 0, n2);
        this._parent.unfreezeRepaints();
        ((Component)((Object)this._parent)).repaint();
    }

    private Object _getData(int n, int n2) {
        Method method;
        Object object = null;
        if (this._desc != null && (method = this._desc[n].getReadMethod()) != null) {
            try {
                Object object2 = this._store.getData(this.getColumnCount(), n2);
                object = method.invoke(object2, null);
            }
            catch (Exception exception) {
                object = null;
            }
        }
        return object;
    }

    private void _sendItemsChangedEvent(int n) {
        if (n == 0 || this._oneDDSManager == null) {
            return;
        }
        Enumeration enumeration = this._oneDDSManager.getListeners();
        if (enumeration == null) {
            return;
        }
        if (n > 0) {
            OneDModelEvent oneDModelEvent = new OneDModelEvent((Object)this, 2001, 0, n);
            while (enumeration.hasMoreElements()) {
                OneDModelListener oneDModelListener = (OneDModelListener)enumeration.nextElement();
                oneDModelListener.itemsAdded(oneDModelEvent);
            }
        } else {
            OneDModelEvent oneDModelEvent = new OneDModelEvent((Object)this, 2002, 0, -n);
            while (enumeration.hasMoreElements()) {
                OneDModelListener oneDModelListener = (OneDModelListener)enumeration.nextElement();
                oneDModelListener.itemsRemoved(oneDModelEvent);
            }
        }
    }

    private void _sendRowsChangedEvent(int n) {
        if (n == 0 || this._twoDDSManager == null) {
            return;
        }
        Enumeration enumeration = this._twoDDSManager.getListeners();
        if (enumeration == null) {
            return;
        }
        if (n > 0) {
            TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2004, 0, n);
            while (enumeration.hasMoreElements()) {
                TwoDModelListener twoDModelListener = (TwoDModelListener)enumeration.nextElement();
                twoDModelListener.rowsAdded(twoDModelEvent);
            }
        } else {
            TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2005, 0, -n);
            while (enumeration.hasMoreElements()) {
                TwoDModelListener twoDModelListener = (TwoDModelListener)enumeration.nextElement();
                twoDModelListener.rowsRemoved(twoDModelEvent);
            }
        }
    }

    private void _sendColumnsChangedEvent(int n) {
        if (n == 0 || this._twoDDSManager == null) {
            return;
        }
        Enumeration enumeration = this._twoDDSManager.getListeners();
        if (enumeration == null) {
            return;
        }
        if (n > 0) {
            TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2001, 0, n);
            while (enumeration.hasMoreElements()) {
                TwoDModelListener twoDModelListener = (TwoDModelListener)enumeration.nextElement();
                twoDModelListener.columnsAdded(twoDModelEvent);
            }
        } else {
            TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2002, 0, -n);
            while (enumeration.hasMoreElements()) {
                TwoDModelListener twoDModelListener = (TwoDModelListener)enumeration.nextElement();
                twoDModelListener.columnsRemoved(twoDModelEvent);
            }
        }
    }

    private void _invalidateCells(int n, int n2, int n3, int n4) {
        if (this._twoDDSManager == null) {
            return;
        }
        Enumeration enumeration = this._twoDDSManager.getListeners();
        if (enumeration == null) {
            return;
        }
        TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2007, n, n2, n3, n4);
        while (enumeration.hasMoreElements()) {
            TwoDModelListener twoDModelListener = (TwoDModelListener)enumeration.nextElement();
            twoDModelListener.invalidateCells(twoDModelEvent);
        }
    }

    private boolean _isEditable(int n) {
        boolean bl = false;
        if (this._desc != null) {
            Method method = this._desc[n].getWriteMethod();
            bl = method != null;
        }
        return bl;
    }

    private int _analizeColumns(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return 0;
        }
        Object object = objectArray[0];
        BeanInfo beanInfo = null;
        try {
            beanInfo = JavaIntrospector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            beanInfo = null;
        }
        this._desc = beanInfo == null ? null : beanInfo.getPropertyDescriptors();
        return this._desc == null ? 0 : this._desc.length;
    }
}

