/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.header;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCNaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.header.CBHeaderItemPainter;
import oracle.bali.dbUI.header.CBWindow;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;

public class CBHeaderInputHandler
implements HeaderItemInputHandler {
    private static final String _COMMAND_ACTIVATE = "ACTIVATE";
    private static final String _COMMAND_FILTER = "FILTER";
    private static final String _KEY_MENU = "HEADER.MENU_STRING";
    private static final String _ACTIVE_KEY = "ACTIVE";
    private OK _okListener;
    private Cancl _cancelListener;
    private boolean _armed;
    int _item;
    int _menuItem;
    Header _header;
    private OneDModelListener _dsListener;
    private MouseMotionAdapter _mListener;
    boolean[] _active;
    CBWindow _window;
    DataConstraint[] _dataConstraints;
    DataConstraint _total;
    private PropertyChangeSupport _propertySupport;
    private Constrainable _constrainable;
    private ConstraintCompFactory _componentFactory;
    private DataDescriptorProvider _descriptProvider;
    private Task _runner;
    private GlassPane _glassPane;

    public CBHeaderInputHandler() {
        this(null, null, null, null);
    }

    public CBHeaderInputHandler(Header header, Constrainable constrainable, ConstraintCompFactory constraintCompFactory, DataDescriptorProvider dataDescriptorProvider) {
        this._constrainable = constrainable;
        this._componentFactory = constraintCompFactory;
        this._descriptProvider = dataDescriptorProvider;
        this.setHeader(header);
        this._okListener = new OK();
        this._cancelListener = new Cancl();
        this._window = new CBWindow(this._okListener, this._cancelListener);
        this._runner = new Run();
    }

    public Constrainable getConstrainable() {
        return this._constrainable;
    }

    public void setConstrainable(Constrainable constrainable) {
        this._constrainable = constrainable;
    }

    public ConstraintCompFactory getComponentFactory() {
        if (this._componentFactory == null) {
            this._componentFactory = ConstraintCompFactory.getConstraintCompFactory();
        }
        return this._componentFactory;
    }

    public void setComponentFactory(ConstraintCompFactory constraintCompFactory) {
        this._componentFactory = constraintCompFactory;
    }

    public DataDescriptorProvider getDescriptorProvider() {
        return this._descriptProvider;
    }

    public void setDescriptorProvider(DataDescriptorProvider dataDescriptorProvider) {
        this._descriptProvider = dataDescriptorProvider;
    }

    public void setHeader(Header header) {
        if (this.getHeader() == header) {
            return;
        }
        Header header2 = this.getHeader();
        if (header2 != null) {
            header2.getModel().removeModelListener(this._dsListener);
            header2.removeMouseMotionListener(this._mListener);
            header2.setHeaderKeyHandler(null);
        }
        this._removeGlassPane();
        this._active = null;
        this._dataConstraints = null;
        this._item = -1;
        this._armed = false;
        this._header = header;
        if (this._header == null) {
            return;
        }
        int n = this._header.getItemCount();
        this._active = new boolean[n];
        this._dataConstraints = new DataConstraint[n];
        if (this._dsListener == null) {
            this._dsListener = new DSListen();
        }
        if (this._mListener == null) {
            this._mListener = new MListen();
        }
        this._header.getModel().addModelListener(this._dsListener);
        this._header.addMouseMotionListener(this._mListener);
        this._header.setHeaderKeyHandler(this.createHeaderKeyHandler());
    }

    public Header getHeader() {
        return this._header;
    }

    public void setDataConstraint(DataConstraint dataConstraint) {
        int n = this._active.length;
        this._total = null;
        int n2 = 0;
        while (n2 < n) {
            this._active[n2] = false;
            this._dataConstraints[n2] = null;
            ++n2;
        }
        if (dataConstraint != null) {
            if (this.getDescriptorProvider() == null) {
                throw new IllegalStateException();
            }
            this._parseConstraint(dataConstraint);
            this.setDataConstraint(false);
        } else {
            Constrainable constrainable = this.getConstrainable();
            if (constrainable != null) {
                constrainable.setDataConstraint(null);
            }
        }
        this._updateUI();
    }

    public DataConstraint getDataConstraint() {
        return this._total;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        Painter painter;
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has " + "not been set on this " + "input handler.");
        }
        if (this._item == -1 && (painter = header.getPainter(n)) instanceof CBHeaderItemPainter) {
            CBHeaderItemPainter cBHeaderItemPainter = (CBHeaderItemPainter)painter;
            boolean bl = cBHeaderItemPainter.pointInActiveArea(header.getItemSize(n), header.getSize().height, mouseEvent.getX(), mouseEvent.getY());
            if (cBHeaderItemPainter.isRollover() != bl) {
                cBHeaderItemPainter.setRollover(bl);
                header.paintItem(n);
            }
            mouseEvent.consume();
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
        CBHeaderItemPainter cBHeaderItemPainter;
        Painter painter;
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has " + "not been set on this " + "input handler.");
        }
        boolean bl = false;
        if (mouseEvent.isMetaDown() || mouseEvent.isPopupTrigger()) {
            bl = this._showPopupMenu(mouseEvent.getX(), mouseEvent.getY(), n);
        }
        if ((painter = header.getPainter(n)) instanceof CBHeaderItemPainter && (cBHeaderItemPainter = (CBHeaderItemPainter)painter).pointInActiveArea(header.getItemSize(n), header.getSize().height, mouseEvent.getX(), mouseEvent.getY())) {
            cBHeaderItemPainter.setRollover(false);
            if (!bl) {
                bl = true;
                this._item = n;
                this._armed = true;
                cBHeaderItemPainter.setActiveAreaArmed(true);
                header.paintItem(this._item);
            }
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has " + "not been set on this " + "input handler.");
        }
        this._checkArmed(mouseEvent, n);
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has " + "not been set on this " + "input handler.");
        }
        if (this._item == n && this._armed) {
            Painter painter;
            if (this._showWindow(n)) {
                mouseEvent.consume();
            }
            if ((painter = header.getPainter(n)) instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter cBHeaderItemPainter = (CBHeaderItemPainter)painter;
                cBHeaderItemPainter.setRollover(false);
                cBHeaderItemPainter.setActiveAreaArmed(!cBHeaderItemPainter.isActive());
                header.paintItem(n);
            }
        } else if (this._item != -1) {
            Painter painter = header.getPainter(this._item);
            if (painter instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter cBHeaderItemPainter = (CBHeaderItemPainter)painter;
                cBHeaderItemPainter.setActiveAreaArmed(false);
                cBHeaderItemPainter.setRollover(false);
                header.paintItem(this._item);
            }
            this._item = -1;
        }
        this._armed = false;
    }

    public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has " + "not been set on this " + "input handler.");
        }
        this._checkArmed(mouseEvent, n);
    }

    public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        CBHeaderItemPainter cBHeaderItemPainter;
        if (!this._checkHeader(header)) {
            throw new IllegalArgumentException("Header " + header + " has " + "not been set on this " + "input handler.");
        }
        this._checkArmed(mouseEvent, n);
        Painter painter = header.getPainter(n);
        if (painter instanceof CBHeaderItemPainter && (cBHeaderItemPainter = (CBHeaderItemPainter)painter).isRollover()) {
            cBHeaderItemPainter.setRollover(false);
            header.paintItem(n);
        }
    }

    JDesktopPane _getDesktop(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof JDesktopPane) {
                return (JDesktopPane)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    void _addToArrays(int n, int n2) {
        boolean[] blArray = this._active;
        int n3 = 0;
        if (blArray != null) {
            n3 = blArray.length;
        }
        boolean[] blArray2 = new boolean[n3 + n2];
        if (n != 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n != n3) {
            System.arraycopy(blArray, n, blArray2, n + n2, n3 - n);
        }
        this._active = blArray2;
        DataConstraint[] dataConstraintArray = this._dataConstraints;
        n3 = 0;
        if (dataConstraintArray != null) {
            n3 = dataConstraintArray.length;
        }
        DataConstraint[] dataConstraintArray2 = new DataConstraint[n3 + n2];
        if (n != 0) {
            System.arraycopy(dataConstraintArray, 0, blArray2, 0, n);
        }
        if (n != n3) {
            System.arraycopy(dataConstraintArray, n, dataConstraintArray2, n + n2, n3 - n);
        }
        this._dataConstraints = dataConstraintArray2;
    }

    void _removeFromArrays(int n, int n2) {
        boolean[] blArray = this._active;
        int n3 = 0;
        if (blArray != null) {
            n3 = blArray.length;
        }
        boolean[] blArray2 = new boolean[n3 - n2];
        if (n != 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(blArray, n + n2, blArray2, n, n3 - (n + n2));
        }
        this._active = blArray2;
        DataConstraint[] dataConstraintArray = this._dataConstraints;
        n3 = 0;
        if (dataConstraintArray != null) {
            n3 = dataConstraintArray.length;
        }
        DataConstraint[] dataConstraintArray2 = new DataConstraint[n3 - n2];
        if (n != 0) {
            System.arraycopy(dataConstraintArray, 0, dataConstraintArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(dataConstraintArray, n + n2, dataConstraintArray2, n, n3 - (n + n2));
        }
        int n4 = n;
        while (n4 < n + n2) {
            this._dataConstraints[n4] = null;
            ++n4;
        }
        this._dataConstraints = dataConstraintArray2;
    }

    void setDataConstraint(boolean bl) {
        Object[] objectArray;
        this._total = null;
        int n = this._active.length;
        Vector<DataConstraint> vector = new Vector<DataConstraint>();
        int n2 = 0;
        while (n2 < n) {
            DataConstraint dataConstraint = this._dataConstraints[n2];
            if (this._active[n2] && dataConstraint != null) {
                vector.addElement(dataConstraint);
            }
            ++n2;
        }
        n = vector.size();
        if (n != 0) {
            objectArray = new DataConstraint[n];
            vector.copyInto(objectArray);
            this._total = n == 1 ? objectArray[0] : new DCBooleanExpression((DataConstraint[])objectArray, 1);
        }
        objectArray = this.getConstrainable();
        objectArray.setDataConstraint(this._total);
        if (bl) {
            this._firePropertyChange();
        }
    }

    void requestFocusToTable() {
        if (this._header != null) {
            this._header.requestFocus();
        }
    }

    JPopupMenu createPopupMenu(int n) {
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        MenuListen menuListen = new MenuListen();
        Header header = this.getHeader();
        Locale locale = header.getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        DataDescriptorProvider dataDescriptorProvider = this.getDescriptorProvider();
        if (dataDescriptorProvider != null) {
            DataDescriptor dataDescriptor = dataDescriptorProvider.getDescriptor(n);
            object = resourceBundle.getString(_KEY_MENU);
            MessageFormat messageFormat = new MessageFormat((String)object);
            Object[] objectArray = new Object[]{dataDescriptor.getDisplayName(locale)};
            String string = messageFormat.format(objectArray);
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand(_COMMAND_FILTER);
            jMenuItem.addActionListener(menuListen);
            jPopupMenu.add(jMenuItem);
        }
        if (this._dataConstraints[n] != null) {
            boolean bl = this._active[n];
            object = new JCheckBoxMenuItem(resourceBundle.getString(_ACTIVE_KEY));
            ((JCheckBoxMenuItem)object).setState(bl);
            ((AbstractButton)object).setActionCommand(_COMMAND_ACTIVATE);
            ((AbstractButton)object).addActionListener(menuListen);
            jPopupMenu.add((JMenuItem)object);
        }
        return jPopupMenu;
    }

    private void _firePropertyChange() {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange("dataConstraint", null, this.getDataConstraint());
        }
    }

    private void _updateUI() {
        Header header = this.getHeader();
        if (header == null) {
            return;
        }
        int n = this._active.length;
        int n2 = 0;
        while (n2 < n) {
            Painter painter = header.getPainter(n2);
            if (painter instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter cBHeaderItemPainter = (CBHeaderItemPainter)painter;
                cBHeaderItemPainter.setActive(this._active[n2]);
            }
            ++n2;
        }
        header.repaint();
    }

    private boolean _showWindow(int n) {
        DataConstraint dataConstraint;
        ConstraintCompFactory constraintCompFactory = this.getComponentFactory();
        DataDescriptorProvider dataDescriptorProvider = this.getDescriptorProvider();
        Constrainable constrainable = this.getConstrainable();
        if (dataDescriptorProvider == null || constrainable == null) {
            return true;
        }
        int n2 = dataDescriptorProvider.getDescriptorCount();
        if (n >= n2) {
            return true;
        }
        DataDescriptor dataDescriptor = dataDescriptorProvider.getDescriptor(n);
        ConstraintComponent constraintComponent = constraintCompFactory.createConstraintComponent(null, dataDescriptor, dataConstraint = this._dataConstraints[n]);
        if (constraintComponent == null) {
            return true;
        }
        Header header = this.getHeader();
        JDesktopPane jDesktopPane = this._getDesktop((Component)header);
        if (jDesktopPane == null) {
            throw new IllegalStateException("The header must have a JDesktopPane as an ancestor.  Try using the javax.swing.JDesktopPane component.");
        }
        if (this._window != null) {
            this._window.setConstraintComponent(null);
        }
        this._window = null;
        this._window = new CBWindow(this._okListener, this._cancelListener);
        boolean bl = dataConstraint == null ? true : this._active[n];
        Locale locale = header.getLocale();
        this._window.setWindowTitle(dataDescriptor.getDisplayName(locale));
        this._window.setConstraintActive(bl);
        this._window.setLocale(locale);
        this._window.setConstraintComponent(constraintComponent);
        this._item = n;
        this._armed = true;
        Point point = header.getLocationOnScreen();
        Point point2 = header.getCanvasOrigin();
        point.x -= point2.x;
        point.y -= point2.y;
        int n3 = header.getItemPosition(this._item);
        point.x = Math.max(point.x, point.x + (n3 += point2.x));
        point.y += header.getSize().height;
        Point point3 = jDesktopPane.getLocationOnScreen();
        point.x -= point3.x;
        point.y -= point3.y;
        this._window.setVisible(false);
        this._glassPane = new GlassPane();
        this._glassPane.add(this._window);
        jDesktopPane.add(this._glassPane);
        jDesktopPane.addComponentListener(this._glassPane);
        jDesktopPane.moveToFront(this._glassPane);
        this._glassPane.setBounds(0, 0, jDesktopPane.getWidth(), jDesktopPane.getHeight());
        this._window.pack();
        if (point.x + this._window.getWidth() > jDesktopPane.getWidth()) {
            point.x = Math.max(0, jDesktopPane.getWidth() - this._window.getWidth());
        }
        this._window.setLocation(point.x, point.y);
        DBUILookAndFeel.getTaskScheduler().schedule(this._runner, 0);
        return true;
    }

    private boolean _showPopupMenu(int n, int n2, int n3) {
        JPopupMenu jPopupMenu = this.createPopupMenu(n3);
        if (jPopupMenu != null && jPopupMenu.getComponentCount() != 0) {
            Header header = this.getHeader();
            DBUILookAndFeel.getLookAndFeel().popupMenu((Component)header, jPopupMenu, n += header.getItemPosition(n3), n2);
            this._menuItem = n3;
            return true;
        }
        return false;
    }

    private void _checkArmed(MouseEvent mouseEvent, int n) {
        CBHeaderItemPainter cBHeaderItemPainter;
        boolean bl;
        Header header;
        Painter painter;
        if (this._item == n && (painter = (header = this.getHeader()).getPainter(n)) instanceof CBHeaderItemPainter && (bl = (cBHeaderItemPainter = (CBHeaderItemPainter)painter).pointInActiveArea(header.getItemSize(n), header.getSize().height, mouseEvent.getX(), mouseEvent.getY())) != this._armed) {
            mouseEvent.consume();
            this._armed = bl;
            cBHeaderItemPainter.setActiveAreaArmed(this._armed);
            header.paintItem(n);
        }
    }

    private boolean _checkHeader(Header header) {
        boolean bl = true;
        Header header2 = this.getHeader();
        if (header2 == null) {
            this.setHeader(header);
        } else if (header != header2) {
            bl = false;
        }
        return bl;
    }

    private void _parseConstraint(DataConstraint dataConstraint) {
        if (dataConstraint instanceof DCNaryExpression) {
            DCNaryExpression dCNaryExpression = (DCNaryExpression)dataConstraint;
            int n = 0;
            while (n < dCNaryExpression.getConstraintCount()) {
                this._parseConstraint(dCNaryExpression.getConstraint(n));
                ++n;
            }
        } else if (dataConstraint instanceof DCBinaryExpression) {
            DCBinaryExpression dCBinaryExpression = (DCBinaryExpression)dataConstraint;
            DataConstraint dataConstraint2 = dCBinaryExpression.getConstraint(0);
            DataConstraint dataConstraint3 = dCBinaryExpression.getConstraint(1);
            if (dataConstraint2 instanceof DCVariable) {
                this._setItemConstraint((DCVariable)dataConstraint2, dCBinaryExpression);
            } else if (dataConstraint3 instanceof DCVariable) {
                this._setItemConstraint((DCVariable)dataConstraint3, dCBinaryExpression);
            } else {
                this._parseConstraint(dataConstraint2);
                this._parseConstraint(dataConstraint3);
            }
        } else if (dataConstraint instanceof DCBetweenExpression) {
            DCBetweenExpression dCBetweenExpression = (DCBetweenExpression)dataConstraint;
            DataConstraint dataConstraint4 = dCBetweenExpression.getFirstConstraint();
            if (dataConstraint4 instanceof DCVariable) {
                this._setItemConstraint((DCVariable)dataConstraint4, dCBetweenExpression);
            } else {
                dataConstraint4 = dCBetweenExpression.getSecondConstraint();
                if (dataConstraint4 instanceof DCVariable) {
                    this._setItemConstraint((DCVariable)dataConstraint4, dCBetweenExpression);
                } else {
                    dataConstraint4 = dCBetweenExpression.getCheckConstraint();
                    if (dataConstraint4 instanceof DCVariable) {
                        this._setItemConstraint((DCVariable)dataConstraint4, dCBetweenExpression);
                    }
                }
            }
        }
    }

    private void _setItemConstraint(DCVariable dCVariable, DataConstraint dataConstraint) {
        Object object = dCVariable.getVariable();
        String string = object instanceof DataDescriptor ? ((DataDescriptor)object).getName() : null;
        DataDescriptorProvider dataDescriptorProvider = this.getDescriptorProvider();
        int n = -1;
        int n2 = 0;
        while (n2 < dataDescriptorProvider.getDescriptorCount()) {
            DataDescriptor dataDescriptor = dataDescriptorProvider.getDescriptor(n2);
            if (dataDescriptor.equals(object) || dataDescriptor.getName().equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            this._dataConstraints[n] = dataConstraint;
            this._active[n] = true;
        }
    }

    private void _removeGlassPane() {
        if (this._glassPane != null) {
            JDesktopPane jDesktopPane;
            if (this._window != null) {
                this._glassPane.remove(this._window);
            }
            if ((jDesktopPane = this._getDesktop((Component)this.getHeader())) != null) {
                ((Container)jDesktopPane).remove(this._glassPane);
                jDesktopPane.removeComponentListener(this._glassPane);
                jDesktopPane.repaint();
            }
            this._glassPane = null;
        }
    }

    HeaderKeyHandler createHeaderKeyHandler() {
        return new MenuKeyHandler();
    }

    private class GlassPane
    extends JPanel
    implements ComponentListener {
        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    Toolkit.getDefaultToolkit().beep();
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Component component = (Component)componentEvent.getSource();
            this.setBounds(0, 0, component.getWidth(), component.getHeight());
        }
    }

    class MenuKeyHandler
    extends StandardHeaderKeyHandler {
        MenuKeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1 && keyEvent.getID() == 401) {
                int n = header.getFocusItem();
                if (n != -1) {
                    CBHeaderInputHandler.this._showPopupMenu(header.getItemSize(n) / 2, header.getSize().height / 3, n);
                }
                keyEvent.consume();
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }

    private class MenuListen
    implements ActionListener {
        private MenuListen() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (CBHeaderInputHandler._COMMAND_ACTIVATE.equals(string)) {
                boolean bl;
                CBHeaderInputHandler.this._active[CBHeaderInputHandler.this._menuItem] = bl = !CBHeaderInputHandler.this._active[CBHeaderInputHandler.this._menuItem];
                Painter painter = CBHeaderInputHandler.this._header.getPainter(CBHeaderInputHandler.this._menuItem);
                if (painter instanceof CBHeaderItemPainter) {
                    ((CBHeaderItemPainter)painter).setActive(bl);
                    CBHeaderInputHandler.this._header.paintItem(CBHeaderInputHandler.this._menuItem);
                }
                CBHeaderInputHandler.this.setDataConstraint(true);
            } else if (CBHeaderInputHandler._COMMAND_FILTER.equals(string)) {
                CBHeaderInputHandler.this._showWindow(CBHeaderInputHandler.this._menuItem);
            }
        }
    }

    private class Run
    implements Task {
        private Run() {
        }

        public void runTask(TaskEvent taskEvent) {
            CBHeaderInputHandler.this._window.pack();
            CBHeaderInputHandler.this._window.setVisible(true);
            CBHeaderInputHandler.this._window.repaint();
            CBHeaderInputHandler.this._window.requestFocus();
        }
    }

    private class Cancl
    implements ActionListener {
        private Cancl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CBHeaderInputHandler.this._window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            Painter painter = CBHeaderInputHandler.this._header.getPainter(CBHeaderInputHandler.this._item);
            if (painter instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter cBHeaderItemPainter = (CBHeaderItemPainter)painter;
                cBHeaderItemPainter.setActiveAreaArmed(false);
                CBHeaderInputHandler.this._header.paintItem(CBHeaderInputHandler.this._item);
            }
            CBHeaderInputHandler.this._removeGlassPane();
            CBHeaderInputHandler.this._item = -1;
            CBHeaderInputHandler.this.requestFocusToTable();
        }
    }

    private class OK
    implements ActionListener {
        private OK() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            try {
                CBHeaderInputHandler.this._window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            DataConstraint dataConstraint = CBHeaderInputHandler.this._window.getDataConstraint();
            CBHeaderInputHandler.this._active[CBHeaderInputHandler.this._item] = bl = dataConstraint == null ? false : CBHeaderInputHandler.this._window.isConstraintActive();
            CBHeaderInputHandler.this._dataConstraints[CBHeaderInputHandler.this._item] = dataConstraint;
            Painter painter = CBHeaderInputHandler.this._header.getPainter(CBHeaderInputHandler.this._item);
            if (painter instanceof CBHeaderItemPainter) {
                CBHeaderItemPainter cBHeaderItemPainter = (CBHeaderItemPainter)painter;
                cBHeaderItemPainter.setActive(bl);
                cBHeaderItemPainter.setActiveAreaArmed(false);
                CBHeaderInputHandler.this._header.paintItem(CBHeaderInputHandler.this._item);
            }
            CBHeaderInputHandler.this._removeGlassPane();
            CBHeaderInputHandler.this.setDataConstraint(true);
            CBHeaderInputHandler.this._item = -1;
            CBHeaderInputHandler.this.requestFocusToTable();
        }
    }

    private class DSListen
    implements OneDModelListener {
        private DSListen() {
        }

        public void itemsAdded(OneDModelEvent oneDModelEvent) {
            CBHeaderInputHandler.this._addToArrays(oneDModelEvent.getStartIndex(), oneDModelEvent.getItemCount());
        }

        public void itemsRemoved(OneDModelEvent oneDModelEvent) {
            CBHeaderInputHandler.this._removeFromArrays(oneDModelEvent.getStartIndex(), oneDModelEvent.getItemCount());
        }

        public void invalidateItems(OneDModelEvent oneDModelEvent) {
        }
    }

    private class MListen
    extends MouseMotionAdapter {
        private MListen() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (CBHeaderInputHandler.this._item != -1) {
                int n;
                Point point = CBHeaderInputHandler.this._header.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
                boolean bl = CBHeaderInputHandler.this._header.getOrientation() == 0;
                Point point2 = CBHeaderInputHandler.this._header.getCanvasOrigin();
                int n2 = CBHeaderInputHandler.this._header.getItemPosition(CBHeaderInputHandler.this._item);
                if (bl) {
                    n = -point2.x - n2;
                    mouseEvent.translatePoint(n, 0);
                } else {
                    n = -point2.y - n2;
                    mouseEvent.translatePoint(0, n);
                }
                CBHeaderInputHandler.this.mouseDragged(mouseEvent, CBHeaderInputHandler.this._header, CBHeaderInputHandler.this._item);
                if (bl) {
                    mouseEvent.translatePoint(-n, 0);
                } else {
                    mouseEvent.translatePoint(0, -n);
                }
                mouseEvent.consume();
            }
        }
    }
}

