/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.dbUI.graph.jle.JLECaptionTile;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;

class TitleBar
extends JPanel {
    private JLEWindow _component;
    private JLabel _titleLabel;
    private JLabel _iconLabel;
    private CaptionComp _captionTile;
    private JPanel _buttonPanel;
    private JButton _minimizeButton;
    private JButton _restoreButton;
    private JButton _closeButton;
    private static final String _ACTIVE = "paintActive";
    private boolean _armed;
    private static final int _MINIMUM_WIDTH = 130;
    private static final int _CAPTION_MIN_WIDTH = 45;
    private static KeyStroke _sCloseShortcut;
    private static final String _RESTORE_KEY = "RESTORE";
    private static final String _MOVE_KEY = "MOVE";
    private static final String _RESIZE_KEY = "RESIZE";
    private static final String _MINIMIZE_KEY = "MINIMIZE";
    private static final String _CLOSE_KEY = "CLOSE";
    private static final Painter _CAPTION_FILL;
    private static Painter _sCloseIcon;
    private static Painter _sMinimizeIcon;
    private static Painter _sRestoreIcon;
    private static Painter _sLightPainter;
    private static Painter _sDarkPainter;
    private Image _image;
    private Color _background;
    private Color _foreground;
    private boolean _tooltipDefaulted = true;
    private String _tooltipString;
    private boolean _autoDisplay;
    private static final int _DEFAULT_HEIGHT = 20;

    public TitleBar(JLEWindow jLEWindow) {
        this._component = jLEWindow;
        this._createComponents();
        this.__updateButtons();
        this._updateCaptionFill();
        this._addListeners();
    }

    public void setPainter(Painter painter) {
        this._captionTile.setPainter(painter);
    }

    public Painter getPainter() {
        return this._captionTile.getPainter();
    }

    public void setTitleBackground(Color color) {
        this._background = color;
        this.setBackground(color);
    }

    public void setTitleForeground(Color color) {
        this._foreground = color;
        this.setForeground(color);
    }

    public Color getBackground() {
        UIDefaults uIDefaults;
        Color color;
        if (this._component != null && (color = this._getBackground(uIDefaults = UIManager.getDefaults(), this.isActive())) != null) {
            return color;
        }
        return super.getBackground();
    }

    public Color getForeground() {
        UIDefaults uIDefaults;
        Color color;
        if (this._component != null && (color = this._getForeground(uIDefaults = UIManager.getDefaults(), this.isActive())) != null) {
            return color;
        }
        return super.getForeground();
    }

    public void setClosable(boolean bl) {
        this._closeButton.setVisible(bl);
    }

    public boolean isClosable() {
        return this._closeButton.isVisible();
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void setArmed(boolean bl) {
        if (bl != this._armed) {
            this._armed = bl;
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = 130;
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        Dimension dimension2 = this.getPreferredSize();
        dimension.height = dimension2.height;
        return dimension;
    }

    public void setTitle(String string) {
        this._titleLabel.setText(string);
        this.invalidate();
        this.repaint();
    }

    public void setToolTipText(String string) {
        this._tooltipDefaulted = string == null;
        this._tooltipString = string;
        this._titleLabel.setToolTipText(string);
    }

    public boolean isToolTipDefaulted() {
        return this._tooltipDefaulted;
    }

    public String getToolTipText() {
        return this._tooltipString;
    }

    public void setAutoDisplay(boolean bl) {
        if (this._autoDisplay != bl) {
            this._autoDisplay = bl;
            if (bl) {
                if (this.isToolTipDefaulted()) {
                    this._titleLabel.setToolTipText(this.getTitle());
                }
            } else if (this.isToolTipDefaulted()) {
                this._titleLabel.setToolTipText(null);
            }
        }
    }

    public boolean getAutoDisplay() {
        return this._autoDisplay;
    }

    public String getTitle() {
        return this._titleLabel.getText();
    }

    public void setSelected(boolean bl) {
        this._updateButtonActiveState(bl);
    }

    public boolean isActive() {
        return this._component.isSelected();
    }

    private void _createComponents() {
        this._titleLabel = new JLabel(){
            private Font _font;

            public void setToolTipText(String string) {
                super.setToolTipText(string);
                ToolTipManager.sharedInstance().unregisterComponent(TitleBar.this._titleLabel);
            }

            public Font getFont() {
                Font font = super.getFont();
                if (font != null && (this._font == null || font.getName() != this._font.getName() || font.getSize() != this._font.getSize())) {
                    this._font = new Font(font.getName(), 1, font.getSize());
                }
                return this._font;
            }

            public Color getForeground() {
                if (TitleBar.this != null) {
                    return TitleBar.this.getForeground();
                }
                return super.getForeground();
            }
        };
        this._iconLabel = new JLabel();
        this._captionTile = new CaptionComp();
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new FlowLayout(0, 2, 0));
        this._buttonPanel.setOpaque(false);
        this._minimizeButton = this._createButton("InternalFrame.iconifyIcon");
        this._restoreButton = this._createButton("InternalFrame.minimizeIcon");
        this._closeButton = this._createButton("InternalFrame.closeIcon");
        this._updateButtonActiveState(this.isActive());
        this._buttonPanel.add(this._minimizeButton);
        this._buttonPanel.add(this._restoreButton);
        this._buttonPanel.add(this._closeButton);
        this.setLayout(new TitleBarLayout());
        this.add(this._titleLabel);
        this.add(this._iconLabel);
        this.add((Component)((Object)this._captionTile));
        this.add(this._buttonPanel);
    }

    private Color _getBackground(UIDefaults uIDefaults, boolean bl) {
        return this._background != null ? this._background : (bl ? uIDefaults.getColor("InternalFrame.activeTitleBackground") : uIDefaults.getColor("InternalFrame.inactiveTitleBackground"));
    }

    private Color _getForeground(UIDefaults uIDefaults, boolean bl) {
        return this._foreground != null ? this._foreground : (bl ? uIDefaults.getColor("InternalFrame.activeTitleForeground") : uIDefaults.getColor("InternalFrame.inactiveTitleForeground"));
    }

    void __updateButtons() {
        JLEWindow jLEWindow = this._component;
        boolean bl = jLEWindow.isMinimized();
        this._restoreButton.setVisible(bl);
        this._minimizeButton.setVisible(!bl);
    }

    private void _updateCaptionFill() {
        JLEWindow jLEWindow = this._component;
        Painter painter = _CAPTION_FILL;
        if (painter != this._captionTile.getPainter()) {
            this._captionTile.setPainter(painter);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._updateEnabledState();
    }

    public void setImage(Image image) {
        this._image = image;
        this._iconLabel.setIcon(new ImageIcon(image));
    }

    public Image getImage() {
        return this._image;
    }

    private void _addListeners() {
        JLEWindow jLEWindow = this._component;
        ActionHandler actionHandler = new ActionHandler();
        this._titleLabel.addMouseListener(actionHandler);
        this._iconLabel.addMouseListener(actionHandler);
        ((Component)((Object)this._captionTile)).addMouseListener(actionHandler);
        this.addMouseListener(actionHandler);
        this._minimizeButton.addMouseListener(actionHandler);
        this._restoreButton.addMouseListener(actionHandler);
        this._closeButton.addMouseListener(actionHandler);
    }

    private void _updateEnabledState() {
        JLEWindow jLEWindow = this._component;
        boolean bl = jLEWindow.isEnabled();
        this._titleLabel.setEnabled(bl);
        this._iconLabel.setEnabled(bl);
        this._minimizeButton.setEnabled(bl);
        this._closeButton.setEnabled(bl);
        this._restoreButton.setEnabled(bl);
    }

    private JButton _createButton(String string) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Icon icon = uIDefaults.getIcon(string);
        TitleBarButton titleBarButton = new TitleBarButton(icon);
        return titleBarButton;
    }

    private void _updateButtonActiveState(boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this._minimizeButton.putClientProperty(_ACTIVE, bl2);
        this._closeButton.putClientProperty(_ACTIVE, bl2);
        this._restoreButton.putClientProperty(_ACTIVE, bl2);
    }

    static KeyStroke __getCloseShortcut() {
        if (_sCloseShortcut == null) {
            _sCloseShortcut = KeyStroke.getKeyStroke(115, 2);
        }
        return _sCloseShortcut;
    }

    private static Painter _createFill(Painter painter) {
        return new AndOrStatePainterSwitcher((Painter)new FixedBorderPainter((Painter)new FixedAlignmentPainter(painter, 0.0f, 0.5f), 0, 8, 0, 0), (Painter)NullPainter.getPainter(), 4, 0, 0, 0);
    }

    static {
        _CAPTION_FILL = TitleBar._createFill(JLECaptionTile.getPainter());
    }

    private class TitleBarLayout
    implements LayoutManager2 {
        private TitleBarLayout() {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public void invalidateLayout(Container container) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public Dimension preferredLayoutSize(Container container) {
            return this._getSize(1);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this._getSize(0);
        }

        public Dimension maximumLayoutSize(Container container) {
            return this._getSize(2);
        }

        private Dimension _getSize(int n) {
            int n2 = 20;
            int n3 = 0;
            switch (n) {
                case 0: {
                    Dimension dimension;
                    n3 += 5;
                    if (TitleBar.this._iconLabel.getIcon() != null) {
                        dimension = TitleBar.this._iconLabel.getMinimumSize();
                        n3 += dimension.width + 5;
                        if (dimension.height > n2) {
                            n2 = dimension.height;
                        }
                    }
                    if (TitleBar.this._titleLabel.getText() != null) {
                        dimension = TitleBar.this._titleLabel.getMinimumSize();
                        n3 += dimension.width + 5;
                        if (dimension.height > n2) {
                            n2 = dimension.height;
                        }
                    }
                    n3 += 50;
                    dimension = TitleBar.this._buttonPanel.getMinimumSize();
                    n3 += dimension.width + 5;
                    if (dimension.height <= n2) break;
                    n2 = dimension.height;
                    break;
                }
                case 1: {
                    Dimension dimension;
                    n3 += 5;
                    if (TitleBar.this._iconLabel.getIcon() != null) {
                        dimension = TitleBar.this._iconLabel.getPreferredSize();
                        n3 += dimension.width + 5;
                        if (dimension.height > n2) {
                            n2 = dimension.height;
                        }
                    }
                    if (TitleBar.this._titleLabel.getText() != null) {
                        dimension = TitleBar.this._titleLabel.getPreferredSize();
                        n3 += dimension.width + 5;
                        if (dimension.height > n2) {
                            n2 = dimension.height;
                        }
                    }
                    n3 += 50;
                    dimension = TitleBar.this._buttonPanel.getPreferredSize();
                    n3 += dimension.width + 5;
                    if (dimension.height <= n2) break;
                    n2 = dimension.height;
                    break;
                }
                case 2: {
                    Dimension dimension;
                    n3 += 5;
                    if (TitleBar.this._iconLabel.getIcon() != null) {
                        dimension = TitleBar.this._iconLabel.getMaximumSize();
                        n3 += dimension.width + 5;
                        if (dimension.height > n2) {
                            n2 = dimension.height;
                        }
                    }
                    if (TitleBar.this._titleLabel.getText() != null) {
                        dimension = TitleBar.this._titleLabel.getMaximumSize();
                        n3 += dimension.width + 5;
                        if (dimension.height > n2) {
                            n2 = dimension.height;
                        }
                    }
                    n3 += 50;
                    dimension = TitleBar.this._buttonPanel.getMaximumSize();
                    n3 += dimension.width + 5;
                    if (dimension.height <= n2) break;
                    n2 = dimension.height;
                }
            }
            return new Dimension(n3, n2);
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            Dimension dimension2 = new Dimension(dimension.width, dimension.height);
            boolean bl = true;
            int n = 5;
            if (insets != null) {
                n += insets.left;
            }
            int n2 = dimension.width - 5;
            if (insets != null) {
                n2 -= insets.left + insets.right;
            }
            if (TitleBar.this._iconLabel.getIcon() != null) {
                dimension2 = TitleBar.this._iconLabel.getPreferredSize();
                if (bl) {
                    TitleBar.this._iconLabel.setBounds(n, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
                    n += dimension2.width + 5;
                } else {
                    TitleBar.this._iconLabel.setBounds(n2 - dimension2.width, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
                    n2 -= dimension2.width + 5;
                }
            }
            dimension2 = TitleBar.this._buttonPanel.getPreferredSize();
            if (bl) {
                TitleBar.this._buttonPanel.setBounds(n2 - dimension2.width, (dimension.height - dimension2.height) / 2, dimension.width, dimension2.height);
                n2 -= dimension2.width + 5;
            } else {
                TitleBar.this._buttonPanel.setBounds(n, (dimension.height - dimension2.height) / 2, dimension.width, dimension2.height);
                n += dimension2.width + 5;
            }
            if (TitleBar.this._titleLabel.getText() != null) {
                dimension2 = TitleBar.this._titleLabel.getPreferredSize();
                if (n + dimension2.width + 45 + 5 > n2) {
                    dimension2.width = n2 - n - 45 - 5;
                    if (TitleBar.this._tooltipDefaulted) {
                        TitleBar.this._titleLabel.setToolTipText(TitleBar.this._titleLabel.getText());
                    }
                }
                if (bl) {
                    TitleBar.this._titleLabel.setBounds(n, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
                    n += dimension2.width + 5;
                } else {
                    TitleBar.this._titleLabel.setBounds(n2 - dimension2.width, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
                    n2 -= dimension2.width + 5;
                }
            }
            int n3 = insets == null ? 0 : insets.top;
            ((Component)((Object)TitleBar.this._captionTile)).setBounds(n, n3, n2 - n, dimension.height);
        }
    }

    private class CaptionComp
    extends PainterComponent {
        private CaptionComp() {
        }

        public Dimension getMinimumSize() {
            Painter painter = this.getPainter();
            Dimension dimension = super.getMinimumSize();
            dimension.height = painter.getMinimumSize((PaintContext)this.getPaintContext()).height;
            if (dimension.width < 45) {
                dimension.width = 45;
            }
            return dimension;
        }

        protected int getPaintState() {
            int n = super.getPaintState();
            if (TitleBar.this.isArmed()) {
                n |= 2;
            }
            if (TitleBar.this.isActive()) {
                n |= 0x20;
            }
            return n;
        }
    }

    private class ActionHandler
    extends MouseAdapter {
        private ActionHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLEWindow jLEWindow = TitleBar.this._component;
            if (!jLEWindow.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Object object = mouseEvent.getSource();
            if (object == TitleBar.this._minimizeButton) {
                jLEWindow.setMinimized(true);
            } else if (object == TitleBar.this._restoreButton) {
                if (jLEWindow.isMinimized()) {
                    jLEWindow.setMinimized(false);
                }
            } else if (object == TitleBar.this._closeButton) {
                jLEWindow.close();
            } else if (mouseEvent.getClickCount() % 2 == 0 && jLEWindow.isMinimized()) {
                jLEWindow.setMinimized(false);
            }
            if (object == TitleBar.this._captionTile || object == TitleBar.this._titleLabel) {
                TitleBar.this.setArmed(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JLEWindow jLEWindow = TitleBar.this._component;
            if (!jLEWindow.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Object object = mouseEvent.getSource();
            if (object == TitleBar.this._captionTile || object == TitleBar.this._titleLabel) {
                TitleBar.this.setArmed(false);
            }
        }
    }

    private class TitleBarButton
    extends JButton {
        public TitleBarButton(Icon icon) {
            super(icon);
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setContentAreaFilled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

