/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.NodeFocusManager;
import oracle.bali.jle.GlassPane;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.ComponentItem;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;

class NodeGlassPane
extends GlassPane {
    public static final Object TOOLTIP_KEY = new StringKey("TOOLTIP_KEY");

    public NodeGlassPane(GraphCanvas graphCanvas) {
        super((JLECanvas)graphCanvas);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        FocusManager.setCurrentManager(new NodeFocusManager(graphCanvas));
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        JLECanvas jLECanvas = this.getCanvas();
        Point point = new Point(0, 0);
        Point2D point2D = jLECanvas.deviceToContent((double)(n - point.x), (double)(n2 - point.y));
        LayoutItem layoutItem = jLECanvas.getHitItem(point2D.getX(), point2D.getY());
        while (layoutItem != null) {
            Point2D point2D2;
            String string;
            Object object = layoutItem.getProperty(TOOLTIP_KEY);
            if (object != PropertyManager.NOT_FOUND_OBJECT && object != null && !"".equals(object)) {
                return (String)object;
            }
            if (layoutItem instanceof ComponentItem && (string = ((ComponentItem)layoutItem).getToolTipText((point2D2 = ItemUtils.deviceToItem((LayoutItem)layoutItem, (double)(n - point.x), (double)(n2 - point.y))).getX(), point2D2.getY())) != null && !"".equals(string)) {
                return string;
            }
            layoutItem = layoutItem.getItemParent();
        }
        return null;
    }
}

