/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import javax.swing.DefaultFocusManager;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.NodeBoundsTool;
import oracle.bali.dbUI.graph.jle.NodeTool;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;

class NodeFocusManager
extends DefaultFocusManager {
    private GraphCanvas _canvas;

    public NodeFocusManager(GraphCanvas graphCanvas) {
        this._canvas = graphCanvas;
    }

    public GraphCanvas getCanvas() {
        return this._canvas;
    }

    public void processKeyEvent(Component component, KeyEvent keyEvent) {
        if (component != null && !((Container)((Object)this.getCanvas())).isAncestorOf(component)) {
            super.processKeyEvent(component, keyEvent);
            return;
        }
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t') {
            keyEvent.consume();
            if (keyEvent.getID() != 401) {
                return;
            }
            LayoutItem layoutItem = this.getCanvas().getFocusedItem();
            if (keyEvent.isControlDown() || layoutItem == null) {
                if (keyEvent.isShiftDown()) {
                    this._transferBack(layoutItem);
                } else {
                    this._transferForward(layoutItem);
                }
            } else if (layoutItem instanceof JLENodeWindow) {
                JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
                Component component2 = jLENodeWindow.getComponent();
                if (jLENodeWindow.isMinimized()) {
                    component2.requestFocus();
                } else {
                    Object object = null;
                    Grid grid = jLENodeWindow.getNodeComponent().getSpreadTable().getGrid();
                    Header header = jLENodeWindow.getNodeComponent().getSpreadTable().getColumnHeader();
                    object = keyEvent.getSource() == grid ? (keyEvent.isShiftDown() ? component2 : header) : (keyEvent.getSource() == header ? (keyEvent.isShiftDown() ? grid : component2) : (keyEvent.isShiftDown() ? header : grid));
                    if (object != null) {
                        ((Component)object).requestFocus();
                    }
                }
            }
        }
    }

    public void focusNextComponent(Component component) {
        if (component != null && !((Container)((Object)this.getCanvas())).isAncestorOf(component)) {
            super.focusNextComponent(component);
        }
    }

    public void focusPreviousComponent(Component component) {
        if (component != null && !((Container)((Object)this.getCanvas())).isAncestorOf(component)) {
            super.focusPreviousComponent(component);
        }
    }

    private void _transferForward(LayoutItem layoutItem) {
        LayoutItem layoutItem2 = this.getCanvas().getFocusNext(layoutItem, true);
        LayoutTool layoutTool = this.getCanvas().getTool();
        if (layoutTool instanceof NodeTool) {
            NodeBoundsTool nodeBoundsTool = ((NodeTool)layoutTool).getBoundsTool();
            if (layoutItem != null) {
                nodeBoundsTool.processDeselect(layoutItem);
            }
            if (layoutItem2 != null) {
                nodeBoundsTool.processSelect(layoutItem2);
            }
        }
    }

    private void _transferBack(LayoutItem layoutItem) {
        LayoutItem layoutItem2 = this.getCanvas().getFocusPrevious(layoutItem, true);
        LayoutTool layoutTool = this.getCanvas().getTool();
        if (layoutTool instanceof NodeTool) {
            NodeBoundsTool nodeBoundsTool = ((NodeTool)layoutTool).getBoundsTool();
            if (layoutItem != null) {
                nodeBoundsTool.processDeselect(layoutItem);
            }
            if (layoutItem2 != null) {
                nodeBoundsTool.processSelect(layoutItem2);
            }
        }
    }
}

