/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.dbUI.graph.NodeToolTipClient;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.geom.Dimension2D;

public class JLENodeWindow
extends JLEWindow {
    private Listener _listener;
    private boolean _added;

    protected JLENodeWindow() {
        this(null);
    }

    protected JLENodeWindow(Node node) {
        NodeComponent nodeComponent = this.createNodeComponent();
        this._listener = new Listener();
        this.setContent((Component)((Object)nodeComponent));
        this.setNode(node);
        nodeComponent.getSpreadTable().getGrid().addKeyListener(this._listener);
        nodeComponent.getSpreadTable().getColumnHeader().addKeyListener(this._listener);
        this.getComponent().addKeyListener(this._listener);
        ((Container)((Object)nodeComponent)).addPropertyChangeListener(this._listener);
        this._addMouseListener(this.__getTitleBar(), this._listener);
        this._unregisterComponents(this.getComponent());
    }

    void setAutoDisplayToolTips(boolean bl) {
        super.setAutoDisplayToolTips(bl);
        NodeComponent nodeComponent = this.getNodeComponent();
        Grid grid = nodeComponent.getSpreadTable().getGrid();
        GridToolTipManager gridToolTipManager = grid.getToolTipManager();
        if (gridToolTipManager instanceof NodeToolTipClient) {
            ((NodeToolTipClient)gridToolTipManager).setAlwaysDisplayed(bl);
        }
    }

    public void setNode(Node node) {
        Node node2 = this.getNode();
        if (node != node2) {
            if (node2 != null) {
                node2.removePropertyChangeListener(this._listener);
            }
            if (node != null) {
                node.addPropertyChangeListener(this._listener);
            }
            this.getNodeComponent().setNode(node);
            Dimension dimension = this.getComponent().getPreferredSize();
            this.__setItemSize(dimension.width, dimension.height);
        }
    }

    public Node getNode() {
        return this.getNodeComponent().getNode();
    }

    public NodeComponent getNodeComponent() {
        return (NodeComponent)((Object)this.getContent());
    }

    public Port getPort(double d, double d2) {
        Dimension2D dimension2D = this.getItemSize();
        Insets insets = this.__getBorderInsets();
        if (d < (double)insets.left || d >= dimension2D.getWidth() - (double)insets.right || d2 < (double)insets.top || d2 >= dimension2D.getHeight() - (double)insets.bottom || this.isMinimized()) {
            return null;
        }
        Rectangle rectangle = this.__getTitleBarBounds();
        if (d2 < (double)(rectangle.y + rectangle.height)) {
            return this.getNode();
        }
        Point point = this.__getContentLocation();
        int n = (int)d2 - point.y;
        return this.getNodeComponent().getPortAt(n);
    }

    public void setMinimized(boolean bl) {
        super.setMinimized(bl);
        if (bl && !this._added && this.__getMinimizedComponent() != null) {
            this._addMouseListener(this.__getMinimizedComponent(), this._listener);
            this._added = true;
        }
    }

    public void setContent(Component component) {
        if (!(component instanceof NodeComponent)) {
            throw new IllegalArgumentException("JLENodeWindow only displays NodeComponents");
        }
        super.setContent(component);
    }

    protected NodeComponent createNodeComponent() {
        return new NodeComponent();
    }

    void __updateSize() {
        this.repaintItem();
        Dimension dimension = this.getComponent().getPreferredSize();
        this.setItemSize(dimension.width, dimension.height);
        this.repaintItem();
    }

    private void _addMouseListener(Component component, MouseListener mouseListener) {
        component.addMouseListener(mouseListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this._addMouseListener(container.getComponent(n2), mouseListener);
                ++n2;
            }
        }
    }

    private void _unregisterComponents(Component component) {
        if (component instanceof JComponent) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)component);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this._unregisterComponents(container.getComponent(n));
                ++n;
            }
        }
    }

    private class Listener
    extends KeyAdapter
    implements PropertyChangeListener,
    MouseListener {
        private boolean _pressConsumed = false;

        private Listener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (GraphCanvas.__isPopupTrigger(mouseEvent)) {
                this._pressConsumed = true;
                mouseEvent.consume();
            } else if (this._pressConsumed) {
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (GraphCanvas.__isPopupTrigger(mouseEvent)) {
                JLECanvas jLECanvas = JLENodeWindow.this.getCanvas();
                if (jLECanvas instanceof GraphCanvas) {
                    ((GraphCanvas)jLECanvas).__showMenuForNode(JLENodeWindow.this.getNode(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), JLENodeWindow.this.isMinimized());
                    mouseEvent.consume();
                }
            } else if (this._pressConsumed) {
                mouseEvent.consume();
                this._pressConsumed = false;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            String string = null;
            if (mouseEvent.getClickCount() == 1) {
                string = "GraphCanvas.nodeSingleClick";
            } else if (mouseEvent.getClickCount() % 2 == 0) {
                string = "GraphCanvas.nodeDoubleClick";
            }
            JLECanvas jLECanvas = JLENodeWindow.this.getCanvas();
            if (jLECanvas instanceof GraphCanvas) {
                ((GraphCanvas)jLECanvas).__fireActionEvent(JLENodeWindow.this.getNode(), string, mouseEvent.getModifiers());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("nodeExpanded".equals(string)) {
                JLENodeWindow.this.__updateSize();
            } else if ("portSelectionCount".equals(string)) {
                JLECanvas jLECanvas = JLENodeWindow.this.getCanvas();
                if (jLECanvas instanceof GraphCanvas) {
                    ((GraphCanvas)jLECanvas).firePropertyChange("portSelectionCount", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            } else if ("displayName".equals(string)) {
                Locale locale = LocaleUtils.getDefaultableLocale((Component)JLENodeWindow.this.getContent());
                JLENodeWindow.this.setTitle(JLENodeWindow.this.getNode().getDisplayName(locale));
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getComponent() == JLENodeWindow.this.getComponent() && keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
                JLECanvas jLECanvas = JLENodeWindow.this.getCanvas();
                if (jLECanvas instanceof GraphCanvas) {
                    ((GraphCanvas)jLECanvas).__showMenuForNode(JLENodeWindow.this.getNode(), JLENodeWindow.this.__getTitleBar(), 0, 0, JLENodeWindow.this.isMinimized());
                }
                return;
            }
        }
    }
}

