/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.bali.dbUI.graph.DefaultEdgeFactory;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.EdgeFactory;
import oracle.bali.dbUI.graph.Graph;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.EdgeLinkItem;
import oracle.bali.dbUI.graph.jle.JLENodeWindow;
import oracle.bali.dbUI.graph.jle.NodeGlassPane;
import oracle.bali.dbUI.graph.jle.NodeTool;
import oracle.bali.dbUI.graph.jle.PortLinkPort;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.jle.GlassPane;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventAdapter;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.CompContainerFactory;
import oracle.bali.jle.item.DefaultLinkPainter;
import oracle.bali.jle.item.LinkPainter;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.tool.LinkToolEvent;
import oracle.bali.jle.tool.LinkToolListener;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class GraphCanvas
extends JLECanvas
implements Graph {
    public static final String PROPERTY_NODE_SELECTION_COUNT = "nodeSelectionCount";
    public static final String PROPERTY_EDGE_SELECTION_COUNT = "edgeSelectionCount";
    public static final String PROPERTY_PORT_SELECTION_COUNT = "portSelectionCount";
    public static final String COMMAND_NODE_DOUBLE_CLICK = "GraphCanvas.nodeDoubleClick";
    public static final String COMMAND_NODE_SINGLE_CLICK = "GraphCanvas.nodeSingleClick";
    public static final String COMMAND_PORT_DOUBLE_CLICK = "GraphCanvas.portDoubleClick";
    public static final String COMMAND_PORT_SINGLE_CLICK = "GraphCanvas.portSingleClick";
    private static final String _CREATE_SEPARATOR = ".";
    private static final String _DELETE_SEPARATOR = ": ";
    private static final String _KEY_LINKTO = "GRAPH.LINK_TO";
    private static final String _KEY_DELETELINK = "GRAPH.DELETE_LINK";
    static final String COMMAND_LINK = "LINK";
    static final String COMMAND_DELETE_LINK = "DELETE_LINK";
    private Port _menuPort;
    private Hashtable _sources;
    private Hashtable _targets;
    private Hashtable _links;
    private Listener _listener;
    private LinkPainter _defaultPainter;
    private EdgeFactory _edgeFactory;
    private ListenerManager _actionListeners;
    private boolean _tooltipDisplay = true;
    private Vector _items;
    private boolean _createMode;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$oracle$bali$jle$item$JComponentContainer;

    public GraphCanvas() {
        CompContainerFactory.registerCompContainerClass((Class)(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = GraphCanvas.class$("javax.swing.JComponent")) : class$javax$swing$JComponent), (Class)(class$oracle$bali$jle$item$JComponentContainer == null ? (class$oracle$bali$jle$item$JComponentContainer = GraphCanvas.class$("oracle.bali.jle.item.JComponentContainer")) : class$oracle$bali$jle$item$JComponentContainer));
        NodeTool nodeTool = new NodeTool();
        this._listener = new Listener();
        nodeTool.getLinkTool().addLinkToolListener((LinkToolListener)this._listener);
        this.setTool(nodeTool);
        this.getContentItem().setBackground(Color.white);
        this.addJLEEventListener((JLEEventListener)this._listener);
        this._sources = new Hashtable();
        this._targets = new Hashtable();
        this._links = new Hashtable();
        this._items = new Vector();
    }

    public void setCreateMode(boolean bl) {
        if (this._createMode != bl) {
            this._createMode = bl;
            LayoutItem[] layoutItemArray = this.getContentItem().getItems();
            int n = layoutItemArray == null ? 0 : layoutItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                LayoutItem layoutItem = layoutItemArray[n2];
                if (layoutItem instanceof JLENodeWindow) {
                    JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
                    jLENodeWindow.getNodeComponent().setCreateMode(bl);
                    jLENodeWindow.__updateSize();
                }
                ++n2;
            }
            if (!this._createMode) {
                ((Container)((Object)this)).validate();
            }
        }
    }

    public boolean isCreateMode() {
        return this._createMode;
    }

    public void setAutoDisplayToolTips(boolean bl) {
        if (this._tooltipDisplay != bl) {
            this._tooltipDisplay = bl;
            this._updateTooltips();
        }
    }

    public boolean getAutoDisplayToolTips() {
        return this._tooltipDisplay;
    }

    public JLENodeWindow addNode(Node node) {
        JLENodeWindow jLENodeWindow = this.getNodeWindow(node);
        if (jLENodeWindow != null) {
            return jLENodeWindow;
        }
        JLENodeWindow jLENodeWindow2 = this.createNodeWindow();
        PropertyManager propertyManager = jLENodeWindow2.getPropertyManager();
        propertyManager.addPropertyChangeListener((PropertyChangeListener)this._listener);
        jLENodeWindow2.getNodeComponent().setCreateMode(this.isCreateMode());
        jLENodeWindow2.setNode(node);
        this.getContentItem().addItem((LayoutItem)jLENodeWindow2);
        this._items.addElement(jLENodeWindow2);
        jLENodeWindow2.getNodeComponent().setGraph(this);
        ((Container)((Object)jLENodeWindow2.getNodeComponent())).addPropertyChangeListener(this._listener);
        jLENodeWindow2.getNodeComponent().addActionListener(this._listener);
        return jLENodeWindow2;
    }

    public void removeNode(Node node) {
        LayoutItem[] layoutItemArray = this.getContentItem().getItems();
        int n = layoutItemArray == null ? 0 : layoutItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Edge edge;
            Object object;
            LayoutItem layoutItem = layoutItemArray[n2];
            if (layoutItem instanceof JLENodeWindow) {
                object = (JLENodeWindow)layoutItem;
                if (object.getNode() == node) {
                    object.getNodeComponent().removeActionListener(this._listener);
                    ((Component)((Object)object.getNodeComponent())).removePropertyChangeListener(this._listener);
                    object.getNodeComponent().setGraph(null);
                    edge = object.getPropertyManager();
                    edge.removePropertyChangeListener(this._listener);
                    this.getContentItem().removeItem((LayoutItem)object);
                    this._items.removeElement(object);
                    ((Component)((Object)this)).repaint();
                }
            } else if (layoutItem instanceof EdgeLinkItem) {
                object = (EdgeLinkItem)layoutItem;
                edge = ((EdgeLinkItem)object).getEdge();
                int n3 = edge.getSourcePortCount();
                int n4 = 0;
                while (n4 < n3) {
                    if (this._isChild(edge.getSourcePort(n4), node) || this._isChild(edge.getTargetPort(n4), node)) {
                        this.removeEdge(edge);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void removeAllNodes() {
        Node[] nodeArray = this.getNodes();
        int n = nodeArray == null ? 0 : nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.removeNode(nodeArray[n2]);
            ++n2;
        }
    }

    public final void removeNodeWindow(JLENodeWindow jLENodeWindow) {
        Node node = jLENodeWindow.getNode();
        if (node == null && jLENodeWindow.getCanvas() == this) {
            this.getContentItem().removeItem((LayoutItem)jLENodeWindow);
            this._items.removeElement((Object)jLENodeWindow);
        } else {
            this.removeNode(node);
        }
    }

    public int getNodeCount() {
        int n = this.getContentItem().getItemCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n3);
            if (layoutItem instanceof JLENodeWindow) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public Node getNode(int n) {
        int n2 = this.getContentItem().getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            JLENodeWindow jLENodeWindow;
            LayoutItem layoutItem = this.getContentItem().getItem(n4);
            if (layoutItem instanceof JLENodeWindow && (jLENodeWindow = (JLENodeWindow)layoutItem).getNode() != null) {
                if (n3 == n) {
                    return jLENodeWindow.getNode();
                }
                ++n3;
            }
            ++n4;
        }
        return null;
    }

    public Node[] getNodes() {
        Object[] objectArray;
        int n = this.getContentItem().getItemCount();
        Vector<Node> vector = new Vector<Node>();
        int n2 = 0;
        while (n2 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n2);
            if (layoutItem instanceof JLENodeWindow && (objectArray = (JLENodeWindow)layoutItem).getNode() != null) {
                vector.addElement(objectArray.getNode());
            }
            ++n2;
        }
        int n3 = vector.size();
        objectArray = null;
        if (n3 != 0) {
            objectArray = new Node[n3];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public JLENodeWindow getNodeWindow(Node node) {
        int n = this.getContentItem().getItemCount();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JLENodeWindow jLENodeWindow;
            LayoutItem layoutItem = this.getContentItem().getItem(n2);
            if (layoutItem instanceof JLENodeWindow && (jLENodeWindow = (JLENodeWindow)layoutItem).getNode() == node) {
                return jLENodeWindow;
            }
            ++n2;
        }
        return null;
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        if (this._getEdgeLinkItem(edge) != null) {
            return;
        }
        Port port = edge.getSourcePort(0);
        Port port2 = edge.getTargetPort(0);
        JLENodeWindow jLENodeWindow = this._findWindow(port);
        JLENodeWindow jLENodeWindow2 = this._findWindow(port2);
        if (jLENodeWindow == null || jLENodeWindow2 == null) {
            throw new IllegalArgumentException("All Ports in Edge must be added to Graph before calling addEdge");
        }
        EdgeFactory edgeFactory = this.getEdgeFactory();
        if (!(jLENodeWindow != jLENodeWindow2 && port.isSourceable() && port2.isTargetable() && edgeFactory.isEdgeValid(port, port2))) {
            return;
        }
        EdgeLinkItem edgeLinkItem = this.__addEdge(edge, port, jLENodeWindow, port2, jLENodeWindow2);
    }

    public void removeEdge(Edge edge) {
        EdgeLinkItem edgeLinkItem = this._getEdgeLinkItem(edge);
        if (edgeLinkItem != null) {
            this.getContentItem().removeItem((LayoutItem)edgeLinkItem);
            this._items.removeElement(edgeLinkItem);
            this._links.remove(edge);
            LinkPort[] linkPortArray = edgeLinkItem.getPorts();
            int n = 0;
            while (n < linkPortArray.length) {
                linkPortArray[n].die();
                ++n;
            }
            this.getContentItem().repaintItem();
            this.firePropertyChange("edgeCount", edge, null);
        }
    }

    public int getEdgeCount() {
        return this._links.size();
    }

    public Edge getEdge(int n) {
        int n2 = this.getContentItem().getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            LayoutItem layoutItem = this.getContentItem().getItem(n4);
            if (layoutItem instanceof EdgeLinkItem) {
                EdgeLinkItem edgeLinkItem = (EdgeLinkItem)layoutItem;
                if (n3 == n) {
                    return edgeLinkItem.getEdge();
                }
                ++n3;
            }
            ++n4;
        }
        return null;
    }

    public Edge[] getEdges() {
        Object[] objectArray;
        int n = this.getContentItem().getItemCount();
        Vector<Edge> vector = new Vector<Edge>();
        int n2 = 0;
        while (n2 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n2);
            if (layoutItem instanceof EdgeLinkItem) {
                objectArray = (EdgeLinkItem)layoutItem;
                vector.addElement(objectArray.getEdge());
            }
            ++n2;
        }
        int n3 = vector.size();
        objectArray = null;
        if (n3 != 0) {
            objectArray = new Edge[n3];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public boolean doesEdgeExist(Port port, Port port2) {
        Edge[] edgeArray = this.getEdges();
        int n = edgeArray == null ? 0 : edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Edge edge = edgeArray[n2];
            if (edge.getSourcePortCount() == 1 && edge.getSourcePort(0) == port && edge.getTargetPort(0) == port2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setMultipleSelectionAllowed(boolean bl) {
        LayoutTool layoutTool = this.getTool();
        if (layoutTool instanceof NodeTool) {
            NodeTool nodeTool = (NodeTool)layoutTool;
            nodeTool.getBoundsTool().setMultipleSelectAllowed(bl);
        }
    }

    public boolean isMultipleSelectionAllowed() {
        LayoutTool layoutTool = this.getTool();
        if (layoutTool instanceof NodeTool) {
            NodeTool nodeTool = (NodeTool)layoutTool;
            return nodeTool.getBoundsTool().isMultipleSelectAllowed();
        }
        return false;
    }

    public int getSelectedNodeCount() {
        int n = this.getContentItem().getItemCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n3);
            if (layoutItem instanceof JLENodeWindow && SelectionTool.isSelected((LayoutItem)layoutItem)) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public Node getSelectedNode(int n) {
        int n2 = this.getContentItem().getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            JLENodeWindow jLENodeWindow;
            LayoutItem layoutItem = this.getContentItem().getItem(n4);
            if (layoutItem instanceof JLENodeWindow && (jLENodeWindow = (JLENodeWindow)layoutItem).getNode() != null && SelectionTool.isSelected((LayoutItem)layoutItem)) {
                if (n3 == n) {
                    return jLENodeWindow.getNode();
                }
                ++n3;
            }
            ++n4;
        }
        return null;
    }

    public Node[] getSelectedNodes() {
        Object[] objectArray;
        int n = this.getContentItem().getItemCount();
        Vector<Node> vector = new Vector<Node>();
        int n2 = 0;
        while (n2 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n2);
            if (layoutItem instanceof JLENodeWindow && (objectArray = (JLENodeWindow)layoutItem).getNode() != null && SelectionTool.isSelected((LayoutItem)layoutItem)) {
                vector.addElement(objectArray.getNode());
            }
            ++n2;
        }
        int n3 = vector.size();
        objectArray = null;
        if (n3 != 0) {
            objectArray = new Node[n3];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public boolean isNodeSelected(Node node) {
        JLENodeWindow jLENodeWindow = this.getNodeWindow(node);
        return jLENodeWindow == null ? false : SelectionTool.isSelected((LayoutItem)jLENodeWindow);
    }

    public void setNodeSelected(Node node, boolean bl) {
        JLENodeWindow jLENodeWindow = this.getNodeWindow(node);
        if (jLENodeWindow == null) {
            return;
        }
        LayoutTool layoutTool = this.getTool();
        if (layoutTool instanceof NodeTool) {
            NodeTool nodeTool = (NodeTool)layoutTool;
            if (bl) {
                nodeTool.getBoundsTool().processSelect((LayoutItem)jLENodeWindow);
            } else {
                nodeTool.getBoundsTool().processDeselect((LayoutItem)jLENodeWindow);
            }
        }
    }

    public final void deselectAllNodes() {
        Node[] nodeArray = this.getSelectedNodes();
        int n = nodeArray == null ? 0 : nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.setNodeSelected(nodeArray[n2], false);
            ++n2;
        }
    }

    public int getSelectedEdgeCount() {
        int n = this.getContentItem().getItemCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n3);
            if (layoutItem instanceof EdgeLinkItem && SelectionTool.isSelected((LayoutItem)layoutItem)) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public Edge getSelectedEdge(int n) {
        int n2 = this.getContentItem().getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            LayoutItem layoutItem = this.getContentItem().getItem(n4);
            if (layoutItem instanceof EdgeLinkItem && SelectionTool.isSelected((LayoutItem)layoutItem)) {
                EdgeLinkItem edgeLinkItem = (EdgeLinkItem)layoutItem;
                if (n3 == n) {
                    return edgeLinkItem.getEdge();
                }
                ++n3;
            }
            ++n4;
        }
        return null;
    }

    public Edge[] getSelectedEdges() {
        Object object;
        int n = this.getContentItem().getItemCount();
        Vector<Edge> vector = new Vector<Edge>();
        int n2 = 0;
        while (n2 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n2);
            if (layoutItem instanceof EdgeLinkItem && SelectionTool.isSelected((LayoutItem)layoutItem)) {
                object = (EdgeLinkItem)layoutItem;
                vector.addElement(((EdgeLinkItem)object).getEdge());
            }
            ++n2;
        }
        int n3 = vector.size();
        object = null;
        if (n3 != 0) {
            object = new Edge[n3];
            vector.copyInto((Object[])object);
        }
        return object;
    }

    public boolean isEdgeSelected(Edge edge) {
        EdgeLinkItem edgeLinkItem = this._getEdgeLinkItem(edge);
        return edgeLinkItem == null ? false : SelectionTool.isSelected((LayoutItem)edgeLinkItem);
    }

    public void setEdgeSelected(Edge edge, boolean bl) {
        EdgeLinkItem edgeLinkItem = this._getEdgeLinkItem(edge);
        if (edgeLinkItem == null) {
            return;
        }
        LayoutTool layoutTool = this.getTool();
        if (layoutTool instanceof NodeTool) {
            NodeTool nodeTool = (NodeTool)layoutTool;
            if (bl) {
                nodeTool.getBoundsTool().processSelect((LayoutItem)edgeLinkItem);
            } else {
                nodeTool.getBoundsTool().processDeselect((LayoutItem)edgeLinkItem);
            }
        }
    }

    public final void deselectAllEdges() {
        Edge[] edgeArray = this.getSelectedEdges();
        int n = edgeArray == null ? 0 : edgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.setEdgeSelected(edgeArray[n2], false);
            ++n2;
        }
    }

    public int getSelectedPortCount() {
        int n = this.getContentItem().getItemCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n3);
            if (layoutItem instanceof JLENodeWindow) {
                JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
                NodeComponent nodeComponent = jLENodeWindow.getNodeComponent();
                n2 += nodeComponent.getSelectedPortCount();
            }
            ++n3;
        }
        return n2;
    }

    public Port getSelectedPort(int n) {
        int n2 = this.getContentItem().getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            LayoutItem layoutItem = this.getContentItem().getItem(n4);
            if (layoutItem instanceof JLENodeWindow) {
                JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
                NodeComponent nodeComponent = jLENodeWindow.getNodeComponent();
                int n5 = nodeComponent.getSelectedPortCount();
                if (n3 < n5) {
                    return nodeComponent.getSelectedPort(n3);
                }
                n3 += n5;
            }
            ++n4;
        }
        return null;
    }

    public Port[] getSelectedPorts() {
        Object[] objectArray;
        int n = this.getContentItem().getItemCount();
        Vector<Port> vector = new Vector<Port>();
        int n2 = 0;
        while (n2 < n) {
            NodeComponent nodeComponent;
            Port[] portArray;
            LayoutItem layoutItem = this.getContentItem().getItem(n2);
            if (layoutItem instanceof JLENodeWindow && (portArray = (nodeComponent = (objectArray = (JLENodeWindow)layoutItem).getNodeComponent()).getSelectedPorts()) != null) {
                int n3 = 0;
                while (n3 < portArray.length) {
                    vector.addElement(portArray[n3]);
                    ++n3;
                }
            }
            ++n2;
        }
        int n4 = vector.size();
        objectArray = null;
        if (n4 != 0) {
            objectArray = new Port[n4];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public boolean isPortSelected(Port port) {
        Node node = port.getParent();
        while (node.getParent() != null) {
            node = node.getParent();
        }
        JLENodeWindow jLENodeWindow = this.getNodeWindow(node);
        if (jLENodeWindow == null) {
            return false;
        }
        return jLENodeWindow.getNodeComponent().isPortSelected(port);
    }

    public void setPortSelected(Port port, boolean bl) {
        Node node = port.getParent();
        while (node.getParent() != null) {
            node = node.getParent();
        }
        JLENodeWindow jLENodeWindow = this.getNodeWindow(node);
        if (jLENodeWindow != null) {
            jLENodeWindow.getNodeComponent().setPortSelected(port, bl);
        }
    }

    public final void deselectAllPorts() {
        Port[] portArray = this.getSelectedPorts();
        int n = portArray == null ? 0 : portArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.setPortSelected(portArray[n2], false);
            ++n2;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener((EventListener)actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener((EventListener)actionListener);
        }
    }

    public boolean isSource(Port port) {
        return this._sources.get(port) != null;
    }

    public boolean isTarget(Port port) {
        return this._targets.get(port) != null;
    }

    public EdgeFactory getEdgeFactory() {
        return this._edgeFactory == null ? DefaultEdgeFactory.getEdgeFactory() : this._edgeFactory;
    }

    public void setEdgeFactory(EdgeFactory edgeFactory) {
        this._edgeFactory = edgeFactory;
    }

    public void showMenuForPort(Port port, NodeComponent nodeComponent, int n, int n2) {
        Point point;
        JPopupMenu jPopupMenu = this.getDefaultMenuForPort(port);
        if (jPopupMenu == null) {
            return;
        }
        this._menuPort = port;
        Object object = nodeComponent;
        while (object != null && object != this) {
            point = ((Component)object).getLocation();
            n += point.x;
            n2 += point.y;
            object = ((Component)object).getParent();
        }
        point = this.contentToDevice(n, n2);
        MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)((Object)this), (int)point.x, (int)point.y);
    }

    public void setDefaultLinkPainter(LinkPainter linkPainter) {
        this._defaultPainter = linkPainter;
    }

    public LinkPainter getDefaultLinkPainter() {
        return this._defaultPainter == null ? DefaultLinkPainter.getLinkPainter() : this._defaultPainter;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        Dimension2D dimension2D = this.getContentItem().getItemSize();
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        if (this.getScrollableTracksViewportWidth()) {
            d = (double)n3 * this.getEngineUnitsPerPixelX();
        }
        if (this.getScrollableTracksViewportHeight()) {
            d2 = (double)n4 * this.getEngineUnitsPerPixelY();
        }
        this.getContentItem().setItemSize(d, d2);
    }

    public LayoutItem getFocusNext(LayoutItem layoutItem, boolean bl) {
        LayoutItem layoutItem2;
        LayoutItem layoutItem3 = layoutItem;
        if (layoutItem3 != null && layoutItem3.getItemParent() != null) {
            LayoutItem layoutItem4;
            do {
                Object[] objectArray;
                boolean bl2 = false;
                layoutItem4 = layoutItem3.getItemParent();
                if (layoutItem4 == this.getContentItem()) {
                    objectArray = new LayoutItem[this._items.size()];
                    this._items.copyInto(objectArray);
                } else {
                    objectArray = layoutItem4.getItems();
                }
                int n = objectArray == null ? 0 : objectArray.length;
                boolean bl3 = false;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (bl2) {
                        if (object.isFocusTraversable() || bl) {
                            return object;
                        }
                    } else if (object == layoutItem3) {
                        bl2 = true;
                    }
                    if (n2 == n - 1 && !bl3) {
                        n2 = -1;
                        bl3 = true;
                    }
                    ++n2;
                }
            } while ((layoutItem3 = layoutItem4) != this.getContentItem() && layoutItem3.getItemParent() != null);
        }
        if ((layoutItem2 = this.focusForwardAndInto((LayoutItem)this.getContentItem(), bl)) == layoutItem3 && layoutItem3 != null) {
            return this.focusForwardAndInto(layoutItem2, bl);
        }
        return layoutItem2;
    }

    public void setZoom(double d, double d2) {
        super.setZoom(d, d2);
        this._updateTooltips();
    }

    protected GlassPane createGlassPane() {
        return new NodeGlassPane(this);
    }

    protected JLENodeWindow createNodeWindow() {
        return new JLENodeWindow();
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        int n = actionEvent.getID();
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumeration = this._actionListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (n) {
            case 1001: {
                while (enumeration.hasMoreElements()) {
                    ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
                }
                break;
            }
        }
    }

    boolean __fireVetoableChange(String string, Object object, Object object2) {
        try {
            super.fireVetoableChange(string, object, object2);
        }
        catch (PropertyVetoException propertyVetoException) {
            return true;
        }
        return false;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "edgeCount") {
            if (object == null) {
                this._edgeAdded((Edge)object2);
            } else {
                this._edgeRemoved((Edge)object);
            }
        }
        super.firePropertyChange(string, object, object2);
    }

    protected JPopupMenu getDefaultMenuForNode(Node node) {
        return null;
    }

    protected JPopupMenu getDefaultMenuForMinimizedNode(Node node) {
        return this.getDefaultMenuForNode(node);
    }

    protected JPopupMenu getDefaultMenuForEdge(Edge edge) {
        return null;
    }

    protected JPopupMenu getDefaultMenuForGraph() {
        return null;
    }

    protected JPopupMenu getDefaultMenuForPort(Port port) {
        JMenu jMenu;
        Object[] objectArray;
        if (!port.isSourceable()) {
            return null;
        }
        Node[] nodeArray = this.getNodes();
        if (nodeArray == null) {
            return null;
        }
        Node node = port.getParent();
        while (node.getParent() != null) {
            node = node.getParent();
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        Locale locale = ((Component)((Object)this)).getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.GraphBundle", locale);
        String string = resourceBundle.getString(_KEY_LINKTO);
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray2 = new Object[]{port.getDisplayName(locale)};
        String string2 = messageFormat.format(objectArray2);
        JMenu jMenu2 = new JMenu(string2);
        jPopupMenu.add(jMenu2);
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            objectArray = nodeArray[n2];
            if (objectArray != node && (jMenu = this._getMenuForNode((Node)objectArray, port, locale)) != null) {
                jMenu2.add(jMenu);
            }
            ++n2;
        }
        string = resourceBundle.getString(_KEY_DELETELINK);
        messageFormat = new MessageFormat(string);
        objectArray = new Object[]{port.getDisplayName(locale)};
        string2 = messageFormat.format(objectArray);
        jMenu = new JMenu(string2);
        Edge[] edgeArray = this.getEdges();
        int n3 = edgeArray == null ? 0 : edgeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Port port2 = null;
            Edge edge = edgeArray[n4];
            int n5 = 0;
            while (n5 < edge.getSourcePortCount()) {
                Port port3 = edge.getSourcePort(n5);
                Port port4 = edge.getTargetPort(n5);
                if (port == port3) {
                    port2 = port4;
                }
                if (port == port4) {
                    port2 = port3;
                }
                if (port2 != null) {
                    String string3 = GraphCanvas._getActionCommand(port2, locale, false);
                    JMenuItem jMenuItem = new JMenuItem(string3);
                    jMenuItem.setActionCommand(COMMAND_DELETE_LINK + string3);
                    jMenuItem.addActionListener(this._listener);
                    jMenu.add(jMenuItem);
                }
                ++n5;
            }
            ++n4;
        }
        jPopupMenu.add(jMenu);
        jMenu.setEnabled(jMenu.getMenuComponentCount() > 0);
        return jPopupMenu;
    }

    EdgeLinkItem __addEdge(Edge edge, Port port, JLENodeWindow jLENodeWindow, Port port2, JLENodeWindow jLENodeWindow2) {
        PortLinkPort portLinkPort = new PortLinkPort(port, jLENodeWindow, false);
        PortLinkPort portLinkPort2 = new PortLinkPort(port2, jLENodeWindow2, true);
        EdgeLinkItem edgeLinkItem = new EdgeLinkItem(portLinkPort, portLinkPort2, edge);
        edgeLinkItem.setLinkPainter(this.getDefaultLinkPainter());
        this.getContentItem().addItem((LayoutItem)edgeLinkItem);
        this._items.addElement(edgeLinkItem);
        this._links.put(edge, edgeLinkItem);
        this.firePropertyChange("edgeCount", null, edge);
        return edgeLinkItem;
    }

    void __removeItem(Object object) {
        this._items.removeElement(object);
    }

    void __fireActionEvent(Object object, String string, int n) {
        this.processEvent(new ActionEvent(object, 1001, string, n));
    }

    void __showMenuForNode(Node node, Component component, int n, int n2, boolean bl) {
        Point point;
        JPopupMenu jPopupMenu;
        JPopupMenu jPopupMenu2 = jPopupMenu = bl ? this.getDefaultMenuForMinimizedNode(node) : this.getDefaultMenuForNode(node);
        if (jPopupMenu == null) {
            return;
        }
        Component component2 = component;
        while (component2 != null && component2 != this) {
            point = component2.getLocation();
            n += point.x;
            n2 += point.y;
            component2 = component2.getParent();
        }
        point = this.contentToDevice(n, n2);
        MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)((Object)this), (int)point.x, (int)point.y);
    }

    void __showMenuForEdge(Edge edge, LayoutItem layoutItem, double d, double d2) {
        JPopupMenu jPopupMenu = this.getDefaultMenuForEdge(edge);
        if (jPopupMenu == null) {
            return;
        }
        Point2D point2D = layoutItem.getItemLocation();
        Point point = this.contentToDevice(d + point2D.getX(), d2 + point2D.getY());
        MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)((Object)this), (int)point.x, (int)point.y);
    }

    void __showMenuForGraph(double d, double d2) {
        JPopupMenu jPopupMenu = this.getDefaultMenuForGraph();
        if (jPopupMenu == null) {
            return;
        }
        Point point = this.contentToDevice(d, d2);
        MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)((Object)this), (int)point.x, (int)point.y);
    }

    void __createLink(String string) {
        int n = string.indexOf(_CREATE_SEPARATOR);
        String string2 = n == -1 ? string : string.substring(0, n);
        String string3 = n == -1 ? null : string.substring(n + 1);
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        Node node = this._findNode(string2, locale);
        if (node == null) {
            return;
        }
        Port port = GraphCanvas._findPort(node, string3, locale, true);
        if (port == null) {
            return;
        }
        Port port2 = this._menuPort;
        Edge edge = this.getEdgeFactory().createEdge(port2, port);
        if (edge == null) {
            return;
        }
        this.addEdge(edge);
    }

    void __deleteLink(String string) {
        int n = string.indexOf(_DELETE_SEPARATOR);
        String string2 = n == -1 ? string : string.substring(0, n);
        String string3 = n == -1 ? null : string.substring(n + _DELETE_SEPARATOR.length());
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        Node node = this._findNode(string2, locale);
        if (node == null) {
            return;
        }
        Port port = GraphCanvas._findPort(node, string3, locale, false);
        if (port == null) {
            return;
        }
        Port port2 = this._menuPort;
        Edge[] edgeArray = this.getEdges();
        int n2 = edgeArray == null ? 0 : edgeArray.length;
        Edge edge = null;
        int n3 = 0;
        while (n3 < n2) {
            Edge edge2 = edgeArray[n3];
            if (edge2.getSourcePort(0) == port2 && edge2.getTargetPort(0) == port || edge2.getSourcePort(0) == port && edge2.getTargetPort(0) == port2) {
                edge = edge2;
                break;
            }
            ++n3;
        }
        if (edge != null) {
            this.removeEdge(edge);
        }
    }

    void __redispatchMouseEvent(JLEEvent jLEEvent, LayoutItem layoutItem) {
        GraphCanvas graphCanvas = this;
        Point2D point2D = ItemUtils.itemToDevice((LayoutItem)layoutItem, (double)jLEEvent.getX(), (double)jLEEvent.getY());
        Point2D point2D2 = graphCanvas.deviceToContent(point2D.getX(), point2D.getY());
        LayoutItem layoutItem2 = graphCanvas.getHitItem(point2D.getX(), point2D.getY());
        if (layoutItem2 != null) {
            point2D = ItemUtils.deviceToItem((LayoutItem)layoutItem2, (double)point2D.getX(), (double)point2D.getY());
            jLEEvent = new JLEEvent(jLEEvent.getSource(), jLEEvent.getID(), jLEEvent.getWhen(), jLEEvent.getModifiers(), point2D.getX(), point2D.getY(), jLEEvent.getClickCount());
            layoutItem2.processEvent(jLEEvent);
        }
    }

    static boolean __isPopupTrigger(JLEEvent jLEEvent) {
        return (jLEEvent.getModifiers() & 0x10) == 0;
    }

    static boolean __isPopupTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return true;
        }
        return (mouseEvent.getModifiers() & 0x10) == 0;
    }

    private EdgeLinkItem _getEdgeLinkItem(Edge edge) {
        return (EdgeLinkItem)this._links.get(edge);
    }

    private boolean _equals(Edge edge, Edge edge2) {
        if (edge == edge2) {
            return true;
        }
        if (edge == null || edge2 == null) {
            return false;
        }
        int n = edge.getSourcePortCount();
        if (n != edge2.getSourcePortCount()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (edge.getSourcePort(n2) != edge2.getSourcePort(n2) || edge.getTargetPort(n2) != edge2.getTargetPort(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private JLENodeWindow _findWindow(Port port) {
        Node node = port instanceof Node ? (Node)port : port.getParent();
        while (node != null) {
            if (node.getParent() == null) break;
            node = node.getParent();
        }
        return this.getNodeWindow(node);
    }

    private void _edgeAdded(Edge edge) {
        int n = edge.getSourcePortCount();
        int n2 = 0;
        while (n2 < n) {
            Port port = edge.getSourcePort(n2);
            this._addToTable(port, this._sources);
            Port port2 = edge.getTargetPort(n2);
            this._addToTable(port2, this._targets);
            ++n2;
        }
    }

    private void _edgeRemoved(Edge edge) {
        int n = edge.getSourcePortCount();
        int n2 = 0;
        while (n2 < n) {
            Port port = edge.getSourcePort(n2);
            this._removeFromTable(port, this._sources);
            Port port2 = edge.getTargetPort(n2);
            this._removeFromTable(port2, this._targets);
            ++n2;
        }
    }

    private void _addToTable(Object object, Hashtable hashtable) {
        Object v = hashtable.get(object);
        if (v == null) {
            hashtable.put(object, IntegerUtils.getInteger((int)1));
        } else {
            Integer n = (Integer)v;
            hashtable.put(object, IntegerUtils.getInteger((int)(n + 1)));
        }
    }

    private void _removeFromTable(Object object, Hashtable hashtable) {
        Object v = hashtable.get(object);
        if (v != null) {
            Integer n = (Integer)v;
            int n2 = n;
            if (n2 == 1) {
                hashtable.remove(object);
            } else {
                hashtable.put(object, IntegerUtils.getInteger((int)(n2 - 1)));
            }
        }
    }

    private JMenu _getMenuForNode(Node node, Port port, Locale locale) {
        Port[] portArray = this.getEdgeFactory().getTargetablePorts(port, node);
        if (portArray == null || portArray.length == 0) {
            return null;
        }
        JMenu jMenu = new JMenu(node.getDisplayName(locale));
        int n = 0;
        while (n < portArray.length) {
            Port port2 = portArray[n];
            JMenuItem jMenuItem = new JMenuItem(port2.getDisplayName(locale));
            String string = GraphCanvas._getActionCommand(port2, locale, true);
            jMenuItem.setActionCommand(COMMAND_LINK + string);
            jMenuItem.addActionListener(this._listener);
            jMenu.add(jMenuItem);
            if (port2 instanceof Node && (jMenuItem = this._getMenuForNode((Node)port2, port, locale)) != null) {
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        return jMenu;
    }

    private static String _getActionCommand(Port port, Locale locale, boolean bl) {
        String string = port.getDisplayName(locale);
        String string2 = bl ? _CREATE_SEPARATOR : _DELETE_SEPARATOR;
        Node node = port.getParent();
        while (node != null) {
            string = node.getDisplayName(locale) + string2 + string;
            node = node.getParent();
        }
        return string;
    }

    private Node _findNode(String string, Locale locale) {
        Node[] nodeArray = this.getNodes();
        if (nodeArray == null || string == null) {
            return null;
        }
        int n = 0;
        while (n < nodeArray.length) {
            if (string.equals(nodeArray[n].getDisplayName(locale))) {
                return nodeArray[n];
            }
            ++n;
        }
        return null;
    }

    private static Port _findPort(Node node, String string, Locale locale, boolean bl) {
        String string2 = bl ? _CREATE_SEPARATOR : _DELETE_SEPARATOR;
        int n = string2.length();
        int n2 = string.indexOf(string2);
        String string3 = n2 == -1 ? string : string.substring(0, n2);
        String string4 = n2 == -1 ? null : string.substring(n2 + n);
        int n3 = node.getPortCount();
        int n4 = 0;
        while (n4 < n3) {
            Port port = node.getPort(n4);
            if (string3.equals(port.getDisplayName(locale))) {
                Port port2;
                if (string4 != null && port instanceof Node && (port2 = GraphCanvas._findPort((Node)port, string4, locale, bl)) != null) {
                    return port2;
                }
                return port;
            }
            ++n4;
        }
        return null;
    }

    private boolean _isChild(Port port, Node node) {
        Node node2 = port.getParent();
        return node2 == node ? true : (node2 == null ? false : this._isChild(node2, node));
    }

    private void _updateTooltips() {
        boolean bl = this.getAutoDisplayToolTips();
        boolean bl2 = this.getZoomX() < 1.0 || this.getZoomY() < 1.0;
        boolean bl3 = bl & bl2;
        int n = this.getContentItem().getItemCount();
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < n) {
            LayoutItem layoutItem = this.getContentItem().getItem(n2);
            if (layoutItem instanceof JLENodeWindow) {
                JLENodeWindow jLENodeWindow = (JLENodeWindow)layoutItem;
                jLENodeWindow.setAutoDisplayToolTips(bl3);
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    extends JLEEventAdapter
    implements LinkToolListener,
    ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void linkCreating(LinkToolEvent linkToolEvent) {
        }

        public void linkPositioning(LinkToolEvent linkToolEvent) {
        }

        public void linkCreated(LinkToolEvent linkToolEvent) {
            if (linkToolEvent.getLinkItem() != null) {
                linkToolEvent.getLinkItem().setLinkPainter(GraphCanvas.this.getDefaultLinkPainter());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("portLocation".equals(string)) {
                ((Component)((Object)GraphCanvas.this)).repaint();
            } else if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(string) || LayoutItem.BOUNDS_KEY.equals(string)) {
                double d;
                LayoutItem layoutItem = (LayoutItem)propertyChangeEvent.getSource();
                Rectangle2D rectangle2D = layoutItem.getItemBounds();
                Dimension2D dimension2D = GraphCanvas.this.getJLECanvasSize();
                boolean bl = false;
                double d2 = rectangle2D.getX() + rectangle2D.getWidth();
                if (d2 > dimension2D.getWidth()) {
                    dimension2D.setSize(d2 + 5.0, dimension2D.getHeight());
                    bl = true;
                }
                if ((d = rectangle2D.getY() + rectangle2D.getHeight()) > dimension2D.getHeight()) {
                    dimension2D.setSize(dimension2D.getWidth(), d + 5.0);
                    bl = true;
                }
                if (bl) {
                    GraphCanvas.this.setJLECanvasSize(dimension2D.getWidth(), dimension2D.getHeight());
                }
            }
        }

        public void mousePressed(JLEEvent jLEEvent) {
            if (GraphCanvas.__isPopupTrigger(jLEEvent) && GraphCanvas.this.getHitItem(jLEEvent.getX(), jLEEvent.getY()) == null) {
                jLEEvent.consume();
            }
        }

        public void mouseReleased(JLEEvent jLEEvent) {
            if (GraphCanvas.__isPopupTrigger(jLEEvent) && GraphCanvas.this.getHitItem(jLEEvent.getX(), jLEEvent.getY()) == null) {
                jLEEvent.consume();
                GraphCanvas.this.__showMenuForGraph(jLEEvent.getX(), jLEEvent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.startsWith(GraphCanvas.COMMAND_LINK)) {
                    string = string.substring(GraphCanvas.COMMAND_LINK.length());
                    GraphCanvas.this.__createLink(string);
                } else if (string.startsWith(GraphCanvas.COMMAND_DELETE_LINK)) {
                    string = string.substring(GraphCanvas.COMMAND_DELETE_LINK.length());
                    GraphCanvas.this.__deleteLink(string);
                } else if ("NodeComponent.portDoubleClick".equals(string)) {
                    GraphCanvas.this.__fireActionEvent(actionEvent.getSource(), GraphCanvas.COMMAND_PORT_DOUBLE_CLICK, actionEvent.getModifiers());
                } else if ("NodeComponent.portSingleClick".equals(string)) {
                    GraphCanvas.this.__fireActionEvent(actionEvent.getSource(), GraphCanvas.COMMAND_PORT_SINGLE_CLICK, actionEvent.getModifiers());
                }
            }
        }
    }
}

