/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.IllegalComponentStateException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import oracle.bali.dbUI.graph.jle.AccessibleComponentImpl;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.item.AccessibleLayoutItem;

class AccessibleJLEWindow
extends AccessibleLayoutItem
implements AccessibleAction {
    private static final String _KEY_MINIMIZE = "TOGGLE_MINIMIZE";
    private static final String _KEY_SELECT = "TOGGLE_SELECT";
    private JLEWindow _window;

    public AccessibleJLEWindow(JLEWindow jLEWindow) {
        super((LayoutItem)jLEWindow);
        this._window = jLEWindow;
    }

    public JLEWindow getWindow() {
        return this._window;
    }

    public String getAccessibleName() {
        String string = super.getAccessibleName();
        if (string == null || "".equals(string)) {
            string = this.getWindow().getTitle();
        }
        return string;
    }

    public AccessibleRole getAccessibleRole() {
        return this.getWindow().isMinimized() ? AccessibleRole.DESKTOP_ICON : AccessibleRole.INTERNAL_FRAME;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        if (this.getWindow().isEnabled()) {
            accessibleStateSet.add(AccessibleState.ENABLED);
        }
        if (this.getWindow().isVisible()) {
            accessibleStateSet.add(AccessibleState.VISIBLE);
            if (this.getWindow().getComponent().isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
        }
        if (this.getWindow().isResizable()) {
            accessibleStateSet.add(AccessibleState.RESIZABLE);
        }
        accessibleStateSet.add(AccessibleState.SELECTABLE);
        if (this.getWindow().isSelected()) {
            accessibleStateSet.add(AccessibleState.SELECTED);
            accessibleStateSet.add(AccessibleState.ACTIVE);
        }
        accessibleStateSet.add(AccessibleState.FOCUSABLE);
        if (((JComponent)this.getWindow().getComponent()).hasFocus()) {
            accessibleStateSet.add(AccessibleState.FOCUSED);
        }
        if (this.getWindow().isMinimized()) {
            accessibleStateSet.add(AccessibleState.ICONIFIED);
        }
        return accessibleStateSet;
    }

    public int getAccessibleChildrenCount() {
        return this.getWindow().getContent() instanceof Accessible ? 1 : 0;
    }

    public AccessibleComponent getAccessibleComponent() {
        return new AccessibleComponentImpl(this.getWindow().getComponent());
    }

    public Accessible getAccessibleChild(int n) {
        if (n < 0 || n >= this.getAccessibleChildrenCount()) {
            return null;
        }
        return this.getWindow().getContent() instanceof Accessible ? (Accessible)((Object)this.getWindow().getContent()) : null;
    }

    public Locale getLocale() throws IllegalComponentStateException {
        return this.getWindow().getComponent().getLocale();
    }

    public AccessibleAction getAccessibleAction() {
        return this;
    }

    public int getAccessibleActionCount() {
        return 2;
    }

    public String getAccessibleActionDescription(int n) {
        if (n < 0 || n >= this.getAccessibleActionCount()) {
            return null;
        }
        String string = null;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.AccessibleBundle", this.getLocale());
        switch (n) {
            case 0: {
                string = resourceBundle.getString(_KEY_MINIMIZE);
                break;
            }
            case 1: {
                string = resourceBundle.getString(_KEY_SELECT);
            }
        }
        return string;
    }

    public boolean doAccessibleAction(int n) {
        if (n < 0 || n >= this.getAccessibleActionCount()) {
            return false;
        }
        switch (n) {
            case 0: {
                this.getWindow().setMinimized(!this.getWindow().isMinimized());
                break;
            }
            case 1: {
                this.getWindow().setSelected(!this.getWindow().isSelected());
            }
        }
        return true;
    }
}

