/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.Point;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.share.thread.Timer;

class NodeAutoScroller
implements Runnable {
    private static final int _INITIAL_SCROLLING_DELAY = 400;
    private static final int _REPEAT_SCROLLING_DELAY = 200;
    private static NodeAutoScroller _sAutoScroller;
    private Timer _timer = new Timer((Runnable)this, "NodeAutoScroller");
    private Grid _scrollee;
    private NodeComponent _node;
    private boolean _vDecrease;
    private boolean _cancel;
    private boolean _scheduled;

    public static NodeAutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new NodeAutoScroller();
        }
        return _sAutoScroller;
    }

    public void schedule(NodeComponent nodeComponent, boolean bl) {
        this._node = nodeComponent;
        this._scrollee = nodeComponent.getSpreadTable().getGrid();
        this._vDecrease = bl;
        this._cancel = false;
        if (this._scheduled) {
            return;
        }
        this._scheduled = true;
        this._timer.schedule(400L);
    }

    public void cancel() {
        this._timer.cancel();
        this._scheduled = false;
        this._cancel = true;
    }

    public void cancel(NodeComponent nodeComponent) {
        if (this._node == nodeComponent) {
            this.cancel();
        }
    }

    public void run() {
        if (this._cancel) {
            return;
        }
        Point point = this._scrollee.getCanvasOrigin();
        boolean bl = false;
        this._scrollee.freezeRepaints();
        try {
            int n = -1;
            if (this._vDecrease) {
                n = this._scrollee.getRowAt(-point.y);
                if (n != -1) {
                    n = this._scrollee.getPreviousVisibleRow(n);
                }
            } else {
                int n2 = -point.y + this._scrollee.getInnerSize().height;
                n = this._scrollee.getRowAt(n2);
                if (n != -1) {
                    n = this._scrollee.getNextVisibleRow(n);
                }
            }
            if (n != -1) {
                this._scrollee.scrollRowIntoView(n);
                this._node.locationChanged();
                bl = true;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._scrollee.unfreezeRepaints();
            throw throwable;
        }
        this._scrollee.unfreezeRepaints();
        if (bl) {
            this._timer.schedule(200L);
        } else {
            this._scheduled = false;
        }
    }

    private NodeAutoScroller() {
    }
}

