/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class GridFocusPainter
extends AbstractBorderPainter {
    private static Painter _sPainter;
    private static final ImmInsets _sInsets;

    public static Painter getPainter() {
        if (_sPainter == null) {
            _sPainter = new GridFocusPainter();
        }
        return _sPainter;
    }

    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        return _sInsets;
    }

    protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
        return ImmInsets.getEmptyInsets();
    }

    public Painter getContentPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Object object = super.getContentPainterAt(paintContext, n, n2, n3, n4, painter);
        if (painter == this && object != null || object == null && n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
            object = this;
        }
        return object;
    }

    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = paintContext.getPaintState();
        if ((n5 & 0x40) != 0) {
            Color color = graphics.getColor();
            boolean bl = (n5 & 0x20) != 0;
            UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
            if (bl) {
                graphics.setColor(uIDefaults.getColor(LookAndFeel.SELECTED_FOCUS));
            } else {
                graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_TEXT));
            }
            this._drawFocusLine(graphics, n, n2, n3);
            this._drawFocusLine(graphics, n, n2 + n4 - 1, n3);
            if (color != null) {
                graphics.setColor(color);
            }
        }
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 0x20;
    }

    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    private void _drawFocusLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 / 3;
        int n5 = n4 * 3;
        int n6 = n + n5;
        while (n < n6) {
            graphics.drawLine(n, n2, n + 1, n2);
            n += 3;
        }
        if ((n3 -= n5) > 0) {
            if (n3 > 2) {
                n3 = 2;
            }
            graphics.drawLine(n, n2, n + n3 - 1, n2);
        }
    }

    private GridFocusPainter() {
    }

    static {
        _sInsets = new ImmInsets(2, 0, 2, 0);
    }
}

