/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db.impl;

import java.util.Locale;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.share.util.IntegerUtils;

public final class DynamicRelationshipImpl
extends DynamicRelationship {
    private Column[] _children;
    private Column[] _referenced;
    private String _name;
    private int _type;

    public DynamicRelationshipImpl(Column column, Column column2, String string) {
        this(column, column2, string, 0);
    }

    public DynamicRelationshipImpl(Column column, Column column2, String string, int n) {
        this.setRelationshipType(n);
        this._children = new Column[1];
        this._children[0] = column;
        this._referenced = new Column[1];
        this._referenced[0] = column2;
        this._name = string;
    }

    public DynamicRelationshipImpl(Column[] columnArray, Column[] columnArray2, String string) {
        this(columnArray, columnArray2, string, 0);
    }

    public DynamicRelationshipImpl(Column[] columnArray, Column[] columnArray2, String string, int n) {
        if (columnArray == null || columnArray.length == 0) {
            throw new IllegalArgumentException("children is empty");
        }
        if (columnArray2 == null || columnArray2.length == 0) {
            throw new IllegalArgumentException("referenced is empty");
        }
        this.setRelationshipType(n);
        this._children = new Column[columnArray.length];
        System.arraycopy(columnArray, 0, this._children, 0, columnArray.length);
        this._referenced = new Column[columnArray2.length];
        System.arraycopy(columnArray2, 0, this._referenced, 0, columnArray2.length);
        this._name = string;
    }

    public int getColumnCount() {
        return this._children.length;
    }

    public Column getColumn(int n) {
        return this._children[n];
    }

    public Column getReferencedColumn(int n) {
        return this._referenced[n];
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public void setName(String string) {
        this._name = string;
    }

    public int getRelationshipType() {
        return this._type;
    }

    public void setRelationshipType(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("type is incorrect");
        }
        if (this._type != n) {
            Integer n2 = IntegerUtils.getInteger((int)this._type);
            this._type = n;
            this.firePropertyChange("relationshipType", n2, IntegerUtils.getInteger((int)this._type));
        }
    }

    public void addColumn(Column column, Column column2, int n) {
        if (column == null || column2 == null) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getColumnCount();
        if (n < 0 || n >= n2) {
            n = n2;
        }
        Column[] columnArray = new Column[n2 + 1];
        Column[] columnArray2 = new Column[n2 + 1];
        if (n != 0) {
            System.arraycopy(this._children, 0, columnArray, 0, n);
            System.arraycopy(this._referenced, 0, columnArray2, 0, n);
        }
        if (n != n2) {
            System.arraycopy(this._children, n, columnArray, n + 1, n2 - n + 1);
            System.arraycopy(this._referenced, n, columnArray2, n + 1, n2 - n + 1);
        }
        this._children = columnArray;
        this._referenced = columnArray2;
        this._children[n] = column;
        this._referenced[n] = column2;
        this.fireRelationshipEvent(100, column, column2, n);
    }

    public void removeColumn(Column column, Column column2) {
        int n = -1;
        int n2 = this.getColumnCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getColumn(n3) == column && this.getReferencedColumn(n3) == column2) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n == -1) {
            throw new IllegalArgumentException("columns not found");
        }
        Column[] columnArray = new Column[n2 - 1];
        Column[] columnArray2 = new Column[n2 - 1];
        if (n != 0) {
            System.arraycopy(this._children, 0, columnArray, 0, n);
            System.arraycopy(this._referenced, 0, columnArray2, 0, n);
        }
        if (n != n2 - 1) {
            System.arraycopy(this._children, n + 1, columnArray, n, n2 - n - 1);
            System.arraycopy(this._referenced, n + 1, columnArray2, n, n2 - n - 1);
        }
        this._children = columnArray;
        this._referenced = columnArray2;
        this.fireRelationshipEvent(101, column, column2, n);
    }

    public String toString() {
        return "DynamicRelationshipImpl: " + this.getName();
    }
}

