/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.event.DynamicRelationshipEvent;
import oracle.bali.dbUI.db.event.DynamicRelationshipListener;
import oracle.bali.share.event.ListenerManager;

public abstract class DynamicRelationship
extends Relationship {
    public static final String PROPERTY_TYPE = "relationshipType";
    private PropertyChangeSupport _support;
    private ListenerManager _listener;

    public abstract void setRelationshipType(int var1);

    public abstract void addColumn(Column var1, Column var2, int var3);

    public abstract void removeColumn(Column var1, Column var2);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addRelationshipListener(DynamicRelationshipListener dynamicRelationshipListener) {
        if (this._listener == null) {
            this._listener = new ListenerManager();
        }
        this._listener.addListener((EventListener)dynamicRelationshipListener);
    }

    public void removeRelationshipListener(DynamicRelationshipListener dynamicRelationshipListener) {
        if (this._listener != null) {
            this._listener.removeListener((EventListener)dynamicRelationshipListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._support != null) {
            this._support.firePropertyChange(string, object, object2);
        }
    }

    protected void fireRelationshipEvent(int n, Column column, Column column2, int n2) {
        DynamicRelationshipEvent dynamicRelationshipEvent = new DynamicRelationshipEvent(this, n, column, column2, n2);
        this.processRelationshipEvent(dynamicRelationshipEvent);
    }

    protected void processRelationshipEvent(DynamicRelationshipEvent dynamicRelationshipEvent) {
        if (this._listener == null) {
            return;
        }
        Enumeration enumeration = this._listener.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (dynamicRelationshipEvent.getID()) {
            case 100: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicRelationshipListener)enumeration.nextElement()).columnAdded(dynamicRelationshipEvent);
                }
                break;
            }
            case 101: {
                while (enumeration.hasMoreElements()) {
                    ((DynamicRelationshipListener)enumeration.nextElement()).columnRemoved(dynamicRelationshipEvent);
                }
                break;
            }
        }
    }
}

