/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.BaseConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;

public class StringConstraintComp
extends BaseConstraintComponent {
    public static final int CONDITION_CONTAINS = 100;
    public static final int CONDITION_DOES_NOT_CONTAIN = 101;
    public static final int CONDITION_STARTS_WITH = 102;
    public static final int CONDITION_DOES_NOT_START_WITH = 103;
    public static final int CONDITION_ENDS_WITH = 104;
    public static final int CONDITION_DOES_NOT_END_WITH = 105;
    private static final String _CONTAINS_KEY = "TEXT_CONTAINS";
    private static final String _DOES_NOT_CONTAIN_KEY = "TEXT_DOES_NOT_CONTAIN";
    private static final String _STARTS_WITH_KEY = "TEXT_STARTS_WITH";
    private static final String _DOES_NOT_START_WITH_KEY = "TEXT_DOES_NOT_START_WITH";
    private static final String _ENDS_WITH_KEY = "TEXT_ENDS_WITH";
    private static final String _DOES_NOT_END_WITH_KEY = "TEXT_DOES_NOT_END_WITH";
    private static final int _STRING_COUNT = 6;
    private static final int _CONTAINS_INDEX = 2;
    private static final int _DOES_NOT_CONTAIN_INDEX = 3;
    private static final int _STARTS_WITH_INDEX = 4;
    private static final int _DOES_NOT_START_WITH_INDEX = 5;
    private static final int _ENDS_WITH_INDEX = 6;
    private static final int _DOES_NOT_END_WITH_INDEX = 7;

    public StringConstraintComp() {
        this.setBetweenAllowed(true);
    }

    public void setTestString(String string) {
        this._getTextField().setText(string);
    }

    public String getTestString() {
        return this._getTextField().getText();
    }

    protected boolean isConditionValid(int n) {
        if (n == 100 || n == 101 || n == 102 || n == 103 || n == 104 || n == 105) {
            return true;
        }
        return super.isConditionValid(n);
    }

    protected int convertConditionToSelection(int n) {
        int n2 = -1;
        switch (n) {
            case 100: {
                n2 = 2;
                break;
            }
            case 101: {
                n2 = 3;
                break;
            }
            case 102: {
                n2 = 4;
                break;
            }
            case 103: {
                n2 = 5;
                break;
            }
            case 104: {
                n2 = 6;
                break;
            }
            case 105: {
                n2 = 7;
                break;
            }
            default: {
                n2 = super.convertConditionToSelection(n);
            }
        }
        return n2;
    }

    protected int convertSelectionToCondition(int n) {
        int n2 = -1;
        switch (n) {
            case 2: {
                n2 = 100;
                break;
            }
            case 3: {
                n2 = 101;
                break;
            }
            case 4: {
                n2 = 102;
                break;
            }
            case 5: {
                n2 = 103;
                break;
            }
            case 6: {
                n2 = 104;
                break;
            }
            case 7: {
                n2 = 105;
                break;
            }
            default: {
                n2 = super.convertSelectionToCondition(n);
            }
        }
        return n2;
    }

    protected int getBaseBetweenIndex() {
        return super.getBaseBetweenIndex() + 6;
    }

    protected int getBaseNullIndex() {
        return super.getBaseNullIndex() + 6;
    }

    protected int getItemCount() {
        return super.getItemCount() + 6;
    }

    protected String[] getChoiceValues(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        String[] stringArray = super.getChoiceValues(locale);
        stringArray[2] = resourceBundle.getString(_CONTAINS_KEY);
        stringArray[3] = resourceBundle.getString(_DOES_NOT_CONTAIN_KEY);
        stringArray[4] = resourceBundle.getString(_STARTS_WITH_KEY);
        stringArray[5] = resourceBundle.getString(_DOES_NOT_START_WITH_KEY);
        stringArray[6] = resourceBundle.getString(_ENDS_WITH_KEY);
        stringArray[7] = resourceBundle.getString(_DOES_NOT_END_WITH_KEY);
        return stringArray;
    }

    protected DataConstraint getDataConstraint(DataDescriptor dataDescriptor, int n) {
        DataConstraint dataConstraint = null;
        DataConstraint dataConstraint2 = this.getValueDataConstraint(this.getValueComponent(), dataDescriptor, n);
        DataConstraint dataConstraint3 = this.getItemDataConstraint(dataDescriptor, n);
        switch (n) {
            case 100: {
                int n2 = 5;
                dataConstraint = new DCCollectionExpression(dataConstraint2, dataConstraint3, n2);
                break;
            }
            case 101: {
                int n3 = 6;
                dataConstraint = new DCCollectionExpression(dataConstraint2, dataConstraint3, n3);
                break;
            }
            case 102: {
                int n4 = 1;
                dataConstraint = new DCCollectionExpression(dataConstraint2, dataConstraint3, n4);
                break;
            }
            case 103: {
                int n5 = 2;
                dataConstraint = new DCCollectionExpression(dataConstraint2, dataConstraint3, n5);
                break;
            }
            case 104: {
                int n6 = 3;
                dataConstraint = new DCCollectionExpression(dataConstraint2, dataConstraint3, n6);
                break;
            }
            case 105: {
                int n7 = 4;
                dataConstraint = new DCCollectionExpression(dataConstraint2, dataConstraint3, n7);
                break;
            }
            default: {
                dataConstraint = super.getDataConstraint(dataDescriptor, n);
            }
        }
        return dataConstraint;
    }

    protected void parseConstraint(DataConstraint dataConstraint) {
        if (dataConstraint == null || !(dataConstraint instanceof DCCollectionExpression)) {
            super.parseConstraint(dataConstraint);
        } else {
            DCCollectionExpression dCCollectionExpression = (DCCollectionExpression)dataConstraint;
            int n = -1;
            switch (dCCollectionExpression.getOperand()) {
                case 5: {
                    n = 100;
                    break;
                }
                case 6: {
                    n = 101;
                    break;
                }
                case 1: {
                    n = 102;
                    break;
                }
                case 2: {
                    n = 103;
                    break;
                }
                case 3: {
                    n = 104;
                    break;
                }
                case 4: {
                    n = 105;
                }
            }
            this.setTestString(this._getString(dCCollectionExpression));
            this.setTestCondition(n);
        }
    }

    protected int getNotCondition(int n) {
        switch (n) {
            case 100: {
                n = 101;
                break;
            }
            case 101: {
                n = 100;
                break;
            }
            case 102: {
                n = 103;
                break;
            }
            case 104: {
                n = 105;
                break;
            }
            case 103: {
                n = 102;
                break;
            }
            case 105: {
                n = 104;
                break;
            }
            default: {
                n = super.getNotCondition(n);
            }
        }
        return n;
    }

    private String _getString(DCCollectionExpression dCCollectionExpression) {
        DataConstraint dataConstraint = dCCollectionExpression.getConstraint(0);
        DataConstraint dataConstraint2 = dCCollectionExpression.getConstraint(1);
        String string = null;
        if (dataConstraint instanceof DCConstant) {
            string = (String)((DCConstant)dataConstraint).getValue();
        } else if (dataConstraint2 instanceof DCConstant) {
            string = (String)((DCConstant)dataConstraint2).getValue();
        }
        return string;
    }

    private JTextField _getTextField() {
        Component component = this.getValueComponent();
        return (JTextField)component;
    }
}

