/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.FreeFormDataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;

public class FreeFormComponent
extends LWComponent
implements ConstraintComponent,
Accessible {
    private static BorderPainter _sBorderPainter;
    private static final int _DEFAULT_COLUMNS = 40;
    private DataDescriptor _descriptor;
    private JTextComponent _field;

    public FreeFormComponent() {
        this(40, 1);
    }

    public FreeFormComponent(int n) {
        this(n, 1);
    }

    public FreeFormComponent(int n, int n2) {
        this._field = n2 > 1 ? new JTextArea(null, n, n2) : new JTextField(n);
        this._field.addFocusListener(new A());
        ((Container)((Object)this)).setLayout(new BorderLayout(2, 2));
        ((Container)((Object)this)).add("Center", this._field);
        ((JComponent)((Object)this)).setBackground(UIManager.getColor("control"));
    }

    public String getText() {
        return this._field.getText();
    }

    public void setText(String string) {
        this._field.setText(string);
        this._field.setCaretPosition(this._field.getText().length());
        this.firePropertyChangeEvent();
    }

    public Component getComponent() {
        return this;
    }

    public DataConstraint getDataConstraint() {
        return new FreeFormDataConstraint(this._field.getText());
    }

    public DataDescriptor getDataDescriptor() {
        return this._descriptor;
    }

    public void initState(DataDescriptor dataDescriptor, DataConstraint dataConstraint) {
        this._descriptor = dataDescriptor;
        if (dataConstraint == null) {
            this._field.setText(null);
            return;
        }
        boolean bl = false;
        if (dataConstraint instanceof DCUnaryExpression) {
            dataConstraint = ((DCUnaryExpression)dataConstraint).getConstraint(0);
            bl = true;
        }
        if (!(dataConstraint instanceof FreeFormDataConstraint)) {
            throw new IllegalArgumentException("dataConstraint must be a FreeFormDataConstraint");
        }
        String string = ((FreeFormDataConstraint)dataConstraint).getString();
        if (bl) {
            string = string.startsWith("NOT") ? string.substring(3) : "NOT " + string;
        }
        this._field.setText(string);
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    public void requestFocus() {
        this._field.requestFocus();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._field.setEnabled(bl);
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        PaintContext paintContext = this.getPaintContext();
        graphics.setColor(paintContext.getPaintBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public BorderPainter getBorderPainter() {
        if (_sBorderPainter == null) {
            _sBorderPainter = new FixedBorderPainter(1, 0, 1, 1);
        }
        return _sBorderPainter;
    }

    void firePropertyChangeEvent() {
        ((Component)((Object)this)).firePropertyChange("dataConstraint", null, this.getDataConstraint());
    }

    private class A
    extends FocusAdapter {
        private A() {
        }

        public void focusLost(FocusEvent focusEvent) {
            FreeFormComponent.this.firePropertyChangeEvent();
        }
    }
}

