/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.util.ArrayCollection;
import oracle.bali.dbUI.util.Collection;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.util.LocaleUtils;

public class CollectionConstraintComp
extends LWComponent
implements ConstraintComponent,
Accessible {
    private static final String _EQUAL_KEY = "EQUAL";
    private static final String _NOT_EQUAL_KEY = "NOT_EQUAL";
    private Object[] _fullArray = new Object[1];
    private int _objectCount;
    private JComboBox _choice;
    private JList _list;
    private JScrollPane _scrollPane;
    private DataDescriptor _descriptor;

    public CollectionConstraintComp() {
        this(null);
    }

    public CollectionConstraintComp(Collection collection) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        this._choice = new JComboBox();
        this._choice.setEditable(false);
        gridBagLayout.setConstraints(this._choice, gridBagConstraints);
        ((Container)((Object)this)).add(this._choice);
        gridBagConstraints.insets = new Insets(2, 1, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        this._list = new JList();
        this._list.setVisibleRowCount(4);
        this._list.getSelectionModel().setSelectionMode(2);
        this._scrollPane = new JScrollPane(this._list);
        gridBagLayout.setConstraints(this._scrollPane, gridBagConstraints);
        ((Container)((Object)this)).add(this._scrollPane);
        this._setCollection(collection);
        this._setLocaleText(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public void setCollection(Collection collection) {
        this._setCollection(collection);
    }

    public Collection getCollection() {
        return this._getCollection();
    }

    public void setInCollection(boolean bl) {
        int n = bl ? 0 : 1;
        this._choice.setSelectedIndex(n);
    }

    public boolean isInCollection() {
        return this._choice.getSelectedIndex() == 0;
    }

    public void setTestCollection(Collection collection) {
        this._list.getSelectionModel().clearSelection();
        if (collection != null) {
            Enumeration enumeration = collection.getEnumeration();
            while (enumeration.hasMoreElements()) {
                int n = this._getIndex(enumeration.nextElement());
                if (n == -1) continue;
                this._list.setSelectedIndex(n);
            }
        }
    }

    public Collection getTestCollection() {
        int[] nArray = this._list.getSelectedIndices();
        if (nArray == null) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this._getObject(nArray[n]);
            ++n;
        }
        return new ArrayCollection(objectArray);
    }

    public void setMultipleSelection(boolean bl) {
        this._list.getSelectionModel().setSelectionMode(2);
    }

    public boolean isMultipleSelection() {
        return this._list.getSelectionModel().getSelectionMode() == 2;
    }

    public Component getComponent() {
        return this;
    }

    public DataConstraint getDataConstraint() {
        if (this._descriptor == null) {
            return null;
        }
        DCConstant dCConstant = new DCConstant(this.getTestCollection());
        DCVariable dCVariable = new DCVariable(this._descriptor);
        int n = this.isInCollection() ? 5 : 6;
        return new DCCollectionExpression(dCVariable, dCConstant, n);
    }

    public DataDescriptor getDataDescriptor() {
        return this._descriptor;
    }

    public void initState(DataDescriptor dataDescriptor, DataConstraint dataConstraint) {
        this._descriptor = dataDescriptor;
        if (dataConstraint == null) {
            this.setTestCollection(null);
            this.setInCollection(true);
            return;
        }
        boolean bl = false;
        if (dataConstraint instanceof DCUnaryExpression) {
            dataConstraint = ((DCUnaryExpression)dataConstraint).getConstraint(0);
            bl = true;
        }
        if (!(dataConstraint instanceof DCCollectionExpression)) {
            throw new IllegalArgumentException("dataConstraint " + dataConstraint + " is invalid!");
        }
        DCCollectionExpression dCCollectionExpression = (DCCollectionExpression)dataConstraint;
        boolean bl2 = dCCollectionExpression.getOperand() == 5;
        this.setTestCollection(this._getCollection(dCCollectionExpression));
        if (bl) {
            bl2 = !bl2;
        }
        this.setInCollection(bl2);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._setLocaleText(((Component)((Object)this)).getLocale());
    }

    public void requestFocus() {
        this._choice.requestFocus();
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    private void _setLocaleText(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        this._updateChoice(resourceBundle);
    }

    private void _updateChoice(ResourceBundle resourceBundle) {
        int n = this._choice.getSelectedIndex();
        this._choice.removeAllItems();
        this._choice.addItem(resourceBundle.getString(_EQUAL_KEY));
        this._choice.addItem(resourceBundle.getString(_NOT_EQUAL_KEY));
        if (n != -1) {
            this._choice.setSelectedIndex(n);
        }
    }

    private void _setCollection(Collection collection) {
        Object object;
        this._objectCount = 0;
        if (collection != null) {
            object = collection.getEnumeration();
            while (object.hasMoreElements()) {
                if (this._objectCount == this._fullArray.length) {
                    Object[] objectArray = new Object[this._fullArray.length * 2];
                    System.arraycopy(this._fullArray, 0, objectArray, 0, this._objectCount);
                    this._fullArray = objectArray;
                }
                this._fullArray[this._objectCount] = object.nextElement();
                ++this._objectCount;
            }
        }
        object = new DefaultListModel();
        int n = 0;
        while (n < this._objectCount) {
            ((DefaultListModel)object).addElement(this._fullArray[n].toString());
            ++n;
        }
        this._list.setModel(object);
    }

    private Collection _getCollection() {
        Object[] objectArray = new Object[this._objectCount];
        System.arraycopy(this._fullArray, 0, objectArray, 0, this._objectCount);
        return new ArrayCollection(objectArray);
    }

    private int _getIndex(Object object) {
        int n = 0;
        while (n < this._objectCount) {
            if (this._fullArray[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Object _getObject(int n) {
        return n >= this._objectCount ? null : this._fullArray[n];
    }

    private Collection _getCollection(DCBinaryExpression dCBinaryExpression) {
        DataConstraint dataConstraint = dCBinaryExpression.getConstraint(0);
        DataConstraint dataConstraint2 = dCBinaryExpression.getConstraint(1);
        Collection collection = null;
        if (dataConstraint instanceof DCConstant) {
            collection = (Collection)((DCConstant)dataConstraint).getValue();
        } else if (dataConstraint2 instanceof DCConstant) {
            collection = (Collection)((DCConstant)dataConstraint2).getValue();
        }
        return collection;
    }
}

