/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.AndOrComponent;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintBuilder.Sprout;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.painter.BorderPainter;

public class RootComponent
extends ParentComponent {
    private static final String _KEY_ROOT = "ROOT";
    private boolean _leafLocationValid;

    public RootComponent() {
        ((JComponent)((Object)this)).setBackground(Color.white);
    }

    public DataConstraint getDataConstraint() {
        return this.getChildCount() == 0 ? null : this.getChild(0).getDataConstraint();
    }

    public void setDataConstraint(DataConstraint dataConstraint) {
        this.removeAll();
        if (dataConstraint != null) {
            this.addChild(this.getConstraintBuilder().parseConstraint(dataConstraint));
        }
    }

    public int getGroupDepth() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        ConstraintBuilderComp constraintBuilderComp = this.getChild(0);
        if (constraintBuilderComp instanceof ParentComponent) {
            return ((ParentComponent)constraintBuilderComp).getGroupDepth();
        }
        return 0;
    }

    public int getGroupWidth(int n) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        ConstraintBuilderComp constraintBuilderComp = this.getChild(0);
        if (constraintBuilderComp instanceof ParentComponent) {
            int n2 = this.getGroupWidth();
            if (n == 0) {
                n2 += 2;
            }
            return n2;
        }
        return 0;
    }

    public boolean isLeafLocationValid() {
        return this._leafLocationValid;
    }

    public void addChild(ConstraintBuilderComp constraintBuilderComp, int n) {
        if (this.getChildCount() == 0) {
            super.addChild(constraintBuilderComp, n);
        } else {
            ConstraintBuilderComp constraintBuilderComp2 = this.getChild(0);
            if (constraintBuilderComp2 instanceof AndOrComponent) {
                ((AndOrComponent)constraintBuilderComp2).addChild(constraintBuilderComp);
            } else {
                this.removeChild(constraintBuilderComp2);
                ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
                AndOrComponent andOrComponent = constraintBuilder.createAndOrComponent(true);
                andOrComponent.setConstraintBuilder(constraintBuilder);
                andOrComponent.addChild(constraintBuilderComp2);
                andOrComponent.addChild(constraintBuilderComp);
                super.addChild(andOrComponent);
                this.getConstraintBuilder().tryInvalidateLeafLocation();
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.getChildCount() == 0) {
            dimension = new Dimension(300, 50);
        } else {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(0);
            dimension = ((JComponent)((Object)constraintBuilderComp)).getPreferredSize();
            dimension.width += 4;
            dimension.height += 8;
        }
        return dimension;
    }

    public void requestDBUIFocus(boolean bl) {
        super.requestDBUIFocus(false);
    }

    public void doLayout() {
        this.getConstraintBuilder().layoutChildren();
    }

    public void setLeafLocationValid(boolean bl) {
        this._leafLocationValid = bl;
    }

    public void layoutChildren() {
        if (this.getChildCount() == 0) {
            return;
        }
        Dimension dimension = ((Component)((Object)this)).getSize();
        ConstraintBuilderComp constraintBuilderComp = this.getChild(0);
        if (constraintBuilderComp instanceof ParentComponent) {
            ParentComponent parentComponent = (ParentComponent)constraintBuilderComp;
            if (!this._leafLocationValid) {
                int n = parentComponent.computeLeafLocation();
                parentComponent.setLeafLocation(n);
                this.setLeafLocationValid(true);
            }
            ((Component)((Object)constraintBuilderComp)).setBounds(2, 0, dimension.width - 4, dimension.height);
        } else {
            Dimension dimension2 = ((JComponent)((Object)constraintBuilderComp)).getPreferredSize();
            int n = (dimension.height - dimension2.height) / 2;
            ((Component)((Object)constraintBuilderComp)).setBounds(2, n, dimension2.width, dimension2.height);
        }
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(((Component)((Object)this)).getBackground());
        graphics.fillRect(0, 0, ((JComponent)((Object)this)).getWidth(), ((JComponent)((Object)this)).getHeight());
        this.paintDragFeedback(graphics);
        this.getConstraintBuilder().paintGroupLines(graphics);
        if (((Component)((Object)this)).hasFocus()) {
            int n = this.getChildCount();
            BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null);
            Dimension dimension = ((Component)((Object)this)).getSize();
            borderPainter.paint(this.getPaintContext(), graphics, 10, 10, dimension.width - 20, dimension.height - 20);
        }
    }

    public boolean isFocusTraversable() {
        return this.getChildCount() == 0;
    }

    public Component getFocusComponent() {
        if (this.getChildCount() > 0) {
            return this.getChild(0);
        }
        return this;
    }

    protected boolean acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (this._isChildAParent()) {
            return false;
        }
        return super.acceptDrag(dropTargetDragEvent);
    }

    protected boolean acceptDrop(DropTargetDropEvent dropTargetDropEvent) {
        if (this._isChildAParent()) {
            return false;
        }
        return super.acceptDrop(dropTargetDropEvent);
    }

    protected void calculateFeedback(int n, int n2) {
        if (n < 0 || this._isChildAParent()) {
            this.setFeedbackSprout(null);
            return;
        }
        Sprout sprout = this.getFeedbackSprout();
        if (this.getChildCount() == 0) {
            if (sprout == null) {
                Dimension dimension = ((Component)((Object)this)).getSize();
                int n3 = 0;
                int n4 = dimension.height / 2;
                sprout = new Sprout(n3, n4, n3 + 6, n4);
                this.setFeedbackSprout(sprout);
            }
        } else {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(0);
            Rectangle rectangle = ((Component)((Object)constraintBuilderComp)).getBounds();
            int n5 = n2 < rectangle.y ? rectangle.y - 4 : rectangle.y + rectangle.height + 4;
            int n6 = 0;
            int n7 = n6 + 6;
            int n8 = n5;
            if (sprout == null) {
                sprout = new Sprout(n6, n5, n7, n8);
            } else {
                sprout.x1 = n6;
                sprout.y1 = n5;
                sprout.x2 = n7;
                sprout.y2 = n8;
            }
            this.setFeedbackSprout(sprout);
        }
    }

    private boolean _isChildAParent() {
        return this.getChildCount() == 1 && this.getChild(0) instanceof ParentComponent;
    }

    protected String getAccessName() {
        return this.getTranslatedAccessibleString(_KEY_ROOT);
    }

    protected int getAccessActionCount() {
        return 2;
    }

    protected String getAccessActionDescription(int n) {
        switch (n) {
            case 0: {
                return this.getTranslatedAccessibleString("SIMPLIFY");
            }
            case 1: {
                return this.getTranslatedAccessibleString("ADD_CONSTRAINT");
            }
        }
        return null;
    }

    protected boolean doAccessAction(int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                if (this.getChildCount() == 0) break;
                this.getConstraintBuilder().simplifyLayout();
                bl = true;
                break;
            }
            case 1: {
                this.getConstraintBuilder().clearSelection();
                this.getConstraintBuilder().performAdd();
                return true;
            }
        }
        return bl;
    }
}

