/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.DragComponent;
import oracle.bali.dbUI.constraintBuilder.Sprout;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.datatransfer.TransferUtils;

public abstract class ParentComponent
extends ConstraintBuilderComp
implements DropTargetListener {
    public static final int _VINSET = 4;
    public static final int _HINSET = 2;
    private static final int _EXPANDED_WIDTH = 0;
    private static final int _EXPANDED_INCREMENT = 0;
    private boolean _expanded;
    private Sprout _feedbackSprout;
    private Vector _children;
    private Vector _sprouts;
    private ConstraintBuilder _parent;
    private DropTargetListener _dropper = this;
    private boolean _dragSelection;
    private int _leafLocation;

    public ParentComponent() {
        super.setLayout(null);
        this.addDropTarget(this);
        this._expanded = true;
        ((Component)((Object)this)).enableEvents(60L);
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n2);
            this.getConstraintBuilder().removeFromSelection(constraintBuilderComp);
            constraintBuilderComp.setSelected(bl);
            ++n2;
        }
    }

    public void setConstraintBuilder(ConstraintBuilder constraintBuilder) {
        super.setConstraintBuilder(constraintBuilder);
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n2);
            constraintBuilderComp.setConstraintBuilder(constraintBuilder);
            ++n2;
        }
    }

    public void setExpanded(boolean bl) {
        if (this._expanded != bl) {
            this._expanded = bl;
            ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
            constraintBuilder.freezeRepaints();
            int n = 0;
            while (n < this.getChildCount()) {
                ((JComponent)((Object)this.getChild(n))).setVisible(bl);
                ++n;
            }
            ((Container)((Object)constraintBuilder)).validate();
            ((Component)((Object)constraintBuilder)).repaint();
            constraintBuilder.unfreezeRepaints();
        }
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public final void addChild(ConstraintBuilderComp constraintBuilderComp) {
        this.addChild(constraintBuilderComp, -1);
    }

    public void addChild(ConstraintBuilderComp constraintBuilderComp, int n) {
        if (this._children == null) {
            this._children = new Vector(2);
        }
        if (this._children.indexOf(constraintBuilderComp) != -1) {
            return;
        }
        int n2 = this.getChildCount();
        if (n < 0 || n >= n2) {
            n = n2;
        }
        this._children.insertElementAt(constraintBuilderComp, n);
        this.addDropTarget(constraintBuilderComp);
        ((Container)((Object)this)).add((Component)((Object)constraintBuilderComp), n);
        constraintBuilderComp.setSelected(this.isSelected());
        ((JComponent)((Object)constraintBuilderComp)).setEnabled(((Component)((Object)this)).isEnabled());
        ((JComponent)((Object)constraintBuilderComp)).setVisible(this.isExpanded());
        constraintBuilderComp.setParentComponent(this);
        AccessibleContext accessibleContext = ((JComponent)((Object)this)).accessibleContext;
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleChild", null, constraintBuilderComp.getAccessibleContext());
            accessibleContext.firePropertyChange("AccessibleName", null, accessibleContext.getAccessibleName());
        }
        ((Container)((Object)this)).invalidate();
    }

    public void removeChild(ConstraintBuilderComp constraintBuilderComp) {
        if (this._children == null) {
            return;
        }
        int n = this._children.indexOf(constraintBuilderComp);
        if (n != -1) {
            this.removeDropTarget(constraintBuilderComp);
            this._children.removeElementAt(n);
            constraintBuilderComp.setParentComponent(null);
            constraintBuilderComp.setIndex(-1);
            ((Container)((Object)this)).remove((Component)((Object)constraintBuilderComp));
            ((Container)((Object)this)).invalidate();
            AccessibleContext accessibleContext = ((JComponent)((Object)this)).accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleChild", constraintBuilderComp.getAccessibleContext(), null);
                accessibleContext.firePropertyChange("AccessibleName", null, accessibleContext.getAccessibleName());
            }
        }
    }

    public void removeAll() {
        ConstraintBuilderComp[] constraintBuilderCompArray = this.getChildren();
        int n = 0;
        while (n < constraintBuilderCompArray.length) {
            this.removeChild(constraintBuilderCompArray[n]);
            ++n;
        }
    }

    public int getChildCount() {
        return this._children == null ? 0 : this._children.size();
    }

    public ConstraintBuilderComp getChild(int n) {
        return n >= this.getChildCount() ? null : (ConstraintBuilderComp)this._children.elementAt(n);
    }

    public int getIndex(ConstraintBuilderComp constraintBuilderComp) {
        return this._children == null ? -1 : this._children.indexOf(constraintBuilderComp);
    }

    public ConstraintBuilderComp[] getChildren() {
        int n = this.getChildCount();
        Object[] objectArray = new ConstraintBuilderComp[n];
        if (n != 0) {
            this._children.copyInto(objectArray);
        }
        return objectArray;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrag(dropTargetDragEvent)) {
            Point point = dropTargetDragEvent.getLocation();
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            Point point2 = this._getOffset(component);
            this.calculateFeedback(point2.x + point.x, point2.y + point.y);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrag(dropTargetDragEvent)) {
            Point point = dropTargetDragEvent.getLocation();
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            Point point2 = this._getOffset(component);
            this.calculateFeedback(point2.x + point.x, point2.y + point.y);
        } else {
            this.calculateFeedback(-1, -1);
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.calculateFeedback(-1, -1);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        this.calculateFeedback(-1, -1);
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        if (!this.acceptDrop(dropTargetDropEvent)) {
            dropTargetContext.dropComplete(false);
            return;
        }
        dropTargetDropEvent.acceptDrop(2);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Point point = dropTargetDropEvent.getLocation();
        Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
        Point point2 = this._getOffset(component);
        int n = this.getInsertIndex(point2.y + point.y);
        Object object2 = null;
        if (transferable.isDataFlavorSupported(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
            try {
                object2 = transferable.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
            }
            catch (IOException iOException) {
                object2 = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object2 = null;
            }
            if (object2 instanceof DataDescriptor && (object = (DataDescriptor)object2) != null) {
                dropTargetContext.dropComplete(true);
                ConstraintComponent constraintComponent = this.getConstraintBuilder().createConstraintComponent((DataDescriptor)object);
                this.getConstraintBuilder().dropConstraintComponent(constraintComponent, this, n);
            }
        }
        if (object2 == null && transferable.isDataFlavorSupported(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
            try {
                object2 = transferable.getTransferData(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR);
            }
            catch (IOException iOException) {
                object2 = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object2 = null;
            }
            if (object2 instanceof ConstraintComponent) {
                object = (ConstraintComponent)object2;
                if (object != null) {
                    this.getConstraintBuilder().dropConstraintComponent((ConstraintComponent)object, this, n);
                }
                dropTargetContext.dropComplete(object != null);
                return;
            }
        }
        if (object2 == null && transferable.isDataFlavorSupported(CBCompArray.CB_COMP_ARRAY_FLAVOR)) {
            try {
                object2 = transferable.getTransferData(CBCompArray.CB_COMP_ARRAY_FLAVOR);
            }
            catch (IOException iOException) {
                object2 = null;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                object2 = null;
            }
            if (object2 instanceof CBCompArray && (object = ((CBCompArray)object2).getData()) != null) {
                dropTargetContext.dropComplete(true);
                int n2 = 0;
                while (n2 < ((ConstraintBuilderComp[])object).length) {
                    if (object[n2] == this) {
                        return;
                    }
                    ++n2;
                }
                this.getConstraintBuilder().dropConstraintBuilderComp((ConstraintBuilderComp[])object, this, n);
                return;
            }
        }
        dropTargetContext.dropComplete(false);
    }

    public int getGroupWidth() {
        return this.getConstraintBuilder().getGroupWidth();
    }

    public int getGroupDepth() {
        int n = this.getChildCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n3);
            if (constraintBuilderComp instanceof ParentComponent && (n4 = ((ParentComponent)constraintBuilderComp).getGroupDepth()) > n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2 + 1;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Component getFocusComponent() {
        return this;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = 0;
        while (n < this.getChildCount()) {
            ((JComponent)((Object)this.getChild(n))).setEnabled(bl);
            ++n;
        }
        if (bl) {
            ((JComponent)((Object)this)).setBackground(null);
        } else {
            ((JComponent)((Object)this)).setBackground(this.getUIDefaults().getColor("lightIntensity"));
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (!this.isExpanded()) {
            n += 0;
        } else {
            int n3 = this.getChildCount();
            int n4 = this.getLeafWidth() + this.getLeafLocation() - this.getGroupWidth();
            int n5 = 0;
            while (n5 < n3) {
                ConstraintBuilderComp constraintBuilderComp = this.getChild(n5);
                Dimension dimension = ((JComponent)((Object)constraintBuilderComp)).getPreferredSize();
                int n6 = constraintBuilderComp instanceof ParentComponent ? dimension.width : n4;
                if (n6 > n) {
                    n = n6;
                }
                n2 += dimension.height + 4;
                ++n5;
            }
        }
        return new Dimension(n += 2, n2);
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        if (!this.isExpanded()) {
            n += 0;
        } else {
            int n3 = this.getChildCount();
            int n4 = 0;
            while (n4 < n3) {
                ConstraintBuilderComp constraintBuilderComp = this.getChild(n4);
                Dimension dimension = ((JComponent)((Object)constraintBuilderComp)).getMinimumSize();
                if (dimension.width > n) {
                    n = dimension.width;
                }
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                ++n4;
            }
            n2 += n3 * 4;
        }
        return new Dimension(n += 2, n2);
    }

    public Dimension getMaximumSize() {
        int n = 0;
        int n2 = 0;
        if (!this.isExpanded()) {
            n += 0;
        } else {
            int n3 = this.getChildCount();
            int n4 = 0;
            while (n4 < n3) {
                ConstraintBuilderComp constraintBuilderComp = this.getChild(n4);
                Dimension dimension = ((JComponent)((Object)constraintBuilderComp)).getMaximumSize();
                if (dimension.width > n) {
                    n = dimension.width;
                }
                n2 += dimension.height;
                ++n4;
            }
            n2 += n3 * 4;
        }
        return new Dimension(n += 2, n2);
    }

    public ConstraintComponent[] getLeaves() {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>(1);
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n2);
            if (constraintBuilderComp instanceof ParentComponent) {
                objectArray = ((ParentComponent)constraintBuilderComp).getLeaves();
                if (objectArray != null) {
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        vector.addElement(objectArray[n3]);
                        ++n3;
                    }
                }
            } else {
                vector.addElement(((DragComponent)constraintBuilderComp).getConstraintComponent());
            }
            ++n2;
        }
        n = vector.size();
        if (n == 0) {
            return null;
        }
        objectArray = new ConstraintComponent[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int computeLeafLocation() {
        return 0;
    }

    public void setLeafLocation(int n) {
        this._leafLocation = n;
    }

    public int getLeafLocation() {
        return this._leafLocation;
    }

    public void paintComponent(Graphics graphics) {
        ((Container)((Object)this)).validate();
        PaintContext paintContext = this.getPaintContext();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        if (((Component)((Object)this)).isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(uIDefaults.getColor("textInactiveText"));
        }
        int n = this.getSproutCount();
        int n2 = 0;
        while (n2 < n) {
            Sprout sprout = this.getSprout(n2);
            this.paintSprout(graphics, sprout);
            ++n2;
        }
        if (((Component)((Object)this)).hasFocus()) {
            Dimension dimension = ((Component)((Object)this)).getSize();
            BorderPainter borderPainter = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null);
            int n3 = 0;
            int n4 = dimension.height - 1;
            n = this.getChildCount();
            if (n != 0) {
                ConstraintBuilderComp constraintBuilderComp = this.getChild(0);
                ConstraintBuilderComp constraintBuilderComp2 = this.getChild(n - 1);
                n3 = ((Component)((Object)constraintBuilderComp)).getLocation().y - 2;
                Rectangle rectangle = ((Component)((Object)constraintBuilderComp2)).getBounds();
                n4 = rectangle.y + rectangle.height - n3;
            }
            borderPainter.paint(paintContext, graphics, 0, n3, dimension.width, n4);
        }
        this.paintDragFeedback(graphics);
    }

    protected void addSprout(Sprout sprout) {
        if (this._sprouts == null) {
            this._sprouts = new Vector(2);
        }
        this._sprouts.addElement(sprout);
    }

    protected void removeAllSprouts() {
        if (this._sprouts != null) {
            this._sprouts.removeAllElements();
        }
    }

    protected int getSproutCount() {
        return this._sprouts == null ? 0 : this._sprouts.size();
    }

    protected Sprout getSprout(int n) {
        return this._sprouts == null ? null : (Sprout)this._sprouts.elementAt(n);
    }

    protected void paintSprout(Graphics graphics, Sprout sprout) {
        int n = sprout.x1;
        int n2 = sprout.y1;
        int n3 = sprout.x2;
        int n4 = sprout.y2;
        graphics.drawLine(n, n2, n, n4);
        graphics.drawLine(n + 1, n2, n + 1, n4);
        graphics.drawLine(n, n4, n3 - 3, n4);
        graphics.drawLine(n, n4 + 1, n3 - 3, n4 + 1);
        graphics.drawLine(n3 - 3, n4, n3 - 3, n4);
        graphics.drawLine(n3 - 2, n4 - 1, n3 - 2, n4 + 2);
        graphics.drawLine(n3 - 1, n4 - 2, n3 - 1, n4 + 3);
    }

    protected int getInsertIndex(int n) {
        int n2 = 0;
        int n3 = this.getChildCount();
        int n4 = 0;
        while (n4 < n3) {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n4);
            Rectangle rectangle = ((Component)((Object)constraintBuilderComp)).getBounds();
            if (n < rectangle.y + rectangle.height / 2) {
                return n2;
            }
            ++n2;
            ++n4;
        }
        return n2;
    }

    protected void setFeedbackSprout(Sprout sprout) {
        this._feedbackSprout = sprout;
        this.paintImmediateInterior();
    }

    protected Sprout getFeedbackSprout() {
        return this._feedbackSprout;
    }

    protected void paintDragFeedback(Graphics graphics) {
        Sprout sprout = this.getFeedbackSprout();
        if (sprout != null) {
            graphics.setColor(this.getConstraintBuilder().DROP_FEEDBACK_COLOR);
            this.paintSprout(graphics, sprout);
        }
    }

    protected void layoutSprouts() {
    }

    protected void addDropTarget(LWComponent lWComponent) {
        if (JFCSupport.getEWTDropTarget((JComponent)lWComponent) != null) {
            return;
        }
        DropTarget dropTarget = new DropTarget((Component)lWComponent, this._dropper);
        int n = lWComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = lWComponent.getComponent(n2);
            if (component instanceof LWComponent) {
                this.addDropTarget((LWComponent)component);
            }
            ++n2;
        }
    }

    protected void removeDropTarget(LWComponent lWComponent) {
        DropTarget dropTarget = JFCSupport.getEWTDropTarget((JComponent)lWComponent);
        boolean bl = true;
        try {
            dropTarget.removeDropTargetListener(this._dropper);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            JFCSupport.setEWTDropTarget((JComponent)lWComponent, null);
        }
        int n = lWComponent.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = lWComponent.getComponent(n2);
            if (component instanceof LWComponent) {
                this.removeDropTarget((LWComponent)component);
            }
            ++n2;
        }
    }

    protected boolean acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!((Component)((Object)this)).isEnabled()) {
            return false;
        }
        Object object = this;
        while (object != null && object instanceof ParentComponent) {
            if (((ConstraintBuilderComp)object).isDragging()) {
                return false;
            }
            object = ((Component)object).getParent();
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
                return true;
            }
            if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
                return true;
            }
            if (CBCompArray.CB_COMP_ARRAY_FLAVOR.equals(dataFlavorArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void calculateFeedback(int n, int n2) {
    }

    protected boolean acceptDrop(DropTargetDropEvent dropTargetDropEvent) {
        if (!((Component)((Object)this)).isEnabled()) {
            return false;
        }
        Object object = this;
        while (object != null && object instanceof ParentComponent) {
            if (((ConstraintBuilderComp)object).isDragging()) {
                return false;
            }
            object = ((Component)object).getParent();
        }
        return true;
    }

    protected void updateSelection(int n, int n2, int n3, int n4) {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        int n5 = 0;
        while (n5 < this.getChildCount()) {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n5);
            if (constraintBuilderComp instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)constraintBuilderComp;
                Point point = ((Component)((Object)parentComponent)).getLocation();
                parentComponent.updateSelection(n - point.x, n2 - point.y, n3, n4);
            } else if (this.intersects(((Component)((Object)constraintBuilderComp)).getBounds(), n, n2, n3, n4)) {
                constraintBuilder.addToSelection(constraintBuilderComp, false);
            } else {
                constraintBuilder.removeFromSelection(constraintBuilderComp, false);
            }
            ++n5;
        }
    }

    protected boolean intersects(Rectangle rectangle, int n, int n2, int n3, int n4) {
        return rectangle.x + rectangle.width > n && rectangle.y + rectangle.height > n2 && rectangle.x < n + n3 && rectangle.y < n2 + n4;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        ((Component)((Object)this)).repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || constraintBuilder != null && !((Component)((Object)constraintBuilder)).isEnabled()) {
            return;
        }
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 121 && (keyEvent.getModifiers() & 1) != 0) {
            Dimension dimension = ((Component)((Object)this)).getSize();
            constraintBuilder.showMenu(this, 10, dimension.height / 2);
            keyEvent.consume();
        } else if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 9 && ((Component)((Object)this)).hasFocus() && this.getChildCount() != 0) {
            boolean bl = false;
            if (!keyEvent.isShiftDown()) {
                this.getChild(0).requestFocus();
                bl = true;
            } else if (this.getParentComponent() != null && this.getParentComponent().getParentComponent() != null) {
                this.getParentComponent().requestFocus();
                bl = true;
            }
            if (bl) {
                keyEvent.consume();
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || constraintBuilder != null && !((Component)((Object)constraintBuilder)).isEnabled()) {
            return;
        }
        boolean bl = false;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getID();
        switch (n3) {
            case 501: {
                constraintBuilder.tryRequestFocus();
                break;
            }
            case 502: {
                if (this._dragSelection) {
                    constraintBuilder.finishDragSelection(this, n, n2);
                } else {
                    constraintBuilder.clearSelection();
                }
                if (mouseEvent.isPopupTrigger() && ((JComponent)((Object)this)).contains(n, n2)) {
                    constraintBuilder.showMenu(this, this._dragSelection, n, n2);
                }
                this._dragSelection = false;
                bl = true;
            }
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() | !((Component)((Object)constraintBuilder)).isEnabled()) {
            return;
        }
        if (mouseEvent.getID() == 506) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this._dragSelection) {
                constraintBuilder.continueDragSelection(this, n, n2);
            } else {
                this._dragSelection = true;
                constraintBuilder.startDragSelection(this, n, n2);
            }
            mouseEvent.consume();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new AccessibleParent();
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    private Point _getOffset(Component component) {
        Component component2 = component;
        int n = 0;
        int n2 = 0;
        while (component2 != this) {
            Point point = component2.getLocation();
            n += point.x;
            n2 += point.y;
            component2 = component2.getParent();
        }
        return new Point(n, n2);
    }

    class AccessibleParent
    extends ConstraintBuilderComp.AccessibleConstraintBuilderComp
    implements AccessibleSelection {
        public int getAccessibleChildrenCount() {
            return ParentComponent.this.getChildCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return ParentComponent.this.getChild(n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            int n = 0;
            int n2 = ParentComponent.this.getChildCount();
            int n3 = 0;
            while (n3 < n2) {
                if (ParentComponent.this.getChild(n3).isSelected()) {
                    ++n;
                }
                ++n3;
            }
            return n;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n >= this.getAccessibleSelectionCount()) {
                return null;
            }
            int n2 = 0;
            int n3 = ParentComponent.this.getChildCount();
            int n4 = 0;
            while (n4 < n3) {
                ConstraintBuilderComp constraintBuilderComp = ParentComponent.this.getChild(n4);
                if (constraintBuilderComp.isSelected()) {
                    if (n2 == n) {
                        return constraintBuilderComp;
                    }
                    ++n2;
                }
                ++n4;
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return false;
            }
            return ParentComponent.this.getChild(n).isSelected();
        }

        public void addAccessibleSelection(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return;
            }
            ConstraintBuilderComp constraintBuilderComp = ParentComponent.this.getChild(n);
            ParentComponent.this.getConstraintBuilder().addToSelection(constraintBuilderComp);
            constraintBuilderComp.setSelected(true);
        }

        public void removeAccessibleSelection(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return;
            }
            ConstraintBuilderComp constraintBuilderComp = ParentComponent.this.getChild(n);
            ParentComponent.this.getConstraintBuilder().removeFromSelection(constraintBuilderComp);
            constraintBuilderComp.setSelected(false);
        }

        public void clearAccessibleSelection() {
            int n = ParentComponent.this.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                ConstraintBuilderComp constraintBuilderComp = ParentComponent.this.getChild(n2);
                if (constraintBuilderComp.isSelected()) {
                    ParentComponent.this.getConstraintBuilder().removeFromSelection(constraintBuilderComp);
                    constraintBuilderComp.setSelected(false);
                }
                ++n2;
            }
        }

        public void selectAllAccessibleSelection() {
            int n = ParentComponent.this.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                ConstraintBuilderComp constraintBuilderComp = ParentComponent.this.getChild(n2);
                if (!constraintBuilderComp.isSelected()) {
                    ParentComponent.this.getConstraintBuilder().addToSelection(constraintBuilderComp);
                    constraintBuilderComp.setSelected(true);
                }
                ++n2;
            }
        }
    }
}

