/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeDragSupport;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSimpleChild;
import oracle.bali.ewt.dTree.DTreeSimpleRoot;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.datatransfer.CompoundTransferable;
import oracle.bali.share.datatransfer.ObjectTransferable;

public class ColumnConstraintBuilder
extends LWComponent
implements Accessible {
    Column[] _columns;
    ConstraintBuilder _builder;
    P _provider;
    private DTreeSimpleRoot _root;
    private EWTScrollPane _scrollBox;
    private DTree _tree;
    private JSplitPane _splitter;

    public ColumnConstraintBuilder() {
        this(null);
    }

    public ColumnConstraintBuilder(Column[] columnArray) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this._splitter = new JSplitPane();
        this._splitter.setContinuousLayout(false);
        this._tree = new DTree();
        this._root = new DTreeSimpleRoot();
        this._tree.setRoot((DTreeRootItem)this._root);
        this._tree.setDecoration(null);
        DTreeDragSupport dTreeDragSupport = new DTreeDragSupport(this._tree);
        this._builder = new ConstraintBuilder();
        this._scrollBox = new EWTScrollPane((Component)this._tree);
        this._provider = new P();
        this._builder.setDataDescriptorProvider(this._provider);
        this._splitter.add("left", (Component)this._scrollBox);
        this._splitter.add("right", (Component)((Object)this._builder));
        ((Container)((Object)this)).add("Center", this._splitter);
        this.setColumns(columnArray);
    }

    public ConstraintBuilder getConstraintBuilder() {
        return this._builder;
    }

    public void setColumns(Column[] columnArray) {
        int n;
        int n2 = this._columns == null ? 0 : this._columns.length;
        this._columns = null;
        if (columnArray != null) {
            n = columnArray.length;
            this._columns = new Column[n];
            if (n != 0) {
                System.arraycopy(columnArray, 0, this._columns, 0, n);
            }
        }
        n = this._columns == null ? 0 : this._columns.length;
        this.freezeRepaints();
        this._updateTree();
        this._provider.fireDescriptorCountChanged(n2, n);
        this.unfreezeRepaints();
    }

    public Column[] getColumns() {
        if (this._columns == null) {
            return null;
        }
        int n = this._columns.length;
        Column[] columnArray = new Column[n];
        if (n != 0) {
            System.arraycopy(this._columns, 0, columnArray, 0, n);
        }
        return columnArray;
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._scrollBox.setEnabled(bl);
        this._tree.setEnabled(bl);
        this._builder.setEnabled(bl);
    }

    public void requestFocus() {
        this._tree.requestFocus();
    }

    void addColumn(Column column) {
        ConstraintCompFactory constraintCompFactory = ConstraintCompFactory.getConstraintCompFactory();
        ConstraintComponent constraintComponent = constraintCompFactory.createConstraintComponent(this._provider, column, null);
        this._builder.addConstraintComponent(constraintComponent);
    }

    private void _updateTree() {
        int n;
        Object object;
        Cloneable cloneable;
        this._root.removeItems(0, this._root.getItemCount());
        if (this._columns != null) {
            Hashtable<String, CI> hashtable = new Hashtable<String, CI>();
            cloneable = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            int n2 = 0;
            while (n2 < this._columns.length) {
                object = this._columns[n2];
                String string = ((DataDescriptor)object).getDisplayName((Locale)cloneable);
                Object v = hashtable.get(string);
                if (v != null) {
                    CI cI = (CI)((Object)v);
                    string = cI.getColumn().getName();
                    cI.setLabel(string);
                    string = ((DataDescriptor)object).getName();
                }
                CI cI = new CI(string, (Column)object);
                this._root.addItem((DTreeItem)cI);
                if (v == null) {
                    hashtable.put(string, cI);
                }
                ++n2;
            }
        }
        if ((n = this._root.getItemCount()) == 0) {
            this._tree.setPreferredItemsOnScreen(2);
        } else {
            this._root.setExpanded(true);
            this._tree.setPreferredItemsOnScreen(n + 1);
        }
        this._tree.setPreferredLevelsOnScreen(1);
        cloneable = this._tree.getParent().getPreferredSize();
        object = ((JComponent)((Object)this)).getPreferredSize();
    }

    private class P
    implements DataDescriptorProvider {
        private PropertyChangeSupport _propertySupport = new PropertyChangeSupport(this);

        public void fireDescriptorCountChanged(int n, int n2) {
            this._propertySupport.firePropertyChange("descriptorCount", new Integer(n), new Integer(n2));
        }

        public int getDescriptorCount() {
            return ColumnConstraintBuilder.this._columns == null ? 0 : ColumnConstraintBuilder.this._columns.length;
        }

        public DataDescriptor getDescriptor(int n) {
            return ColumnConstraintBuilder.this._columns[n];
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this._propertySupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private class CI
    extends DTreeSimpleChild
    implements DTreeDragSource {
        private Column _column;

        public CI(String string, Column column) {
            super(string, null);
            this._column = column;
        }

        public DTreeDragSource getDragSource() {
            return this;
        }

        public int getSourceActions(DTreeItem dTreeItem) {
            return 2;
        }

        public Transferable getTransferable(DTreeItem dTreeItem) {
            ConstraintCompFactory constraintCompFactory = ConstraintCompFactory.getConstraintCompFactory();
            ConstraintComponent constraintComponent = constraintCompFactory.createConstraintComponent(ColumnConstraintBuilder.this._provider, this._column, null);
            String string = this._column.getName();
            Transferable[] transferableArray = new Transferable[]{ObjectTransferable.createTransferable((Object)constraintComponent), ObjectTransferable.createTransferable((Object)this._column), ObjectTransferable.createTransferable((Object)string)};
            return new CompoundTransferable(transferableArray);
        }

        public void dragDropEnd(DTreeItem dTreeItem, int n) {
        }

        protected void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            int n = mouseEvent.getClickCount();
            boolean bl2 = bl = (mouseEvent.getModifiers() & 0x10) != 0;
            if (bl && n == 2) {
                ColumnConstraintBuilder.this.addColumn(this._column);
            }
        }

        protected void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                ColumnConstraintBuilder.this.addColumn(this._column);
            }
        }

        public Column getColumn() {
            return this._column;
        }
    }
}

