/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.DragComponent;
import oracle.bali.dbUI.constraintBuilder.GroupComponent;
import oracle.bali.dbUI.constraintBuilder.GroupPainterComponent;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintBuilder.RootComponent;
import oracle.bali.dbUI.constraintBuilder.Sprout;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DropTargetDragEvent;

public class AndOrComponent
extends ParentComponent {
    private static final String KEY_REMOVE_AND = "REMOVE_AND";
    private static final String KEY_REMOVE_OR = "REMOVE_OR";
    private static final String KEY_CHANGE_TO_AND = "CHANGE_TO_AND";
    private static final String KEY_CHANGE_TO_OR = "CHANGE_TO_OR";
    private static final int _EXPANDED_WIDTH = 0;
    private static final int _EXPANDED_INCREMENT = 0;
    private GroupComponent _painterComponent;
    private DragComponent _dragComponent;
    private DK _dk;

    public AndOrComponent() {
        this(true);
    }

    public AndOrComponent(boolean bl) {
        int n = bl ? 0 : 1;
        this._painterComponent = this.createGroupComponent();
        this._painterComponent.setGroup(n);
        LWComponent lWComponent = this._painterComponent.getComponent();
        this.addDropTarget(lWComponent);
        this._dragComponent = this.createDragComponent(this, lWComponent);
        this.addDropTarget(this._dragComponent);
        ((Container)((Object)this)).add((Component)((Object)this._dragComponent));
    }

    public void performNot() {
        this.setNot(!this.isNot());
    }

    public boolean isNot() {
        int n = this._painterComponent.getGroup();
        return n == 3 || n == 2;
    }

    public void setNot(boolean bl) {
        if (this.isNot() != bl) {
            String string = null;
            if (((JComponent)((Object)this)).accessibleContext != null) {
                string = this.getAccessName();
            }
            int n = this._getGroup(this.isAnd(), bl);
            this._painterComponent.setGroup(n);
            if (((JComponent)((Object)this)).accessibleContext != null) {
                ((JComponent)((Object)this)).accessibleContext.firePropertyChange("AccessibleName", string, this.getAccessName());
            }
        }
    }

    public boolean isAnd() {
        int n = this._painterComponent.getGroup();
        return n == 0 || n == 2;
    }

    public void setAnd(boolean bl) {
        if (this.isAnd() != bl) {
            String string = null;
            if (((JComponent)((Object)this)).accessibleContext != null) {
                string = this.getAccessName();
            }
            int n = this._getGroup(bl, this.isNot());
            this._painterComponent.setGroup(n);
            if (((JComponent)((Object)this)).accessibleContext != null) {
                ((JComponent)((Object)this)).accessibleContext.firePropertyChange("AccessibleName", string, this.getAccessName());
            }
        }
    }

    public DataConstraint getDataConstraint() {
        int n = this.getChildCount();
        Vector<DataConstraint> vector = new Vector<DataConstraint>();
        int n2 = 0;
        while (n2 < n) {
            DataConstraint dataConstraint = this.getChild(n2).getDataConstraint();
            if (dataConstraint != null) {
                vector.addElement(dataConstraint);
            }
            ++n2;
        }
        DCBooleanExpression dCBooleanExpression = null;
        n = vector.size();
        if (n != 0) {
            Object[] objectArray = new DataConstraint[n];
            vector.copyInto(objectArray);
            int n3 = this.isAnd() ? 1 : 2;
            dCBooleanExpression = new DCBooleanExpression((DataConstraint[])objectArray, n3);
        }
        if (!this.isNot()) {
            return dCBooleanExpression;
        }
        return new DCUnaryExpression(dCBooleanExpression, 1);
    }

    public void setDataConstraint(DataConstraint dataConstraint) {
        if (dataConstraint instanceof DCUnaryExpression) {
            DCUnaryExpression dCUnaryExpression = (DCUnaryExpression)dataConstraint;
            dataConstraint = dCUnaryExpression.getConstraint(0);
            this.setNot(true);
        }
        if (dataConstraint != null && !(dataConstraint instanceof DCBooleanExpression)) {
            throw new IllegalArgumentException("invalid expression");
        }
        this.removeAll();
        if (dataConstraint == null) {
            return;
        }
        boolean bl = false;
        ConstraintBuilder constraintBuilder = this.getConstraintBuilder();
        if (dataConstraint instanceof DCBooleanExpression) {
            DCBooleanExpression dCBooleanExpression = (DCBooleanExpression)dataConstraint;
            bl = dCBooleanExpression.getOperand() == 1;
            int n = 0;
            while (n < dCBooleanExpression.getConstraintCount()) {
                this.addChild(constraintBuilder.parseConstraint(dCBooleanExpression.getConstraint(n)));
                ++n;
            }
        }
        this.setAnd(bl);
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this._dragComponent.setSelected(bl);
    }

    public void setConstraintBuilder(ConstraintBuilder constraintBuilder) {
        super.setConstraintBuilder(constraintBuilder);
        this._dragComponent.setConstraintBuilder(constraintBuilder);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._dragComponent.setEnabled(bl);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this._dragComponent.getPreferredSize();
        dimension.width += dimension2.width + 2;
        dimension.width += this._dragComponent.getBorderWidth();
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Dimension dimension2 = this._dragComponent.getMinimumSize();
        dimension.width += dimension2.width + 2;
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        Dimension dimension2 = this._dragComponent.getMaximumSize();
        dimension.width += dimension2.width + 2;
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public int computeLeafLocation() {
        int n = 0;
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n3);
            if (constraintBuilderComp instanceof ParentComponent && (n4 = ((ParentComponent)constraintBuilderComp).computeLeafLocation()) > n) {
                n = n4;
            }
            ++n3;
        }
        return n + this.getGroupWidth();
    }

    public void setLeafLocation(int n) {
        super.setLeafLocation(n);
        int n2 = this.getChildCount();
        int n3 = n - (this._dragComponent.getPreferredSize().width + 2);
        int n4 = 0;
        while (n4 < n2) {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n4);
            if (constraintBuilderComp instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)constraintBuilderComp;
                parentComponent.setLeafLocation(n3);
            }
            ++n4;
        }
    }

    public void doLayout() {
        Dimension dimension = ((Component)((Object)this)).getSize();
        Dimension dimension2 = this._dragComponent.getPreferredSize();
        int n = (dimension.height - dimension2.height) / 2;
        ((Component)((Object)this._dragComponent)).setBounds(0, n, dimension2.width, dimension2.height);
        int n2 = dimension2.width;
        if (this.isExpanded()) {
            dimension2 = this.getPreferredSize();
            int n3 = n2 + 2;
            int n4 = this.getLeafLocation();
            int n5 = (dimension.height - dimension2.height) / 2 + 2;
            int n6 = this.getChildCount();
            int n7 = 0;
            while (n7 < n6) {
                ConstraintBuilderComp constraintBuilderComp = this.getChild(n7);
                dimension2 = ((JComponent)((Object)constraintBuilderComp)).getPreferredSize();
                int n8 = constraintBuilderComp instanceof ParentComponent || !this.getConstraintBuilder().isAlignLeaves() ? n3 : n4;
                ((Component)((Object)constraintBuilderComp)).setBounds(n8, n5, dimension2.width, dimension2.height);
                n5 += dimension2.height + 4;
                ++n7;
            }
        }
        this.layoutSprouts();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.isExpanded()) {
            graphics.setColor(Color.black);
            Rectangle rectangle = ((Component)((Object)this._dragComponent)).getBounds();
            int n = rectangle.x + rectangle.width;
            int n2 = rectangle.y + rectangle.height / 2;
            int n3 = n + 0;
            int n4 = 0;
            graphics.drawLine(n, n2, n3, n2);
            graphics.drawLine(n, n2 + 1, n3, n2 + 1);
            n = n3 + n4;
            n3 = n + 0;
            graphics.drawLine(n, n2, n3, n2);
            graphics.drawLine(n, n2 + 1, n3, n2 + 1);
            n = n3 + n4;
            n3 = n + 0;
            graphics.drawLine(n, n2, n3, n2);
            graphics.drawLine(n, n2 + 1, n3, n2 + 1);
            n = n3 + n4;
            n3 = n + 0;
        }
    }

    public boolean isDragging() {
        return this._dragComponent.isDragging();
    }

    protected void updateSelection(int n, int n2, int n3, int n4) {
        if (this.intersects(((Component)((Object)this._dragComponent)).getBounds(), n, n2, n3, n4)) {
            this.getConstraintBuilder().addToSelection(this, false);
        } else {
            this.getConstraintBuilder().removeFromSelection(this, false);
            super.updateSelection(n, n2, n3, n4);
        }
    }

    protected void calculateFeedback(int n, int n2) {
        int n3;
        if (n < 0) {
            this._dragComponent.setDropping(false);
            this.setFeedbackSprout(null);
            return;
        }
        Rectangle rectangle = ((Component)((Object)this._dragComponent)).getBounds();
        int n4 = rectangle.x + rectangle.width / 4;
        int n5 = rectangle.x + rectangle.width - 1;
        int n6 = rectangle.y;
        int n7 = rectangle.y + rectangle.height;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = this.getChildCount();
        int n14 = 0;
        while (n14 < n13) {
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n14);
            rectangle = ((Component)((Object)constraintBuilderComp)).getBounds();
            if (n2 <= rectangle.y + rectangle.height / 2) {
                n9 = rectangle.x;
                n10 = rectangle.y - 2;
                n9 = rectangle.x;
                n8 = n4;
                if (n10 <= n6) {
                    n11 = n6;
                } else if (n10 >= n7) {
                    n11 = n7;
                } else {
                    n11 = n10;
                    n8 = n5;
                }
                n12 = n14;
                break;
            }
            ++n14;
        }
        if (n8 == -1) {
            if (n13 == 0) {
                Dimension dimension = ((Component)((Object)this)).getSize();
                n8 = rectangle.x + rectangle.width;
                n9 = 2 + n8;
                n10 = n11 = dimension.height / 2;
                n12 = 0;
            } else {
                n9 = rectangle.x;
                n10 = rectangle.y + rectangle.height + 1;
                n9 = rectangle.x;
                n8 = n4;
                if (n10 <= n6) {
                    n11 = n6;
                } else if (n10 >= n7) {
                    n11 = n7;
                } else {
                    n11 = n10;
                    n8 = n5;
                }
                n12 = this.getChildCount();
            }
        }
        if ((n3 = this._getDraggingChild()) != -1) {
            if (n12 == n3) {
                this.setFeedbackSprout(null);
                this._dragComponent.setDropping(false);
                return;
            }
            if (n12 == n3 + 1) {
                this.setFeedbackSprout(null);
                this._dragComponent.setDropping(false);
                return;
            }
        }
        this._dragComponent.setDropping(true);
        Sprout sprout = this.getFeedbackSprout();
        if (sprout == null) {
            sprout = new Sprout(0, 0, 0, 0);
        }
        if (sprout.x1 != n8 || sprout.x2 != n9 || sprout.y1 != n11 || sprout.y2 != n10) {
            sprout.x1 = n8;
            sprout.x2 = n9;
            sprout.y1 = n11;
            sprout.y2 = n10;
            this.setFeedbackSprout(sprout);
        }
    }

    protected boolean acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (this.isDragging()) {
            return false;
        }
        return super.acceptDrag(dropTargetDragEvent);
    }

    protected int getAccessActionCount() {
        return 11;
    }

    protected String getAccessActionDescription(int n) {
        switch (n) {
            case 0: {
                return this.getTranslatedAccessibleString("TOGGLE_SELECT");
            }
            case 1: {
                return this.getTranslatedAccessibleString("CREATE_AND");
            }
            case 2: {
                return this.getTranslatedAccessibleString("CREATE_OR");
            }
            case 3: {
                return this.getTranslatedAccessibleString("PERFORM_NOT");
            }
            case 4: {
                return this.getTranslatedAccessibleString("DELETE");
            }
            case 5: {
                return this.getTranslatedAccessibleString("SIMPLIFY");
            }
            case 6: {
                return this.getTranslatedAccessibleString("TOGGLE_EXPANDED");
            }
            case 7: {
                return this.getTranslatedAccessibleString(KEY_REMOVE_AND);
            }
            case 8: {
                return this.getTranslatedAccessibleString(KEY_REMOVE_OR);
            }
            case 9: {
                return this.getTranslatedAccessibleString(KEY_CHANGE_TO_AND);
            }
            case 10: {
                return this.getTranslatedAccessibleString(KEY_CHANGE_TO_OR);
            }
            case 11: {
                return this.getTranslatedAccessibleString("ADD_CONSTRAINT");
            }
        }
        return null;
    }

    protected boolean doAccessAction(int n) {
        boolean bl = this.getParentComponent() instanceof RootComponent;
        boolean bl2 = this.getChildCount() == 1;
        boolean bl3 = !bl || bl & bl2;
        switch (n) {
            case 0: {
                boolean bl4;
                boolean bl5 = bl4 = !this.isSelected();
                if (bl4) {
                    this.getConstraintBuilder().addToSelection(this, false);
                } else {
                    this.getConstraintBuilder().removeFromSelection(this, false);
                }
                return true;
            }
            case 1: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(true, false);
                return true;
            }
            case 2: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(false, false);
                return true;
            }
            case 3: {
                if (!this.isNot()) {
                    this.getConstraintBuilder().setSelection(this);
                    this.getConstraintBuilder().createNotOnSelection();
                }
                return true;
            }
            case 4: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().deleteSelectedComponents();
                return true;
            }
            case 5: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performSimplify();
                return true;
            }
            case 6: {
                this.setExpanded(!this.isExpanded());
                return true;
            }
            case 7: {
                if (!this.isAnd() || !bl3) {
                    return false;
                }
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performRemoveParent();
                return true;
            }
            case 8: {
                if (this.isAnd() || !bl3) {
                    return false;
                }
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performRemoveParent();
                return true;
            }
            case 9: {
                if (!this.isAnd()) {
                    this.getConstraintBuilder().setSelection(this);
                    this.getConstraintBuilder().performAndOr(true);
                }
                return true;
            }
            case 10: {
                if (this.isAnd()) {
                    this.getConstraintBuilder().setSelection(this);
                    this.getConstraintBuilder().performAndOr(false);
                }
                return true;
            }
            case 11: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performAdd();
                return true;
            }
        }
        return false;
    }

    protected DragComponent createDragComponent(ParentComponent parentComponent, LWComponent lWComponent) {
        DragComponent dragComponent = new DragComponent(parentComponent, lWComponent);
        if (this._dk == null) {
            this._dk = new DK();
        }
        ((Component)((Object)dragComponent)).addMouseListener(this._dk);
        return dragComponent;
    }

    protected GroupComponent createGroupComponent() {
        GroupPainterComponent groupPainterComponent = new GroupPainterComponent();
        if (this._dk == null) {
            this._dk = new DK();
        }
        groupPainterComponent.getComponent().addMouseListener(this._dk);
        return groupPainterComponent;
    }

    protected final GroupComponent getGroupComponent() {
        return this._painterComponent;
    }

    protected final DragComponent getDragComponent() {
        return this._dragComponent;
    }

    protected void layoutSprouts() {
        this.removeAllSprouts();
        int n = this.getChildCount();
        if (n == 0 || !this.isExpanded()) {
            return;
        }
        Rectangle rectangle = ((Component)((Object)this._dragComponent)).getBounds();
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y;
        int n5 = rectangle.y + rectangle.height;
        int n6 = 0;
        while (n6 < n) {
            int n7;
            ConstraintBuilderComp constraintBuilderComp = this.getChild(n6);
            rectangle = ((Component)((Object)constraintBuilderComp)).getBounds();
            int n8 = rectangle.y + rectangle.height / 2;
            int n9 = rectangle.x;
            int n10 = n2;
            if (n8 <= n4) {
                n7 = n4;
            } else if (n8 >= n5) {
                n7 = n5;
            } else {
                n7 = n8;
                n10 = n3;
            }
            Sprout sprout = new Sprout(n10, n7, n9, n8);
            this.addSprout(sprout);
            ++n6;
        }
    }

    private int _getGroup(boolean bl, boolean bl2) {
        int n = bl ? (bl2 ? 2 : 0) : (bl2 ? 3 : 1);
        return n;
    }

    private int _getDraggingChild() {
        int n = 0;
        while (n < this.getChildCount()) {
            if (this.getChild(n).isDragging()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private class DK
    extends MouseAdapter {
        private DK() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2 = bl = (mouseEvent.getModifiers() & 0x10) != 0;
            if (bl && ((Component)((Object)AndOrComponent.this)).isEnabled() && mouseEvent.getClickCount() == 2) {
                if (AndOrComponent.this.getConstraintBuilder().isCollapseAllowed()) {
                    AndOrComponent.this.setExpanded(!AndOrComponent.this.isExpanded());
                } else {
                    AndOrComponent.this.getConstraintBuilder().performAndOr(!AndOrComponent.this.isAnd());
                }
                mouseEvent.consume();
            }
        }
    }
}

