/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.util.Vector;
import oracle.bali.dbUI.constraint.AndObjectTest;
import oracle.bali.dbUI.constraint.BetweenObjectTest;
import oracle.bali.dbUI.constraint.ContainsObjectTest;
import oracle.bali.dbUI.constraint.DCArithmeticExpression;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.EndsWithObjectTest;
import oracle.bali.dbUI.constraint.EqualToObjectTest;
import oracle.bali.dbUI.constraint.GreaterThanObjectTest;
import oracle.bali.dbUI.constraint.LessThanObjectTest;
import oracle.bali.dbUI.constraint.NaryObjectTest;
import oracle.bali.dbUI.constraint.NotObjectTest;
import oracle.bali.dbUI.constraint.OTAddExpression;
import oracle.bali.dbUI.constraint.OTBinaryExpression;
import oracle.bali.dbUI.constraint.OTConstant;
import oracle.bali.dbUI.constraint.OTDivideExpression;
import oracle.bali.dbUI.constraint.OTMultiplyExpression;
import oracle.bali.dbUI.constraint.OTName;
import oracle.bali.dbUI.constraint.OTSubtractExpression;
import oracle.bali.dbUI.constraint.ObjectTest;
import oracle.bali.dbUI.constraint.ObjectTestExpression;
import oracle.bali.dbUI.constraint.OrObjectTest;
import oracle.bali.dbUI.constraint.StartsWithObjectTest;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;

class ObjectTestGenerator {
    private DataDescriptorProvider _provider;

    public ObjectTestGenerator() {
        this(null);
    }

    public ObjectTestGenerator(DataDescriptorProvider dataDescriptorProvider) {
        this._provider = dataDescriptorProvider;
    }

    public void setDescriptorProvider(DataDescriptorProvider dataDescriptorProvider) {
        this._provider = dataDescriptorProvider;
    }

    public DataDescriptorProvider getDataDescriptorProvider() {
        return this._provider;
    }

    public ObjectTest getObjectTest(DataConstraint dataConstraint) {
        ObjectTest objectTest = null;
        if (dataConstraint == null) {
            return objectTest;
        }
        int n = -1;
        if (dataConstraint instanceof DCExpression) {
            n = ((DCExpression)dataConstraint).getOperand();
        }
        DataConstraint dataConstraint2 = null;
        DataConstraint dataConstraint3 = null;
        if (dataConstraint instanceof DCBinaryExpression) {
            DCBinaryExpression dCBinaryExpression = (DCBinaryExpression)dataConstraint;
            dataConstraint2 = dCBinaryExpression.getConstraint(0);
            dataConstraint3 = dCBinaryExpression.getConstraint(1);
            if (!(dataConstraint2 instanceof DCVariable) && dataConstraint3 instanceof DCVariable) {
                DataConstraint dataConstraint4 = dataConstraint2;
                dataConstraint2 = dataConstraint3;
                dataConstraint3 = dataConstraint4;
            }
        } else if (dataConstraint instanceof DCUnaryExpression) {
            DCUnaryExpression dCUnaryExpression = (DCUnaryExpression)dataConstraint;
            dataConstraint2 = dCUnaryExpression.getConstraint(0);
        }
        if (dataConstraint instanceof DCBooleanExpression) {
            objectTest = this._getBoolean((DCBooleanExpression)dataConstraint);
        } else if (dataConstraint instanceof DCUnaryExpression) {
            ObjectTest objectTest2 = this.getObjectTest(dataConstraint2);
            objectTest = new NotObjectTest(objectTest2);
        } else if (dataConstraint instanceof DCComparisonExpression) {
            objectTest = this._getComparison(dataConstraint2, dataConstraint3, n);
        } else if (dataConstraint instanceof DCCollectionExpression) {
            objectTest = this._getCollection(dataConstraint2, dataConstraint3, n);
        } else if (dataConstraint instanceof DCBetweenExpression) {
            objectTest = this._getBetween((DCBetweenExpression)dataConstraint);
        }
        return objectTest;
    }

    private ObjectTest _getBoolean(DCBooleanExpression dCBooleanExpression) {
        int n = dCBooleanExpression.getOperand();
        NaryObjectTest naryObjectTest = null;
        Vector<ObjectTest> vector = new Vector<ObjectTest>();
        int n2 = 0;
        while (n2 < dCBooleanExpression.getConstraintCount()) {
            ObjectTest objectTest = this.getObjectTest(dCBooleanExpression.getConstraint(n2));
            vector.addElement(objectTest);
            ++n2;
        }
        Object[] objectArray = new ObjectTest[vector.size()];
        vector.copyInto(objectArray);
        switch (n) {
            case 1: {
                naryObjectTest = new AndObjectTest((ObjectTest[])objectArray);
                break;
            }
            case 2: {
                naryObjectTest = new OrObjectTest((ObjectTest[])objectArray);
            }
        }
        return naryObjectTest;
    }

    private ObjectTest _getComparison(DataConstraint dataConstraint, DataConstraint dataConstraint2, int n) {
        ObjectTest objectTest = null;
        ObjectTestExpression objectTestExpression = this._getObjectTestExpression(dataConstraint);
        ObjectTestExpression objectTestExpression2 = this._getObjectTestExpression(dataConstraint2);
        switch (n) {
            case 1: {
                objectTest = new GreaterThanObjectTest(objectTestExpression, objectTestExpression2);
                break;
            }
            case 2: {
                objectTest = new LessThanObjectTest(objectTestExpression, objectTestExpression2);
                break;
            }
            case 3: {
                objectTest = new EqualToObjectTest(objectTestExpression, objectTestExpression2);
                break;
            }
            case 4: {
                objectTest = new NotObjectTest(new EqualToObjectTest(objectTestExpression, objectTestExpression2));
                break;
            }
            case 5: {
                ObjectTest[] objectTestArray = new ObjectTest[]{new GreaterThanObjectTest(objectTestExpression, objectTestExpression2), new EqualToObjectTest(objectTestExpression, objectTestExpression2)};
                objectTest = new OrObjectTest(objectTestArray);
                break;
            }
            case 6: {
                ObjectTest[] objectTestArray = new ObjectTest[]{new LessThanObjectTest(objectTestExpression, objectTestExpression2), new EqualToObjectTest(objectTestExpression, objectTestExpression2)};
                objectTest = new OrObjectTest(objectTestArray);
            }
        }
        return objectTest;
    }

    private ObjectTest _getCollection(DataConstraint dataConstraint, DataConstraint dataConstraint2, int n) {
        ObjectTest objectTest = null;
        ObjectTestExpression objectTestExpression = this._getObjectTestExpression(dataConstraint);
        ObjectTestExpression objectTestExpression2 = this._getObjectTestExpression(dataConstraint2);
        switch (n) {
            case 1: {
                objectTest = new StartsWithObjectTest(objectTestExpression, objectTestExpression2, false);
                break;
            }
            case 2: {
                objectTest = new StartsWithObjectTest(objectTestExpression, objectTestExpression2, true);
                break;
            }
            case 3: {
                objectTest = new EndsWithObjectTest(objectTestExpression, objectTestExpression2, false);
                break;
            }
            case 4: {
                objectTest = new EndsWithObjectTest(objectTestExpression, objectTestExpression2, true);
                break;
            }
            case 5: {
                objectTest = new ContainsObjectTest(objectTestExpression, objectTestExpression2);
                break;
            }
            case 6: {
                objectTest = new NotObjectTest(new ContainsObjectTest(objectTestExpression, objectTestExpression2));
            }
        }
        return objectTest;
    }

    private ObjectTestExpression _getArithmetic(DataConstraint dataConstraint, DataConstraint dataConstraint2, int n) {
        OTBinaryExpression oTBinaryExpression = null;
        ObjectTestExpression objectTestExpression = this._getObjectTestExpression(dataConstraint);
        ObjectTestExpression objectTestExpression2 = this._getObjectTestExpression(dataConstraint2);
        switch (n) {
            case 1: {
                oTBinaryExpression = new OTAddExpression(objectTestExpression, objectTestExpression2);
                break;
            }
            case 2: {
                oTBinaryExpression = new OTSubtractExpression(objectTestExpression, objectTestExpression2);
                break;
            }
            case 3: {
                oTBinaryExpression = new OTMultiplyExpression(objectTestExpression, objectTestExpression2);
                break;
            }
            case 4: {
                oTBinaryExpression = new OTDivideExpression(objectTestExpression, objectTestExpression2);
            }
        }
        return oTBinaryExpression;
    }

    private ObjectTest _getBetween(DCBetweenExpression dCBetweenExpression) {
        int n = dCBetweenExpression.getOperand();
        ObjectTestExpression objectTestExpression = this._getObjectTestExpression(dCBetweenExpression.getCheckConstraint());
        ObjectTestExpression objectTestExpression2 = this._getObjectTestExpression(dCBetweenExpression.getFirstConstraint());
        ObjectTestExpression objectTestExpression3 = this._getObjectTestExpression(dCBetweenExpression.getSecondConstraint());
        boolean bl = n == 2;
        return new BetweenObjectTest(objectTestExpression, objectTestExpression2, objectTestExpression3, bl);
    }

    private ObjectTestExpression _getObjectTestExpression(DataConstraint dataConstraint) {
        ObjectTestExpression objectTestExpression = null;
        DataConstraint dataConstraint2 = null;
        DataConstraint dataConstraint3 = null;
        DCBinaryExpression dCBinaryExpression = null;
        if (dataConstraint instanceof DCBinaryExpression) {
            dCBinaryExpression = (DCBinaryExpression)dataConstraint;
            dataConstraint2 = dCBinaryExpression.getConstraint(0);
            dataConstraint3 = dCBinaryExpression.getConstraint(1);
        }
        if (dataConstraint instanceof DCVariable) {
            objectTestExpression = this._createName((DCVariable)dataConstraint);
        } else if (dataConstraint instanceof DCConstant) {
            objectTestExpression = this._createConstant((DCConstant)dataConstraint);
        } else if (dataConstraint instanceof DCArithmeticExpression) {
            int n = ((DCArithmeticExpression)dataConstraint).getOperand();
            objectTestExpression = this._getArithmetic(dataConstraint2, dataConstraint3, n);
        }
        return objectTestExpression;
    }

    private ObjectTestExpression _createName(DCVariable dCVariable) {
        DataDescriptorProvider dataDescriptorProvider = this.getDataDescriptorProvider();
        if (dataDescriptorProvider == null) {
            return null;
        }
        Object object = dCVariable.getVariable();
        String string = object instanceof DataDescriptor ? ((DataDescriptor)object).getName() : null;
        int n = -1;
        int n2 = dataDescriptorProvider.getDescriptorCount();
        int n3 = 0;
        while (n3 < n2) {
            DataDescriptor dataDescriptor = dataDescriptorProvider.getDescriptor(n3);
            if (dataDescriptor.equals(object) || dataDescriptor.getName().equals(string)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n == -1 ? null : new OTName(n);
    }

    private ObjectTestExpression _createConstant(DCConstant dCConstant) {
        return new OTConstant(dCConstant.getValue());
    }
}

