/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.util.EventListener;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.ObjectTest;
import oracle.bali.dbUI.constraint.ObjectTestGenerator;
import oracle.bali.dbUI.constraint.ObjectTestRowImpl;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.event.ListenerManager;

public class ConstrainableModel
implements Constrainable,
TwoDModel {
    public static final int ROW_NOT_IN_CONSTRAINT = -1;
    private TwoDModelListener _listener;
    private ObjectTestGenerator _parser;
    private DataConstraint _dataConstraint;
    private int _filteredRowCount;
    private int[] _filteredToUnfiltered;
    private ListenerManager _listeners;
    private TwoDModel _ds;
    private DataDescriptorProvider _provider;

    public ConstrainableModel(TwoDModel twoDModel, DataDescriptorProvider dataDescriptorProvider) {
        int n;
        this._ds = twoDModel;
        if (this._ds != null) {
            this._ds.addModelListener(this._getListener());
        }
        this._provider = dataDescriptorProvider;
        this._filteredRowCount = n = this._ds == null ? 0 : this._ds.getRowCount();
    }

    public int getColumnCount() {
        return this._ds == null ? 0 : this._ds.getColumnCount();
    }

    public int getRowCount() {
        return this._filteredRowCount;
    }

    public Object getData(int n, int n2) {
        if (this._filteredToUnfiltered != null) {
            n2 = this._filteredToUnfiltered[n2];
        }
        return this._ds == null ? null : this._ds.getData(n, n2);
    }

    public void setData(int n, int n2, Object object) {
        if (this._filteredToUnfiltered != null) {
            n2 = this._filteredToUnfiltered[n2];
        }
        if (this._ds != null) {
            this._ds.setData(n, n2, object);
            this._sendCellInvalidEvent(n, n2);
        }
    }

    public void addModelListener(TwoDModelListener twoDModelListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)twoDModelListener);
    }

    public void removeModelListener(TwoDModelListener twoDModelListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)twoDModelListener);
        }
    }

    public DataDescriptorProvider getDescriptorProvider() {
        return this._provider;
    }

    public void setDescriptorProvider(DataDescriptorProvider dataDescriptorProvider) {
        this._provider = dataDescriptorProvider;
        this._dataConstraint = null;
        this._applyConstraints();
    }

    public TwoDModel getModel() {
        return this._ds;
    }

    public void setModel(TwoDModel twoDModel) {
        if (this._ds != null) {
            this._ds.removeModelListener(this._getListener());
        }
        this._ds = twoDModel;
        if (this._ds != null) {
            this._ds.addModelListener(this._getListener());
        }
        this._dataConstraint = null;
        this._applyConstraints();
    }

    public void setDataConstraint(DataConstraint dataConstraint) {
        this._dataConstraint = dataConstraint;
        this._applyConstraints();
    }

    public DataConstraint getDataConstraint() {
        return this._dataConstraint;
    }

    public int getConstrainedIndex(int n) {
        if (this._filteredToUnfiltered == null) {
            return n;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    protected void processTwoDModelEvent(TwoDModelEvent var1_1) {
        var2_2 = this._listeners;
        if (this._listeners == null) {
            return;
        }
        var3_3 = var2_2.getListeners();
        if (var3_3 != null) ** GOTO lbl30
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = (TwoDModelListener)var3_3.nextElement();
            switch (var1_1.getID()) {
                case 2004: {
                    var4_4.rowsAdded(var1_1);
                    break;
                }
                case 2005: {
                    var4_4.rowsRemoved(var1_1);
                    break;
                }
                case 2007: {
                    var4_4.invalidateCells(var1_1);
                    break;
                }
                case 2006: {
                    var4_4.invalidateRows(var1_1);
                    break;
                }
                case 2001: {
                    var4_4.columnsAdded(var1_1);
                    break;
                }
                case 2002: {
                    var4_4.columnsRemoved(var1_1);
                    break;
                }
                case 2003: {
                    var4_4.invalidateColumns(var1_1);
                    break;
                }
            }
lbl30:
            // 9 sources

            ** while (var3_3.hasMoreElements())
        }
lbl31:
        // 1 sources

    }

    void _applyConstraints() {
        int n = 0;
        TwoDModel twoDModel = this.getModel();
        int n2 = twoDModel.getRowCount();
        if (this._dataConstraint == null) {
            n = n2;
            this._filteredToUnfiltered = null;
        } else {
            if (this._filteredToUnfiltered == null) {
                this._filteredToUnfiltered = new int[twoDModel.getRowCount()];
            }
            if (this._parser == null) {
                this._parser = new ObjectTestGenerator(this.getDescriptorProvider());
            }
            ObjectTest objectTest = this._parser.getObjectTest(this._dataConstraint);
            int n3 = this.getColumnCount();
            ObjectTestRowImpl objectTestRowImpl = new ObjectTestRowImpl(n3);
            int n4 = 0;
            while (n4 < n2) {
                int n5 = 0;
                while (n5 < n3) {
                    objectTestRowImpl.setObject(n5, twoDModel.getData(n5, n4));
                    ++n5;
                }
                if (objectTest.test(objectTestRowImpl)) {
                    this._filteredToUnfiltered[n] = n4;
                    ++n;
                }
                ++n4;
            }
        }
        int n6 = n - this._filteredRowCount;
        this._filteredRowCount = n;
        if (n6 < 0) {
            this._sendRowsRemovedEvent(-n6);
        } else if (n6 > 0) {
            this._sendRowsAddedEvent(n6);
        }
    }

    private void _sendRowsRemovedEvent(int n) {
        TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2005, 0, n);
        this.processTwoDModelEvent(twoDModelEvent);
        twoDModelEvent = new TwoDModelEvent((Object)this, 2006, 0, this.getRowCount());
        this.processTwoDModelEvent(twoDModelEvent);
    }

    private void _sendRowsAddedEvent(int n) {
        TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2004, 0, n);
        this.processTwoDModelEvent(twoDModelEvent);
        twoDModelEvent = new TwoDModelEvent((Object)this, 2006, 0, this.getRowCount());
        this.processTwoDModelEvent(twoDModelEvent);
    }

    private void _sendCellInvalidEvent(int n, int n2) {
        TwoDModelEvent twoDModelEvent = new TwoDModelEvent((Object)this, 2007, n, 1, n2, 1);
        this.processTwoDModelEvent(twoDModelEvent);
    }

    private TwoDModelListener _getListener() {
        if (this._listener == null) {
            this._listener = new Update();
        }
        return this._listener;
    }

    private class Update
    implements TwoDModelListener {
        private Update() {
        }

        public void rowsAdded(TwoDModelEvent twoDModelEvent) {
            ConstrainableModel.this._applyConstraints();
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            ConstrainableModel.this._applyConstraints();
        }

        public void invalidateRows(TwoDModelEvent twoDModelEvent) {
            TwoDModelEvent twoDModelEvent2 = new TwoDModelEvent((Object)this, 2006, 0, ConstrainableModel.this.getRowCount());
            ConstrainableModel.this.processTwoDModelEvent(twoDModelEvent2);
        }

        public void columnsAdded(TwoDModelEvent twoDModelEvent) {
            TwoDModelEvent twoDModelEvent2 = new TwoDModelEvent((Object)this, 2001, twoDModelEvent.getColumnStartIndex(), twoDModelEvent.getColumnCount());
            ConstrainableModel.this.processTwoDModelEvent(twoDModelEvent2);
            ConstrainableModel.this._applyConstraints();
        }

        public void columnsRemoved(TwoDModelEvent twoDModelEvent) {
            TwoDModelEvent twoDModelEvent2 = new TwoDModelEvent((Object)this, 2002, twoDModelEvent.getColumnStartIndex(), twoDModelEvent.getColumnCount());
            ConstrainableModel.this.processTwoDModelEvent(twoDModelEvent2);
            ConstrainableModel.this._applyConstraints();
        }

        public void invalidateColumns(TwoDModelEvent twoDModelEvent) {
            TwoDModelEvent twoDModelEvent2 = new TwoDModelEvent((Object)this, 2003, twoDModelEvent.getColumnStartIndex(), twoDModelEvent.getColumnCount());
            ConstrainableModel.this.processTwoDModelEvent(twoDModelEvent2);
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            TwoDModelEvent twoDModelEvent2 = new TwoDModelEvent((Object)this, 2007, 0, ConstrainableModel.this.getColumnCount(), 0, ConstrainableModel.this.getRowCount());
            ConstrainableModel.this.processTwoDModelEvent(twoDModelEvent2);
        }
    }
}

