/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.columnPropertyEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.beans.PropertyDescriptor;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapper;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapperFactory;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.propertyTable.PropertyTable;
import oracle.bali.dbUI.propertyTable.PropertyTableAdapter;
import oracle.bali.dbUI.propertyTable.PropertyTableCustomizer;
import oracle.bali.dbUI.propertyTable.PropertyTableEvent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.ComboBoxInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.ProxyPainter;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableMoveAdapter;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.sort.Comparator;

public class ColumnPropertyEditor
extends LWComponent
implements Accessible {
    public static final String PROPERTY_VISUAL_ORDER_CHANGED = "_VISUAL_ORDER_CHANGED";
    static final String[] _DATA_TYPE_NAMES = new String[]{"Boolean", "Byte", "Character", "Double", "Float", "Integer", "Long", "Object", "Short", "String", "Date", "SQL Date", "SQL Time", "SQL Timestamp", "Big Decimal", "Big Integer"};
    static final Class[] _DATA_TYPE_CLASSES = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = ColumnPropertyEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Byte == null ? (class$java$lang$Byte = ColumnPropertyEditor.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = ColumnPropertyEditor.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Double == null ? (class$java$lang$Double = ColumnPropertyEditor.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = ColumnPropertyEditor.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnPropertyEditor.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = ColumnPropertyEditor.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Object == null ? (class$java$lang$Object = ColumnPropertyEditor.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Short == null ? (class$java$lang$Short = ColumnPropertyEditor.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$String == null ? (class$java$lang$String = ColumnPropertyEditor.class$("java.lang.String")) : class$java$lang$String, class$java$util$Date == null ? (class$java$util$Date = ColumnPropertyEditor.class$("java.util.Date")) : class$java$util$Date, class$java$sql$Date == null ? (class$java$sql$Date = ColumnPropertyEditor.class$("java.sql.Date")) : class$java$sql$Date, class$java$sql$Time == null ? (class$java$sql$Time = ColumnPropertyEditor.class$("java.sql.Time")) : class$java$sql$Time, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ColumnPropertyEditor.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ColumnPropertyEditor.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = ColumnPropertyEditor.class$("java.math.BigInteger")) : class$java$math$BigInteger};
    static final String _TABLE_NAME = "tableName";
    static final String _NAME = "name";
    static final String _DISPLAY_NAME = "displayName";
    static final String _WIDTH = "width";
    static final String _VISIBLE = "visible";
    static final String _DATA_TYPE = "dataType";
    static final String _ALLOWS_NULL = "nullAllowed";
    static final String _DEFAULT_VALUE = "defaultValue";
    static final String _KEY_TABLE_NAME = "TABLENAME";
    static final String _KEY_NAME = "NAME";
    static final String _KEY_DISPLAY_NAME = "DISPLAYNAME";
    static final String _KEY_WIDTH = "WIDTH";
    static final String _KEY_VISIBLE = "VISIBLE";
    static final String _KEY_DATA_TYPE = "DATATYPE";
    static final String _KEY_ALLOWS_NULL = "NULLALLOWED";
    static final String _KEY_DEFAULT_VALUE = "DEFAULTVALUE";
    private boolean _dirty;
    private ColumnWrapper[] _wrapperColumns;
    private ColumnWrapperFactory _columnFactory;
    private PropertyTable _pTable;
    private JScrollPane _scrollBox;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public ColumnPropertyEditor() {
        this(null);
    }

    public ColumnPropertyEditor(Column[] columnArray) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this._pTable = new PropertyTable();
        this._pTable.getGrid().setGridSelectionManager(GeneralGridSelectionManager.createSingleCellSelectionManager());
        this._pTable.setCustomizer(new Wrap(this._pTable.getCustomizer()));
        this._pTable.addMoveListener((TableMoveListener)new Move());
        this._pTable.addPropertyTableListener(new Sort());
        this._pTable.getRowHeader().setCanResizeItems(false);
        this._scrollBox = new JScrollPane((Component)((Object)this._pTable));
        ((Container)((Object)this)).add("Center", this._scrollBox);
        this.setColumns(columnArray);
    }

    public void setColumns(Column[] columnArray) {
        this.freezeRepaints();
        if (columnArray == null) {
            this._wrapperColumns = null;
        } else {
            this._createColumnWrappers(columnArray);
        }
        this._dirty = true;
        this._pTable.setObjects(this._wrapperColumns);
        this._updateUI();
        this.unfreezeRepaints();
    }

    public Column[] getColumns() {
        Object[] objectArray = this._pTable.getObjects();
        if (objectArray == null) {
            return null;
        }
        Column[] columnArray = new Column[objectArray.length];
        Grid grid = this._pTable.getGrid();
        int n = 0;
        while (n < columnArray.length) {
            int n2 = grid.getRowVisibleIndex(n);
            ColumnWrapper columnWrapper = (ColumnWrapper)objectArray[n];
            columnArray[n2] = columnWrapper.getColumn();
            ++n;
        }
        return columnArray;
    }

    public void setColumnFactory(ColumnWrapperFactory columnWrapperFactory) {
        this._columnFactory = columnWrapperFactory;
        if (this._wrapperColumns != null) {
            this._createColumnWrappers(this.getColumns());
            this._dirty = true;
            this._pTable.setObjects(this._wrapperColumns);
            this._updateUI();
        }
    }

    public ColumnWrapperFactory getColumnFactory() {
        if (this._columnFactory == null) {
            this._columnFactory = ColumnWrapperFactory.getColumnWrapperFactory();
        }
        return this._columnFactory;
    }

    public ColumnWrapper[] getColumnWrappers() {
        Object[] objectArray = this._pTable.getObjects();
        if (objectArray == null) {
            return null;
        }
        ColumnWrapper[] columnWrapperArray = new ColumnWrapper[objectArray.length];
        Grid grid = this._pTable.getGrid();
        int n = 0;
        while (n < columnWrapperArray.length) {
            int n2 = grid.getRowVisibleIndex(n);
            columnWrapperArray[n2] = (ColumnWrapper)objectArray[n];
            ++n;
        }
        return columnWrapperArray;
    }

    public PropertyTableCustomizer getCustomizer() {
        return this._pTable.getCustomizer();
    }

    public void setCustomizer(PropertyTableCustomizer propertyTableCustomizer) {
        if (propertyTableCustomizer == null) {
            propertyTableCustomizer = PropertyTableCustomizer.getPropertyTableCustomizer();
        }
        this._pTable.setCustomizer(new Wrap(propertyTableCustomizer));
    }

    public PropertyTable getPropertyTable() {
        return this._pTable;
    }

    public AccessibleContext getAccessibleContext() {
        if (((JComponent)((Object)this)).accessibleContext == null) {
            ((JComponent)((Object)this)).accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return ((JComponent)((Object)this)).accessibleContext;
    }

    public void addNotify() {
        super.addNotify();
        this._updateUI();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = ((JComponent)((Object)this)).getPreferredSize();
        dimension.height += 5;
        return dimension;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._pTable.setEnabled(bl);
        this._scrollBox.setEnabled(bl);
    }

    public void requestFocus() {
        this._pTable.requestFocus();
    }

    void firePropertyChange() {
        ((Component)((Object)this)).firePropertyChange(PROPERTY_VISUAL_ORDER_CHANGED, null, this.getColumns());
    }

    private void _createColumnWrappers(Column[] columnArray) {
        int n = columnArray == null ? 0 : columnArray.length;
        this._wrapperColumns = n == 0 ? null : new ColumnWrapper[n];
        ColumnWrapperFactory columnWrapperFactory = this.getColumnFactory();
        int n2 = 0;
        while (n2 < n) {
            this._wrapperColumns[n2] = columnWrapperFactory.createColumnWrapper(columnArray[n2]);
            ++n2;
        }
    }

    private void _updateUI() {
        if (!this._dirty) {
            return;
        }
        this._dirty = false;
        this.freezeRepaints();
        Grid grid = this._pTable.getGrid();
        int n = grid.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propertyDescriptor = this._pTable.getPropertyAt(n2);
            String string = propertyDescriptor.getName();
            if (_TABLE_NAME.equals(string)) {
                this._pTable.setColumnVisibleIndex(n2, 0);
            } else if (_NAME.equals(string)) {
                this._pTable.setColumnVisibleIndex(n2, 1);
            } else if (_DISPLAY_NAME.equals(string)) {
                this._pTable.setColumnVisibleIndex(n2, 2);
            } else if (_WIDTH.equals(string)) {
                this._pTable.setColumnVisibleIndex(n2, 3);
            } else if (_VISIBLE.equals(string)) {
                this._pTable.setColumnVisibleIndex(n2, 4);
            }
            ++n2;
        }
        int n3 = grid.getNextVisibleColumn(-1);
        int n4 = grid.getNextVisibleRow(-1);
        if (n3 != -1 && n4 != -1) {
            grid.requestFocus(n3, n4, null);
        }
        this.unfreezeRepaints();
    }

    int getColumnWidth(PropertyDescriptor propertyDescriptor, FontMetrics fontMetrics, Locale locale, int n) {
        int n2 = this._pTable.getPropertyIndex(propertyDescriptor);
        int n3 = 0;
        Grid grid = this._pTable.getGrid();
        Painter painter = grid.getColumnPainter(n2);
        AppearanceManager appearanceManager = grid.getAppearanceManager();
        int n4 = grid.getRowCount();
        int n5 = 0;
        while (n5 < n4) {
            ImmInsets immInsets;
            int n6 = 0;
            PaintContext paintContext = grid.getCellPaintContext(n2, n5);
            Dimension dimension = painter.getPreferredSize(paintContext);
            Appearance appearance = appearanceManager.getCellPaintingAppearance(n2, n5);
            BorderPainter borderPainter = appearance.getBorderPainter();
            if (borderPainter != null) {
                immInsets = borderPainter.getInsets(paintContext);
                n6 += immInsets.left + immInsets.right;
            }
            immInsets = appearance.getInsets();
            dimension.width += (n6 += immInsets.left + immInsets.right);
            if (dimension.width > n3) {
                n3 = dimension.width;
            }
            ++n5;
        }
        Header header = this._pTable.getColumnHeader();
        PaintContext paintContext = header.getItemPaintContext(n2);
        ImmInsets immInsets = header.getItemAppearance(n2).getInsets();
        int n7 = immInsets.left + immInsets.right;
        BorderPainter borderPainter = header.getHeaderItemBorderPainter();
        immInsets = borderPainter.getInsets(paintContext);
        n7 += immInsets.left + immInsets.right;
        Painter painter2 = header.getPainter(n2);
        if ((n7 += painter2.getPreferredSize((PaintContext)paintContext).width) > n3) {
            n3 = n7;
        }
        return n3 + 4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Wrap
    extends PropertyTableCustomizer {
        private PropertyTableCustomizer _toWrap;
        private Painter _dataTypePainter;
        private Painter _defaultValuePainter;
        private CellInputHandler _defaultValueInputHandler;
        private CellInputHandler _dataTypeInputHandler;

        Wrap(PropertyTableCustomizer propertyTableCustomizer) {
            this._toWrap = propertyTableCustomizer;
        }

        public String getDisplayName(PropertyDescriptor propertyDescriptor, Locale locale) {
            String string = propertyDescriptor.getName();
            String string2 = ColumnPropertyEditor._TABLE_NAME.equals(string) ? this._getString(ColumnPropertyEditor._KEY_TABLE_NAME, locale) : (ColumnPropertyEditor._NAME.equals(string) ? this._getString(ColumnPropertyEditor._KEY_NAME, locale) : (ColumnPropertyEditor._DISPLAY_NAME.equals(string) ? this._getString(ColumnPropertyEditor._KEY_DISPLAY_NAME, locale) : (ColumnPropertyEditor._WIDTH.equals(string) ? this._getString(ColumnPropertyEditor._KEY_WIDTH, locale) : (ColumnPropertyEditor._VISIBLE.equals(string) ? this._getString(ColumnPropertyEditor._KEY_VISIBLE, locale) : (ColumnPropertyEditor._DATA_TYPE.equals(string) ? this._getString(ColumnPropertyEditor._KEY_DATA_TYPE, locale) : (ColumnPropertyEditor._ALLOWS_NULL.equals(string) ? this._getString(ColumnPropertyEditor._KEY_ALLOWS_NULL, locale) : (ColumnPropertyEditor._DEFAULT_VALUE.equals(string) ? this._getString(ColumnPropertyEditor._KEY_DEFAULT_VALUE, locale) : this._toWrap.getDisplayName(propertyDescriptor, locale))))))));
            return string2;
        }

        public boolean displayProperty(PropertyDescriptor propertyDescriptor) {
            String string = propertyDescriptor.getName();
            if ("column".equals(string)) {
                return false;
            }
            if (ColumnPropertyEditor._DATA_TYPE.equals(string)) {
                return true;
            }
            return this._toWrap.displayProperty(propertyDescriptor);
        }

        public int getColumnWidth(PropertyDescriptor propertyDescriptor, FontMetrics fontMetrics, Locale locale) {
            int n = this._toWrap.getColumnWidth(propertyDescriptor, fontMetrics, locale);
            return ColumnPropertyEditor.this.getColumnWidth(propertyDescriptor, fontMetrics, locale, n);
        }

        public Painter getPainter(PropertyDescriptor propertyDescriptor) {
            if (ColumnPropertyEditor._DATA_TYPE.equals(propertyDescriptor.getName())) {
                return this._getDataTypePainter();
            }
            if (ColumnPropertyEditor._DEFAULT_VALUE.equals(propertyDescriptor.getName())) {
                return this._getDefaultValuePainter();
            }
            return this._toWrap.getPainter(propertyDescriptor);
        }

        public CellInputHandler getCellInputHandler(PropertyDescriptor propertyDescriptor) {
            String string = propertyDescriptor.getName();
            if (propertyDescriptor.getWriteMethod() != null) {
                if (ColumnPropertyEditor._DATA_TYPE.equals(string)) {
                    return this._getDataTypeInputHandler();
                }
                if (ColumnPropertyEditor._DEFAULT_VALUE.equals(string)) {
                    return this._getDefaultValueInputHandler();
                }
            }
            return this._toWrap.getCellInputHandler(propertyDescriptor);
        }

        public Comparator getComparator(PropertyDescriptor propertyDescriptor) {
            return this._toWrap.getComparator(propertyDescriptor);
        }

        private String _getString(String string, Locale locale) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
            return resourceBundle.getString(string);
        }

        private Painter _getDataTypePainter() {
            if (this._dataTypePainter == null) {
                this._dataTypePainter = new DTP();
            }
            return this._dataTypePainter;
        }

        private Painter _getDefaultValuePainter() {
            if (this._defaultValuePainter == null) {
                this._defaultValuePainter = new DVP();
            }
            return this._defaultValuePainter;
        }

        private CellInputHandler _getDataTypeInputHandler() {
            if (this._dataTypeInputHandler == null) {
                this._dataTypeInputHandler = new DTH();
            }
            return this._dataTypeInputHandler;
        }

        private CellInputHandler _getDefaultValueInputHandler() {
            this._defaultValueInputHandler = new DVH();
            return this._defaultValueInputHandler;
        }

        private class DTH
        extends ComboBoxInputHandler {
            public DTH() {
                this.setItems(_DATA_TYPE_NAMES);
            }

            public void startEdit(Grid grid, int n, int n2, Object object) {
                if (object != null) {
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < _DATA_TYPE_CLASSES.length) {
                        if (_DATA_TYPE_CLASSES[n3] == object) {
                            object = _DATA_TYPE_NAMES[n3];
                            break;
                        }
                        ++n3;
                    }
                }
                super.startEdit(grid, n, n2, object);
            }

            public Object commitEdit(Grid grid, int n, int n2) {
                Object object = super.commitEdit(grid, n, n2);
                boolean bl = false;
                int n3 = 0;
                while (n3 < _DATA_TYPE_NAMES.length) {
                    if (_DATA_TYPE_NAMES[n3].equals(object)) {
                        object = _DATA_TYPE_CLASSES[n3];
                        break;
                    }
                    ++n3;
                }
                return object;
            }
        }

        private class DVH
        extends ProxyInputHandler {
            private Vector _handlers = new Vector(1);
            private Vector _types = new Vector(1);
            private CellInputHandler _currentHandler;

            private DVH() {
            }

            public CellInputHandler getCellInputHandler(Grid grid, int n, int n2) {
                int n3 = grid.getRowCount();
                if (this._handlers.size() != n3) {
                    this._handlers.setSize(n3);
                    this._types.setSize(n3);
                }
                Object[] objectArray = ColumnPropertyEditor.this.getPropertyTable().getObjects();
                ColumnWrapper columnWrapper = (ColumnWrapper)objectArray[n2];
                Class clazz = columnWrapper.getColumn().getDataType();
                if (this._handlers.elementAt(n2) == null || !clazz.equals(this._types.elementAt(n2))) {
                    this._handlers.setElementAt(Wrap.this._toWrap.getCellInputHandler(clazz), n2);
                    this._types.setElementAt(clazz, n2);
                }
                return (CellInputHandler)this._handlers.elementAt(n2);
            }
        }

        private class DVP
        extends ProxyPainter {
            private DVP() {
            }

            public Painter getPainter(Grid grid, int n, int n2) {
                Object[] objectArray = ColumnPropertyEditor.this.getPropertyTable().getObjects();
                ColumnWrapper columnWrapper = (ColumnWrapper)objectArray[n2];
                Class clazz = columnWrapper.getColumn().getDataType();
                return Wrap.this._toWrap.getPainter(clazz);
            }
        }

        private class DTP
        extends TruncatingTextPainter {
            private DTP() {
            }

            protected String getStringData(PaintContext paintContext) {
                String string = super.getStringData(paintContext);
                return string == null ? string : string.substring(string.lastIndexOf(".") + 1);
            }
        }
    }

    private class Sort
    extends PropertyTableAdapter {
        private Sort() {
        }

        public void columnSorted(PropertyTableEvent propertyTableEvent) {
            ColumnPropertyEditor.this.firePropertyChange();
        }
    }

    private class Move
    extends TableMoveAdapter {
        private Move() {
        }

        public void rowMoved(TableEvent tableEvent) {
            ColumnPropertyEditor.this.firePropertyChange();
        }
    }
}

