/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform.normalize;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraTransformationImpl;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeType;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraNormalizeTransformImpl
extends OraTransformationImpl
implements OraNormalizeTransform {
    public static final String NORMALIZE_XFORM = "NORMALIZE";
    private OraNormalizeType m_normalizeType = OraNormalizeType.systemDefault;
    private Integer m_roundingNumber = new Integer(6);
    private String m_inputNormalizationDefinitionTable = null;
    private String m_normalizationDefinitionTable = null;
    private String m_normalizationDefinitionSchema = null;
    private static final String NORM_DEFINITION_SUFFIX = "_NORM";
    private static final String CREATE_NORM_LIN = "DBMS_DATA_MINING_TRANSFORM.CREATE_NORM_LIN";
    private static final String INSERT_NORM_LIN_ZSCORE = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_NORM_LIN_ZSCORE ( <norm_table_name>,   <data_table_name>,   <exclude_list>,   <round_num>,   <norm_schema_name>,   <data_schema_name>); END;";
    private static final String INSERT_NORM_LIN_MINMAX = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_NORM_LIN_MINMAX ( <norm_table_name>,   <data_table_name>,   <exclude_list>,   <round_num>,   <norm_schema_name>,   <data_schema_name>); END;";
    private static final String INSERT_NORM_LIN_SCALE = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_NORM_LIN_SCALE ( <norm_table_name>,   <data_table_name>,   <exclude_list>,   <round_num>,   <norm_schema_name>,   <data_schema_name>); END;";
    private static final String QRY_DECODE_NORM_TABLE = "SELECT NVL2( att,  col || '.' || att, col ) col, shift, scale  FROM {0} ";
    private static final String QRY_DECODE_NORM_TABLE_102 = " SELECT col, shift, scale  FROM {0} ";
    private static final String IN_NORM_TYPE = "IN_NORM_TYPE";
    private static final String IN_ROUNDING_NUMBER = "IN_ROUNDING_NUMBER";
    private static final String NORM_DEF_TABLE = "NORM_DEF_TABLE";
    private static final String NORM_DEF_SCHEMA = "NORM_DEF_SCHEMA";

    public OraNormalizeTransformImpl(OraConnection dmeComm, OraFactory parentFactory, boolean isOutputAsView, OraNormalizeType normalizeType, Integer roundingNumber, String inputNormalizationDefinitionTable) throws JDMException {
        super(dmeComm, parentFactory, isOutputAsView);
        this.m_normalizeType = normalizeType;
        this.m_xformProperties.put(IN_NORM_TYPE, this.m_normalizeType.name());
        if (roundingNumber != null) {
            this.m_roundingNumber = roundingNumber;
            this.m_xformProperties.put(IN_ROUNDING_NUMBER, this.m_roundingNumber);
        }
        this.m_inputNormalizationDefinitionTable = inputNormalizationDefinitionTable;
        if (this.m_inputNormalizationDefinitionTable != null) {
            OraDataURI normDefTabURI = new OraDataURI(this.m_inputNormalizationDefinitionTable);
            this.m_normalizationDefinitionTable = normDefTabURI.getTableName();
            this.m_normalizationDefinitionSchema = normDefTabURI.getSchemaName();
            this.m_xformProperties.put(NORM_DEF_TABLE, this.m_normalizationDefinitionTable);
            if (this.m_normalizationDefinitionSchema != null) {
                this.m_xformProperties.put(NORM_DEF_SCHEMA, this.m_normalizationDefinitionSchema);
            }
        }
    }

    public OraNormalizeType getNormalizeType() {
        return this.m_normalizeType;
    }

    public String getNormalizationDefinitionTable() {
        return this.m_normalizationDefinitionTable;
    }

    public int getRoundingNumber() {
        return this.m_roundingNumber;
    }

    public Double getShift(String attributeName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        Connection dbConn = this.getDatabaseConnection();
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            String qry = "select SHIFT from " + this.m_normalizationDefinitionTable + " " + "where COL = ?";
            pStmt = dbConn.prepareCall(qry);
            pStmt.setString(1, attributeName.toUpperCase());
            rs = pStmt.executeQuery();
            BigDecimal shift = null;
            if (rs.next()) {
                shift = rs.getBigDecimal("SHIFT");
            }
            if (shift != null) {
                Double d = new Double(shift.doubleValue());
                return d;
            }
            Double d = null;
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraNormalizeTransformImpl.getShift(attributeName) method." + sqlExp.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    public Double getScale(String attributeName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        Connection dbConn = this.getDatabaseConnection();
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            String qry = "select SCALE from " + this.m_normalizationDefinitionTable + " " + "where COL = ?";
            pStmt = dbConn.prepareCall(qry);
            pStmt.setString(1, attributeName.toUpperCase());
            rs = pStmt.executeQuery();
            BigDecimal scale = null;
            if (rs.next()) {
                scale = rs.getBigDecimal("SCALE");
            }
            if (scale != null) {
                Double d = new Double(scale.doubleValue());
                return d;
            }
            Double d = null;
            return d;
        }
        catch (SQLException sqlExp) {
            throw new JDMException(1, "Failed in OraNormalizeTransformImpl.getScale(attributeName) method." + sqlExp.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqlExp1) {}
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp1) {}
        }
    }

    public String getSettingsTable1() {
        return this.m_normalizationDefinitionTable;
    }

    public String getSettingsTable2() {
        return null;
    }

    String getSettingsTable1Property() {
        return NORM_DEF_TABLE;
    }

    public String getType() {
        return NORMALIZE_XFORM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTransformationTable(OraConnection dmeConn, String taskName) throws SQLException {
        Statement cStmt = null;
        try {
            if (this.m_inputNormalizationDefinitionTable != null) {
                return;
            }
            this.m_normalizationDefinitionTable = taskName.startsWith("\"") && taskName.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(taskName) + NORM_DEFINITION_SUFFIX + "\"" : taskName + NORM_DEFINITION_SUFFIX;
            String norm_table_name = this.m_normalizationDefinitionTable;
            String norm_schema_name = null;
            if (this.m_transformationOutputData != null) {
                norm_schema_name = this.m_transformationOutputData.getSchemaName();
            }
            OraSQLUtils.executeCallableStatement(dmeConn.getDatabaseConnection(), CREATE_NORM_LIN, new String[]{"norm_table_name", "norm_schema_name"}, new Object[]{norm_table_name, norm_schema_name}, new int[]{12, 12}, null, dmeConn.getLogger());
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTransformationTables(OraConnection dmeConn, String name) throws SQLException {
        if (this.m_inputNormalizationDefinitionTable != null) {
            return;
        }
        if (this.m_normalizationDefinitionTable == null) {
            return;
        }
        String insertSql = null;
        Statement cStmt = null;
        try {
            String norm_table_name = OraStringUtils.getReplacedString(this.m_normalizationDefinitionTable, "'", "''");
            String[] exclude_list = this.getExcludeColumnList();
            int round_num = this.getRoundingNumber();
            String norm_schema_name = null;
            String data_schema_name = null;
            if (this.m_transformationOutputData != null) {
                norm_schema_name = this.m_transformationOutputData.getSchemaName();
            }
            if (this.m_transformationInputData != null) {
                data_schema_name = this.m_transformationInputData.getSchemaName();
            }
            insertSql = this.m_normalizeType.equals((Object)OraNormalizeType.z_Score) ? INSERT_NORM_LIN_ZSCORE : (this.m_normalizeType.equals((Object)OraNormalizeType.scale) ? INSERT_NORM_LIN_SCALE : INSERT_NORM_LIN_MINMAX);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<norm_table_name>", "'" + norm_table_name + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_table_name>", "'" + this.getProcessedTableName() + "'");
            insertSql = this.getReplacedExcludedList(insertSql);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<round_num>", round_num + "");
            insertSql = norm_schema_name == null ? OraStringUtils.getReplacedString(insertSql, "<norm_schema_name>", "null") : OraStringUtils.getReplacedString(insertSql, "<norm_schema_name>", "'" + this.getProcessedSchemaName(norm_schema_name) + "'");
            insertSql = data_schema_name == null ? OraStringUtils.getReplacedString(insertSql, "<data_schema_name>", "null") : OraStringUtils.getReplacedString(insertSql, "<data_schema_name>", "'" + this.getProcessedSchemaName(data_schema_name) + "'");
            OraSQLUtils.execSql(dmeConn.getDatabaseConnection(), insertSql, dmeConn.getLogger());
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    protected String getStack() {
        if (this.m_normalizationDefinitionTable == null) {
            return null;
        }
        StringBuffer stack = new StringBuffer("BEGIN ").append("DBMS_DATA_MINING_TRANSFORM.STACK_NORM_LIN( NORM_TABLE_NAME => '" + this.m_normalizationDefinitionTable + "', TRANSFORM_LIST => v_xform_stack" + (this.m_normalizationDefinitionSchema == null ? "" : ", NORM_SCHEMA_NAME => '" + this.m_normalizationDefinitionSchema + "'") + " );  END;");
        return stack.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanXformSpecificObjects(OraConnection dmConn, String taskName) {
        if (this.m_inputNormalizationDefinitionTable == null) {
            OraConnection dmeConn = dmConn;
            Connection dbConn = dmeConn.getDatabaseConnection();
            Statement pStmt = null;
            try {
                String dropSQL = null;
                if (taskName.startsWith("\"") && taskName.endsWith("\"")) {
                    taskName = OraStringUtils.trimDoubleQuotes(taskName);
                }
                dropSQL = this.m_transformationOutputData.getSchemaName() == null ? "\"" + taskName + NORM_DEFINITION_SUFFIX + "\"" : "\"" + this.m_transformationOutputData.getSchemaName() + "\"." + "\"" + taskName + NORM_DEFINITION_SUFFIX + "\"";
                pStmt = dbConn.prepareStatement("DROP TABLE " + dropSQL);
                pStmt.execute();
            }
            catch (Exception e) {
            }
            finally {
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (Exception anyExp) {}
                }
            }
        }
    }

    public static String getUnnormalizeClause(String normTable, boolean is102) {
        String qry = "";
        if (normTable != null) {
            qry = is102 ? qry + MessageFormat.format(QRY_DECODE_NORM_TABLE_102, normTable) : qry + MessageFormat.format(QRY_DECODE_NORM_TABLE.replaceAll("'", "''"), normTable);
        }
        return qry;
    }
}

