/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform.clipping;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraTransformationImpl;
import oracle.dmt.jdm.transform.clipping.OraClippingTransform;
import oracle.dmt.jdm.transform.clipping.OraClippingType;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraClippingTransformImpl
extends OraTransformationImpl
implements OraClippingTransform {
    private static final String CLIPPING_XFORM = "CLIPPING";
    protected boolean m_bUserSuppliedTable = false;
    private static final String INSERT_CLIP_TRIM = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_CLIP_TRIM_TAIL ( <clip_table_name>,   <data_table_name>,   <tail_frac>,   <exclude_list>,   <clip_schema_name>,   <data_schema_name>); END;";
    private static final String INSERT_CLIP_WINSORIZE = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_CLIP_WINSOR_TAIL ( <clip_table_name>,   <data_table_name>,   <tail_frac>,   <exclude_list>,   <clip_schema_name>,   <data_schema_name>); END;";
    private static final String CLIP_DEFINITION_SUFFIX = "_CLIP";
    private OraClippingType m_clippingType = OraClippingType.trim;
    private String m_clippingTable = null;
    private String m_clippingSchema = null;
    private double m_tailFraction = 0.025;
    private static final String IN_CLIP_TYPE = "IN_CLIP_TYPE";
    private static final String IN_TAIL_FRACTION = "IN_TAIL_FRACTION";
    private static final String CLIP_DEF_TABLE = "CLIP_DEF_TABLE";
    private static final String CLIP_DEF_SCHEMA = "CLIP_DEF_SCHEMA";

    public void setTailFraction(double tail) {
        this.m_tailFraction = tail;
    }

    public String getType() {
        return CLIPPING_XFORM;
    }

    public OraClippingTransformImpl(OraConnection dmeConn, OraFactory parentFactory, boolean isOutputAsView) throws JDMException {
        super(dmeConn, parentFactory, isOutputAsView);
    }

    public OraClippingTransformImpl(OraConnection dmeConn, OraFactory parentFactory, boolean isOutputAsView, String inputClippingTable) throws JDMException {
        super(dmeConn, parentFactory, isOutputAsView);
        this.m_bUserSuppliedTable = true;
        OraDataURI clippingURI = new OraDataURI(inputClippingTable);
        this.m_clippingTable = clippingURI.getTableName();
        this.m_clippingSchema = clippingURI.getSchemaName();
        this.m_xformProperties.put(CLIP_DEF_TABLE, this.m_clippingTable);
        if (this.m_clippingSchema != null) {
            this.m_xformProperties.put(CLIP_DEF_SCHEMA, this.m_clippingSchema);
        }
    }

    public OraClippingTransformImpl(OraConnection dmeConn, OraFactory parentFactory, boolean isOutputAsView, OraClippingType clippingType, double tailFraction) throws JDMException {
        super(dmeConn, parentFactory, isOutputAsView);
        this.m_clippingType = clippingType;
        this.m_tailFraction = tailFraction;
        this.m_xformProperties.put(IN_CLIP_TYPE, this.m_clippingType.name());
        this.m_xformProperties.put(IN_TAIL_FRACTION, new Double(this.m_tailFraction));
    }

    public OraClippingType getClippingType() {
        return this.m_clippingType;
    }

    public void setClippingType(OraClippingType type) {
        this.m_clippingType = type;
        this.m_xformProperties.put(IN_CLIP_TYPE, this.m_clippingType.name());
    }

    public String getClippingTable() {
        return this.m_clippingTable;
    }

    public String getSettingsTable1() {
        return this.getClippingTable();
    }

    public String getSettingsTable2() {
        return null;
    }

    String getSettingsTable1Property() {
        return CLIP_DEF_TABLE;
    }

    protected void cleanXformSpecificObjects(OraConnection dmeConn, String name) {
        if (!this.m_bUserSuppliedTable) {
            this.dropTable(name + CLIP_DEFINITION_SUFFIX);
        }
    }

    protected void createTransformationTable(OraConnection dmeConn, String taskName) throws SQLException {
        if (this.m_bUserSuppliedTable) {
            return;
        }
        this.m_clippingTable = taskName + CLIP_DEFINITION_SUFFIX;
        this.createClipDefinitionTable(dmeConn);
    }

    private void createClipDefinitionTable(OraConnection dmeConn) throws SQLException {
        String sqlStr = "DBMS_DATA_MINING_TRANSFORM.CREATE_CLIP";
        String[] paramNames = new String[]{"clip_table_name", "clip_schema_name"};
        Object[] paramValues = new Object[]{this.m_clippingTable, this.m_transformationOutputData.getSchemaName()};
        int[] sqlTypes = new int[]{12, 12};
        CallableStatement cStmt = OraSQLUtils.createCallableStatement(this.getConnection().getDatabaseConnection(), sqlStr, paramNames, paramValues, sqlTypes, null, this.getLogger());
        cStmt.execute();
    }

    protected void populateTransformationTables(OraConnection dmeConn, String taskName) throws SQLException {
        if (this.m_bUserSuppliedTable) {
            return;
        }
        Logger logger = dmeConn.getLogger();
        logger.setLevel(Level.FINEST);
        if (this.m_clippingType.equals((Object)OraClippingType.trim)) {
            this.insertClip(INSERT_CLIP_TRIM);
        } else if (this.m_clippingType.equals((Object)OraClippingType.winsorize)) {
            this.insertClip(INSERT_CLIP_WINSORIZE);
        }
    }

    protected String getStack() {
        if (this.m_clippingTable == null) {
            return null;
        }
        StringBuffer stack = new StringBuffer("BEGIN ").append("DBMS_DATA_MINING_TRANSFORM.STACK_CLIP( CLIP_TABLE_NAME => '" + this.m_clippingTable + "', TRANSFORM_LIST => v_xform_stack" + (this.m_clippingSchema == null ? "" : ", CLIP_SCHEMA_NAME => '" + this.m_clippingSchema + "'") + " ); END; ");
        return null;
    }

    private void insertClip(String insertSql) throws SQLException {
        Statement cStmt = null;
        try {
            insertSql = OraStringUtils.getReplacedString(insertSql, "<clip_table_name>", "'" + this.m_clippingTable + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_table_name>", "'" + this.getProcessedTableName() + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<tail_frac>", this.m_tailFraction + "");
            insertSql = this.getReplacedExcludedList(insertSql);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<clip_schema_name>", this.m_transformationOutputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationOutputData.getSchemaName()) + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_schema_name>", this.m_transformationInputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationInputData.getSchemaName()) + "'");
            OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), insertSql, this.getLogger());
        }
        catch (SQLException e) {
            this.logTrace("Failed Operation: OraClippingTransformImpl.insertClip: colName: ", e);
            throw e;
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }
}

