/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform.binning;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalDataSet;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.data.OraPhysicalDataSetFactory;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraTransformationImpl;
import oracle.dmt.jdm.transform.binning.OraAttributeBins;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.binning.OraCategoricalAttributeBins;
import oracle.dmt.jdm.transform.binning.OraCategoricalAttributeBinsImpl;
import oracle.dmt.jdm.transform.binning.OraCategoricalBin;
import oracle.dmt.jdm.transform.binning.OraCategoricalBinImpl;
import oracle.dmt.jdm.transform.binning.OraCategoricalBinningType;
import oracle.dmt.jdm.transform.binning.OraNumericalAttributeBins;
import oracle.dmt.jdm.transform.binning.OraNumericalAttributeBinsImpl;
import oracle.dmt.jdm.transform.binning.OraNumericalBin;
import oracle.dmt.jdm.transform.binning.OraNumericalBinImpl;
import oracle.dmt.jdm.transform.binning.OraNumericalBinningType;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;
import oracle.jdbc.OraclePreparedStatement;

public class OraBinningTransformImpl
extends OraTransformationImpl
implements OraBinningTransform {
    private static final int BATCH_SIZE = 100;
    private static final String BINNING_XFORM = "BINNING";
    private static final int MAX_SAMPLE_COUNT = 50000;
    private static final double BIN_FACTOR = 0.9;
    private static final double MAX_NUMBER_OF_BINS = 100.0;
    private static final int ATTRIBUTE_SCAN_SIZE = 300;
    private static String TEMPLATE_START = "MAX({0}) Max{1} , MIN({0}) Min{1}";
    private static String TEMPLATE_START_AUTO_BIN = "COUNT({0}) COUNT{1} , MAX({0}) Max{1} , MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}";
    private static String QTILE_BINNING = "SELECT MIN(val), MAX(val) FROM (SELECT {0} val,NTILE(TO_CHAR(ABS({1}))) OVER(ORDER BY {0} ASC) qtile FROM {2} WHERE {0} IS NOT NULL) GROUP BY qtile ORDER BY qtile ASC";
    static final String TOPN_STATS = "SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}";
    private static final String INSERT_AUTOBIN_NUM_EQWIDTH = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_AUTOBIN_NUM_EQWIDTH ( <bin_table_name>,   <data_table_name>,   <bin_num>,   <max_bin_num>,   <exclude_list>,   <round_num>,   <sample_size>,   <bin_schema_name>,   <data_schema_name>); END;";
    private static final String INSERT_BIN_NUM_EQWIDTH = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_BIN_NUM_EQWIDTH ( <bin_table_name>,   <data_table_name>,   <bin_num>,   <exclude_list>,   <round_num>,   <bin_schema_name>,   <data_schema_name>); END;";
    private static final String INSERT_BIN_NUM_QTILE = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_BIN_NUM_QTILE ( <bin_table_name>,   <data_table_name>,   <bin_num>,   <exclude_list>,   <bin_schema_name>,   <data_schema_name>); END;";
    private static final String INSERT_BIN_CAT_FREQ = "BEGIN DBMS_DATA_MINING_TRANSFORM.INSERT_BIN_CAT_FREQ ( <bin_table_name>,   <data_table_name>,   <bin_num>,   <exclude_list>,   <default_num>,   <bin_support>,   <bin_schema_name>,   <data_schema_name>); END;";
    private static final String UPDATE_BIN_NUM_EQWIDTH = "UPDATE <bin_table_name> o SET bin = (SELECT Decode(bin,'1','[','(') || lv || ',' || val || ']'    FROM ( SELECT col, bin,         last_value(val) over (                               PARTITION BY col                               ORDER BY val                              rows BETWEEN unbounded preceding                              AND 1 preceding) lv,          val          from  <bin_table_name> ) b    WHERE b.col = o.col AND b.val = o.val)    WHERE bin IS NOT null";
    private static final String INSERT_CUSTOM_BINS = "INSERT INTO {0} (COL, VAL, BIN) values (?, ?, ?)";
    private static final String DELETE_CUSTOM_BINS = "DELETE FROM {0} WHERE COL=?";
    private static final String NUM_BIN_DEFINITION_SUFFIX = "_NUM";
    private static final String CAT_BIN_DEFINITION_SUFFIX = "_CAT";
    private String m_numBinTable = null;
    private String m_numBinSchema = null;
    private String m_catBinTable = null;
    private String m_catBinSchema = null;
    private OraCategoricalBinningType m_catBinningType = OraCategoricalBinningType.systemDefault;
    private OraNumericalBinningType m_numBinningType = OraNumericalBinningType.systemDefault;
    private int m_numBinNumber = 10;
    private int m_maxnumBinNumber = 100;
    private int m_catBinNumber = 9;
    protected boolean m_bUserSuppliedNumBinDefTable = false;
    protected boolean m_bUserSuppliedCatBinDefTable = false;
    private String m_targetColumnName = null;
    protected OraAttributeBins[] m_customBins;
    private boolean m_bLiteralFlag = false;
    private int m_nRound = 6;
    private int m_nSampleSize = 50000;
    private int m_numberDefaults = 2;
    private Double m_binSupport = null;
    private Integer m_maxBinNum = null;
    private static final String QRY_DECODE_NUM_BIN_TABLE = " SELECT col, bin,Decode(bin,'1','[','(') || lv || ',' || val || ']' label FROM (SELECT col, bin, last_value(val) over ( PARTITION BY col ORDER BY val rows BETWEEN unbounded preceding AND 1 preceding) lv, val FROM ";
    private static final String QRY_DECODE_CAT_BIN_TABLE = " SELECT col, bin, val label  FROM {0} ";
    protected static final String IN_CAT_BIN_NUMBER = "IN_CAT_BIN_NUMBER";
    protected static final String IN_NUM_BIN_NUMBER = "IN_NUM_BIN_NUMBER";
    protected static final String IN_LITERAL_FLAG = "IN_LITERAL_FLAG";
    protected static final String IN_NUM_BIN_TYPE = "IN_NUM_BIN_TYPE";
    protected static final String IN_CAT_BIN_TYPE = "IN_CAT_BIN_TYPE";
    protected static final String IN_NUM_BIN_ROUND = "IN_NUM_BIN_ROUND";
    protected static final String NUM_BIN_TABLE = "NUM_BIN_TABLE";
    protected static final String CAT_BIN_TABLE = "CAT_BIN_TABLE";
    protected static final String NUM_BIN_SCHEMA = "NUM_BIN_SCHEMA";
    protected static final String CAT_BIN_SCHEMA = "CAT_BIN_SCHEMA";
    protected static final String IN_TARGET_COLUMN_NAME = "IN_TARGET_COLUMN_NAME";
    protected static final String IN_BIN_SUPPORT = "IN_BIN_SUPPORT";
    protected static final String IN_MAX_BINS = "IN_MAX_BINS";

    public void setLiteralFlag(boolean bLiteralFlag) {
        this.m_bLiteralFlag = bLiteralFlag;
        this.m_xformProperties.put(IN_LITERAL_FLAG, bLiteralFlag ? "Y" : "N");
    }

    public boolean getLiteralFlag() {
        return this.m_bLiteralFlag;
    }

    public void setTargetAttributeName(String targetAttributename) throws JDMException {
        if (OraCategoricalBinningType.supervised.equals((Object)this.m_catBinningType) || OraNumericalBinningType.supervised.equals((Object)this.m_numBinningType)) {
            this.m_targetColumnName = this.getValidationHandler().validateTableColumnName(targetAttributename, "targetAttributename");
            this.m_xformProperties.put(IN_TARGET_COLUMN_NAME, this.m_targetColumnName);
        } else {
            this.unsupported("targetAttributename");
        }
    }

    public String getTargetAttributeName() {
        return this.m_targetColumnName;
    }

    public String getType() {
        return BINNING_XFORM;
    }

    public void setRound(int round) {
        this.m_nRound = round;
        this.m_xformProperties.put(IN_NUM_BIN_ROUND, new Integer(this.m_nRound));
    }

    public int getRound() {
        return this.m_nRound;
    }

    public void setSampleSize(int nSampleSize) {
        this.m_nSampleSize = nSampleSize;
    }

    public int getSampleSize() {
        return this.m_nSampleSize;
    }

    public void setNumberDefaults(int numberDefaults) {
        this.m_numberDefaults = numberDefaults;
    }

    public int getNumberDefaults() {
        return this.m_numberDefaults;
    }

    public void setBinSupport(double binSupport) {
        this.m_binSupport = new Double(binSupport);
        this.m_xformProperties.put(IN_BIN_SUPPORT, this.m_binSupport);
    }

    public Double getBinSupport() {
        return this.m_binSupport;
    }

    public void setMaximumNumberOfBins(Integer maxBins) {
        this.m_maxBinNum = maxBins;
        this.m_xformProperties.put(IN_MAX_BINS, this.m_maxBinNum);
    }

    public Integer getMaximumNumberOfBins() {
        return this.m_maxBinNum;
    }

    public OraBinningTransformImpl(OraConnection dmeConn, OraFactory parentFactory, String numBinTable, String catBinTable, boolean isOutputAsView) throws JDMException {
        super(dmeConn, parentFactory, isOutputAsView);
        this.setupDefaults();
        if (numBinTable != null) {
            this.m_bUserSuppliedNumBinDefTable = true;
            OraDataURI numBinTableURI = new OraDataURI(numBinTable);
            this.m_numBinTable = numBinTableURI.getTableName();
            this.m_xformProperties.put(NUM_BIN_TABLE, this.m_numBinTable);
            this.m_numBinSchema = numBinTableURI.getSchemaName();
            if (this.m_numBinSchema != null) {
                this.m_xformProperties.put(NUM_BIN_SCHEMA, this.m_numBinTable);
            }
        }
        if (catBinTable != null) {
            this.m_bUserSuppliedCatBinDefTable = true;
            OraDataURI catBinTableURI = new OraDataURI(catBinTable);
            this.m_catBinTable = catBinTableURI.getTableName();
            this.m_xformProperties.put(CAT_BIN_TABLE, this.m_catBinTable);
            this.m_catBinSchema = catBinTableURI.getSchemaName();
            if (this.m_catBinSchema != null) {
                this.m_xformProperties.put(CAT_BIN_SCHEMA, this.m_catBinSchema);
            }
        }
    }

    public OraBinningTransformImpl(OraConnection dmeConn, OraFactory parentFactory, boolean isOutputAsView) throws JDMException {
        super(dmeConn, parentFactory, isOutputAsView);
        this.setupDefaults();
    }

    public OraBinningTransformImpl(OraConnection dmeConn, OraFactory parentFactory, Integer numberOfNumericalBins, Integer numberOfCategoricalBins, OraCategoricalBinningType catBinType, OraNumericalBinningType numBinType, String[] excludeAttributes) throws JDMException {
        super(dmeConn, parentFactory, false);
        this.setupDefaults();
        this.m_bUserSuppliedNumBinDefTable = false;
        this.m_bUserSuppliedCatBinDefTable = false;
        if (numberOfNumericalBins != null) {
            this.m_numBinNumber = numberOfNumericalBins;
        }
        if (numberOfCategoricalBins != null) {
            this.m_catBinNumber = numberOfCategoricalBins;
            this.m_xformProperties.put(IN_CAT_BIN_NUMBER, numberOfCategoricalBins);
        }
        if (catBinType != null) {
            this.m_catBinningType = catBinType;
        }
        if (numBinType != null) {
            this.m_numBinningType = numBinType;
        }
        this.setExcludeColumnList(excludeAttributes);
        this.m_xformProperties.put(IN_NUM_BIN_NUMBER, new Integer(this.m_numBinNumber));
        this.m_xformProperties.put(IN_CAT_BIN_NUMBER, new Integer(this.m_catBinNumber));
        this.m_xformProperties.put(IN_NUM_BIN_TYPE, this.m_numBinningType.name());
        this.m_xformProperties.put(IN_CAT_BIN_TYPE, this.m_catBinningType.name());
    }

    public OraBinningTransformImpl(OraConnection dmeConn, OraFactory parentFactory) throws JDMException {
        super(dmeConn, parentFactory, false);
        this.setupDefaults();
    }

    public OraBinningTransformImpl(OraConnection dmeConn, OraFactory parentFactory, Integer[] numberOfCategoricalBins, OraCategoricalBinningType[] catBinType, String[] categoricAttributes) throws JDMException {
        super(dmeConn, parentFactory, false);
        this.setupDefaults();
    }

    public OraBinningTransformImpl(OraConnection dmeConn, OraFactory parentFactory, OraAttributeBins[] customBins, boolean isOutputAsView) throws JDMException {
        super(dmeConn, parentFactory, isOutputAsView);
        this.m_customBins = customBins;
        this.setupDefaults();
    }

    public OraBinningTransformImpl(OraConnection dmeConn, OraFactory parentFactory, String numBinTable, String catBinTable, OraAttributeBins[] customBins, boolean isOutputAsView) throws JDMException {
        super(dmeConn, parentFactory, isOutputAsView);
        this.setupDefaults();
        if (numBinTable != null) {
            this.m_bUserSuppliedNumBinDefTable = true;
            OraDataURI numBinTableURI = new OraDataURI(numBinTable);
            this.m_numBinTable = numBinTableURI.getTableName();
            this.m_xformProperties.put(NUM_BIN_TABLE, this.m_numBinTable);
            this.m_numBinSchema = numBinTableURI.getSchemaName();
            if (this.m_numBinSchema != null) {
                this.m_xformProperties.put(NUM_BIN_SCHEMA, this.m_numBinTable);
            }
        }
        if (catBinTable != null) {
            this.m_bUserSuppliedCatBinDefTable = true;
            OraDataURI catBinTableURI = new OraDataURI(catBinTable);
            this.m_catBinTable = catBinTableURI.getTableName();
            this.m_xformProperties.put(CAT_BIN_TABLE, this.m_catBinTable);
            this.m_catBinSchema = catBinTableURI.getSchemaName();
            if (this.m_catBinSchema != null) {
                this.m_xformProperties.put(CAT_BIN_SCHEMA, this.m_catBinSchema);
            }
        }
        this.m_customBins = customBins;
    }

    private void setupDefaults() {
        this.m_xformProperties.put(IN_NUM_BIN_NUMBER, new Integer(this.m_numBinNumber));
        this.m_xformProperties.put(IN_CAT_BIN_NUMBER, new Integer(this.m_catBinNumber));
        this.m_xformProperties.put(IN_NUM_BIN_TYPE, OraNumericalBinningType.quantile.name());
        this.m_xformProperties.put(IN_LITERAL_FLAG, this.m_bLiteralFlag ? "Y" : "N");
    }

    protected void populateTransformationTables(OraConnection dmeConn, String name) throws SQLException {
        if (!this.m_bUserSuppliedNumBinDefTable) {
            if (this.m_numBinningType.equals((Object)OraNumericalBinningType.systemDefault) || this.m_numBinningType.equals((Object)OraNumericalBinningType.quantile)) {
                this.insertBinNumQtile();
                if (!this.m_bLiteralFlag) {
                    this.updateBinColumnsWithLabels();
                }
            } else if (this.m_numBinningType.equals((Object)OraNumericalBinningType.equi_width)) {
                this.insertBinNumEqwidth();
                if (!this.m_bLiteralFlag) {
                    this.updateBinColumnsWithLabels();
                }
            } else if (this.m_numBinningType.equals((Object)OraNumericalBinningType.auto_equi_width)) {
                this.insertBinNumAutoEqwidth();
                if (!this.m_bLiteralFlag) {
                    this.updateBinColumnsWithLabels();
                }
            } else if (this.m_numBinningType.equals((Object)OraNumericalBinningType.custom)) {
                this.insertCustomNumericData();
                if (!this.m_bLiteralFlag) {
                    this.updateBinColumnsWithLabels();
                }
            }
        } else if (this.m_numBinningType.equals((Object)OraNumericalBinningType.custom)) {
            this.removeNumBinDefinitions();
            this.insertCustomNumericData();
        }
        if (!this.m_bUserSuppliedCatBinDefTable) {
            if (this.m_catBinningType.equals((Object)OraCategoricalBinningType.top_n)) {
                this.insertBinCatFreq();
            } else if (this.m_catBinningType.equals((Object)OraCategoricalBinningType.custom)) {
                this.insertCustomCategoricData();
            }
        } else if (this.m_catBinningType.equals((Object)OraCategoricalBinningType.custom)) {
            this.removeCatBinDefinitions();
            this.insertCustomCategoricData();
        }
    }

    protected String getStack() {
        if (this.m_catBinTable == null && this.m_numBinTable == null) {
            return null;
        }
        StringBuffer stack = new StringBuffer("BEGIN ").append(this.m_catBinTable == null ? "" : "DBMS_DATA_MINING_TRANSFORM.STACK_BIN_CAT( BIN_TABLE_NAME => '" + this.m_catBinTable + "', TRANSFORM_LIST => v_xform_stack" + (this.m_bLiteralFlag ? ", LITERAL_FLAG => TRUE" : "") + (this.m_catBinSchema == null ? "" : ", BIN_SCHEMA_NAME => '" + this.m_catBinSchema + "'") + " ); ").append(this.m_numBinTable == null ? "" : "DBMS_DATA_MINING_TRANSFORM.STACK_BIN_NUM( BIN_TABLE_NAME => '" + this.m_numBinTable + "', TRANSFORM_LIST => v_xform_stack" + (this.m_bLiteralFlag ? ", LITERAL_FLAG => TRUE" : "") + (this.m_numBinSchema == null ? "" : ", BIN_SCHEMA_NAME => '" + this.m_numBinSchema + "'") + " ); ").append(" END;");
        return stack.toString();
    }

    protected void createTransformationTable(OraConnection dmeConn, String taskName) throws SQLException {
        SQLException exceptionStack = null;
        try {
            if (!this.m_bUserSuppliedNumBinDefTable) {
                this.m_numBinTable = taskName.startsWith("\"") && taskName.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(taskName) + NUM_BIN_DEFINITION_SUFFIX + "\"" : taskName + NUM_BIN_DEFINITION_SUFFIX;
                this.createNumericalBinDefinitionTable(dmeConn);
            }
        }
        catch (SQLException exp1) {
            exceptionStack = exp1;
        }
        try {
            if (!this.m_bUserSuppliedCatBinDefTable) {
                this.m_catBinTable = taskName.startsWith("\"") && taskName.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(taskName) + CAT_BIN_DEFINITION_SUFFIX + "\"" : taskName + CAT_BIN_DEFINITION_SUFFIX;
                this.createCategoricalBinDefinitionTable(dmeConn);
            }
        }
        catch (SQLException exp2) {
            if (exceptionStack == null) {
                throw exp2;
            }
            exceptionStack.setNextException(exp2);
            throw exceptionStack;
        }
    }

    private void createNumericalBinDefinitionTable(OraConnection dmeConn) throws SQLException {
        String sqlStr = "DBMS_DATA_MINING_TRANSFORM.CREATE_BIN_NUM";
        String[] paramNames = null;
        Object[] paramValues = null;
        int[] sqlTypes = null;
        if (this.m_transformationOutputData == null) {
            paramNames = new String[]{"bin_table_name"};
            paramValues = new Object[]{this.m_numBinTable};
            sqlTypes = new int[]{12};
        } else {
            paramNames = new String[]{"bin_table_name", "bin_schema_name"};
            paramValues = new Object[]{this.m_numBinTable, this.m_transformationOutputData.getSchemaName()};
            sqlTypes = new int[]{12, 12};
        }
        CallableStatement cStmt = OraSQLUtils.createCallableStatement(this.getConnection().getDatabaseConnection(), sqlStr, paramNames, paramValues, sqlTypes, null, this.getLogger());
        cStmt.execute();
        this.m_xformProperties.put(NUM_BIN_TABLE, this.m_numBinTable);
    }

    private void createCategoricalBinDefinitionTable(OraConnection dmeConn) throws SQLException {
        String sqlStr = "DBMS_DATA_MINING_TRANSFORM.CREATE_BIN_CAT";
        String[] paramNames = null;
        Object[] paramValues = null;
        int[] sqlTypes = null;
        if (this.m_transformationOutputData == null) {
            paramNames = new String[]{"bin_table_name"};
            paramValues = new Object[]{this.m_catBinTable};
            sqlTypes = new int[]{12};
        } else {
            paramNames = new String[]{"bin_table_name", "bin_schema_name"};
            paramValues = new Object[]{this.m_catBinTable, this.m_transformationOutputData.getSchemaName()};
            sqlTypes = new int[]{12, 12};
        }
        CallableStatement cStmt = OraSQLUtils.createCallableStatement(this.getConnection().getDatabaseConnection(), sqlStr, paramNames, paramValues, sqlTypes, null, this.getLogger());
        cStmt.execute();
        this.m_xformProperties.put(CAT_BIN_TABLE, this.m_catBinTable);
    }

    public OraNumericalBinningType getNumericalBinningType() {
        return this.m_numBinningType;
    }

    public void setNumericalBinningType(OraNumericalBinningType type) {
        this.m_numBinningType = type;
        this.m_xformProperties.put(IN_NUM_BIN_TYPE, this.m_numBinningType.name());
    }

    public OraCategoricalBinningType getCategoricalBinningType() {
        return this.m_catBinningType;
    }

    public void setCategoricalBinningType(OraCategoricalBinningType type) {
        this.m_catBinningType = type;
        this.m_xformProperties.put(IN_CAT_BIN_TYPE, this.m_catBinningType.name());
    }

    public int getNumberOfBinsForNumerical() {
        return this.m_numBinNumber;
    }

    public void setNumberOfBinsForNumerical(int binNumber) {
        this.m_numBinNumber = binNumber;
        this.m_xformProperties.put(IN_NUM_BIN_NUMBER, new Integer(this.m_numBinNumber));
    }

    public int getNumberOfBinsForCategorical() {
        return this.m_catBinNumber;
    }

    public void setNumberOfBinsForCategorical(int binNumber) {
        this.m_catBinNumber = binNumber;
        this.m_xformProperties.put(IN_CAT_BIN_NUMBER, new Integer(this.m_catBinNumber));
    }

    public String getNumericalBinTable() {
        return this.m_numBinTable;
    }

    public String getCategoricalBinTable() {
        return this.m_catBinTable;
    }

    public String getSettingsTable1() {
        return this.getNumericalBinTable();
    }

    public String getSettingsTable2() {
        return this.getCategoricalBinTable();
    }

    String getSettingsTable1Property() {
        return NUM_BIN_TABLE;
    }

    String getSettingsTable2Property() {
        return CAT_BIN_TABLE;
    }

    public OraAttributeBins[] getBins() {
        OraAttributeBins[] resultBins = null;
        try {
            OraPhysicalDataSetFactory pdsFactory = (OraPhysicalDataSetFactory)this.getConnection().getFactory("javax.datamining.data.PhysicalDataSet");
            pdsFactory.setExcludedAttributes(this.getExcludeColumnList());
            PhysicalDataSet pds = pdsFactory.create(this.getTransformInputData(), true);
            Vector<String> vCatAttributes = new Vector<String>();
            Vector<String> vnumAttribute = new Vector<String>();
            Collection physAttributes = pds.getAttributes();
            for (PhysicalAttribute physAttribute : physAttributes) {
                if (physAttribute.getDataType().equals((Object)AttributeDataType.stringType)) {
                    vCatAttributes.add(physAttribute.getName());
                    continue;
                }
                vnumAttribute.add(physAttribute.getName());
            }
            OraNumericalAttributeBins[] numBinnedAttributes = null;
            OraCategoricalAttributeBins[] catBinnedAttributes = null;
            if (!vnumAttribute.isEmpty()) {
                numBinnedAttributes = true == this.m_numBinningType.equals((Object)OraNumericalBinningType.quantile) ? OraBinningTransformImpl.quantileBinning(this.getConnection(), this.getTransformInputData(), vnumAttribute, this.m_numBinNumber) : (true == this.m_numBinningType.equals((Object)OraNumericalBinningType.auto_equi_width) ? OraBinningTransformImpl.autoequalWidthBinning(this.getConnection(), this.getTransformInputData(), vnumAttribute, pds) : OraBinningTransformImpl.equalWidthBinning(this.getConnection(), this.getTransformInputData(), vnumAttribute, this.m_numBinNumber));
            }
            if (this.m_catBinningType.equals((Object)OraCategoricalBinningType.top_n) && !vCatAttributes.isEmpty()) {
                catBinnedAttributes = OraBinningTransformImpl.topNBinning(this.getConnection(), this.getTransformInputData(), vCatAttributes, this.m_catBinNumber);
            }
            if (!(numBinnedAttributes != null && numBinnedAttributes.length != 0 || catBinnedAttributes != null && catBinnedAttributes.length != 0)) {
                return null;
            }
            int numLength = numBinnedAttributes == null ? 0 : numBinnedAttributes.length;
            int catLength = catBinnedAttributes == null ? 0 : catBinnedAttributes.length;
            resultBins = new OraAttributeBins[numLength + catLength];
            if (numLength > 0) {
                System.arraycopy(numBinnedAttributes, 0, resultBins, 0, numLength);
            }
            if (catLength > 0) {
                System.arraycopy(catBinnedAttributes, 0, resultBins, numLength, catLength);
            }
        }
        catch (Exception e) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.getBins: ", e);
        }
        return resultBins;
    }

    protected void cleanXformSpecificObjects(OraConnection dmeConn, String name) {
        String tableName;
        if (!this.m_bUserSuppliedNumBinDefTable) {
            tableName = null;
            tableName = name.startsWith("\"") && name.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(name) + NUM_BIN_DEFINITION_SUFFIX + "\"" : name + NUM_BIN_DEFINITION_SUFFIX;
            this.dropTable(tableName);
        }
        if (!this.m_bUserSuppliedCatBinDefTable) {
            tableName = null;
            tableName = name.startsWith("\"") && name.endsWith("\"") ? "\"" + OraStringUtils.trimDoubleQuotes(name) + CAT_BIN_DEFINITION_SUFFIX + "\"" : name + CAT_BIN_DEFINITION_SUFFIX;
            this.dropTable(tableName);
        }
    }

    private void updateBinColumnsWithLabels() throws SQLException {
        if (this.m_numBinTable == null || this.m_numBinTable.length() == 0) {
            return;
        }
        String insertSql = UPDATE_BIN_NUM_EQWIDTH;
        Statement cStmt = null;
        try {
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_table_name>", this.m_numBinTable);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_table_name>", this.m_numBinTable);
            OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), insertSql, this.getLogger());
        }
        catch (SQLException sqle) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.updateBinColumnsWithLabels: ", sqle);
            throw sqle;
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    private void insertBinNumEqwidth() throws SQLException {
        String insertSql = INSERT_BIN_NUM_EQWIDTH;
        Statement cStmt = null;
        try {
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_table_name>", "'" + OraStringUtils.getReplacedString(this.m_numBinTable, "'", "''") + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_table_name>", "'" + this.getProcessedTableName() + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_num>", this.m_numBinNumber + "");
            insertSql = this.getReplacedExcludedList(insertSql);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<round_num>", this.m_nRound + "");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_schema_name>", this.m_transformationOutputData == null || this.m_transformationOutputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationOutputData.getSchemaName()) + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_schema_name>", this.m_transformationInputData == null || this.m_transformationInputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationInputData.getSchemaName()) + "'");
            OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), insertSql, this.getLogger());
        }
        catch (SQLException sqle) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.insertBinNumEqwidth: ", sqle);
            throw sqle;
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    private void insertBinNumAutoEqwidth() throws SQLException {
        String insertSql = INSERT_AUTOBIN_NUM_EQWIDTH;
        Statement cStmt = null;
        try {
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_table_name>", "'" + OraStringUtils.getReplacedString(this.m_numBinTable, "'", "''") + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_table_name>", "'" + this.getProcessedTableName() + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_num>", this.m_numBinNumber + "");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<max_bin_num>", this.m_maxnumBinNumber + "");
            insertSql = this.getReplacedExcludedList(insertSql);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<round_num>", this.m_nRound + "");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<sample_size>", this.m_nSampleSize + "");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_schema_name>", this.m_transformationOutputData == null || this.m_transformationOutputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationOutputData.getSchemaName()) + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_schema_name>", this.m_transformationInputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationInputData.getSchemaName()) + "'");
            OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), insertSql, this.getLogger());
        }
        catch (SQLException sqle) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.insertBinNumAutoEqwidth: ", sqle);
            throw sqle;
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    private void insertBinNumQtile() throws SQLException {
        String insertSql = INSERT_BIN_NUM_QTILE;
        Statement cStmt = null;
        try {
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_table_name>", "'" + OraStringUtils.getReplacedString(this.m_numBinTable, "'", "''") + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_table_name>", "'" + this.getProcessedTableName() + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_num>", this.m_numBinNumber + "");
            insertSql = this.getReplacedExcludedList(insertSql);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_schema_name>", this.m_transformationOutputData == null || this.m_transformationOutputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationOutputData.getSchemaName()) + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_schema_name>", this.m_transformationInputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationInputData.getSchemaName()) + "'");
            OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), insertSql, this.getLogger());
        }
        catch (SQLException sqle) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.insertBinNumQtile: ", sqle);
            throw sqle;
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    private void insertBinCatFreq() throws SQLException {
        String insertSql = INSERT_BIN_CAT_FREQ;
        Statement cStmt = null;
        try {
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_table_name>", "'" + OraStringUtils.getReplacedString(this.m_catBinTable, "'", "''") + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_table_name>", "'" + this.getProcessedTableName() + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_num>", this.m_catBinNumber + "");
            insertSql = this.getReplacedExcludedList(insertSql);
            insertSql = OraStringUtils.getReplacedString(insertSql, "<default_num>", this.m_numberDefaults + "");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_support>", this.m_binSupport + "");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<bin_schema_name>", this.m_transformationOutputData == null || this.m_transformationOutputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationOutputData.getSchemaName()) + "'");
            insertSql = OraStringUtils.getReplacedString(insertSql, "<data_schema_name>", this.m_transformationInputData.getSchemaName() == null ? "null" : "'" + this.getProcessedSchemaName(this.m_transformationInputData.getSchemaName()) + "'");
            OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), insertSql, this.getLogger());
            if (!this.m_bLiteralFlag) {
                StringBuffer updateCommon = new StringBuffer("UPDATE ");
                updateCommon.append(this.m_transformationInputData.getSchemaName() == null ? "" : "\"" + OraStringUtils.trimDoubleQuotes(this.m_transformationInputData.getSchemaName()) + "\".");
                if (this.m_catBinTable.startsWith("\"") && this.m_catBinTable.endsWith("\"")) {
                    updateCommon.append(this.m_catBinTable);
                } else {
                    updateCommon.append("\"" + this.m_catBinTable + "\"");
                }
                StringBuffer updateBinsSql = new StringBuffer(updateCommon.toString());
                updateBinsSql.append(" SET BIN = VAL WHERE VAL IS NOT NULL");
                OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), updateBinsSql.toString(), this.getLogger());
                updateBinsSql = new StringBuffer(updateCommon.toString());
                String _other = this.getLocalizedMessage("4001", null);
                updateBinsSql.append(" SET BIN = COL || '" + _other + "' WHERE VAL IS NULL");
                OraSQLUtils.execSql(this.getConnection().getDatabaseConnection(), updateBinsSql.toString(), this.getLogger());
            }
        }
        catch (SQLException sqle) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.insertBinCatFreq: ", sqle);
            throw sqle;
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    protected static OraNumericalAttributeBins[] quantileBinning(OraConnection dmeConn, String inputDataURI, Vector attributeNames, Vector numberOfBins) throws SQLException, JDMException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraNumericalAttributeBins[] resultBins = new OraNumericalAttributeBins[attributeNames.size()];
        for (int ni = 0; ni < attributeNames.size(); ++ni) {
            String attributeName = (String)attributeNames.elementAt(ni);
            resultBins[ni] = new OraNumericalAttributeBinsImpl(attributeName);
            Vector<Double> v_min_itab = new Vector<Double>();
            Vector<Double> v_max_itab = new Vector<Double>();
            Statement pstmt = null;
            ResultSet rs = null;
            String query = null;
            try {
                query = MessageFormat.format(QTILE_BINNING, attributeName, (Integer)numberOfBins.elementAt(ni), inputDataURI);
                int v_num = 0;
                pstmt = dbConn.prepareStatement(query);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal tmp = rs.getBigDecimal(1);
                    double min = tmp.doubleValue();
                    tmp = rs.getBigDecimal(2);
                    double max = tmp.doubleValue();
                    v_min_itab.add(new Double(min));
                    v_max_itab.add(new Double(max));
                    ++v_num;
                }
                Vector<QuantileDefinition> quantiles = new Vector<QuantileDefinition>();
                if (v_num == 0) continue;
                v_min_itab.add((Double)v_max_itab.elementAt(v_max_itab.size() - 1));
                Double[] mins = v_min_itab.toArray(new Double[v_min_itab.size()]);
                Double[] maxs = v_max_itab.toArray(new Double[v_max_itab.size()]);
                if (mins[0].doubleValue() == maxs[v_num - 1].doubleValue()) continue;
                int v_bin = 0;
                for (int j = 0; j <= v_num; ++j) {
                    if (j <= v_num - 1 && mins[j].doubleValue() == mins[j + 1].doubleValue()) continue;
                    QuantileDefinition bin = new QuantileDefinition(v_bin, mins[j]);
                    quantiles.add(bin);
                    ++v_bin;
                }
                QuantileDefinition qbinPrev = (QuantileDefinition)quantiles.elementAt(0);
                for (int nq = 1; nq < quantiles.size(); ++nq) {
                    QuantileDefinition qbin = (QuantileDefinition)quantiles.elementAt(nq);
                    String sMin = String.valueOf(Double.MIN_VALUE);
                    OraNumericalBinImpl numBin = new OraNumericalBinImpl();
                    numBin.setBinID("" + (qbin.getBinNumber() - 1));
                    numBin.setStartValue(qbinPrev.getMinNumber());
                    numBin.setEndValue(qbin.getMinNumber());
                    resultBins[ni].addBin(numBin);
                    qbinPrev = qbin;
                }
                continue;
            }
            catch (Exception e) {
                String error = "Unable to execute " + query + "\n";
                error = error + e;
                dmeConn.getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.quantileBinning: ", e);
                throw new SQLException(error);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return resultBins;
    }

    protected static OraNumericalAttributeBins[] quantileBinning(OraConnection dmeConn, String inputDataURI, Vector attributeNames, int numberOfBins) throws SQLException, JDMException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraNumericalAttributeBins[] resultBins = new OraNumericalAttributeBins[attributeNames.size()];
        for (int ni = 0; ni < attributeNames.size(); ++ni) {
            String attributeName = (String)attributeNames.elementAt(ni);
            resultBins[ni] = new OraNumericalAttributeBinsImpl(attributeName);
            Vector<Double> v_min_itab = new Vector<Double>();
            Vector<Double> v_max_itab = new Vector<Double>();
            Statement pstmt = null;
            ResultSet rs = null;
            String query = null;
            try {
                query = MessageFormat.format(QTILE_BINNING, attributeName, new Integer(numberOfBins), inputDataURI);
                int v_num = 0;
                pstmt = dbConn.prepareStatement(query);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal tmp = rs.getBigDecimal(1);
                    double min = tmp.doubleValue();
                    tmp = rs.getBigDecimal(2);
                    double max = tmp.doubleValue();
                    v_min_itab.add(new Double(min));
                    v_max_itab.add(new Double(max));
                    ++v_num;
                }
                Vector<QuantileDefinition> quantiles = new Vector<QuantileDefinition>();
                if (v_num == 0) continue;
                v_min_itab.add((Double)v_max_itab.elementAt(v_max_itab.size() - 1));
                Double[] mins = v_min_itab.toArray(new Double[v_min_itab.size()]);
                Double[] maxs = v_max_itab.toArray(new Double[v_max_itab.size()]);
                if (mins[0].doubleValue() == maxs[v_num - 1].doubleValue()) continue;
                int v_bin = 0;
                for (int j = 0; j <= v_num; ++j) {
                    if (j <= v_num - 1 && mins[j].doubleValue() == mins[j + 1].doubleValue()) continue;
                    QuantileDefinition bin = new QuantileDefinition(v_bin, mins[j]);
                    quantiles.add(bin);
                    ++v_bin;
                }
                QuantileDefinition qbinPrev = (QuantileDefinition)quantiles.elementAt(0);
                for (int nq = 1; nq < quantiles.size(); ++nq) {
                    QuantileDefinition qbin = (QuantileDefinition)quantiles.elementAt(nq);
                    String sMin = String.valueOf(Double.MIN_VALUE);
                    OraNumericalBinImpl numBin = new OraNumericalBinImpl();
                    numBin.setBinID("" + (qbin.getBinNumber() - 1));
                    numBin.setStartValue(qbinPrev.getMinNumber());
                    numBin.setEndValue(qbin.getMinNumber());
                    resultBins[ni].addBin(numBin);
                    qbinPrev = qbin;
                }
                continue;
            }
            catch (Exception e) {
                String error = "Unable to execute " + query + "\n";
                error = error + e;
                dmeConn.getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.quantileBinning: ", e);
                throw new SQLException(error);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return resultBins;
    }

    protected static OraNumericalAttributeBins[] autoequalWidthBinning(OraConnection dmeConn, String inputDataURI, Vector attributeNames, PhysicalDataSet pds) throws SQLException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraNumericalAttributeBins[] resultBins = new OraNumericalAttributeBins[attributeNames.size()];
        int numberScans = attributeNames.size() / 300 + 1;
        for (int nscan = 0; nscan < numberScans; ++nscan) {
            int topAttributeNumber = Math.min(attributeNames.size(), 300 * (nscan + 1));
            int lowAttributeNumber = 300 * nscan;
            StringBuffer sbScan = new StringBuffer("SELECT /*+ parallel (t) */");
            for (int ni = lowAttributeNumber; ni < topAttributeNumber; ++ni) {
                String attributeName = "\"" + (String)attributeNames.elementAt(ni) + "\"";
                String temp = MessageFormat.format(TEMPLATE_START_AUTO_BIN, attributeName, String.valueOf(ni));
                sbScan.append(temp);
                if (ni >= topAttributeNumber - 1) continue;
                sbScan.append(",");
            }
            String location = MessageFormat.format(" from ({0} t)", inputDataURI);
            sbScan.append(location);
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery(sbScan.toString());
                if (!rs.next()) continue;
                for (int index = lowAttributeNumber; index < topAttributeNumber; ++index) {
                    String sindex = String.valueOf(index);
                    String attributeName = (String)attributeNames.elementAt(index);
                    resultBins[index] = new OraNumericalAttributeBinsImpl(attributeName);
                    int count = rs.getInt("COUNT" + sindex);
                    BigDecimal tmp = rs.getBigDecimal("Max" + sindex);
                    if (rs.wasNull()) continue;
                    double maxVal = tmp.doubleValue();
                    tmp = rs.getBigDecimal("Min" + sindex);
                    if (rs.wasNull()) continue;
                    double minVal = tmp.doubleValue();
                    tmp = rs.getBigDecimal("Variance" + sindex);
                    double var = tmp.doubleValue();
                    double dev = rs.wasNull() ? 0.0 : Math.sqrt(var);
                    int numberBins = OraBinningTransformImpl.autoBinnumberCalculation(pds, attributeName, count, dev, maxVal, minVal);
                    OraNumericalBin[] bins = OraBinningTransformImpl.getEqualWidthBounds(minVal, maxVal, numberBins);
                    resultBins[index].addBins(bins);
                }
                continue;
            }
            catch (Exception e) {
                String error = "Unable to execute " + sbScan.toString() + "\n";
                error = error + e;
                dmeConn.getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.equalWidthBinning: ", e);
                throw new SQLException(error);
            }
            finally {
                try {
                    rs.close();
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        return resultBins;
    }

    private static int autoBinnumberCalculation(PhysicalDataSet pds, String attrName, int cnt, double dev, double max, double min) throws JDMException {
        PhysicalAttribute phAttr;
        AttributeDataType atType;
        int binNumber = 3;
        int nTempNaxCount = 50000;
        if (cnt > 0) {
            if (cnt < 50000) {
                nTempNaxCount = cnt;
            }
            int ntemp = 0;
            if (dev == 0.0) {
                ntemp = 1;
            } else {
                ntemp = (int)Math.min(Math.pow(nTempNaxCount, 0.3333333333333333) * 0.9 * (max - min) / (3.49 * dev), 100.0);
                if (ntemp < 3) {
                    ntemp = 3;
                }
            }
            binNumber = ntemp;
        }
        if ((atType = (phAttr = pds.getAttribute(attrName)).getDataType()).equals((Object)AttributeDataType.integerType)) {
            binNumber = (int)Math.min((double)binNumber, max - min + 1.0);
        }
        return binNumber;
    }

    protected static OraNumericalAttributeBins[] equalWidthBinning(OraConnection dmeConn, String inputDataURI, Vector attributeNames, Vector numberOfBins) throws SQLException {
        if (attributeNames == null || attributeNames.size() == 0) {
            return null;
        }
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraNumericalAttributeBins[] resultBins = new OraNumericalAttributeBins[attributeNames.size()];
        int numberScans = attributeNames.size() / 300 + 1;
        for (int nscan = 0; nscan < numberScans; ++nscan) {
            int topAttributeNumber = Math.min(attributeNames.size(), 300 * (nscan + 1));
            int lowAttributeNumber = 300 * nscan;
            StringBuffer sbScan = new StringBuffer("SELECT /*+ parallel (t) */");
            for (int ni = lowAttributeNumber; ni < topAttributeNumber; ++ni) {
                String attributeName = "\"" + (String)attributeNames.elementAt(ni) + "\"";
                String temp = MessageFormat.format(TEMPLATE_START, attributeName, String.valueOf(ni));
                sbScan.append(temp);
                if (ni >= topAttributeNumber - 1) continue;
                sbScan.append(",");
            }
            String location = MessageFormat.format(" from ({0} t)", inputDataURI);
            sbScan.append(location);
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery(sbScan.toString());
                if (!rs.next()) continue;
                for (int index = lowAttributeNumber; index < topAttributeNumber; ++index) {
                    String sindex = String.valueOf(index);
                    String attributeName = (String)attributeNames.elementAt(index);
                    resultBins[index] = new OraNumericalAttributeBinsImpl(attributeName);
                    BigDecimal tmp = rs.getBigDecimal("Max" + sindex);
                    double maxVal = tmp.doubleValue();
                    tmp = rs.getBigDecimal("Min" + sindex);
                    double minVal = tmp.doubleValue();
                    OraNumericalBin[] bins = OraBinningTransformImpl.getEqualWidthBounds(minVal, maxVal, (Integer)numberOfBins.elementAt(index));
                    resultBins[index].addBins(bins);
                }
                continue;
            }
            catch (Exception e) {
                String error = "Unable to execute " + sbScan.toString() + "\n";
                error = error + e;
                dmeConn.getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.equalWidthBinning: ", e);
                throw new SQLException(error);
            }
            finally {
                try {
                    rs.close();
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        return resultBins;
    }

    protected static OraNumericalAttributeBins[] equalWidthBinning(OraConnection dmeConn, String inputDataURI, Vector attributeNames, int numberOfBins) throws SQLException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraNumericalAttributeBins[] resultBins = new OraNumericalAttributeBins[attributeNames.size()];
        int numberScans = attributeNames.size() / 300 + 1;
        for (int nscan = 0; nscan < numberScans; ++nscan) {
            int topAttributeNumber = Math.min(attributeNames.size(), 300 * (nscan + 1));
            int lowAttributeNumber = 300 * nscan;
            StringBuffer sbScan = new StringBuffer("SELECT /*+ parallel (t) */");
            for (int ni = lowAttributeNumber; ni < topAttributeNumber; ++ni) {
                String attributeName = "\"" + (String)attributeNames.elementAt(ni) + "\"";
                String temp = MessageFormat.format(TEMPLATE_START, attributeName, String.valueOf(ni));
                sbScan.append(temp);
                if (ni >= topAttributeNumber - 1) continue;
                sbScan.append(",");
            }
            String location = MessageFormat.format(" from ({0} t)", inputDataURI);
            sbScan.append(location);
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery(sbScan.toString());
                if (!rs.next()) continue;
                for (int index = lowAttributeNumber; index < topAttributeNumber; ++index) {
                    String sindex = String.valueOf(index);
                    String attributeName = (String)attributeNames.elementAt(index);
                    resultBins[index] = new OraNumericalAttributeBinsImpl(attributeName);
                    BigDecimal tmp = rs.getBigDecimal("Max" + sindex);
                    double maxVal = tmp.doubleValue();
                    tmp = rs.getBigDecimal("Min" + sindex);
                    double minVal = tmp.doubleValue();
                    OraNumericalBin[] bins = OraBinningTransformImpl.getEqualWidthBounds(minVal, maxVal, numberOfBins);
                    resultBins[index].addBins(bins);
                }
                continue;
            }
            catch (Exception e) {
                String error = "Unable to execute " + sbScan.toString() + "\n";
                error = error + e;
                dmeConn.getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.equalWidthBinning: ", e);
                throw new SQLException(error);
            }
            finally {
                try {
                    rs.close();
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        return resultBins;
    }

    private static OraNumericalBin[] getEqualWidthBounds(double minValue, double maxValue, int numberOfBins) throws JDMException {
        if (minValue >= maxValue) {
            return null;
        }
        Vector<OraNumericalBinImpl> binBounds = new Vector<OraNumericalBinImpl>();
        double delta = (maxValue - minValue) / (double)numberOfBins;
        double start = minValue;
        double end = start + delta;
        DecimalFormat df = new DecimalFormat("00.##E0");
        for (int ni = 0; ni < numberOfBins; ++ni) {
            if (ni == numberOfBins - 1) {
                end = maxValue;
            }
            OraNumericalBinImpl bin = new OraNumericalBinImpl();
            bin.setBinID("" + ni);
            bin.setStartValue(start);
            bin.setEndValue(end);
            binBounds.add(bin);
            start = end;
            String tmp = df.format(end += delta);
            end = Double.parseDouble(tmp);
        }
        return binBounds.toArray(new OraNumericalBin[binBounds.size()]);
    }

    protected static OraCategoricalAttributeBins[] topNBinning(OraConnection dmeConn, String inputDataURI, Vector attributeNames, Vector numberOfBins) throws SQLException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraCategoricalAttributeBins[] resultBins = new OraCategoricalAttributeBins[attributeNames.size()];
        for (int ni = 0; ni < attributeNames.size(); ++ni) {
            String attributeName = (String)attributeNames.elementAt(ni);
            resultBins[ni] = new OraCategoricalAttributeBinsImpl(attributeName);
            Statement stmt = null;
            ResultSet rs = null;
            String sql = null;
            Vector vBinBounds = new Vector();
            int nb = 1;
            try {
                sql = MessageFormat.format(TOPN_STATS, "\"" + attributeName.toUpperCase() + "\"", inputDataURI, String.valueOf(numberOfBins.elementAt(ni)));
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String category = rs.getString(1);
                    OraCategoricalBinImpl cb = new OraCategoricalBinImpl();
                    cb.setBinID("" + nb++);
                    cb.addCategory(category);
                    resultBins[ni].addBin(cb);
                }
                continue;
            }
            catch (Exception e) {
                String error = "Unable to execute " + sql + "\n";
                error = error + e;
                dmeConn.getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.topNBinning: ", e);
                throw new SQLException(error);
            }
            finally {
                try {
                    rs.close();
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return resultBins;
    }

    protected static OraCategoricalAttributeBins[] topNBinning(OraConnection dmeConn, String inputDataURI, Vector attributeNames, int binNumber) throws SQLException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        OraCategoricalAttributeBins[] resultBins = new OraCategoricalAttributeBins[attributeNames.size()];
        for (int ni = 0; ni < attributeNames.size(); ++ni) {
            String attributeName = (String)attributeNames.elementAt(ni);
            resultBins[ni] = new OraCategoricalAttributeBinsImpl(attributeName);
            Statement stmt = null;
            ResultSet rs = null;
            String sql = null;
            Vector vBinBounds = new Vector();
            int nb = 1;
            try {
                sql = MessageFormat.format(TOPN_STATS, "\"" + attributeName.toUpperCase() + "\"", inputDataURI, String.valueOf(binNumber));
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String category = rs.getString(1);
                    OraCategoricalBinImpl cb = new OraCategoricalBinImpl();
                    cb.setBinID("" + nb++);
                    cb.addCategory(category);
                    resultBins[ni].addBin(cb);
                }
                continue;
            }
            catch (Exception e) {
                String error = "Unable to execute " + sql + "\n";
                error = error + e;
                dmeConn.getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.topNBinning: ", e);
                throw new SQLException(error);
            }
            finally {
                try {
                    rs.close();
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return resultBins;
    }

    private void insertCustomNumericData() throws SQLException {
        Connection dbConn = this.getConnection().getDatabaseConnection();
        boolean bAutoCommit = dbConn.getAutoCommit();
        dbConn.setAutoCommit(false);
        String sql = MessageFormat.format(INSERT_CUSTOM_BINS, (this.m_transformationOutputData == null || this.m_transformationOutputData.getSchemaName() == null ? "" : this.m_transformationOutputData.getSchemaName() + ".") + OraStringUtils.getReplacedString(this.m_numBinTable, "'", "''"));
        PreparedStatement ps = dbConn.prepareStatement(sql);
        ((OraclePreparedStatement)ps).setExecuteBatch(100);
        try {
            for (int bin = 0; bin < this.m_customBins.length; ++bin) {
                if (!(this.m_customBins[bin] instanceof OraNumericalAttributeBins)) continue;
                OraNumericalAttributeBins oraNumBin = (OraNumericalAttributeBins)this.m_customBins[bin];
                String colName = oraNumBin.getAttributeName();
                OraNumericalBin[] oranumBins = oraNumBin.getBins();
                String binId = null;
                double dEndValue = 0.0;
                try {
                    ps.setString(1, colName);
                    ps.setDouble(2, oranumBins[0].getStartValue());
                    ps.setNull(3, 12);
                    ps.executeUpdate();
                    for (int nb = 1; nb < oranumBins.length; ++nb) {
                        binId = oranumBins[nb].getBinID();
                        dEndValue = oranumBins[nb].getEndValue();
                        ps.setString(1, colName);
                        ps.setDouble(2, dEndValue);
                        ps.setString(3, binId);
                        ps.executeUpdate();
                    }
                    ((OraclePreparedStatement)ps).sendBatch();
                    dbConn.commit();
                    continue;
                }
                catch (SQLException e) {
                    this.logTrace("Failed Operation: OraBinningTransformationImpl.insertCustomNumericData: colName:" + colName + " binId:" + binId + " dEndValue: " + dEndValue + ": ", e);
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.insertCustomNumericData:", e);
            throw e;
        }
        finally {
            try {
                dbConn.setAutoCommit(bAutoCommit);
            }
            catch (Exception anyExp) {}
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    private void insertCustomCategoricData() throws SQLException {
        Connection dbConn = this.getConnection().getDatabaseConnection();
        boolean bAutoCommit = dbConn.getAutoCommit();
        dbConn.setAutoCommit(false);
        String sql = MessageFormat.format(INSERT_CUSTOM_BINS, (this.m_transformationOutputData == null || this.m_transformationOutputData.getSchemaName() == null ? "" : this.m_transformationOutputData.getSchemaName() + ".") + this.m_catBinTable);
        PreparedStatement ps = dbConn.prepareStatement(sql);
        ((OraclePreparedStatement)ps).setExecuteBatch(100);
        try {
            for (int bin = 0; bin < this.m_customBins.length; ++bin) {
                if (!(this.m_customBins[bin] instanceof OraCategoricalAttributeBins)) continue;
                OraCategoricalAttributeBins oraCatBin = (OraCategoricalAttributeBins)this.m_customBins[bin];
                OraCategoricalBin[] oracatBins = oraCatBin.getBins();
                String colName = oraCatBin.getAttributeName();
                String binId = null;
                String category = null;
                try {
                    for (int cb = 0; cb < oracatBins.length; ++cb) {
                        OraCategoricalBin oraCB = oracatBins[cb];
                        binId = oracatBins[cb].getBinID();
                        Object[] categories = oraCB.getCategories();
                        if (categories == null) continue;
                        for (int cat = 0; cat < categories.length; ++cat) {
                            if (categories[cat] == null) continue;
                            category = categories[cat].toString();
                            ps.setString(1, colName);
                            ps.setString(2, category);
                            ps.setString(3, !this.m_bLiteralFlag ? category : "'" + binId + "'");
                            ps.executeUpdate();
                        }
                    }
                    ((OraclePreparedStatement)ps).sendBatch();
                    dbConn.commit();
                    continue;
                }
                catch (SQLException e) {
                    this.logTrace("Failed Operation: OraBinningTransformationImpl.insertCustomCategoricData: colName:" + colName + " binId:" + binId + " category: " + category + ": ", e);
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            this.logTrace("Failed Operation: OraBinningTransformationImpl.insertCustomCategoricData:", e);
            throw e;
        }
        finally {
            try {
                dbConn.setAutoCommit(bAutoCommit);
            }
            catch (Exception anyExp) {}
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    private void removeNumBinDefinitions() throws SQLException {
        this.removeBinDefinitions(this.m_numBinTable);
    }

    private void removeCatBinDefinitions() throws SQLException {
        this.removeBinDefinitions(this.m_catBinTable);
    }

    private void removeBinDefinitions(String tableName) throws SQLException {
        Connection dbConn = this.getConnection().getDatabaseConnection();
        String sql = MessageFormat.format(DELETE_CUSTOM_BINS, (this.m_transformationOutputData == null || this.m_transformationOutputData.getSchemaName() == null ? "" : this.m_transformationOutputData.getSchemaName() + ".") + tableName);
        PreparedStatement ps = dbConn.prepareStatement(sql);
        try {
            for (int bin = 0; bin < this.m_customBins.length; ++bin) {
                String colName = this.m_customBins[bin].getAttributeName();
                try {
                    ps.setString(1, colName);
                    ps.execute();
                    continue;
                }
                catch (SQLException e) {
                    this.getConnection().getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.removeBinDefinitions: Table: " + tableName, e);
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            this.getConnection().getLogger().log(Level.FINEST, "Failed Operation: OraBinningTransformationImpl.removeBinDefinitions: Table: " + tableName, e);
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    public static String getUnbinningClause(String catBinTable, String numBinTable) {
        String qry = "";
        if (numBinTable != null) {
            qry = qry + QRY_DECODE_NUM_BIN_TABLE;
            qry = qry + numBinTable + " )";
            if (catBinTable != null && 0 != catBinTable.length()) {
                qry = qry + " UNION ALL ";
            }
        }
        if (catBinTable != null && 0 != catBinTable.length()) {
            qry = qry + MessageFormat.format(QRY_DECODE_CAT_BIN_TABLE, catBinTable);
        }
        return qry;
    }

    static class QuantileDefinition {
        int binNumber;
        double minValue;

        public QuantileDefinition(int binNumber, double minValue) {
            this.binNumber = binNumber;
            this.minValue = minValue;
        }

        public int getBinNumber() {
            return this.binNumber;
        }

        public double getMinNumber() {
            return this.minValue;
        }
    }
}

