/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.transform;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.utils.OraStringUtils;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public abstract class OraTransformationImpl
extends OraDMObject
implements OraTransformation {
    protected HashMap m_xformProperties = new HashMap();
    protected OraDataURI m_transformationInputData = null;
    protected OraDataURI m_transformationOutputData = null;
    private String[] m_excludedColumns = null;
    private String[] m_includedColumns = null;
    protected boolean m_bOutputAsView = false;
    protected static String COLUMN_LIST = "COLUMN_LIST_JDM";
    protected static String CREATE_JDM_TYPE = "create or replace  TYPE COLUMN_LIST_JDM  IS VARRAY(1000) OF VARCHAR2(32)";
    protected static String DROP_JDM_TYPE = "DROP TYPE COLUMN_LIST_JDM";
    protected static final String IN_INPUT_TABLE = "IN_INPUT_TABLE";
    protected static final String IN_OUTPUT_TABLE = "IN_OUTPUT_TABLE";
    protected static final String IN_INPUT_SCHEMA = "IN_INPUT_SCHEMA";
    protected static final String IN_OUTPUT_SCHEMA = "IN_OUTPUT_SCHEMA";
    protected static final String IN_IS_OUTPUT_VIEW = "IN_IS_OUTPUT_VIEW";
    protected static final String IN_EXCLUDE_ATTRS = "IN_EXCLUDE_ATTRS";
    protected static final String IN_INCLUDE_ATTRS = "IN_INCLUDE_ATTRS";

    protected OraTransformationImpl(OraConnection dmeConn, OraFactory parentFactory, boolean bOutputAsView) throws JDMException {
        super(dmeConn, parentFactory);
        this.m_bOutputAsView = bOutputAsView;
    }

    public String getTransformInputData() {
        return this.m_transformationInputData.getURI();
    }

    public void setTransformInputData(String dataURI) {
        this.m_transformationInputData = new OraDataURI(dataURI);
        if (dataURI != null) {
            String tableName = this.m_transformationInputData.getTableName();
            String schemaName = this.m_transformationInputData.getSchemaName();
            if (tableName != null) {
                this.m_xformProperties.put(IN_INPUT_TABLE, tableName);
            }
            if (schemaName != null) {
                this.m_xformProperties.put(IN_INPUT_SCHEMA, schemaName);
            }
        }
    }

    public String getTransformOutputData() {
        return this.m_transformationOutputData.getURI();
    }

    public void setTransformOutputData(String dataURI) {
        this.m_transformationOutputData = new OraDataURI(dataURI);
        if (dataURI == null) {
            this.m_xformProperties.remove(IN_OUTPUT_TABLE);
            this.m_xformProperties.remove(IN_OUTPUT_SCHEMA);
        } else {
            String tableName = this.m_transformationOutputData.getTableName();
            String schemaName = this.m_transformationOutputData.getSchemaName();
            if (tableName != null) {
                this.m_xformProperties.put(IN_OUTPUT_TABLE, tableName);
            }
            if (schemaName != null) {
                this.m_xformProperties.put(IN_OUTPUT_SCHEMA, schemaName);
            }
        }
    }

    public void setExcludeColumnList(String[] excludeColumnList) {
        this.m_excludedColumns = excludeColumnList;
        if (excludeColumnList == null) {
            this.m_xformProperties.remove(IN_EXCLUDE_ATTRS);
        } else {
            try {
                ArrayDescriptor attrNamesDesc = null;
                attrNamesDesc = ArrayDescriptor.createDescriptor((String)((this.is102() ? "DMSYS." : "SYS.") + "JDM_ATTR_NAMES"), (Connection)this.getConnection().getDatabaseConnection());
                ARRAY arr_excludeAttrs = new ARRAY(attrNamesDesc, this.getConnection().getDatabaseConnection(), (Object)excludeColumnList);
                this.m_xformProperties.put(IN_EXCLUDE_ATTRS, arr_excludeAttrs);
            }
            catch (SQLException exp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, exp);
            }
        }
    }

    public String[] getExcludeColumnList() {
        return this.m_excludedColumns;
    }

    public void setIncludeColumnList(String[] includeColumnList) {
        this.m_includedColumns = includeColumnList;
        if (includeColumnList == null) {
            this.m_xformProperties.remove(IN_INCLUDE_ATTRS);
        } else {
            try {
                ArrayDescriptor attrNamesDesc = null;
                attrNamesDesc = ArrayDescriptor.createDescriptor((String)"SYS.JDM_ATTR_NAMES", (Connection)this.getConnection().getDatabaseConnection());
                ARRAY arr_includeAttrs = new ARRAY(attrNamesDesc, this.getConnection().getDatabaseConnection(), (Object)includeColumnList);
                this.m_xformProperties.put(IN_INCLUDE_ATTRS, arr_includeAttrs);
            }
            catch (SQLException exp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, exp);
            }
        }
    }

    public String[] getIncludeColumnList() {
        return this.m_includedColumns;
    }

    public boolean isOutputView() {
        return this.m_bOutputAsView;
    }

    public String saveObjectInDatabase(OraConnection dmeConn, String name, boolean replace) throws JDMException, SQLException {
        if (replace) {
            if (this.doesObjectExist(dmeConn, name)) {
                this.removeObject(dmeConn, name);
            }
            this.cleanXformSpecificObjects(dmeConn, name);
        }
        return this.saveObjectInDatabase(dmeConn, name);
    }

    protected String saveObjectInDatabase(OraConnection dmeConn, String name) throws JDMException, SQLException {
        this.createTransformationTable(dmeConn, name);
        this.populateTransformationTables(dmeConn, name);
        return this.getStack();
    }

    protected String getStack() {
        return null;
    }

    protected abstract void populateTransformationTables(OraConnection var1, String var2) throws SQLException;

    protected abstract void createTransformationTable(OraConnection var1, String var2) throws SQLException;

    protected abstract void cleanXformSpecificObjects(OraConnection var1, String var2);

    public abstract String getSettingsTable1();

    public abstract String getSettingsTable2();

    public abstract String getType();

    String getSettingsTable1Property() {
        return null;
    }

    String getSettingsTable2Property() {
        return null;
    }

    Map getSettingsMap() {
        return this.m_xformProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesObjectExist(OraConnection dmeConn, String name) {
        String sql = "SELECT OBJECT_NAME FROM ( SELECT OBJECT_NAME FROM USER_OBJECTS WHERE " + (!this.m_bOutputAsView ? "OBJECT_TYPE='TABLE'" : "OBJECT_TYPE='VIEW' ") + " ) WHERE OBJECT_NAME = '" + OraStringUtils.processQuotedName(name) + "'";
        Connection dbConn = dmeConn.getDatabaseConnection();
        Statement stmt = null;
        ResultSet rs = null;
        boolean bExist = false;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery(sql);
            String sName = null;
            if (rs.next()) {
                sName = rs.getString(1);
            }
            if (sName != null) {
                bExist = true;
            }
        }
        catch (Exception e) {
            this.logTrace("Failed Operation: OraTransformationImpl.doesObjectExist: Object:" + name + ": ", e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp2) {}
            }
        }
        return bExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObject(OraConnection dmeConn, String name) {
        Connection dbConn = dmeConn.getDatabaseConnection();
        Statement pStmt = null;
        try {
            pStmt = dbConn.prepareStatement("DROP " + (!this.m_bOutputAsView ? " TABLE " : " VIEW ") + name);
            pStmt.execute();
        }
        catch (Exception e) {
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTable(String name) {
        Connection dbConn = this.getConnection().getDatabaseConnection();
        Statement pStmt = null;
        try {
            pStmt = dbConn.prepareStatement("DROP TABLE " + name);
            pStmt.execute();
        }
        catch (Exception e) {
        }
        finally {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    protected String getProcessedTableName() {
        String processedTableName = this.m_transformationInputData.getTableName();
        if (processedTableName.startsWith("\"") && processedTableName.endsWith("\"")) {
            return "\"" + OraStringUtils.processQuotedName(this.m_transformationInputData.getTableName()) + "\"";
        }
        return processedTableName;
    }

    protected String getProcessedSchemaName(String schemaName) {
        String processedSchemaName = schemaName;
        if (schemaName.startsWith("\"") && schemaName.endsWith("\"")) {
            processedSchemaName = "\"" + OraStringUtils.processQuotedName(schemaName) + "\"";
        }
        return processedSchemaName;
    }

    protected String getReplacedExcludedList(String inSql) {
        StringBuffer insertSql = new StringBuffer();
        if (this.m_excludedColumns == null) {
            insertSql.append(OraStringUtils.getReplacedString(inSql, "<exclude_list>", "null"));
        } else {
            String list = "dbms_data_mining_transform.column_list ( ";
            for (int i = 0; i < this.m_excludedColumns.length; ++i) {
                String processedAttrName = OraStringUtils.getReplacedString(this.m_excludedColumns[i], "'", "''");
                list = i < this.m_excludedColumns.length - 1 ? list + "'" + processedAttrName + "'," : list + "'" + processedAttrName + "'";
            }
            list = list + ")";
            insertSql.append(OraStringUtils.getReplacedString(inSql, "<exclude_list>", list));
        }
        return insertSql.toString();
    }
}

