/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task.apply;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.NamedObject;
import javax.datamining.base.Model;
import javax.datamining.data.PhysicalDataRecord;
import javax.datamining.task.apply.RecordApplyTask;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.clustering.OraClusteringApplySettings;
import oracle.dmt.jdm.data.OraPhysicalDataRecord;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionApplySettings;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.classification.OraClassificationApplySettings;
import oracle.dmt.jdm.supervised.regression.OraRegressionApplySettings;
import oracle.dmt.jdm.task.apply.OraApplySettings;
import oracle.dmt.jdm.task.apply.OraApplyTask;
import oracle.dmt.jdm.task.apply.OraRecordApplyTaskFactory;

public class OraRecordApplyTask
extends OraApplyTask
implements RecordApplyTask {
    private OraPhysicalDataRecord m_inputRecord = null;
    private Vector m_attrNames = null;
    private final String DOUBLE_QUOTES = "\"";
    private final String EMPTY = "";

    OraRecordApplyTask(OraConnection dmeConn, OraRecordApplyTaskFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, (String)null);
    }

    OraRecordApplyTask(OraConnection dmeConn, OraRecordApplyTaskFactory factory, PhysicalDataRecord applyRecord, String modelName, String applySettingsName) throws JDMException {
        super(dmeConn, (OraFactory)factory, applySettingsName);
        this.setModelName(modelName);
        this.setInputRecord(applyRecord);
    }

    protected void mapJobArgs() {
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
    }

    public PhysicalDataRecord getInputRecord() {
        return this.m_inputRecord;
    }

    public void setInputRecord(PhysicalDataRecord record) throws JDMException {
        this.getValidationHandler().validateNotNull(record, "record");
        if (!(record instanceof OraPhysicalDataRecord)) {
            this.createException(OraJDMBundleKeys.JDMR_INVALID_OBJECT_TYPE, new Object[]{"PhysicalDataRecord"}, null);
        }
        this.m_inputRecord = (OraPhysicalDataRecord)record;
    }

    public PhysicalDataRecord getOutputRecord() {
        return this.m_inputRecord;
    }

    private String toSQL() throws JDMException {
        String[] predictionSQL = this.m_applySettings.toSQL(this.m_modelName);
        this.m_attrNames = this.m_applySettings.getAttributeNames();
        StringBuffer recordApplySQL = new StringBuffer("WITH a_record AS  (");
        recordApplySQL.append(this.m_inputRecord.toSQL()).append(") ").append(predictionSQL[0]).append(predictionSQL[0].startsWith(",") ? "" : " from a_record ");
        if (predictionSQL[1] != null) {
            recordApplySQL.append(predictionSQL[1]);
        }
        return recordApplySQL.toString();
    }

    public String getTaskDescription() {
        String description = "Successful record apply task execution for ";
        if (this.m_applySettings != null) {
            if (this.m_applySettings instanceof OraClassificationApplySettings) {
                description = description + "classification";
            } else if (this.m_applySettings instanceof OraRegressionApplySettings) {
                description = description + "regression";
            } else if (this.m_applySettings instanceof OraClusteringApplySettings) {
                description = description + "clustering";
            } else if (this.m_applySettings instanceof OraFeatureExtractionApplySettings) {
                description = description + "feature extraction";
            }
        }
        return description + " model " + this.m_modelName + " and apply settings " + this.m_applySettingsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OraConnection dmeConn, Long timeout) throws JDMException {
        Model model;
        Connection dbConn = this.getDatabaseConnection();
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        if (this.m_applySettings == null) {
            this.m_applySettings = (OraApplySettings)this.getConnection().retrieveObject(this.m_applySettingsName, NamedObject.applySettings);
        }
        if (this.m_applySettings instanceof OraClassificationApplySettings && (MiningAlgorithm.decisionTree.equals((Object)(model = (Model)dmeConn.retrieveObject(this.m_modelName, NamedObject.model)).getMiningAlgorithm()) || OraMiningAlgorithm.adaptiveBayesNetwork.equals((Object)model.getMiningAlgorithm()))) {
            this.m_applySettings.enableNodeId(true);
        }
        try {
            String sqlStat = this.toSQL();
            pStmt = dbConn.prepareStatement(sqlStat);
            Map attrValMap = this.m_inputRecord.getAttributeNameValueMap();
            Collection values = attrValMap.values();
            Iterator valIt = values.iterator();
            int ix = 1;
            while (valIt.hasNext()) {
                Object value = valIt.next();
                if (value instanceof Number) {
                    pStmt.setBigDecimal(ix++, new BigDecimal(((Number)value).doubleValue()));
                    continue;
                }
                if (!(value instanceof String) && !(value instanceof Character)) continue;
                pStmt.setString(ix++, value.toString());
            }
            rs = pStmt.executeQuery();
            HashMap allPredMap = new HashMap();
            Object attrValue = null;
            int mappingType = this.m_applySettings.getAttributeMapping();
            String sqlColName = null;
            String recordAttrName = null;
            int numElements = 0;
            while (rs.next()) {
                boolean beginRanked = true;
                int rowItems = this.m_attrNames.size();
                for (int iName = 0; iName < rowItems; ++iName) {
                    sqlColName = (String)this.m_attrNames.elementAt(iName);
                    switch (mappingType) {
                        case 1: {
                            recordAttrName = sqlColName;
                            break;
                        }
                        case 2: {
                            recordAttrName = this.getSequencedAttrName(allPredMap, sqlColName);
                            break;
                        }
                        case 3: {
                            recordAttrName = this.getSequencedAttrName(allPredMap, sqlColName);
                            sqlColName = this.m_applySettings.getPredictionColName(sqlColName);
                            break;
                        }
                        case 4: {
                            if (beginRanked) {
                                rowItems = Integer.parseInt((String)this.m_attrNames.elementAt(numElements++));
                                beginRanked = false;
                            }
                            recordAttrName = (String)this.m_attrNames.elementAt(numElements++);
                            sqlColName = this.m_applySettings.getPredictionColName(recordAttrName);
                            break;
                        }
                        default: {
                            System.out.println("Invalid column type in ApplySettings " + mappingType);
                        }
                    }
                    if (sqlColName.length() > 0) {
                        String tmpStr = null;
                        tmpStr = sqlColName.substring(0, 1);
                        if ("\"".equalsIgnoreCase(tmpStr)) {
                            sqlColName = sqlColName.substring(1, sqlColName.length());
                        }
                        if ("\"".equalsIgnoreCase(tmpStr = sqlColName.substring(sqlColName.length() - 1, sqlColName.length()))) {
                            sqlColName = sqlColName.substring(0, sqlColName.length() - 1);
                        }
                    }
                    if ((attrValue = rs.getObject(sqlColName)) instanceof BigDecimal) {
                        attrValue = (BigDecimal)attrValue;
                    }
                    this.m_inputRecord.setValue(recordAttrName, attrValue);
                }
            }
        }
        catch (SQLException sqlExp) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp, "2008", new Object[]{this.getName()});
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlExp) {}
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlExp) {}
            }
        }
    }

    private String getSequencedAttrName(HashMap indexMap, String baseName) {
        int index = 0;
        Integer attrIndex = (Integer)indexMap.get(baseName);
        if (attrIndex != null) {
            index = attrIndex;
        }
        indexMap.put(baseName, new Integer(++index));
        return baseName + index;
    }
}

