/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task.apply;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.JDMException;
import javax.datamining.MiningFunction;
import javax.datamining.NamedObject;
import javax.datamining.VerificationReport;
import javax.datamining.resource.Connection;
import javax.datamining.task.apply.ApplySettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public abstract class OraApplySettings
extends OraMiningObject
implements ApplySettings {
    public static final int DEFAULT_APPLY_OUTPUT = 1;
    public static final int TARGET_OR_CLUID_APPLY_OUTPUT = 2;
    public static final int TOP_PREDICTION_APPLY_OUTPUT = 3;
    public static final int ALL_PREDICTIONS_APPLY_OUTPUT = 4;
    protected MiningFunction m_function = null;
    protected Map m_SDMap = null;
    protected Vector m_contents = null;
    protected Vector m_contentAttrNames = null;
    protected Vector m_contentAttrVals = null;
    protected int m_applyOutputMode = 1;
    protected int m_topN = 1;
    protected Map m_rankContentMap = null;
    protected String m_costMatrixName = null;
    protected int m_useCostMatrixFromModel = 0;
    protected boolean _enableNodeId = false;
    protected Vector m_attrNames = null;
    protected int m_attrMapping = 0;
    public static final int SINGLE_ROW_AS_SPECIFIED = 1;
    public static final int MULTIPLE_ROW_DEFAULT = 2;
    public static final int MULTIPLE_ROW_ALL = 3;
    public static final int MULTIPLE_ROW_RANKED = 4;

    protected abstract String[] toSQL(String var1) throws JDMException;

    public Vector getAttributeNames() {
        return this.m_attrNames;
    }

    int getAttributeMapping() {
        return this.m_attrMapping;
    }

    protected abstract String getPredictionColName(String var1);

    public void enableNodeId(boolean enable) {
        this._enableNodeId = enable;
    }

    protected String[] getDestinations() {
        if (this.m_SDMap == null || this.m_SDMap.isEmpty()) {
            return null;
        }
        String[] dests = new String[this.m_SDMap.size()];
        Set keySet = this.m_SDMap.keySet();
        Iterator keyIterator = keySet.iterator();
        int i = 0;
        while (keyIterator.hasNext()) {
            String source = (String)keyIterator.next();
            dests[i] = (String)this.m_SDMap.get(source);
            ++i;
        }
        return dests;
    }

    protected String getSourceDestination() {
        if (this.m_SDMap == null || this.m_SDMap.isEmpty()) {
            return null;
        }
        StringBuffer sdMap = new StringBuffer();
        Set keySet = this.m_SDMap.keySet();
        for (String source : keySet) {
            String destination = (String)this.m_SDMap.get(source);
            if (sdMap.length() > 0) {
                sdMap.append(", ");
            }
            sdMap.append(source + " as " + destination);
        }
        return sdMap.toString();
    }

    public VerificationReport verify() {
        return null;
    }

    public void setSourceDestinationMap(Map sourceDestinationMap) throws JDMException {
        this.getValidationHandler().validateNotNull(sourceDestinationMap, "sourceDestinationMap");
        this.m_SDMap = sourceDestinationMap;
    }

    public Map getSourceDestinationMap() {
        return this.m_SDMap;
    }

    protected OraApplySettings(OraConnection dmeConn, OraFactory factory, MiningFunction miningFunction) throws JDMException {
        super(dmeConn, factory, NamedObject.applySettings);
        this.m_function = miningFunction;
    }

    protected void saveObjectInDatabase(Connection dmeConn, String name) throws JDMException {
    }

    public NamedObject getObjectType() {
        return NamedObject.applySettings;
    }

    public MiningFunction getFunction() {
        return this.m_function;
    }

    public boolean isInputObject() {
        return true;
    }

    protected void mapByRank(Enum content, String[] destPhysAttrNameArray, boolean fromTop) throws JDMException {
        this.getValidationHandler().validateNotNull(content, "content");
        this.getValidationHandler().validateArray(destPhysAttrNameArray, "destPhysAttrNameArray");
        if (!fromTop) {
            this.unsupported("ClassificationApplySettings.mapByRank from bottom");
        }
        if (this.m_applyOutputMode != 3) {
            this.m_contents = new Vector();
            this.m_contentAttrNames = new Vector();
            this.m_contentAttrVals = new Vector();
        }
        if (this.m_contents == null) {
            this.m_contents = new Vector();
        }
        if (this.m_rankContentMap == null) {
            this.m_rankContentMap = new HashMap();
        }
        this.m_contents.add(content);
        this.m_rankContentMap.put(content, destPhysAttrNameArray);
        this.m_topN = destPhysAttrNameArray.length;
        this.m_applyOutputMode = 3;
    }

    protected void mapByCategory(Enum content, Object categoryValue, String destinationAttrName) throws JDMException {
        this.getValidationHandler().validateNotNull(content, "content");
        this.getValidationHandler().validateNotNull(categoryValue, "categoryValue");
        this.getValidationHandler().validateNotNull(destinationAttrName, "destinationAttrName");
        if (this.m_applyOutputMode != 2) {
            this.m_contents = new Vector();
            this.m_contentAttrNames = new Vector();
            this.m_contentAttrVals = new Vector();
        }
        if (this.m_contents == null) {
            this.m_contents = new Vector();
        }
        if (this.m_contentAttrNames == null) {
            this.m_contentAttrNames = new Vector();
        }
        if (this.m_contentAttrVals == null) {
            this.m_contentAttrVals = new Vector();
        }
        this.m_contents.add(content);
        this.m_contentAttrNames.add(destinationAttrName);
        this.m_contentAttrVals.add(categoryValue);
        this.m_applyOutputMode = 2;
    }

    protected void mapTopPrediction(Enum content, String destPhysAttrName) {
        this.getValidationHandler().validateNotNull(content, "content");
        this.getValidationHandler().validateNotNull(destPhysAttrName, "destPhysAttrName");
        if (this.m_applyOutputMode != 3) {
            this.m_contents = new Vector();
            this.m_contentAttrNames = new Vector();
        }
        this.m_contents.add(content);
        this.m_contentAttrNames.add(destPhysAttrName);
        this.m_applyOutputMode = 3;
    }

    protected void mapPredictions(Enum content, String baseDestPhysAttrName) {
        this.getValidationHandler().validateNotNull(content, "content");
        this.getValidationHandler().validateNotNull(baseDestPhysAttrName, "baseDestPhysAttrName");
        if (this.m_applyOutputMode != 4) {
            this.m_contents = new Vector();
            this.m_contentAttrNames = new Vector();
            this.m_contentAttrVals = new Vector();
        }
        this.m_contents.add(content);
        this.m_contentAttrNames.add(baseDestPhysAttrName);
        this.m_applyOutputMode = 4;
    }

    protected Integer getRank(String destinationAttrName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(destinationAttrName, "destinationAttrName");
        if (this.m_applyOutputMode == 3) {
            if (this.m_rankContentMap == null) {
                return null;
            }
            Collection vals = this.m_rankContentMap.values();
            for (String[] attrNames : vals) {
                for (int iAttr = 0; iAttr < attrNames.length; ++iAttr) {
                    if (!attrNames[iAttr].equals(destinationAttrName)) continue;
                    return new Integer(iAttr + 1);
                }
            }
            this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new String[]{destinationAttrName}, null);
        }
        return null;
    }

    protected Integer getRanks() {
        if (this.m_applyOutputMode == 3) {
            if (this.m_rankContentMap == null) {
                return new Integer(this.m_topN);
            }
            Collection vals = this.m_rankContentMap.values();
            Iterator iterate = vals.iterator();
            if (iterate.hasNext()) {
                String[] attrNames = (String[])iterate.next();
                return new Integer(attrNames.length);
            }
            return new Integer(this.m_topN);
        }
        return null;
    }

    protected boolean isFromTop() {
        return true;
    }

    protected Object[] getMappedCategories() {
        if (this.m_applyOutputMode == 2) {
            HashSet vals = new HashSet(this.m_contentAttrVals);
            return vals.toArray();
        }
        return null;
    }

    protected String getMappedDestinationAttrName(Enum contentType) throws JDMException {
        this.getValidationHandler().validateNotNull(contentType, "contentType");
        String attrName = null;
        if (this.m_applyOutputMode == 3) {
            for (int iContent = 0; iContent < this.m_contents.size(); ++iContent) {
                if (!contentType.equals(this.m_contents.elementAt(iContent))) continue;
                attrName = (String)this.m_contentAttrNames.elementAt(iContent);
                break;
            }
        }
        return attrName;
    }

    protected String getMappedDestinationAttrName(Object categoryValue, Enum contentType) throws JDMException {
        if (this.m_applyOutputMode == 2) {
            this.getValidationHandler().validateNotNull(categoryValue, "categoryValue");
            this.getValidationHandler().validateNotNull(contentType, "contentType");
            for (int iContent = 0; iContent < this.m_contents.size(); ++iContent) {
                if (!contentType.equals(this.m_contents.elementAt(iContent))) continue;
                if (categoryValue.equals(this.m_contentAttrVals.elementAt(iContent))) {
                    return (String)this.m_contentAttrNames.elementAt(iContent);
                }
                if (!(categoryValue instanceof Number) || ((Number)categoryValue).doubleValue() != ((Number)this.m_contentAttrVals.elementAt(iContent)).doubleValue()) continue;
                return (String)this.m_contentAttrNames.elementAt(iContent);
            }
            return null;
        }
        return null;
    }

    protected String getMappedDestinationAttrName(int rank, Enum contentType) throws JDMException {
        String[] attrNames;
        this.getValidationHandler().validateNumber(rank, 1, "rank");
        this.getValidationHandler().validateNotNull(contentType, "contentType");
        String attrName = null;
        if (this.m_applyOutputMode == 3 && this.m_rankContentMap != null && (attrNames = (String[])this.m_rankContentMap.get(contentType)) != null) {
            this.getValidationHandler().validateNumber(rank, 1, attrNames.length, "rank");
            attrName = attrNames[rank - 1];
        }
        return attrName;
    }

    protected String getMappedBaseDestinationAttributeName(Enum content) {
        if (this.m_applyOutputMode == 4) {
            this.getValidationHandler().validateNotNull(content, "content");
            for (int iContent = 0; iContent < this.m_contents.size(); ++iContent) {
                if (!content.equals(this.m_contents.elementAt(iContent))) continue;
                return (String)this.m_contentAttrNames.elementAt(iContent);
            }
            return null;
        }
        return null;
    }

    protected String[] getMappedDestinationAttributeNames(Enum content) {
        this.getValidationHandler().validateNotNull(content, "content");
        String[] destAttrNames2 = null;
        if (this.m_applyOutputMode == 3) {
            if (!this.m_rankContentMap.containsKey(content)) {
                return null;
            }
            Object[] destAttrNames = (Object[])this.m_rankContentMap.get(content);
            destAttrNames2 = new String[destAttrNames.length];
            System.arraycopy(destAttrNames, 0, destAttrNames2, 0, destAttrNames.length);
        }
        return destAttrNames2;
    }

    protected Enum getContentEnum(String destinationAttrName) throws JDMException {
        this.getValidationHandler().validateNotNull(destinationAttrName, "destinationAttrName");
        if (this.m_applyOutputMode == 1) {
            return null;
        }
        if (this.m_applyOutputMode == 3) {
            if (this.m_rankContentMap != null) {
                Set keys = this.m_rankContentMap.keySet();
                Iterator contentsIterator = keys.iterator();
                Enum currContent = null;
                while (contentsIterator.hasNext()) {
                    currContent = (Enum)contentsIterator.next();
                    String[] attrNames = (String[])this.m_rankContentMap.get(currContent);
                    for (int iAttr = 0; iAttr < attrNames.length; ++iAttr) {
                        if (!attrNames[iAttr].equals(destinationAttrName)) continue;
                        return currContent;
                    }
                }
                return null;
            }
            if (this.m_contents != null) {
                for (int i = 0; i < this.m_contentAttrNames.size(); ++i) {
                    if (destinationAttrName.compareToIgnoreCase((String)this.m_contentAttrNames.get(i)) != 0) continue;
                    return (Enum)this.m_contents.get(i);
                }
            }
        } else {
            if (this.m_applyOutputMode == 4) {
                if (this.m_contentAttrNames == null || this.m_contents == null) {
                    return null;
                }
                for (int iAttr = 0; iAttr < this.m_contentAttrNames.size(); ++iAttr) {
                    if (!this.m_contentAttrNames.elementAt(iAttr).equals(destinationAttrName)) continue;
                    return (Enum)this.m_contents.elementAt(iAttr);
                }
                return null;
            }
            if (this.m_applyOutputMode == 2) {
                if (this.m_contentAttrNames == null || this.m_contents == null) {
                    return null;
                }
                for (int iAttr = 0; iAttr < this.m_contentAttrNames.size(); ++iAttr) {
                    if (!this.m_contentAttrNames.elementAt(iAttr).equals(destinationAttrName)) continue;
                    return (Enum)this.m_contents.elementAt(iAttr);
                }
                return null;
            }
        }
        return null;
    }

    protected Object[] getContentsByRankEnums(int rank) throws JDMException {
        if (this.m_rankContentMap != null && this.m_applyOutputMode == 3) {
            Set keys = this.m_rankContentMap.keySet();
            return keys.toArray();
        }
        return null;
    }

    protected Object[] getContentsByCategoryEnums(Object categoryValue) throws JDMException {
        if (this.m_applyOutputMode == 2) {
            if (this.m_contents == null || this.m_contentAttrVals == null) {
                return null;
            }
            Vector enumVector = new Vector();
            for (int iVal = 0; iVal < this.m_contentAttrVals.size(); ++iVal) {
                if (categoryValue instanceof Number && this.m_contentAttrVals.elementAt(iVal) instanceof Number) {
                    if (((Number)categoryValue).doubleValue() != ((Number)this.m_contentAttrVals.elementAt(iVal)).doubleValue()) continue;
                    enumVector.add(this.m_contents.elementAt(iVal));
                    continue;
                }
                if (!categoryValue.equals(this.m_contentAttrVals.elementAt(iVal))) continue;
                enumVector.add(this.m_contents.elementAt(iVal));
            }
            return enumVector.toArray();
        }
        return null;
    }

    protected void setCostMatrixName(String costMatrixName) throws JDMException {
        this.getValidationHandler().validateObjectName(costMatrixName, "costMatrixName", NamedObject.costMatrix);
        this.m_costMatrixName = costMatrixName;
    }

    protected String getCostMatrixName() {
        return this.m_costMatrixName;
    }

    protected int useCMFromModel() {
        return this.m_useCostMatrixFromModel;
    }

    protected void useCMFromModel(int useCMFromModel) {
        this.m_useCostMatrixFromModel = useCMFromModel;
    }

    public void resetMapping() {
        this.m_applyOutputMode = 1;
        this.m_contents = null;
        this.m_contentAttrNames = null;
        this.m_contentAttrVals = null;
    }

    public Object[] getMappedContentsEnums() {
        if (this.m_contents != null) {
            return this.m_contents.toArray();
        }
        return null;
    }

    public Object getContentAttrValue(String destPhysAttrName) {
        this.getValidationHandler().validateTableColumnName(destPhysAttrName, "destPhysAttrName");
        if (this.m_applyOutputMode == 2) {
            if (this.m_contentAttrVals == null || this.m_contentAttrNames == null) {
                return null;
            }
            for (int iAttr = 0; iAttr < this.m_contentAttrNames.size(); ++iAttr) {
                if (!destPhysAttrName.equals(this.m_contentAttrNames.elementAt(iAttr))) continue;
                return this.m_contentAttrVals.elementAt(iAttr);
            }
        }
        return null;
    }
}

