/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Vector;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraTransformationTask;
import oracle.dmt.jdm.task.OraTransformationTaskFactoryImpl;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.OraTransformationImpl;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.binning.OraBinningTransformFactory;
import oracle.dmt.jdm.transform.clipping.OraClippingTransform;
import oracle.dmt.jdm.transform.clipping.OraClippingTransformFactory;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformFactory;
import oracle.dmt.jdm.transform.text.OraTextTransform;
import oracle.dmt.jdm.transform.text.OraTextTransformFactory;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class OraTransformationTaskImpl
extends OraTask
implements OraTransformationTask {
    private OraTransformationImpl m_xform = null;
    private String m_xformType = null;
    private OraDataURI m_outputURI = null;
    private OraDataURI m_inputURI = null;
    private boolean m_isViewOutput = true;
    private OraDataURI m_settings1URI = null;
    private OraDataURI m_settings2URI = null;
    private boolean m_binningLiteralFlag = false;
    private String m_caseId = null;
    private String[] m_textCols = null;
    private String[] m_featureTables = null;
    private OraDataURI m_xform_seq = null;
    private String m_useTransformDefitionTables = "Y";
    private static final int ARG_IX_XFORM_TYPE = 0;
    private static final int ARG_IX_OUTPUT_TABLE_NAME = 1;
    private static final int ARG_IX_INPUT_TABLE_NAME = 2;
    private static final int ARG_IX_IS_VIEW_OUTPUT = 3;
    private static final int ARG_IX_XFORM_SETTINGS_TABLE_1 = 4;
    private static final int ARG_IX_XFORM_SETTINGS_TABLE_2 = 5;
    private static final int ARG_IX_OUTPUT_SCHEMA_NAME = 6;
    private static final int ARG_IX_INPUT_SCHEMA_NAME = 7;
    private static final int ARG_IX_XFORM_SETTINGS_SCHEMA_1 = 8;
    private static final int ARG_IX_XFORM_SETTINGS_SCHEMA_2 = 9;
    private static final int ARG_IX_BINNING_LITERAL_FALG = 10;
    private static final int ARG_IX_TEXT_COLS = 11;
    private static final int ARG_IX_CASE_ID = 12;
    private static final int ARG_IX_FEATURE_TABLES = 13;
    private static final String ARG_XFORM_TYPE = "XFORM_TYPE";
    private static final String ARG_OUTPUT_TABLE_NAME = "OUTPUT_TABLE_NAME";
    private static final String ARG_INPUT_TABLE_NAME = "INPUT_TABLE_NAME";
    private static final String ARG_IS_VIEW_OUTPUT = "IS_VIEW_OUTPUT";
    private static final String ARG_XFORM_SETTINGS_TABLE_1 = "XFORM_SETTINGS_TABLE_1";
    private static final String ARG_XFORM_SETTINGS_TABLE_2 = "XFORM_SETTINGS_TABLE_2";
    private static final String ARG_OUTPUT_SCHEMA_NAME = "OUTPUT_SCHEMA_NAME";
    private static final String ARG_INPUT_SCHEMA_NAME = "INPUT_SCHEMA_NAME";
    private static final String ARG_XFORM_SETTINGS_SCHEMA_1 = "XFORM_SETTINGS_SCHEMA_1";
    private static final String ARG_XFORM_SETTINGS_SCHEMA_2 = "XFORM_SETTINGS_SCHEMA_2";
    private static final String ARG_BINNING_LITERAL_FALG = "BINNING_LITERAL_FALG";
    private static final String ARG_TEXT_COLS = "TEXT_COLS";
    private static final String ARG_CASE_ID = "CASE_ID";
    private static final String ARG_FEATURE_TABLES = "FEATURE_TABLES";
    public static final String BINNING_XFORM = "BINNING";
    public static final String NORMALIZE_XFORM = "NORMALIZE";
    public static final String CLIPPING_XFORM = "CLIPPING";
    public static final String TEXT_XFORM = "TEXT";
    private static final int ARG_IX_XSS_XFORM_SEQ_TABLE_NAME = 0;
    private static final int ARG_IX_XSS_USE_XFORM_DEF_TABLES = 1;
    private static final int ARG_IX_XSS_XFORM_SEQ_SCHEMA_NAME = 2;
    private static final String ARG_XSS_XFORM_SEQ_TABLE_NAME = "XFORM_SEQ_TABLE_NAME";
    private static final String ARG_XSS_USE_XFORM_DEF_TABLES = "USE_XFORM_DEF_TABLES";
    private static final String ARG_XSS_XFORM_SEQ_SCHEMA_NAME = "XFORM_SEQ_SCHEMA_NAME";

    public OraTransformationTaskImpl(OraConnection dmeConn, OraTransformationTaskFactoryImpl factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, XFORM_PROGRAM);
        this.ARG_IX_OVERWRITE_OUTPUT = 14;
        this.ARG_IX_PARENT_TASKS = 15;
        this.ARG_IX_CHILD_TASKS = 16;
    }

    public OraTransformationTaskImpl(OraConnection dmeConn, OraTransformationTaskFactoryImpl factory, String programName) throws JDMException {
        super(dmeConn, (OraFactory)factory, programName);
        if (programName.equals(XFORM_PROGRAM)) {
            this.ARG_IX_OVERWRITE_OUTPUT = 14;
            this.ARG_IX_PARENT_TASKS = 15;
            this.ARG_IX_CHILD_TASKS = 16;
        } else {
            this.ARG_IX_OVERWRITE_OUTPUT = 3;
            this.ARG_IX_PARENT_TASKS = 4;
            this.ARG_IX_CHILD_TASKS = 5;
        }
    }

    public OraTransformationTaskImpl(OraConnection dmeConn, OraTransformationTaskFactoryImpl factory, OraTransformation transform) throws JDMException {
        super(dmeConn, (OraFactory)factory, XFORM_PROGRAM);
        this.setTransformation(transform);
        this.ARG_IX_OVERWRITE_OUTPUT = 14;
        this.ARG_IX_PARENT_TASKS = 15;
        this.ARG_IX_CHILD_TASKS = 16;
    }

    public OraTransformationTaskImpl(OraConnection dmeConn, OraTransformationTaskFactoryImpl factory, String transformSeq, boolean useTransformDefintionTables) throws JDMException {
        super(dmeConn, (OraFactory)factory, XFORM_SEQ_PROGRAM);
        this.setTransformationSequence(transformSeq, useTransformDefintionTables);
        this.ARG_IX_OVERWRITE_OUTPUT = 3;
        this.ARG_IX_PARENT_TASKS = 4;
        this.ARG_IX_CHILD_TASKS = 5;
    }

    public void setTransformation(OraTransformation transform) {
        this.m_xform = (OraTransformationImpl)transform;
        this.m_inputURI = new OraDataURI(this.m_xform.getTransformInputData());
        this.m_outputURI = new OraDataURI(this.m_xform.getTransformOutputData());
        this.m_settings1URI = new OraDataURI(this.m_xform.getSettingsTable1());
        this.m_settings2URI = new OraDataURI(this.m_xform.getSettingsTable2());
        this.m_isViewOutput = this.m_xform.isOutputView();
        this.m_xformType = this.m_xform.getType();
        if (this.m_xformType.equals(BINNING_XFORM)) {
            this.m_binningLiteralFlag = ((OraBinningTransform)((Object)this.m_xform)).getLiteralFlag();
        }
        if (this.m_xformType.equals(TEXT_XFORM)) {
            OraTextTransform txtXForm = (OraTextTransform)((Object)this.m_xform);
            this.m_caseId = txtXForm.getCaseId();
        }
    }

    public OraTransformation getTransformation() {
        if (this.m_xform == null) {
            try {
                if (this.m_xformType.equals(BINNING_XFORM)) {
                    OraBinningTransformFactory binningFactory = (OraBinningTransformFactory)this.getConnection().getFactory("oracle.dmt.jdm.transform.binning.OraBinningTransform");
                    OraBinningTransform binningXform = binningFactory.create(this.m_inputURI.getURI(), this.m_outputURI.getURI(), this.m_isViewOutput, this.m_settings2URI.getURI(), this.m_settings1URI.getURI());
                    binningXform.setLiteralFlag(this.m_binningLiteralFlag);
                    this.m_xform = (OraTransformationImpl)((Object)binningXform);
                } else if (this.m_xformType.equals(NORMALIZE_XFORM)) {
                    OraNormalizeTransformFactory normalizeFactory = (OraNormalizeTransformFactory)this.getConnection().getFactory("oracle.dmt.jdm.transform.normalize.OraNormalizeTransform");
                    OraNormalizeTransform normalizeXform = normalizeFactory.create(this.m_inputURI.getURI(), this.m_outputURI.getURI(), this.m_isViewOutput, this.m_settings1URI.getURI());
                    this.m_xform = (OraTransformationImpl)((Object)normalizeXform);
                } else if (this.m_xformType.equals(CLIPPING_XFORM)) {
                    OraClippingTransformFactory clippingFactory = (OraClippingTransformFactory)this.getConnection().getFactory("oracle.dmt.jdm.transform.clipping.OraClippingTransform");
                    OraClippingTransform clippingXform = clippingFactory.create(this.m_inputURI.getURI(), this.m_outputURI.getURI(), this.m_isViewOutput, this.m_settings1URI.getURI());
                    this.m_xform = (OraTransformationImpl)((Object)clippingXform);
                } else if (this.m_xformType.equals(TEXT_XFORM)) {
                    OraTextTransformFactory textFactory = (OraTextTransformFactory)this.getConnection().getFactory("oracle.dmt.jdm.transform.text.OraTextTransform");
                    OraTextTransform textXform = textFactory.create(this.m_inputURI.getURI(), this.m_outputURI.getURI(), this.m_caseId, this.m_textCols, this.m_featureTables);
                    this.m_xform = (OraTransformationImpl)((Object)textXform);
                }
            }
            catch (Exception anyExp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, anyExp);
            }
        }
        return this.m_xform;
    }

    public void setTransformationSequence(String transformSeq, boolean useTransformDefitionTables) {
        this.m_xform_seq = new OraDataURI(transformSeq);
        this.m_useTransformDefitionTables = useTransformDefitionTables ? "Y" : "N";
    }

    public String getTransformationSequence() {
        return this.m_xform_seq.getURI();
    }

    public boolean useTransformDefitionTables() {
        return this.m_useTransformDefitionTables.equalsIgnoreCase("Y");
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        if (XFORM_PROGRAM.equals(this.m_programName) || this.is102()) {
            this.prepareJobArgumentsXformTask(taskName);
        } else {
            this.prepareJobArgumentsXformSeqTask(taskName);
        }
    }

    private void prepareJobArgumentsXformSeqTask(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_XSS_XFORM_SEQ_TABLE_NAME, this.m_xform_seq.getTableName(), new Integer(12)}, new Object[]{ARG_XSS_USE_XFORM_DEF_TABLES, this.m_useTransformDefitionTables, new Integer(12)}, new Object[]{ARG_XSS_XFORM_SEQ_SCHEMA_NAME, this.m_xform_seq.getSchemaName(), new Integer(12)}));
    }

    private void prepareJobArgumentsXformTask(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        String isViewOutput = null;
        isViewOutput = this.m_isViewOutput ? "Y" : "N";
        String binningLiteralFlag = null;
        binningLiteralFlag = this.m_binningLiteralFlag ? "Y" : "N";
        ARRAY arr_txtCols = null;
        ARRAY arr_featureTables = null;
        if (this.m_xform.getType().equalsIgnoreCase(TEXT_XFORM)) {
            this.m_textCols = ((OraTextTransform)((Object)this.m_xform)).getTextColumnNames();
            this.m_featureTables = ((OraTextTransform)((Object)this.m_xform)).getFeatureTables();
            try {
                ArrayDescriptor attrNamesDesc = ArrayDescriptor.createDescriptor((String)(this.installedSchema + ".JDM_ATTR_NAMES"), (Connection)dbConn);
                arr_txtCols = new ARRAY(attrNamesDesc, dbConn, (Object)this.m_textCols);
                arr_featureTables = new ARRAY(attrNamesDesc, dbConn, (Object)this.m_featureTables);
            }
            catch (SQLException sqlExp) {
                this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, sqlExp);
            }
        }
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_XFORM_TYPE, this.m_xformType, new Integer(12)}, new Object[]{ARG_OUTPUT_TABLE_NAME, this.m_outputURI.getTableName(), new Integer(12)}, new Object[]{ARG_INPUT_TABLE_NAME, this.m_inputURI.getTableName(), new Integer(12)}, new Object[]{ARG_IS_VIEW_OUTPUT, isViewOutput, new Integer(12)}, new Object[]{ARG_XFORM_SETTINGS_TABLE_1, this.m_settings1URI.getTableName(), new Integer(12)}, new Object[]{ARG_XFORM_SETTINGS_TABLE_2, this.m_settings2URI.getTableName(), new Integer(12)}, new Object[]{ARG_OUTPUT_SCHEMA_NAME, this.m_outputURI.getSchemaName(), new Integer(12)}, new Object[]{ARG_INPUT_SCHEMA_NAME, this.m_inputURI.getSchemaName(), new Integer(12)}, new Object[]{ARG_XFORM_SETTINGS_SCHEMA_1, this.m_settings1URI.getSchemaName(), new Integer(12)}, new Object[]{ARG_XFORM_SETTINGS_SCHEMA_2, this.m_settings2URI.getSchemaName(), new Integer(12)}, new Object[]{ARG_BINNING_LITERAL_FALG, binningLiteralFlag, new Integer(12)}, new Object[]{ARG_TEXT_COLS, arr_txtCols, new Integer(2003)}, new Object[]{ARG_CASE_ID, this.m_caseId, new Integer(12)}, new Object[]{ARG_FEATURE_TABLES, arr_featureTables, new Integer(2003)}));
    }

    protected void mapJobArgs() {
        if (XFORM_PROGRAM.equals(this.m_programName)) {
            this.mapJobArgsXformTask();
        } else {
            this.mapJobArgsXformSeqTask();
        }
    }

    private void mapJobArgsXformSeqTask() {
        if (this.m_jobArgs != null) {
            this.m_useTransformDefitionTables = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_xform_seq = new OraDataURI((String)((Object[])this.m_jobArgs.get(0))[1], (String)((Object[])this.m_jobArgs.get(2))[1]);
        }
    }

    private void mapJobArgsXformTask() {
        if (this.m_jobArgs != null) {
            this.m_xformType = (String)((Object[])this.m_jobArgs.get(0))[1];
            this.m_outputURI = new OraDataURI((String)((Object[])this.m_jobArgs.get(1))[1], (String)((Object[])this.m_jobArgs.get(6))[1]);
            this.m_inputURI = new OraDataURI((String)((Object[])this.m_jobArgs.get(2))[1], (String)((Object[])this.m_jobArgs.get(7))[1]);
            String isViewOutput = (String)((Object[])this.m_jobArgs.get(3))[1];
            this.m_isViewOutput = isViewOutput == null || isViewOutput == "Y";
            this.m_settings1URI = new OraDataURI((String)((Object[])this.m_jobArgs.get(4))[1], (String)((Object[])this.m_jobArgs.get(8))[1]);
            this.m_settings2URI = new OraDataURI((String)((Object[])this.m_jobArgs.get(5))[1], (String)((Object[])this.m_jobArgs.get(9))[1]);
            String binningLiteralFlag = (String)((Object[])this.m_jobArgs.get(10))[1];
            this.m_binningLiteralFlag = binningLiteralFlag == null || binningLiteralFlag == "Y";
            if (this.m_xformType.equals(TEXT_XFORM)) {
                this.m_caseId = (String)((Object[])this.m_jobArgs.get(12))[1];
                try {
                    String jobName = this.getJob().getName();
                    this.m_textCols = this.getJDM_ATTR_NAMES(jobName, 12);
                    this.m_featureTables = this.getJDM_ATTR_NAMES(jobName, 14);
                }
                catch (SQLException sqlExp) {
                    this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
                }
            }
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
        if (XFORM_PROGRAM.equals(this.m_programName)) {
            try {
                this.m_xform.saveObjectInDatabase(this.getConnection(), taskName, true);
                this.m_inputURI = new OraDataURI(this.m_xform.getTransformInputData());
                this.m_outputURI = new OraDataURI(this.m_xform.getTransformOutputData());
                this.m_settings1URI = new OraDataURI(this.m_xform.getSettingsTable1());
                this.m_settings2URI = new OraDataURI(this.m_xform.getSettingsTable2());
                this.m_isViewOutput = this.m_xform.isOutputView();
                this.m_xformType = this.m_xform.getType();
                if (this.m_xformType.equals(BINNING_XFORM)) {
                    this.m_binningLiteralFlag = ((OraBinningTransform)((Object)this.m_xform)).getLiteralFlag();
                }
            }
            catch (Exception anyExp) {
                this.createException("2000", new Object[]{"save"}, anyExp);
            }
        }
    }

    protected void removeTaskNonJobContents(OraConnection dmeConn) throws JDMException {
    }
}

