/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Vector;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraPredictiveAnalyticsTaskFactoryImpl;
import oracle.dmt.jdm.task.OraSegmentTask;

public class OraSegmentTaskImpl
extends OraTask
implements OraSegmentTask {
    private OraDataURI m_inputURI = null;
    private OraDataURI m_outputSegmentDetailsURI = null;
    private OraDataURI m_outputSegmentResultURI = null;
    private String m_caseID = null;
    private Integer m_numberOfSegments = null;
    private Integer m_maxDescriptionAttributes = null;
    private static final String ARG_DATA_TABLE_NAME = "DATA_TABLE_NAME";
    private static final String ARG_CASE_ID_COLUMN_NAME = "CASE_ID_COLUMN_NAME";
    private static final String ARG_SEGMENT_RESULT_TABLE_NAME = "SEGMENT_RESULT_TABLE_NAME";
    private static final String ARG_DETAILS_RESULT_TABLE_NAME = "DETAILS_RESULT_TABLE_NAME";
    private static final String ARG_NUMBER_OF_SEGMENTS = "NUMBER_OF_SEGMENTS";
    private static final String ARG_MAX_DESCRIPTIVE_ATTRIBUTES = "MAX_DESCRIPTIVE_ATTRIBUTES";
    private static final String ARG_DATA_SCHEMA_NAME = "DATA_SCHEMA_NAME";
    private static final int ARG_IX_DATA_TABLE_NAME = 0;
    private static final int ARG_IX_CASE_ID_COLUMN_NAME = 1;
    private static final int ARG_IX_SEGMENT_RESULT_TABLE_NAME = 2;
    private static final int ARG_IX_DETAILS_RESULT_TABLE_NAME = 3;
    private static final int ARG_IX_NUMBER_OF_SEGMENTS = 4;
    private static final int ARG_IX_MAX_DESCRIPTIVE_ATTRIBUTES = 5;
    private static final int ARG_IX_DATA_SCHEMA_NAME = 6;

    public OraSegmentTaskImpl(OraConnection dmeConn, OraPredictiveAnalyticsTaskFactoryImpl factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, SEGMENT_PROGRAM);
    }

    public String getInputData() {
        return this.m_inputURI.getURI();
    }

    public void setInputData(String dataURI, String caseID) {
        this.m_inputURI = new OraDataURI(dataURI);
        this.m_caseID = caseID;
    }

    public String getSegmentResultTableName() {
        return this.m_outputSegmentResultURI == null ? null : this.m_outputSegmentResultURI.getURI();
    }

    public void setSegmentResultTableName(String segmentResultTableName) {
        this.m_outputSegmentResultURI = new OraDataURI(segmentResultTableName);
    }

    public String getSegmentDetailsTableName() {
        return this.m_outputSegmentDetailsURI == null ? null : this.m_outputSegmentDetailsURI.getURI();
    }

    public void setSegmentDetailsTableName(String segmentDetailsTableName) {
        this.m_outputSegmentDetailsURI = new OraDataURI(segmentDetailsTableName);
    }

    public void setNumberOfSegments(Integer numberOfSegments) {
        this.m_numberOfSegments = numberOfSegments;
    }

    public Integer getNumberOfSegments() {
        return this.m_numberOfSegments;
    }

    public void setMaximumDescriptionAttributes(Integer maxDescriptionAttributes) {
        this.m_maxDescriptionAttributes = maxDescriptionAttributes;
    }

    public Integer getMaximumDescriptionAttributes() {
        return this.m_maxDescriptionAttributes;
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList({ARG_DATA_TABLE_NAME, this.m_inputURI.getTableName(), new Integer(12)}, {ARG_CASE_ID_COLUMN_NAME, this.m_caseID, new Integer(12)}, {ARG_SEGMENT_RESULT_TABLE_NAME, this.m_outputSegmentResultURI == null ? null : this.m_outputSegmentResultURI.getTableName(), new Integer(12)}, {ARG_DETAILS_RESULT_TABLE_NAME, this.m_outputSegmentDetailsURI == null ? null : this.m_outputSegmentDetailsURI.getTableName(), new Integer(12)}, {ARG_NUMBER_OF_SEGMENTS, this.m_numberOfSegments == null ? null : this.m_numberOfSegments, new Integer(4)}, {ARG_MAX_DESCRIPTIVE_ATTRIBUTES, this.m_maxDescriptionAttributes == null ? null : this.m_maxDescriptionAttributes, new Integer(4)}, {ARG_DATA_SCHEMA_NAME, this.m_inputURI.getSchemaName(), new Integer(12)}));
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            this.m_inputURI = new OraDataURI((String)((Object[])this.m_jobArgs.get(0))[1], (String)((Object[])this.m_jobArgs.get(6))[1]);
            this.m_caseID = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_outputSegmentResultURI = ((Object[])this.m_jobArgs.get(2))[1] == null ? null : new OraDataURI((String)((Object[])this.m_jobArgs.get(2))[1]);
            this.m_outputSegmentDetailsURI = ((Object[])this.m_jobArgs.get(3))[1] == null ? null : new OraDataURI((String)((Object[])this.m_jobArgs.get(3))[1]);
            this.m_numberOfSegments = ((Object[])this.m_jobArgs.get(4))[1] == null ? null : new Integer(((BigDecimal)((Object[])this.m_jobArgs.get(4))[1]).intValue());
            this.m_maxDescriptionAttributes = ((Object[])this.m_jobArgs.get(5))[1] == null ? null : new Integer(((BigDecimal)((Object[])this.m_jobArgs.get(5))[1]).intValue());
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }
}

