/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import javax.datamining.JDMException;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.dmt.jdm.task.OraDetectTask;
import oracle.dmt.jdm.task.OraExplainTask;
import oracle.dmt.jdm.task.OraExplainTaskImpl;
import oracle.dmt.jdm.task.OraPredictTask;
import oracle.dmt.jdm.task.OraPredictTaskImpl;
import oracle.dmt.jdm.task.OraPredictiveAnalyticsTaskFactory;
import oracle.dmt.jdm.task.OraProfileTask;
import oracle.dmt.jdm.task.OraProfileTaskImpl;
import oracle.dmt.jdm.task.OraSegmentTask;

public class OraPredictiveAnalyticsTaskFactoryImpl
extends OraFactory
implements OraPredictiveAnalyticsTaskFactory {
    public OraPredictTask createPredictTask(String inputDataURI, String caseID, String targetColumn, String predictionResultTableName) throws JDMException {
        OraValidationHandler validate = this.m_dmeConn.getValidationHandler();
        validate.validateNotNull(inputDataURI, "inputDataURI");
        validate.validateTableColumnName(caseID, "caseID");
        validate.validateTableColumnName(targetColumn, "targetColumn");
        validate.validateNotNull(predictionResultTableName, "outputDataURI");
        OraPredictTaskImpl task = new OraPredictTaskImpl(this.m_dmeConn, this);
        task.setInputData(inputDataURI, caseID);
        task.setOutputData(predictionResultTableName);
        task.setTargetAttributeName(targetColumn);
        return task;
    }

    public OraExplainTask createExplainTask(String inputDataURI, String explainAttributeName, String explainResultTableName) throws JDMException {
        OraValidationHandler validate = this.m_dmeConn.getValidationHandler();
        validate.validateNotNull(inputDataURI, "inputDataURI");
        validate.validateTableColumnName(explainAttributeName, "explainAttributeName");
        validate.validateNotNull(explainResultTableName, "outputDataURI");
        OraExplainTaskImpl task = new OraExplainTaskImpl(this.m_dmeConn, this);
        task.setInputData(inputDataURI);
        task.setOutputData(explainResultTableName);
        task.setExplainAttributeName(explainAttributeName);
        return task;
    }

    public OraSegmentTask createSegmentTask(String inputDataURI, String caseID, String segmentDetailsTableName, String segmentResultTableName, Integer numberOfSegments, Integer maxDescriptionAttributes) throws JDMException {
        return null;
    }

    public OraDetectTask createDetectTask(String inputDataURI, String caseID, String detectDetailsTableName, String detectResultTableName, Double detectionRate, Integer maxDescriptionAttributes) throws JDMException {
        return null;
    }

    public OraProfileTask createProfileTask(String inputDataURI, String targetAttributeName, String profileResultTableName) throws JDMException {
        OraValidationHandler validate = this.m_dmeConn.getValidationHandler();
        validate.validateNotNull(inputDataURI, "inputDataURI");
        validate.validateTableColumnName(targetAttributeName, "targetAttributeName");
        validate.validateNotNull(profileResultTableName, "profileResultTableName");
        OraProfileTaskImpl task = new OraProfileTaskImpl(this.m_dmeConn, this);
        task.setInputData(inputDataURI);
        task.setProfileResultTableName(profileResultTableName);
        task.setTargetAttributeName(targetAttributeName);
        return task;
    }
}

