/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import java.util.Arrays;
import java.util.Vector;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraPredictTask;
import oracle.dmt.jdm.task.OraPredictTaskFactoryImpl;
import oracle.dmt.jdm.task.OraPredictiveAnalyticsTaskFactoryImpl;

public class OraPredictTaskImpl
extends OraTask
implements OraPredictTask {
    private OraDataURI m_inputURI = null;
    private OraDataURI m_outputURI = null;
    private String m_caseID = null;
    private String m_targetAttributeName = null;
    private static final String ARG_DATA_TABLE_NAME = "DATA_TABLE_NAME";
    private static final String ARG_CASE_ID_COLUMN_NAME = "CASE_ID_COLUMN_NAME";
    private static final String ARG_TARGET_COLUMN_NAME = "TARGET_COLUMN_NAME";
    private static final String ARG_RESULT_TABLE_NAME = "RESULT_TABLE_NAME";
    private static final String ARG_DATA_SCHEMA_NAME = "DATA_SCHEMA_NAME";
    private static final int ARG_IX_DATA_TABLE_NAME = 0;
    private static final int ARG_IX_CASE_ID_COLUMN_NAME = 1;
    private static final int ARG_IX_TARGET_COLUMN_NAME = 2;
    private static final int ARG_IX_RESULT_TABLE_NAME = 3;
    private static final int ARG_IX_DATA_SCHEMA_NAME = 4;

    public OraPredictTaskImpl(OraConnection dmeConn, OraPredictTaskFactoryImpl factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, PREDICT_PROGRAM);
        this.ARG_IX_OVERWRITE_OUTPUT = 5;
        this.ARG_IX_PARENT_TASKS = 6;
        this.ARG_IX_CHILD_TASKS = 7;
    }

    public OraPredictTaskImpl(OraConnection dmeConn, OraPredictiveAnalyticsTaskFactoryImpl factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, PREDICT_PROGRAM);
    }

    public String getInputData() {
        return this.m_inputURI.getURI();
    }

    public void setInputData(String dataURI, String caseID) {
        this.m_inputURI = new OraDataURI(dataURI);
        this.m_caseID = caseID;
    }

    public String getOutputData() {
        return this.m_outputURI.getURI();
    }

    public void setOutputData(String dataURI) {
        this.m_outputURI = new OraDataURI(dataURI);
    }

    public void setTargetAttributeName(String targetAttributeName) {
        this.m_targetAttributeName = targetAttributeName;
    }

    public String getTargetAttributeName() {
        return this.m_targetAttributeName;
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_DATA_TABLE_NAME, this.m_inputURI.getTableName(), new Integer(12)}, new Object[]{ARG_CASE_ID_COLUMN_NAME, this.m_caseID, new Integer(12)}, new Object[]{ARG_TARGET_COLUMN_NAME, this.m_targetAttributeName, new Integer(12)}, new Object[]{ARG_RESULT_TABLE_NAME, this.m_outputURI.getTableName(), new Integer(12)}, new Object[]{ARG_DATA_SCHEMA_NAME, this.m_inputURI.getSchemaName(), new Integer(12)}));
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            this.m_inputURI = new OraDataURI((String)((Object[])this.m_jobArgs.get(0))[1], (String)((Object[])this.m_jobArgs.get(4))[1]);
            this.m_outputURI = new OraDataURI((String)((Object[])this.m_jobArgs.get(3))[1]);
            this.m_caseID = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_targetAttributeName = (String)((Object[])this.m_jobArgs.get(2))[1];
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }
}

