/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.datamining.Enum;
import javax.datamining.ImportExportFormat;
import javax.datamining.JDMException;
import javax.datamining.MiningTask;
import javax.datamining.NamedObject;
import javax.datamining.VerificationReport;
import javax.datamining.task.ExportTask;
import javax.datamining.task.SettingsInclusionOption;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraSupportedEnums;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraExportTaskFactory;

public class OraExportTask
extends OraTask
implements ExportTask {
    private Vector m_modelNameVector = new Vector();
    private File m_exportFile = null;
    private ImportExportFormat m_ieFormat = ImportExportFormat.systemDefault;
    private SettingsInclusionOption m_settingsInclusionOption = SettingsInclusionOption.settingsOnly;
    private OraSupportedEnums supportedInclusionOptions = new OraSupportedEnums(new Enum[]{SettingsInclusionOption.systemDefault, SettingsInclusionOption.settingsOnly});
    private static final int ARG_IX_FILE_NAME = 0;
    private static final int ARG_IX_DIRECTORY_NAME = 1;
    private static final int ARG_IX_MODEL_FILTER = 2;
    private static final int ARG_IX_FILE_SIZE = 3;
    private static final int ARG_IX_OPERATION = 4;
    private static final int ARG_IX_REMOTE_LINK = 5;
    private static final int ARG_IX_JOB_NAME = 6;
    private static final String ARG_FILE_NAME = "filename";
    private static final String ARG_DIRECTORY_NAME = "directory";
    private static final String ARG_MODEL_FILTER = "model_filter";
    private static final String ARG_FILE_SIZE = "filesize";
    private static final String ARG_OPERATION = "operation";
    private static final String ARG_REMOTE_LINK = "remote_link";
    private static final String ARG_JOB_NAME = "jobname";
    private static final String MODEL_NAME_IN = "name IN (";

    public void addObjectName(String name, NamedObject namedObjectType) throws JDMException {
        this.getValidationHandler().validateNotNull(namedObjectType, "namedObjectType");
        this.getValidationHandler().validateObjectName(name, "name", namedObjectType);
        OraFactory factory = null;
        factory = this.getFactory();
        if (factory != null && !namedObjectType.equals((Object)NamedObject.model)) {
            this.unsupported("ExportTask for " + namedObjectType.name());
        }
        this.m_modelNameVector.add(name);
    }

    public void removeObjectName(String name, NamedObject namedObjectType) throws JDMException {
        this.getValidationHandler().validateNotNull(namedObjectType, "namedObjectType");
        this.getValidationHandler().validateObjectName(name, "name", namedObjectType);
        OraFactory factory = null;
        factory = this.getFactory();
        if (factory != null && !namedObjectType.equals((Object)NamedObject.model)) {
            this.unsupported("ExportTask for " + namedObjectType.name());
        }
        this.m_modelNameVector.remove(name);
    }

    public String getURI() {
        if (this.m_exportFile == null) {
            return null;
        }
        return this.m_exportFile.getAbsolutePath();
    }

    public void setURI(String uri) throws JDMException {
        this.getValidationHandler().validateNotNull(uri, "uri");
        this.m_exportFile = new File(uri);
    }

    public ImportExportFormat getFormat() {
        return this.m_ieFormat;
    }

    public void setFormat(ImportExportFormat format) {
        OraFactory factory = null;
        factory = this.getFactory();
        if (factory != null) {
            try {
                boolean isSupportedFormat = ((OraExportTaskFactory)factory).supportsCapability(NamedObject.model, format);
                if (!isSupportedFormat) {
                    this.unsupported("ExportTask for " + format.name());
                }
                this.m_ieFormat = format;
            }
            catch (JDMException jDMException) {
                // empty catch block
            }
        }
    }

    public String[] getObjectNames() {
        String[] objNames = new String[this.m_modelNameVector.size()];
        System.arraycopy(this.m_modelNameVector.toArray(), 0, objNames, 0, this.m_modelNameVector.size());
        return objNames;
    }

    public void setIncludeModelSettings(SettingsInclusionOption option) {
        this.getValidationHandler().validateNotNull(option, "option");
        if (this.supportedInclusionOptions.isSupported((Enum)option)) {
            if (option.equals((Object)SettingsInclusionOption.systemDefault)) {
                option = SettingsInclusionOption.settingsOnly;
            }
            this.m_settingsInclusionOption = option;
        } else {
            this.unsupported("SettingsInclusionOption - " + option.name());
        }
    }

    public SettingsInclusionOption getIncludeModelSettings() {
        return this.m_settingsInclusionOption;
    }

    public VerificationReport verify() {
        return null;
    }

    public OraExportTask(OraConnection dmeConn, OraExportTaskFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, EXPORT_PROGRAM);
        this.m_taskType = MiningTask.exportTask;
        this.ARG_IX_OVERWRITE_OUTPUT = 7;
        this.ARG_IX_PARENT_TASKS = 8;
        this.ARG_IX_CHILD_TASKS = 9;
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        OraConnection dmeConn = this.getConnection();
        Connection dbConn = dmeConn.getDatabaseConnection();
        if (this.m_modelNameVector.size() < 1) {
            this.createException("2006", null, null);
        }
        StringBuffer modelInClause = new StringBuffer(MODEL_NAME_IN);
        for (int iModel = 0; iModel < this.m_modelNameVector.size(); ++iModel) {
            if (iModel == 0) {
                modelInClause.append("'");
            } else {
                modelInClause.append(",'");
            }
            modelInClause.append(this.m_modelNameVector.elementAt(iModel).toString().toUpperCase());
            modelInClause.append("'");
        }
        modelInClause.append(")");
        Object[] params = null;
        this.logTrace(modelInClause.toString(), params);
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList(new Object[]{ARG_FILE_NAME, this.m_exportFile.getName(), new Integer(12)}, new Object[]{ARG_DIRECTORY_NAME, this.m_exportFile.getParent(), new Integer(12)}, new Object[]{ARG_MODEL_FILTER, modelInClause.toString(), new Integer(12)}, new Object[]{ARG_FILE_SIZE, null, new Integer(12)}, new Object[]{ARG_OPERATION, null, new Integer(12)}, new Object[]{ARG_REMOTE_LINK, null, new Integer(12)}, new Object[]{ARG_JOB_NAME, null, new Integer(12)}));
        this.logTrace("filename=" + this.m_exportFile.getName(), params);
        this.logTrace("directory=" + this.m_exportFile.getParent(), params);
        this.logTrace("model_filter=" + modelInClause.toString(), params);
        this.logTrace("filesize=null", params);
        this.logTrace("operation=null", params);
        this.logTrace("remote_link=null", params);
        this.logTrace("jobname=null", params);
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            String fileName = (String)((Object[])this.m_jobArgs.get(0))[1];
            String directoryName = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_exportFile = new File(directoryName, fileName);
            String modelFilter = (String)((Object[])this.m_jobArgs.get(2))[1];
            String modelList = modelFilter.substring(10);
            StringTokenizer tokenizer = new StringTokenizer(modelList, "\",\")");
            while (tokenizer.hasMoreTokens()) {
                this.m_modelNameVector.add(tokenizer.nextElement());
            }
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }
}

