/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.task;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Vector;
import javax.datamining.JDMException;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraDetectTask;
import oracle.dmt.jdm.task.OraPredictiveAnalyticsTaskFactoryImpl;

public class OraDetectTaskImpl
extends OraTask
implements OraDetectTask {
    private OraDataURI m_inputURI = null;
    private OraDataURI m_outputDetectResultURI = null;
    private String m_caseID = null;
    private String m_detectAttributeName = null;
    private Double m_detectionRate = null;
    private Integer m_maxDescriptionAttributes = null;
    private static final String ARG_DATA_TABLE_NAME = "DATA_TABLE_NAME";
    private static final String ARG_CASE_ID_COLUMN_NAME = "CASE_ID_COLUMN_NAME";
    private static final String ARG_RESULT_TABLE_NAME = "RESULT_TABLE_NAME";
    private static final String ARG_DETECT_COLUMN_NAME = "DETECT_COLUMN_NAME";
    private static final String ARG_DETECTION_RATE = "DETECTION_RATE";
    private static final String ARG_MAX_DESCRIPTIVE_ATTRIBUTES = "MAX_DESCRIPTIVE_ATTRIBUTES";
    private static final String ARG_DATA_SCHEMA_NAME = "DATA_SCHEMA_NAME";
    private static final int ARG_IX_DATA_TABLE_NAME = 0;
    private static final int ARG_IX_CASE_ID_COLUMN_NAME = 1;
    private static final int ARG_IX_RESULT_TABLE_NAME = 2;
    private static final int ARG_IX_DETECT_COLUMN_NAME = 3;
    private static final int ARG_IX_DETECTION_RATE = 4;
    private static final int ARG_IX_MAX_DESCRIPTIVE_ATTRIBUTES = 5;
    private static final int ARG_IX_DATA_SCHEMA_NAME = 6;

    public OraDetectTaskImpl(OraConnection dmeConn, OraPredictiveAnalyticsTaskFactoryImpl factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, DETECT_PROGRAM);
    }

    public String getInputData() {
        return this.m_inputURI.getURI();
    }

    public void setInputData(String dataURI, String caseID) {
        this.m_inputURI = new OraDataURI(dataURI);
        this.m_caseID = caseID;
    }

    public String getDetectResultTableName() {
        return this.m_outputDetectResultURI == null ? null : this.m_outputDetectResultURI.getURI();
    }

    public void setDetectResultTableName(String detectResultTableName) {
        this.m_outputDetectResultURI = new OraDataURI(detectResultTableName);
    }

    public void setDetectionRate(Double detectionRate) {
        this.m_detectionRate = detectionRate;
    }

    public Double getDetectionRate() {
        return this.m_detectionRate;
    }

    public void setMaximumDescriptionAttributes(Integer maxDescriptionAttributes) {
        this.m_maxDescriptionAttributes = maxDescriptionAttributes;
    }

    public Integer getMaximumDescriptionAttributes() {
        return this.m_maxDescriptionAttributes;
    }

    public void setDetectionAttributeName(String detectionAttrName) {
        this.m_detectAttributeName = detectionAttrName;
    }

    public String getDetectionAttributeName() {
        return this.m_detectAttributeName;
    }

    protected void prepareJobArguments(String taskName) throws JDMException {
        this.m_jobArgs = new Vector();
        this.m_jobArgs.addAll(Arrays.asList({ARG_DATA_TABLE_NAME, this.m_inputURI.getTableName(), new Integer(12)}, {ARG_CASE_ID_COLUMN_NAME, this.m_caseID, new Integer(12)}, {ARG_RESULT_TABLE_NAME, this.m_outputDetectResultURI == null ? null : this.m_outputDetectResultURI.getTableName(), new Integer(12)}, {ARG_DETECT_COLUMN_NAME, this.m_detectAttributeName == null ? null : this.m_detectAttributeName, new Integer(12)}, {ARG_DETECTION_RATE, this.m_detectionRate == null ? null : this.m_detectionRate, new Integer(8)}, {ARG_MAX_DESCRIPTIVE_ATTRIBUTES, this.m_maxDescriptionAttributes == null ? null : this.m_maxDescriptionAttributes, new Integer(4)}, {ARG_DATA_SCHEMA_NAME, this.m_inputURI.getSchemaName(), new Integer(12)}));
    }

    protected void mapJobArgs() {
        if (this.m_jobArgs != null) {
            this.m_inputURI = new OraDataURI((String)((Object[])this.m_jobArgs.get(0))[1], (String)((Object[])this.m_jobArgs.get(6))[1]);
            this.m_caseID = (String)((Object[])this.m_jobArgs.get(1))[1];
            this.m_outputDetectResultURI = ((Object[])this.m_jobArgs.get(2))[1] == null ? null : new OraDataURI((String)((Object[])this.m_jobArgs.get(2))[1]);
            this.m_detectAttributeName = (String)((Object[])this.m_jobArgs.get(3))[1];
            this.m_detectionRate = ((Object[])this.m_jobArgs.get(4))[1] == null ? null : new Double(((BigDecimal)((Object[])this.m_jobArgs.get(4))[1]).doubleValue());
            this.m_maxDescriptionAttributes = ((Object[])this.m_jobArgs.get(5))[1] == null ? null : new Integer(((BigDecimal)((Object[])this.m_jobArgs.get(5))[1]).intValue());
        }
    }

    protected void setupTaskInputs(String taskName) throws JDMException {
    }
}

