/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.regression;

import java.util.HashMap;
import javax.datamining.JDMException;
import javax.datamining.supervised.regression.RegressionTestMetrics;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraTestMetrics;

public class OraRegressionTestMetrics
extends OraTestMetrics
implements RegressionTestMetrics {
    private static String c_metric_mean_predicated_value = "MEAN_PREDICATED_VALUE";
    private static String c_metric_mean_actual_value = "MEAN_ACTUAL_VALUE";
    private static String c_metric_mean_absolute_error = "MEAN_ABSOLUTE_ERROR";
    private static String c_metric_mean_rms_error = "MEAN_RMS_ERROR";
    private Double m_normShiftVal = null;
    private Double m_normScaleVal = null;

    public OraRegressionTestMetrics(OraConnection dmeConn, HashMap metricsPair) throws JDMException {
        super(dmeConn);
        this.m_metricsPair = metricsPair;
    }

    public void setTargetNormalizationDetails(Double shiftValue, Double scaleValue) {
        this.m_normShiftVal = shiftValue;
        this.m_normScaleVal = scaleValue;
    }

    public Double getTargetNormalizationShiftValue() {
        return this.m_normShiftVal;
    }

    public Double getTargetNormalizationScaleValue() {
        return this.m_normScaleVal;
    }

    public Double getMeanPredictedValue() {
        Double retValue = null;
        if (this.m_metricsPair != null) {
            retValue = Double.valueOf((String)this.getObjectValue(c_metric_mean_predicated_value));
        }
        if (this.m_normScaleVal != null) {
            retValue = new Double(this.m_normScaleVal * retValue);
        }
        if (this.m_normShiftVal != null) {
            retValue = new Double(retValue + this.m_normShiftVal);
        }
        return retValue;
    }

    public Double getMeanActualValue() {
        Double retValue = null;
        if (this.m_metricsPair != null) {
            retValue = Double.valueOf((String)this.getObjectValue(c_metric_mean_actual_value));
        }
        if (this.m_normScaleVal != null) {
            retValue = new Double(this.m_normScaleVal * retValue);
        }
        if (this.m_normShiftVal != null) {
            retValue = new Double(retValue + this.m_normShiftVal);
        }
        return retValue;
    }

    public Double getMeanAbsoluteError() {
        Double retValue = null;
        if (this.m_metricsPair != null) {
            retValue = Double.valueOf((String)this.getObjectValue(c_metric_mean_absolute_error));
        }
        if (this.m_normScaleVal != null) {
            retValue = new Double(this.m_normScaleVal * retValue);
        }
        return retValue;
    }

    public Double getRMSError() {
        Double retValue = null;
        if (this.m_metricsPair != null) {
            retValue = Double.valueOf((String)this.getObjectValue(c_metric_mean_rms_error));
        }
        if (this.m_normScaleVal != null) {
            retValue = new Double(this.m_normScaleVal * retValue);
        }
        return retValue;
    }

    public Double getRSquared() {
        this.unsupported("getRSquared");
        return null;
    }
}

