/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.supervised.classification.ConfusionMatrix;
import oracle.dmt.jdm.data.OraCategoryMatrix;
import oracle.dmt.jdm.data.OraCategorySet;
import oracle.dmt.jdm.data.OraCategorySetFactory;
import oracle.dmt.jdm.resource.OraConnection;

public class OraConfusionMatrix
extends OraCategoryMatrix
implements ConfusionMatrix {
    private double m_accuracy;

    OraConfusionMatrix(OraConnection dmeConn) {
        super(dmeConn, null);
    }

    void setAccuracy(double accuracy) {
        this.m_accuracy = accuracy;
    }

    void addEntry(Object actualTarget, Object predictedTarget, int predictionCount) throws JDMException {
        Vector colList;
        boolean isNewPredicted;
        this.getValidationHandler().validateCategory(actualTarget, "actualTarget");
        this.getValidationHandler().validateCategory(predictedTarget, "predictedTarget");
        if (this.m_categorySet == null) {
            try {
                OraCategorySetFactory csFactory = (OraCategorySetFactory)this.getConnection().getFactory("javax.datamining.data.CategorySet");
                AttributeDataType dataType = AttributeDataType.stringType;
                if (actualTarget instanceof Integer) {
                    dataType = AttributeDataType.integerType;
                } else if (actualTarget instanceof Double) {
                    dataType = AttributeDataType.doubleType;
                }
                this.m_categorySet = (OraCategorySet)csFactory.create(dataType);
                this.m_categorySet.setDefaultProperty(CategoryProperty.valid);
            }
            catch (JDMException jdmExp) {
                // empty catch block
            }
        }
        if (this.m_categorySet != null) {
            boolean actualExist = false;
            boolean predictedExist = predictedTarget.equals(actualTarget);
            if (this.m_categorySet.getSize() > 0) {
                int i;
                Object[] values = this.m_categorySet.getValues();
                for (i = 0; !actualExist && i < values.length; ++i) {
                    actualExist = values[i].equals(actualTarget);
                }
                for (i = 0; !predictedExist && i < values.length; ++i) {
                    predictedExist = values[i].equals(predictedTarget);
                }
            }
            if (!actualExist) {
                this.m_categorySet.addCategory(actualTarget, CategoryProperty.valid);
            }
            if (!predictedExist) {
                this.m_categorySet.addCategory(predictedTarget, CategoryProperty.valid);
            }
        }
        if (actualTarget != null) {
            this.m_targetSet.add(actualTarget);
        }
        if (predictedTarget != null) {
            this.m_targetSet.add(predictedTarget);
        }
        if (!this.m_rowMap.containsKey(actualTarget)) {
            this.m_rowMap.put(actualTarget, new Vector());
            this.m_countMap.put(actualTarget, new Vector());
        }
        boolean bl = isNewPredicted = !(colList = (Vector)this.m_rowMap.get(actualTarget)).contains(predictedTarget);
        if (isNewPredicted) {
            colList.addElement(predictedTarget);
            this.m_rowMap.put(actualTarget, colList);
        }
        int index = colList.indexOf(predictedTarget);
        Vector countList = (Vector)this.m_countMap.get(actualTarget);
        if (isNewPredicted) {
            countList.addElement(new Integer(predictionCount));
        } else {
            countList.setElementAt(new Integer(predictionCount), index);
        }
    }

    public double getAccuracy() {
        return this.m_accuracy;
    }

    public double getError() {
        return 1.0 - this.m_accuracy;
    }

    public long getNumberOfPredictions(Object actualCategoryValue, Object predictedCategoryValue) throws JDMException {
        Double count = this.getValue(actualCategoryValue, predictedCategoryValue);
        if (count == null) {
            return 0L;
        }
        return count.longValue();
    }
}

