/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.util.Map;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.NamedObject;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettingsFactory;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.supervised.classification.ClassificationSettings;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.abn.OraABNSettingsImpl;
import oracle.dmt.jdm.algorithm.glm.OraGLMSettings;
import oracle.dmt.jdm.algorithm.naivebayes.OraNaiveBayesSettings;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettings;
import oracle.dmt.jdm.algorithm.tree.OraTreeSettings;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraSupervisedSettings;
import oracle.dmt.jdm.supervised.classification.OraClassificationSettingsFactory;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraClassificationSettings
extends OraSupervisedSettings
implements ClassificationSettings {
    protected String m_costMatrixName = null;
    protected boolean m_usePriors = false;

    OraClassificationSettings(OraConnection dmeConn, OraClassificationSettingsFactory factory) throws JDMException {
        super(dmeConn, (OraFactory)factory, MiningFunction.classification);
    }

    protected AlgorithmSettings getDefaultAlgorithmSettings() {
        try {
            NaiveBayesSettingsFactory nbFactory = (NaiveBayesSettingsFactory)this.getConnection().getFactory("javax.datamining.algorithm.naivebayes.NaiveBayesSettings");
            return nbFactory.create();
        }
        catch (JDMException jdmExp) {
            return null;
        }
    }

    protected boolean isSupported(AlgorithmSettings algoSettings) {
        return algoSettings instanceof OraNaiveBayesSettings || algoSettings instanceof OraSVMClassificationSettings || algoSettings instanceof OraABNSettingsImpl || algoSettings instanceof OraTreeSettings || algoSettings instanceof OraGLMSettings;
    }

    public void setCostMatrixName(String costMatrixName) {
        if (this.m_algoSettings == null || !MiningAlgorithm.decisionTree.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            this.unsupported("setCostMatrixName");
        } else if (costMatrixName == null) {
            this.m_costMatrixName = null;
            this.setValue("CLAS_COST_TABLE_NAME", this.m_costMatrixName);
        } else {
            this.getValidationHandler().validateObjectName(costMatrixName, "costMatrixName", NamedObject.costMatrix);
            this.m_costMatrixName = costMatrixName;
            this.setValue("CLAS_COST_TABLE_NAME", this.m_costMatrixName);
        }
    }

    public String getCostMatrixName() {
        if (this.m_costMatrixName != null) {
            return this.m_costMatrixName;
        }
        return this.getValue("CLAS_COST_TABLE_NAME");
    }

    public Map getPriorProbabilitiesMap(String attributeName) throws JDMException {
        this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        return this.getPriorsMap(attributeName);
    }

    public void setPriorProbabilitiesMap(String attributeName, Map priorsMap) throws JDMException {
        String targetAtrrName;
        String processedAttributeName;
        this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        this.getValidationHandler().validateNotNull(priorsMap, "priorsMap");
        if (this.m_algoSettings == null || MiningAlgorithm.decisionTree.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            this.unsupported("setPriorProbabilitiesMap");
        }
        if ((processedAttributeName = OraStringUtils.getReplacedString(attributeName, "'", "''")).equals(targetAtrrName = this.getTargetAttributeName())) {
            this.m_usePriors = true;
            this.setPriorsMap(processedAttributeName, priorsMap);
        } else {
            this.unsupported("setPriorProbabilitiesMap. ", "3506", null);
        }
    }

    public void usePriors(boolean usePriors) {
        this.m_usePriors = usePriors;
    }

    public boolean getUsePriors() {
        return this.m_usePriors;
    }

    public int getDesiredExecutionTimeInMinutes() {
        int noOfMinutes = 0;
        if (this.m_algoSettings == null || !OraMiningAlgorithm.adaptiveBayesNetwork.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            this.unsupported("DesiredExecutionTimeInMinutes");
        } else {
            noOfMinutes = ((OraABNSettingsImpl)this.m_algoSettings).getMaxBuildMinutes();
        }
        return noOfMinutes;
    }

    public void setDesiredExecutionTimeInMinutes(int minutes) {
        if (this.m_algoSettings == null || !OraMiningAlgorithm.adaptiveBayesNetwork.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            this.unsupported("DesiredExecutionTimeInMinutes");
        } else {
            ((OraABNSettingsImpl)this.m_algoSettings).setMaxBuildMinutes(minutes);
        }
    }

    public void setPriorProbabilitiesName(String priorTableName) {
        this.m_priorTableName = priorTableName;
    }

    public String getPriorProbabilitiesName() {
        if (this.m_priorTableName == null) {
            this.m_priorTableName = this.getValue("CLAS_PRIORS_TABLE_NAME");
        }
        return this.m_priorTableName;
    }

    public void setTargetWeightsTableName(String targetWeightsTable) {
        if (!this.is102() && this.m_algoSettings != null && OraMiningAlgorithm.generalizedLinearModel.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            this.m_targetWeightsTableName = targetWeightsTable;
        } else {
            this.unsupported("BuildSettings.setTargetWeightsTableName");
        }
    }

    public String getTargetWeightsTableName() {
        if (!this.is102() && this.m_algoSettings != null && OraMiningAlgorithm.generalizedLinearModel.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            if (this.m_targetWeightsTableName == null) {
                this.m_targetWeightsTableName = this.getValue("CLAS_WEIGHTS_TABLE_NAME");
            } else {
                this.unsupported("BuildSettings.setTargetWeightsTableName");
            }
        }
        return this.m_targetWeightsTableName;
    }

    public void setTargetWeightsMap(Map targetWeightsMap) {
        this.getValidationHandler().validateNotNull(targetWeightsMap, "targetWeightsMap");
        if (!this.is102() && this.m_algoSettings != null && OraMiningAlgorithm.generalizedLinearModel.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            this.m_targetWeightsMap = targetWeightsMap;
        } else {
            this.unsupported("BuildSettings.setTargetWeightsMap");
        }
    }

    public Map getTargetWeightsMap() {
        if (!this.is102() && this.m_algoSettings != null && OraMiningAlgorithm.generalizedLinearModel.equals((Object)this.m_algoSettings.getMiningAlgorithm())) {
            return this.m_targetWeightsMap;
        }
        this.unsupported("BuildSettings.getTargetWeightsMap");
        return null;
    }
}

