/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.supervised.classification;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.NamedObject;
import javax.datamining.base.ModelDetail;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.CategorySet;
import javax.datamining.data.CategorySetFactory;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.dmt.jdm.OraDataURI;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.modeldetail.abn.OraABNModelDetailImpl;
import oracle.dmt.jdm.modeldetail.glm.OraGLMModelDetailImpl;
import oracle.dmt.jdm.modeldetail.naivebayes.OraNaiveBayesModelDetail;
import oracle.dmt.jdm.modeldetail.svm.OraSVMClassificationModelDetail;
import oracle.dmt.jdm.modeldetail.tree.OraTreeModelDetail;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.supervised.OraSupervisedModel;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.normalize.OraNormalizeTransformImpl;

public class OraClassificationModel
extends OraSupervisedModel
implements ClassificationModel {
    private CategorySet m_categorySet = null;
    private ModelDetail m_modelDetail = null;

    public double getClassificationError() {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"method", "ClassificationModel.getClassificationError"}, null);
        return 0.0;
    }

    public CategorySet getTargetCategorySet() {
        if (this.m_categorySet == null) {
            java.sql.Connection dbConn = this.getDatabaseConnection();
            Statement pStmt = null;
            ResultSet rs = null;
            try {
                pStmt = dbConn.prepareCall("select prediction from TABLE(PREDICTION_SET(" + this.getName() + " USING))");
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    Object value = rs.getObject(1);
                    if (value instanceof BigDecimal) {
                        BigDecimal decValue = (BigDecimal)value;
                        value = decValue.scale() == 0 ? (Number)new Integer(decValue.intValue()) : (Number)new Double(decValue.doubleValue());
                    }
                    if (this.m_categorySet == null) {
                        AttributeDataType targetAttrType = AttributeDataType.stringType;
                        if (value instanceof Double) {
                            targetAttrType = AttributeDataType.doubleType;
                        } else if (value instanceof Integer) {
                            targetAttrType = AttributeDataType.integerType;
                        }
                        CategorySetFactory catFactory = (CategorySetFactory)this.getConnection().getFactory("javax.datamining.data.CategorySet");
                        this.m_categorySet = catFactory.create(targetAttrType);
                    }
                    this.m_categorySet.addCategory(value, CategoryProperty.valid);
                }
            }
            catch (SQLException sqlExp) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqlExp1) {
                    // empty catch block
                }
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sqlExp1) {}
            }
            catch (JDMException jdmExp) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, jdmExp);
            }
        }
        return this.m_categorySet;
    }

    public boolean wasCostMatrixUsed() {
        if (MiningAlgorithm.decisionTree.equals((Object)this.getMiningAlgorithm())) {
            return this.isCostMatrixSpecified();
        }
        return false;
    }

    public OraClassificationModel(OraConnection dmeConn, String name, String targetAttrName) throws JDMException {
        super(dmeConn, name, MiningFunction.classification, targetAttrName);
    }

    private boolean isCostMatrixSpecified() {
        return false;
    }

    public ModelDetail getModelDetail() {
        if (this.m_modelDetail == null) {
            try {
                if (this.getMiningAlgorithm().equals((Object)MiningAlgorithm.naiveBayes)) {
                    this.m_modelDetail = new OraNaiveBayesModelDetail(this.getConnection(), this, (OraBinningTransform)this.m_buildTransform);
                } else if (this.getMiningAlgorithm().equals((Object)MiningAlgorithm.svmClassification)) {
                    this.m_modelDetail = new OraSVMClassificationModelDetail(this.getConnection(), this, (OraNormalizeTransformImpl)this.m_buildTransform);
                } else if (this.getMiningAlgorithm().equals((Object)MiningAlgorithm.decisionTree)) {
                    this.m_modelDetail = new OraTreeModelDetail(this.getConnection(), this);
                } else if (this.getMiningAlgorithm().equals((Object)OraMiningAlgorithm.adaptiveBayesNetwork)) {
                    this.m_modelDetail = new OraABNModelDetailImpl(this.getConnection(), this, (OraBinningTransform)this.m_buildTransform);
                } else if (this.getMiningAlgorithm().equals((Object)OraMiningAlgorithm.generalizedLinearModel)) {
                    this.m_modelDetail = new OraGLMModelDetailImpl(this.getConnection(), this);
                }
            }
            catch (JDMException jDMException) {
                // empty catch block
            }
        }
        return this.m_modelDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCostMatrix(Connection dmeConn, String modelName, String costMatrixName) throws JDMException {
        OraConnection oraDMEConn = (OraConnection)dmeConn;
        java.sql.Connection dbConn = oraDMEConn.getDatabaseConnection();
        if (oraDMEConn.doesObjectExist(modelName, NamedObject.model) && oraDMEConn.doesObjectExist(costMatrixName, NamedObject.costMatrix)) {
            CallableStatement cStmt = null;
            try {
                cStmt = dbConn.prepareCall("{call DBMS_DATA_MINING.ADD_COST_MATRIX (?, ?, ?) }");
                cStmt.setString(1, modelName);
                OraDataURI costMatrixURI = new OraDataURI(costMatrixName);
                String costMatrixTableName = costMatrixURI.getTableName();
                String costMatrixSchemaName = costMatrixURI.getSchemaName();
                cStmt.setString(2, costMatrixTableName);
                if (costMatrixSchemaName == null) {
                    cStmt.setNull(3, 12);
                } else {
                    cStmt.setString(3, costMatrixSchemaName);
                }
                cStmt.execute();
            }
            catch (SQLException sqlExp) {
                oraDMEConn.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
            }
            finally {
                try {
                    if (cStmt != null) {
                        cStmt.close();
                    }
                }
                catch (SQLException sqlExp) {}
            }
        } else {
            oraDMEConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new String[]{modelName + "/" + costMatrixName, NamedObject.model.name() + "/" + NamedObject.costMatrix.name()}, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCostMatrix(Connection dmeConn, String modelName) throws JDMException {
        OraConnection oraDMEConn = (OraConnection)dmeConn;
        java.sql.Connection dbConn = oraDMEConn.getDatabaseConnection();
        if (oraDMEConn.doesObjectExist(modelName, NamedObject.model)) {
            CallableStatement cStmt = null;
            try {
                cStmt = dbConn.prepareCall("{call DBMS_DATA_MINING.REMOVE_COST_MATRIX (?) }");
                cStmt.setString(1, modelName);
                cStmt.execute();
            }
            catch (SQLException sqlExp) {
                oraDMEConn.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
            }
            finally {
                try {
                    if (cStmt != null) {
                        cStmt.close();
                    }
                }
                catch (SQLException sqlExp) {}
            }
        } else {
            oraDMEConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new String[]{modelName, NamedObject.model.name()}, null);
        }
    }
}

