/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.statistics;

import javax.datamining.JDMException;
import javax.datamining.data.AttributeType;
import javax.datamining.data.CategoryProperty;
import javax.datamining.data.CategorySet;
import javax.datamining.data.SignatureAttribute;
import javax.datamining.statistics.ContinuousStatistics;
import javax.datamining.statistics.DiscreteStatistics;
import javax.datamining.statistics.NumericalStatistics;
import javax.datamining.statistics.UnivariateStatistics;
import oracle.dmt.jdm.OraDMObject;
import oracle.dmt.jdm.data.OraInterval;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;

public class OraUnivariateStatistics
extends OraDMObject
implements UnivariateStatistics {
    private SignatureAttribute m_signatureAttribute;
    private String m_attributeName;
    private OraInterval[] m_ranges = null;
    private CategorySet m_categorySet = null;
    private long[] m_frequencies = null;
    private double[] m_probabilities;
    private boolean m_bUnbinned = false;

    public String getName() {
        return this.m_attributeName;
    }

    public Object[] getValues() {
        AttributeType attrType = this.m_signatureAttribute.getAttributeType();
        if (attrType.equals((Object)AttributeType.categorical) || this.m_bUnbinned) {
            return this.m_categorySet.getValues();
        }
        if (attrType.equals((Object)AttributeType.numerical)) {
            return this.m_ranges;
        }
        return null;
    }

    public long getFrequency(int index) throws JDMException {
        return this.m_frequencies[index];
    }

    public long[] getFrequencies() {
        if (this.m_frequencies == null && this.m_probabilities != null) {
            this.m_frequencies = new long[this.m_probabilities.length];
            for (int ni = 0; ni < this.m_probabilities.length; ++ni) {
                this.m_frequencies[ni] = (long)this.m_probabilities[ni];
            }
        }
        return this.m_frequencies;
    }

    public double[] getProbabilities() {
        return this.m_probabilities;
    }

    public long getFrequency(CategoryProperty property) {
        this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{"getFrequency", ""}, null);
        return 0L;
    }

    public DiscreteStatistics getDiscreteStatistics() {
        return null;
    }

    public NumericalStatistics getNumericalStatistics() {
        return null;
    }

    public ContinuousStatistics getContinuousStatistics() {
        return null;
    }

    public OraUnivariateStatistics(OraConnection dmeConn, String attributeName, SignatureAttribute signatureAttribute, CategorySet categorySet, long[] frequencies) throws JDMException {
        this(dmeConn, attributeName, signatureAttribute, frequencies);
        this.m_categorySet = categorySet;
    }

    public OraUnivariateStatistics(OraConnection dmeConn, String attributeName, SignatureAttribute signatureAttribute, OraInterval[] ranges, long[] frequencies) throws JDMException {
        this(dmeConn, attributeName, signatureAttribute, frequencies);
        this.m_ranges = ranges;
    }

    private OraUnivariateStatistics(OraConnection dmeConn, String attributeName, SignatureAttribute signatureAttribute, long[] frequencies) throws JDMException {
        super(dmeConn, null);
        this.m_attributeName = attributeName;
        this.m_signatureAttribute = signatureAttribute;
        this.m_frequencies = frequencies;
    }

    public OraUnivariateStatistics(OraConnection dmeConn, String attributeName, SignatureAttribute signatureAttribute, CategorySet categorySet, double[] percentages, boolean bUnbinned) throws JDMException {
        this(dmeConn, attributeName, signatureAttribute, percentages, bUnbinned);
        this.m_categorySet = categorySet;
    }

    public OraUnivariateStatistics(OraConnection dmeConn, String attributeName, SignatureAttribute signatureAttribute, OraInterval[] ranges, double[] percentages, boolean bUnbinned) throws JDMException {
        this(dmeConn, attributeName, signatureAttribute, percentages, bUnbinned);
        this.m_ranges = ranges;
    }

    private OraUnivariateStatistics(OraConnection dmeConn, String attributeName, SignatureAttribute signatureAttribute, double[] percentages, boolean bUnbinned) throws JDMException {
        super(dmeConn, null);
        this.m_attributeName = attributeName;
        this.m_signatureAttribute = signatureAttribute;
        this.m_probabilities = percentages;
        this.m_bUnbinned = bUnbinned;
    }
}

