/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.scheduler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import oracle.dmt.jdm.utils.OraStringUtils;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;

public class OraJobInfo {
    private Connection m_dbConn = null;
    private String m_jobName = null;
    private Timestamp m_creationTime = null;
    private Timestamp m_startTime = null;
    private Timestamp m_endTime = null;
    private INTERVALDS m_duration = null;
    private String m_state = null;
    private String m_programName = null;
    private String m_failureMessage = null;
    private Logger m_logger;
    private String m_jobComments = null;
    private static final String JOB_INFO = "SELECT STATE, PROGRAM_NAME, COMMENTS FROM USER_SCHEDULER_JOBS WHERE JOB_NAME = ?";
    private static final String JOB_CREATION_DATE = "SELECT CREATED FROM USER_OBJECTS WHERE OBJECT_NAME = ?";
    private static final String GET_JOB_STATE_AND_DESCRIPTION = "SELECT STATUS, ADDITIONAL_INFO, RUN_DURATION, ACTUAL_START_DATE FROM USER_SCHEDULER_JOB_RUN_DETAILS WHERE JOB_NAME = ? ORDER BY  ACTUAL_START_DATE desc";
    private static final String GET_JOB_RUNNING_DURATION = "SELECT ELAPSED_TIME FROM USER_SCHEDULER_RUNNING_JOBS WHERE JOB_NAME = ?";

    public OraJobInfo(Connection dbConn, String jobName) throws SQLException {
        this(dbConn, jobName, null);
    }

    public OraJobInfo(Connection dbConn, String jobName, Logger logger) throws SQLException {
        this.m_logger = logger;
        this.m_jobName = jobName;
        this.m_dbConn = dbConn;
        this.m_creationTime = this.getCreationTime();
        if (this.m_creationTime != null) {
            this.updateJobInfo();
        }
    }

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public boolean doesJobInDatabase() {
        return this.m_creationTime != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getCreationTime() throws SQLException {
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        Timestamp creationTime = null;
        try {
            pStmt = this.m_dbConn.prepareStatement(JOB_CREATION_DATE);
            pStmt.setString(1, OraStringUtils.trimDoubleQuotes(this.m_jobName));
            rs = pStmt.executeQuery();
            if (rs.next()) {
                creationTime = rs.getTimestamp(1);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp) {}
        }
        return creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobInfo() throws SQLException {
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = this.m_dbConn.prepareStatement(JOB_INFO);
            pStmt.setString(1, OraStringUtils.trimDoubleQuotes(this.m_jobName));
            rs = pStmt.executeQuery();
            if (rs.next()) {
                this.m_state = rs.getString(1);
                this.m_programName = rs.getString(2);
                this.m_jobComments = rs.getString(3);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp) {}
        }
        try {
            if ("SUCCEEDED".equals(this.m_state) || "FAILED".equals(this.m_state)) {
                pStmt = this.m_dbConn.prepareStatement(GET_JOB_STATE_AND_DESCRIPTION);
                pStmt.setString(1, OraStringUtils.trimDoubleQuotes(this.m_jobName));
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    if ("SUCCEEDED".equals(this.m_state)) {
                        this.m_state = rs.getString(1);
                    }
                    if ("FAILED".equals(this.m_state)) {
                        this.m_failureMessage = rs.getString(2);
                    }
                    this.m_duration = ((OracleResultSet)rs).getINTERVALDS(3);
                    this.m_startTime = rs.getTimestamp(4);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp) {}
        }
        if (this.m_duration == null) {
            CallableStatement pStmtDuration = null;
            OracleResultSet rsDuration = null;
            try {
                pStmtDuration = this.m_dbConn.prepareCall(GET_JOB_RUNNING_DURATION);
                pStmtDuration.setString(1, OraStringUtils.trimDoubleQuotes(this.m_jobName));
                rsDuration = (OracleResultSet)pStmtDuration.executeQuery();
                if (rsDuration.next()) {
                    this.m_duration = rsDuration.getINTERVALDS(1);
                }
            }
            finally {
                if (rsDuration != null) {
                    try {
                        rsDuration.close();
                    }
                    catch (Exception rsExp) {}
                }
                if (pStmtDuration != null) {
                    try {
                        pStmtDuration.close();
                    }
                    catch (Exception pStmtExp) {}
                }
            }
        }
        if (this.m_duration != null && this.m_startTime != null) {
            this.m_endTime = new Timestamp(this.m_startTime.getTime() + this.getExecutionDuration() * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getJobStateDetails(Connection dbConn, String jobName) throws SQLException {
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String state = null;
        String failureMessage = null;
        try {
            pStmt = dbConn.prepareStatement(GET_JOB_STATE_AND_DESCRIPTION);
            pStmt.setString(1, OraStringUtils.trimDoubleQuotes(jobName));
            rs = pStmt.executeQuery();
            if (rs.next()) {
                state = rs.getString(1);
                failureMessage = rs.getString(2);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sqlExp) {}
        }
        return new String[]{state, failureMessage};
    }

    public Timestamp getCreatedTimestamp() {
        return this.m_creationTime;
    }

    public Timestamp getStartTimestamp() {
        return this.m_creationTime;
    }

    public Timestamp getEndTimestamp() {
        return this.m_endTime;
    }

    public String getJobComments() {
        return this.m_jobComments;
    }

    public long getExecutionDuration() {
        long durationInSeconds = 0L;
        String durationStr = null;
        if (this.m_duration != null) {
            durationStr = this.m_duration.stringValue();
            int days = 0;
            int hrs = 0;
            int min = 0;
            int sec = 0;
            String[] spaceSplits = durationStr.split(" ");
            if (spaceSplits != null) {
                boolean foundDays = false;
                boolean foundAll = false;
                for (int i = 0; i < spaceSplits.length; ++i) {
                    String trimmedString = spaceSplits[i].trim();
                    if (trimmedString.length() <= 0) continue;
                    if (!foundDays) {
                        days = Integer.parseInt(trimmedString);
                        if (days > 0) {
                            durationInSeconds += (long)(days * 86400);
                        }
                        foundDays = true;
                        continue;
                    }
                    if (foundAll) continue;
                    String[] colonSplits = trimmedString.split(":");
                    hrs = Integer.parseInt(colonSplits[0]);
                    min = Integer.parseInt(colonSplits[1]);
                    sec = (int)Double.parseDouble(colonSplits[2]);
                    durationInSeconds += (long)(hrs * 3600 + min * 60 + sec);
                    break;
                }
                return durationInSeconds;
            }
        }
        return durationInSeconds;
    }

    public String getState() {
        return this.m_state;
    }

    public String getProgramName() {
        return this.m_programName;
    }

    public String getFailureMessage() throws SQLException {
        if (this.m_failureMessage != null || "FAILED".equals(this.m_state)) {
            // empty if block
        }
        return this.m_failureMessage;
    }
}

