/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.scheduler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.jdm.scheduler.OraJobInfo;
import oracle.dmt.jdm.utils.OraSQLUtils;

public abstract class OraJob {
    private String m_name = null;
    private String m_comments = null;
    private boolean m_isInlineMode = true;
    protected OraJobInfo m_jobInfo = null;
    protected Logger m_logger = null;
    private long m_sleepTime = 2000L;
    protected static final String CS_CREATE_JOB = "DBMS_SCHEDULER.CREATE_JOB";
    private static final String CS_ENABLE_JOB = "DBMS_SCHEDULER.ENABLE";
    private static final String CS_DISABLE_JOB = "DBMS_SCHEDULER.DISABLE";
    private static final String CS_STOP_JOB = "DBMS_SCHEDULER.STOP_JOB";
    private static final String CS_RUN_JOB = "DBMS_SCHEDULER.RUN_JOB";
    private static final String CS_DROP_JOB = "DBMS_SCHEDULER.DROP_JOB";
    private static final String CS_SET_ATTRIBUTE = "DBMS_SCHEDULER.SET_ATTRIBUTE";
    private static final String CS_ADD_EVENT_QUEUE_SUBSCRIBER = "{ call DBMS_SCHEDULER.ADD_EVENT_QUEUE_SUBSCRIBER }";
    public static final String JOB_DISABLED_STATE = "DISABLED";
    public static final String JOB_SCHEDULED_STATE = "SCHEDULED";
    public static final String JOB_RUNNING_STATE = "RUNNING";
    public static final String JOB_SUCCEEDED_STATE = "SUCCEEDED";
    public static final String JOB_FAILED_STATE = "FAILED";
    public static final String JOB_STOPPED_STATE = "STOPPED";
    public static final String JOB_READY_TO_RUN_STATE = "READY TO RUN";
    protected static final String P_JOB_NAME = "job_name";
    protected static final String P_JOB_CLASS = "job_class";
    protected static final String P_ENABLED = "enabled";
    protected static final String P_AUTO_DROP = "auto_drop";
    protected static final String P_COMMENTS = "comments";
    protected static final String P_PROGRAM_NAME = "program_name";
    protected static final String P_START_DATE = "start_date";
    protected static final String P_REPEAT_INTERVAL = "repeat_interval";
    protected static final String P_END_DATE = "end_date";
    protected static final String P_ARG_NAME = "argument_name";
    protected static final String P_ARG_VALUE = "argument_value";
    protected static final String P_NAME = "name";
    protected static final String P_ATTRIBUTE = "attribute";
    protected static final String P_VALUE = "value";
    protected static final String P_VALUE2 = "value2";
    public static final String JOB_STARTED = "JOB_STARTED";
    public static final String JOB_SUCCEEDED = "JOB_SUCCEEDED";
    public static final String JOB_FAILED = "JOB_FAILED";
    public static final String JOB_BROKEN = "JOB_BROKEN";
    public static final String JOB_COMPLETED = "JOB_COMPLETED";
    public static final String JOB_STOPPED = "JOB_STOPPED";
    public static final String JOB_SCH_LIM_REACHED = "JOB_SCH_LIM_REACHED";
    public static final String JOB_DISABLED = "JOB_DISABLED";
    public static final String JOB_CHAIN_STALLED = "JOB_CHAIN_STALLED";
    public static final String JOB_OVER_MAX_DUR = "JOB_OVER_MAX_DUR";
    private static boolean aq_event_queue_subscribed = false;

    public OraJob() {
    }

    public OraJob(String jobName, String jobComments) {
        this.m_name = jobName;
        this.m_comments = jobComments;
    }

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public OraJobInfo getJobInfo(Connection dbConn) throws SQLException {
        if (this.m_name == null) {
            return null;
        }
        this.m_jobInfo = OraJob.getJobInfo(dbConn, this.m_name, this.m_logger);
        return this.m_jobInfo;
    }

    public static boolean doesJobInDatabase(Connection dbConn, String jobName, Logger logger) throws SQLException {
        OraJobInfo jobInfo = OraJob.getJobInfo(dbConn, jobName, logger);
        return jobInfo.doesJobInDatabase();
    }

    public void setStatusPollingInterval(long sleepTime) {
        this.m_sleepTime = sleepTime;
    }

    public long getStatusPollingInterval() {
        return this.m_sleepTime;
    }

    public void setName(String jobName) {
        this.m_name = jobName;
    }

    public void setComments(String jobComments) {
        this.m_comments = jobComments;
    }

    public String getName() {
        return this.m_name;
    }

    public String getComments() {
        if (this.m_comments == null && this.m_jobInfo != null) {
            this.m_comments = this.m_jobInfo.getJobComments();
        }
        return this.m_comments;
    }

    public void saveJob(Connection dbConn) throws SQLException {
        this.createJob(dbConn);
    }

    public void saveJob(Connection dbConn, String jobName) throws SQLException {
        this.setName(jobName);
        this.saveJob(dbConn);
    }

    protected abstract void createJob(Connection var1) throws SQLException;

    public void enableJob(Connection dbConn) throws SQLException {
        OraJob.enableJob(dbConn, this.m_name, this.m_logger);
    }

    public OraJobInfo waitForCompletion(Connection dbConn, int timeoutInSeconds) throws SQLException {
        long startTimeInSeconds = 0L;
        long currentTimeInSeconds = 0L;
        boolean isTimeOutThere = false;
        if (timeoutInSeconds > 0 && timeoutInSeconds != Integer.MAX_VALUE) {
            startTimeInSeconds = System.currentTimeMillis() / 1000L;
            isTimeOutThere = true;
        }
        while (true) {
            if (this.m_jobInfo == null) {
                this.getJobInfo(dbConn);
            }
            this.m_jobInfo.updateJobInfo();
            if (!(JOB_RUNNING_STATE.equals(this.m_jobInfo.getState()) || JOB_SCHEDULED_STATE.equals(this.m_jobInfo.getState()) || JOB_READY_TO_RUN_STATE.equals(this.m_jobInfo.getState()))) {
                return this.m_jobInfo;
            }
            if (isTimeOutThere && (currentTimeInSeconds = System.currentTimeMillis() / 1000L) - startTimeInSeconds >= (long)timeoutInSeconds) {
                return this.m_jobInfo;
            }
            try {
                Thread.sleep(this.m_sleepTime);
                continue;
            }
            catch (InterruptedException exp) {
                exp.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateJobName(Connection dbConn) throws SQLException {
        CallableStatement cStmt = null;
        String generateJobName = null;
        String plsqlCall = "{ ? = call DBMS_SCHEDULER.GENERATE_JOB_NAME (?) }";
        try {
            cStmt = dbConn.prepareCall(plsqlCall);
            cStmt.setString(2, "JDM$_");
            cStmt.registerOutParameter(1, 12);
            cStmt.execute();
            generateJobName = (String)cStmt.getObject(1);
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
        return generateJobName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableJob(Connection dbConn, String jobName, Logger logger) throws SQLException {
        Statement cStmt = null;
        try {
            OraSQLUtils.executeCallableStatement(dbConn, CS_ENABLE_JOB, new String[]{P_NAME}, new Object[]{jobName}, new int[]{12}, null, logger);
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableJob(Connection dbConn, String jobName, Logger logger) throws SQLException {
        Statement cStmt = null;
        try {
            OraSQLUtils.executeCallableStatement(dbConn, CS_DISABLE_JOB, new String[]{P_NAME}, new Object[]{jobName}, new int[]{12}, null, logger);
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    public static void stopJob(Connection dbConn, String jobName, Logger logger, boolean forceOption) throws SQLException {
        Object cStmt = null;
        if (forceOption) {
            String plsqlCall = "begin DBMS_SCHEDULER.STOP_JOB('" + jobName + "', true); end;";
            OraSQLUtils.executeCallableStatement(dbConn, plsqlCall, null, null, null, null, logger);
        } else {
            OraSQLUtils.executeCallableStatement(dbConn, CS_STOP_JOB, new String[]{P_JOB_NAME}, new Object[]{jobName}, new int[]{12}, null, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJob(Connection dbConn, String jobName, Logger logger) throws SQLException {
        Statement cStmt = null;
        try {
            OraSQLUtils.executeCallableStatement(dbConn, CS_RUN_JOB, new String[]{P_JOB_NAME}, new Object[]{jobName}, new int[]{12}, null, logger);
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropJob(Connection dbConn, String jobName, Logger logger) throws SQLException {
        Statement cStmt = null;
        try {
            OraSQLUtils.executeCallableStatement(dbConn, CS_DROP_JOB, new String[]{P_JOB_NAME}, new Object[]{jobName}, new int[]{12}, null, logger);
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    public static void setJobDependency(Connection dbConn, String jobName, String parentJobName, String jobEventType, Logger logger) throws SQLException {
        OraJob.addEventQueueSubscriber(dbConn, logger);
        if (parentJobName == null) {
            OraJob.setJobAttribute(dbConn, jobName, null, null, null, logger);
        } else {
            OraJob.setJobAttribute(dbConn, parentJobName, "raise_events", new Integer(38), null, logger);
            if (jobEventType == null) {
                OraJob.setJobAttribute(dbConn, jobName, "event_spec", "tab.user_data.event_type='JOB_SUCCEEDED' and tab.user_data.object_name='" + parentJobName + "'", "SYS.SCHEDULER$_EVENT_QUEUE, " + dbConn.getMetaData().getUserName(), logger);
            } else {
                OraJob.setJobAttribute(dbConn, jobName, "event_spec", "tab.user_data.event_type='" + jobEventType + "' and tab.user_data.object_name='" + parentJobName + "'", "SYS.SCHEDULER$_EVENT_QUEUE, " + dbConn.getMetaData().getUserName(), logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJobAttribute(Connection dbConn, String jobName, String attributeName, Object attrValue, String attrValue2, Logger logger) throws SQLException {
        int attrValType = 12;
        if (attrValue instanceof Integer) {
            attrValType = 4;
        }
        Statement cStmt = null;
        try {
            OraSQLUtils.executeCallableStatement(dbConn, CS_SET_ATTRIBUTE, new String[]{P_NAME, P_ATTRIBUTE, P_VALUE, P_VALUE2}, new Object[]{jobName, attributeName, attrValue, attrValue2}, new int[]{12, 12, attrValType, 12}, null, logger);
        }
        finally {
            if (cStmt != null) {
                try {
                    cStmt.close();
                }
                catch (Exception anyExp) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEventQueueSubscriber(Connection dbConn, Logger logger) throws SQLException {
        if (!aq_event_queue_subscribed) {
            aq_event_queue_subscribed = true;
            Statement cStmt = null;
            try {
                OraSQLUtils.executeCallableStatement(dbConn, CS_ADD_EVENT_QUEUE_SUBSCRIBER, null, null, null, null, logger);
            }
            catch (Exception anyExp) {
                logger.log(Level.FINE, "ADD_EVENT_QUEUE_SUBSCRIBER failed.", anyExp);
            }
            finally {
                if (cStmt != null) {
                    try {
                        cStmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static OraJobInfo getJobInfo(Connection dbConn, String jobName, Logger logger) throws SQLException {
        return new OraJobInfo(dbConn, jobName, logger);
    }
}

