/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.rule;

import javax.datamining.ComparisonOperator;
import javax.datamining.JDMException;
import javax.datamining.rule.SimplePredicate;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraPredicate;

public class OraSimplePredicate
extends OraPredicate
implements SimplePredicate {
    private String m_attributeName;
    private ComparisonOperator m_compOperator;
    private Double m_numericalValue;
    private Object[] m_catValues;

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public ComparisonOperator getComparisonOperator() {
        return this.m_compOperator;
    }

    public boolean isNumericalValue() {
        return this.m_numericalValue != null;
    }

    public Double getNumericalValue() {
        return this.m_numericalValue;
    }

    public Object[] getCategoryValues() {
        return this.m_catValues;
    }

    public OraSimplePredicate(OraConnection dmeConn, String attributeName, ComparisonOperator compOperator, Double numericalValue, Object[] catValues) throws JDMException {
        super(dmeConn);
        this.getValidationHandler().validateTableColumnName(attributeName, "attributeName");
        this.getValidationHandler().validateNotNull(compOperator, "compOperator");
        if (numericalValue != null) {
            if (catValues != null) {
                this.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_ARGUMENT, new Object[]{"numericalValue"}, null, "3518", new Object[]{"numericalValue", "catValues"});
            }
        } else if (catValues != null) {
            this.getValidationHandler().validateArray(catValues, "catValues");
            for (int i = 0; i < catValues.length; ++i) {
                this.getValidationHandler().validateCategory(catValues[i], "catValues[" + i + "]");
            }
        } else {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_NULL_ARGUMENT, new Object[]{"numericalValue"}, null, "3519", new Object[]{"numericalValue", "catValues"});
        }
        this.m_attributeName = attributeName;
        this.m_compOperator = compOperator;
        this.m_numericalValue = numericalValue;
        this.m_catValues = catValues;
    }

    public String toString() {
        if (this.m_numericalValue != null) {
            return this.m_attributeName + " " + this.convert(this.m_compOperator) + " " + this.m_numericalValue;
        }
        StringBuffer predicate = new StringBuffer();
        predicate.append(this.m_attributeName).append(' ');
        predicate.append(this.convert(this.m_compOperator));
        if (this.m_catValues.length > 1) {
            predicate.append(" {");
        }
        for (int i = 0; i < this.m_catValues.length; ++i) {
            predicate.append(' ').append(this.m_catValues[i].toString());
        }
        if (this.m_catValues.length > 1) {
            predicate.append(" }");
        }
        return predicate.toString();
    }

    private String convert(ComparisonOperator compOp) {
        if (compOp.equals((Object)ComparisonOperator.equal)) {
            return "=";
        }
        if (compOp.equals((Object)ComparisonOperator.greaterOrEqual)) {
            return ">=";
        }
        if (compOp.equals((Object)ComparisonOperator.greaterThan)) {
            return ">";
        }
        if (compOp.equals((Object)ComparisonOperator.in)) {
            return "is in";
        }
        if (compOp.equals((Object)ComparisonOperator.lessOrEqual)) {
            return "<=";
        }
        if (compOp.equals((Object)ComparisonOperator.lessThan)) {
            return "<";
        }
        if (compOp.equals((Object)ComparisonOperator.notEqual)) {
            return "!=";
        }
        if (compOp.equals((Object)ComparisonOperator.notIn)) {
            return "not is in";
        }
        return compOp.name();
    }
}

