/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.rule;

import javax.datamining.JDMException;
import javax.datamining.rule.Predicate;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.rule.OraPredicate;
import oracle.dmt.jdm.rule.OraRule;
import oracle.dmt.jdm.transform.binning.OraBinningTransform;
import oracle.dmt.jdm.transform.binning.OraBinningTransformImpl;

public class OraABNRule
extends OraRule {
    protected static String QRY_RULE_ANTECEDENT_ABN = "SELECT     rl_ant.attribute_name           attribute_name,    rl_ant.conditional_operator     cond_op,    Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value) predictor_val,    rl_ant.attribute_support        attribute_support,    rl_ant.attribute_confidence     attr_conf FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_abn(?))) a,    TABLE(a.antecedent) rl_ant    WHERE a.rule_id = ? ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_RULE_CONSEQUENT_ABN = "SELECT     rl_cons.attribute_name           attribute_name,    rl_cons.conditional_operator     cond_op,    Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value) predictor_val,    rl_cons.attribute_support        attribute_support,    rl_cons.attribute_confidence     attr_conf FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_abn(?))) a,    TABLE(a.consequent) rl_cons    WHERE a.rule_id = ?  ORDER BY rl_cons.attribute_confidence desc, rl_cons.attribute_support desc";
    protected static String QRY_DECODE_RULE_ANTECEDENT_ABN = "SELECT     rl_ant.attribute_name        attribute_name,    rl_ant.conditional_operator  cond_op,    Nvl(l.label, Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value))  predictor_val,    rl_ant.attribute_support     attribute_support,    rl_ant.attribute_confidence  attr_conf FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_abn(?))) a,    TABLE(a.antecedent) rl_ant,    label_view l   WHERE a.rule_id = ?   AND rl_ant.attribute_name = l.col (+)    AND (Nvl(rl_ant.attribute_str_value, rl_ant.attribute_num_value) = l.bin(+) )  ORDER BY attribute_name, cond_op, predictor_val";
    protected static String QRY_DECODE_RULE_CONSEQUENT_ABN = "SELECT     rl_cons.attribute_name        attribute_name,    rl_cons.conditional_operator  cond_op,    Nvl(l.label, Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value))  predictor_val,    rl_cons.attribute_support     attribute_support,    rl_cons.attribute_confidence  attr_conf FROM (SELECT *   FROM TABLE(dbms_data_mining.get_model_details_abn(?))) a,    TABLE(a.consequent) rl_cons,    label_view l    WHERE a.rule_id = ?   AND rl_cons.attribute_name = l.col (+)    AND (Nvl(rl_cons.attribute_str_value, rl_cons.attribute_num_value) = l.bin(+) )  ORDER BY rl_cons.attribute_confidence desc, rl_cons.attribute_support desc";

    public OraABNRule(OraConnection dmeConn, String modelName, int ruleId, double ruleSupport, double ruleConfidence, OraBinningTransform binningTransform) throws JDMException {
        super(dmeConn, modelName, ruleId, ruleSupport, ruleConfidence, binningTransform);
    }

    public Predicate getAntecedent() {
        if (this.m_antecedent != null) {
            return this.m_antecedent;
        }
        try {
            String query = null;
            if (this.m_Transform == null) {
                query = QRY_RULE_ANTECEDENT_ABN;
            } else {
                query = OraBinningTransformImpl.getUnbinningClause(((OraBinningTransform)this.m_Transform).getCategoricalBinTable(), ((OraBinningTransform)this.m_Transform).getNumericalBinTable());
                query = "WITH label_view AS ( " + query + " ) " + QRY_DECODE_RULE_ANTECEDENT_ABN;
            }
            this.m_antecedent = (OraPredicate)this.getPredicate(query);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraABNRule.getAntecedent: rule ID:" + this.m_ruleId, ex);
        }
        return this.m_antecedent;
    }

    public Predicate getConsequent() {
        if (this.m_consequent != null) {
            return this.m_consequent;
        }
        try {
            String query = null;
            if (this.m_Transform == null) {
                query = QRY_RULE_CONSEQUENT_ABN;
            } else {
                query = OraBinningTransformImpl.getUnbinningClause(((OraBinningTransform)this.m_Transform).getCategoricalBinTable(), ((OraBinningTransform)this.m_Transform).getNumericalBinTable());
                query = "WITH label_view AS ( " + query + " ) " + QRY_DECODE_RULE_CONSEQUENT_ABN;
            }
            this.m_consequent = (OraPredicate)this.getPredicate(query, true);
        }
        catch (Exception ex) {
            this.logTrace("Failed Operation: OraABNRule.getConsequent: rule ID:" + this.m_ruleId, ex);
        }
        return this.m_consequent;
    }
}

