/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.datamining.JDMException;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import oracle.dmt.jdm.OraMiningObject;
import oracle.dmt.jdm.OraNamedObject;
import oracle.dmt.jdm.base.OraBuildSettings;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraCapabilities;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.resource.OraPersistanceManager;
import oracle.dmt.jdm.supervised.OraTestMetrics;
import oracle.dmt.jdm.supervised.classification.OraCostMatrix;
import oracle.dmt.jdm.transform.OraTransformationSequenceImpl;
import oracle.dmt.jdm.utils.OraSQLUtils;
import oracle.dmt.jdm.utils.OraStringUtils;

public class OraPersistanceManagerImpl
extends OraCapabilities
implements OraPersistanceManager {
    private OraConnection m_dmeConn = null;
    private Connection m_dbConn = null;

    public OraPersistanceManagerImpl(OraConnection dmeConn) {
        this.m_dmeConn = dmeConn;
        this.m_dbConn = dmeConn.getDatabaseConnection();
    }

    public int getMaxNameLength() {
        return 25;
    }

    public int getMaxDescriptionLength() {
        return 128;
    }

    public String getDescription(String objectName, NamedObject objectType) throws JDMException {
        String description;
        block6: {
            this.m_dmeConn.getValidationHandler().validateNotNull(objectType, "objectType");
            String objName = this.m_dmeConn.getValidationHandler().validateObjectName(objectName, "objectName", objectType);
            description = null;
            HashMap repository = this.m_dmeConn.getRepository(objectType);
            if (repository == null) {
                try {
                    MiningObject obj;
                    if (NamedObject.buildSettings.equals((Object)objectType) || NamedObject.costMatrix.equals((Object)objectType) || NamedObject.testMetrics.equals((Object)objectType)) {
                        return this.getTableTypeObjectDescription(this.m_dmeConn, objName, objectType);
                    }
                    if (NamedObject.task.equals((Object)objectType) && (obj = this.m_dmeConn.retrieveObject(objName, objectType)) != null) {
                        return obj.getDescription();
                    }
                    break block6;
                }
                catch (SQLException sqlExp) {
                    JDMException jdmExp = new JDMException();
                    jdmExp.initCause((Throwable)sqlExp);
                    throw jdmExp;
                }
            }
            OraMiningObject object = (OraMiningObject)repository.get(objectName);
            if (object == null) {
                this.m_dmeConn.getExceptionHandler().createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new String[]{objectName}, null);
            }
            description = object.getDescription();
        }
        return description;
    }

    public void setDescription(String objectName, NamedObject objectType, String description) throws JDMException {
        String objName = this.m_dmeConn.getValidationHandler().validateObjectName(objectName, "objectName", objectType);
        this.m_dmeConn.getValidationHandler().validateNotNull(objectType, "objectType");
        this.m_dmeConn.getValidationHandler().validateDescription(description, "description");
        HashMap repository = this.m_dmeConn.getRepository(objectType);
        if (repository == null) {
            try {
                if (NamedObject.buildSettings.equals((Object)objectType) || NamedObject.costMatrix.equals((Object)objectType) || NamedObject.testMetrics.equals((Object)objectType)) {
                    this.setTableTypeObjectDescription(this.m_dmeConn, objName, description, objectType);
                }
                this.m_dmeConn.unsupported("setDescription");
            }
            catch (SQLException sqlExp) {
                JDMException jdmExp = new JDMException();
                jdmExp.initCause((Throwable)sqlExp);
                throw jdmExp;
            }
        } else {
            OraMiningObject object = (OraMiningObject)repository.get(objectName);
            if (object == null) {
                this.m_dmeConn.getExceptionHandler().createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new String[]{objectType.name(), objectName}, null);
            }
            object.setDescription(description);
        }
    }

    public synchronized void saveObject(String name, MiningObject object, boolean replace) throws JDMException {
        String objName = this.m_dmeConn.getValidationHandler().validateObjectName(name, "name", ((OraMiningObject)object).getObjectType());
        this.m_dmeConn.getValidationHandler().validateNotNull(object, "object");
        if (!(object instanceof OraMiningObject)) {
            this.m_dmeConn.createRuntimeException(OraJDMBundleKeys.JDMR_INVALID_OBJECT_TYPE, new String[]{name}, null);
        }
        OraMiningObject objectImpl = (OraMiningObject)object;
        NamedObject objectType = objectImpl.getObjectType();
        this.m_dmeConn.getValidationHandler().validateObjectType(objectType, "name", false);
        HashMap repository = this.m_dmeConn.getRepository(objectType);
        if (repository == null) {
            objectImpl.saveObjectInDatabase(this.m_dmeConn, objName, replace);
        } else {
            boolean doesExist = repository.containsKey(name);
            if (doesExist && !replace) {
                this.m_dmeConn.getExceptionHandler().createException(OraJDMBundleKeys.JDM_OBJECT_EXISTS, new String[]{"MiningObject", name}, null);
            }
            objectImpl.doBeforeStore(name);
            repository.put(OraStringUtils.getReplacedString(name, "'", "''"), objectImpl);
        }
    }

    public synchronized void removeObject(String name, NamedObject objectType) throws JDMException {
        try {
            if (this.m_dmeConn.doesObjectExist(name, objectType)) {
                String objName = this.m_dmeConn.getValidationHandler().validateObjectName(name, "name", objectType);
                this.m_dmeConn.getValidationHandler().validateObjectType(objectType, "objectType", true);
                HashMap repository = this.m_dmeConn.getRepository(objectType);
                if (repository == null) {
                    if (objectType.equals((Object)NamedObject.buildSettings)) {
                        OraBuildSettings.removeObjectFromDatabase(this.m_dmeConn, objName);
                    } else if (objectType.equals((Object)NamedObject.model)) {
                        OraModel.removeObjectFromDatabase(this.m_dmeConn, objName);
                    } else if (objectType.equals((Object)NamedObject.task)) {
                        OraTask.removeObjectFromDatabase(this.m_dmeConn, objName);
                    } else if (objectType.equals((Object)NamedObject.testMetrics)) {
                        OraTestMetrics.removeObjectFromDatabase(this.m_dmeConn, objName);
                    } else if (objectType.equals((Object)NamedObject.costMatrix)) {
                        OraCostMatrix.removeObjectFromDatabase(this.m_dmeConn, objName);
                    } else if (objectType.equals((Object)OraNamedObject.transformationSequence)) {
                        OraTransformationSequenceImpl.removeObjectFromDatabase(this.m_dmeConn, objName);
                    }
                } else {
                    OraMiningObject object = (OraMiningObject)repository.remove(name);
                    if (object == null) {
                        this.m_dmeConn.createRuntimeException("2000", new Object[]{"remove"}, null);
                    }
                }
            } else {
                this.m_dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new String[]{objectType.name(), name}, null);
            }
        }
        catch (SQLException sqlExp) {
            if (sqlExp.getErrorCode() == 942) {
                // empty if block
            }
            this.m_dmeConn.createException("2000", new String[]{"removeObject"}, sqlExp);
        }
    }

    public synchronized void renameObject(String oldName, String newName, NamedObject objectType) throws JDMException {
        this.m_dmeConn.getValidationHandler().validateNotNull(oldName, "oldName");
        this.m_dmeConn.getValidationHandler().validateNotNull(newName, "newName");
        String objOldName = this.m_dmeConn.getValidationHandler().validateObjectName(oldName, "oldName", objectType);
        String objNewName = this.m_dmeConn.getValidationHandler().validateObjectName(newName, "newName", objectType);
        try {
            HashMap repository = this.m_dmeConn.getRepository(objectType);
            if (repository == null) {
                if (objectType.equals((Object)NamedObject.buildSettings)) {
                    OraBuildSettings.renameObjectInDatabase(this.m_dmeConn, objOldName, objNewName);
                } else if (objectType.equals((Object)NamedObject.model)) {
                    OraModel.renameObjectInDatabase(this.m_dmeConn, objOldName, objNewName);
                } else if (objectType.equals((Object)NamedObject.task)) {
                    OraTask.renameObjectInDatabase(this.m_dmeConn, objOldName, objNewName);
                } else if (objectType.equals((Object)NamedObject.testMetrics)) {
                    OraTestMetrics.renameObjectInDatabase(this.m_dmeConn, objOldName, objNewName);
                } else if (objectType.equals((Object)NamedObject.costMatrix)) {
                    OraCostMatrix.renameObjectInDatabase(this.m_dmeConn, objOldName, objNewName);
                } else if (objectType.equals((Object)OraNamedObject.transformationSequence)) {
                    OraTransformationSequenceImpl.renameObjectInDatabase(this.m_dmeConn, objOldName, objNewName);
                }
            } else {
                OraMiningObject object = (OraMiningObject)repository.remove(oldName);
                if (object == null) {
                    this.m_dmeConn.createRuntimeException("2000", new Object[]{"renameObject"}, null);
                }
                repository.put(newName, object);
            }
        }
        catch (SQLException sqlExp) {
            if (sqlExp.getErrorCode() == 942) {
                // empty if block
            }
            this.m_dmeConn.createException("2000", new String[]{"renameObject"}, sqlExp);
        }
    }

    private synchronized void setTableTypeObjectDescription(OraConnection dmeConn, String name, String description, NamedObject objectType) throws JDMException, SQLException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        if (OraSQLUtils.doesTableOrViewExists(dbConn, name)) {
            String comments = OraSQLUtils.getComments(dbConn, name);
            if (comments != null) {
                String[] splits = comments.split(";Description:");
                comments = splits[0] + ";Description:" + description;
                OraSQLUtils.setComments(dbConn, name, comments);
            }
        } else {
            dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{objectType.name(), name}, null);
        }
    }

    private String getTableTypeObjectDescription(OraConnection dmeConn, String name, NamedObject objectType) throws JDMException, SQLException {
        Connection dbConn = dmeConn.getDatabaseConnection();
        if (OraSQLUtils.doesTableOrViewExists(dbConn, name)) {
            String comments = OraSQLUtils.getComments(dbConn, name);
            if (comments != null) {
                String[] splits = comments.split(";Description:");
                if (splits.length > 1) {
                    return splits[1];
                }
                return null;
            }
            return null;
        }
        dmeConn.createException(OraJDMBundleKeys.JDM_OBJECT_NOT_FOUND, new Object[]{objectType.name(), name}, null);
        return null;
    }
}

