/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.resource;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.datamining.Enum;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionStatus;
import javax.datamining.Factory;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningFunction;
import javax.datamining.MiningObject;
import javax.datamining.MiningTask;
import javax.datamining.NamedObject;
import javax.datamining.base.Task;
import javax.datamining.resource.Connection;
import javax.datamining.resource.ConnectionMetaData;
import javax.datamining.resource.ConnectionSpec;
import javax.datamining.resource.PersistenceOption;
import oracle.dmt.jdm.OraFactory;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.OraMiningTask;
import oracle.dmt.jdm.OraPLSQLMappings;
import oracle.dmt.jdm.base.OraTask;
import oracle.dmt.jdm.rbundle.OraJDMBundleKeys;
import oracle.dmt.jdm.resource.OraExceptionHandler;
import oracle.dmt.jdm.resource.OraLookupManager;
import oracle.dmt.jdm.resource.OraPersistanceManager;
import oracle.dmt.jdm.resource.OraSupportManager;
import oracle.dmt.jdm.resource.OraTaskManager;
import oracle.dmt.jdm.resource.OraValidationHandler;
import oracle.gss.util.NLSLocale;

public class OraConnection
implements Connection {
    private java.sql.Connection m_dbConn = null;
    private OraPersistanceManager m_persistMgr = null;
    private OraSupportManager m_supportMgr = null;
    private OraTaskManager m_taskMgr = null;
    private OraLookupManager m_lookupMgr = null;
    private ConnectionSpec m_cSpec = null;
    private Logger m_jdmLogger = null;
    private Locale m_locale = Locale.getDefault();
    private OraValidationHandler m_validationHandler = null;
    private OraExceptionHandler m_exceptionHandler = null;
    private boolean isOpen = true;
    private OraConnectionMetaData m_connMetaData = null;
    private Boolean m_is102 = null;
    private HashMap[] m_inMemoryRepository = null;
    private static final NamedObject[] IN_MEMORY_OBJECTS = new NamedObject[]{NamedObject.applySettings, NamedObject.physicalDataSet};

    OraConnection(java.sql.Connection dbConn, ConnectionSpec cSpec) throws JDMException {
        this.m_dbConn = dbConn;
        this.m_cSpec = cSpec;
        this.setupInMemoryRepository();
        this.factorDM();
        this.validatePrivileges();
        this.isOpen = true;
    }

    private void setupInMemoryRepository() {
        this.m_inMemoryRepository = new HashMap[IN_MEMORY_OBJECTS.length];
        for (int i = 0; i < IN_MEMORY_OBJECTS.length; ++i) {
            this.m_inMemoryRepository[i] = new HashMap();
        }
    }

    HashMap getRepository(NamedObject objectType) {
        HashMap repository = null;
        for (int i = 0; i < IN_MEMORY_OBJECTS.length; ++i) {
            if (!IN_MEMORY_OBJECTS[i].equals((Object)objectType)) continue;
            repository = this.m_inMemoryRepository[i];
            break;
        }
        return repository;
    }

    private void factorDM() throws JDMException {
    }

    private void validatePrivileges() throws JDMException {
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() throws JDMException {
        if (this.m_dbConn != null && this.isOpen) {
            try {
                this.m_dbConn.close();
            }
            catch (Exception anyExp) {
                this.createException(OraJDMBundleKeys.JDM_CONNECTION_CLOSE_FAILED, new Object[]{"Oracle Database"}, anyExp);
            }
        }
        this.isOpen = false;
    }

    public Factory getFactory(String objectName) throws JDMException {
        boolean skipReplacing = false;
        if (!objectName.startsWith("javax.datamining.")) {
            if (objectName.startsWith("oracle.dmt.jdm")) {
                skipReplacing = true;
            } else {
                throw new JDMException(1, "TBD");
            }
        }
        StringBuffer strBuf = null;
        if (!skipReplacing) {
            strBuf = new StringBuffer(objectName);
            strBuf.replace(0, 16, "oracle.dmt.jdm");
            int nlastDot = strBuf.lastIndexOf(".");
            strBuf.insert(nlastDot + 1, "Ora");
            strBuf.append("Factory");
        } else {
            strBuf = new StringBuffer(objectName);
            strBuf.append("FactoryImpl");
        }
        OraFactory factory = null;
        String factoryName = strBuf.toString();
        try {
            Class<?> jdmClass = Class.forName(factoryName);
            factory = (OraFactory)jdmClass.newInstance();
            factory.setConnection(this);
            return factory;
        }
        catch (ClassNotFoundException noFoundExp) {
            throw new JDMException(1, noFoundExp.getMessage());
        }
        catch (InstantiationException factoryCreation1Failed1) {
            throw new JDMException(1, factoryCreation1Failed1.getMessage());
        }
        catch (IllegalAccessException factoryCreation1Failed2) {
            throw new JDMException(1, factoryCreation1Failed2.getMessage());
        }
    }

    public ConnectionMetaData getMetaData() {
        if (this.m_connMetaData == null) {
            this.m_connMetaData = new OraConnectionMetaData(this);
        }
        return this.m_connMetaData;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.m_cSpec;
    }

    public MiningFunction[] getSupportedFunctions() {
        return this.m_supportMgr.getSupportedFunctions();
    }

    public MiningAlgorithm[] getSupportedAlgorithms(MiningFunction function) throws JDMException {
        return this.m_supportMgr.getSupportedAlgorithms(function);
    }

    public boolean supportsCapability(MiningFunction function, MiningAlgorithm algorithm, MiningTask taskType) throws JDMException {
        return this.m_supportMgr.supportsCapability(function, algorithm, taskType);
    }

    public boolean supportsCapability(NamedObject object, PersistenceOption persistence) throws JDMException {
        return this.m_supportMgr.supportsCapability(object, persistence);
    }

    public NamedObject[] getNamedObjects(PersistenceOption persistenceOption) {
        return this.m_supportMgr.getNamedObjects(persistenceOption);
    }

    public int getMaxNameLength() {
        return this.m_persistMgr.getMaxNameLength();
    }

    public int getMaxDescriptionLength() {
        return this.m_persistMgr.getMaxDescriptionLength();
    }

    public String getDescription(String objectName, NamedObject objectType) throws JDMException {
        return this.m_persistMgr.getDescription(objectName, objectType);
    }

    public void setDescription(String objectName, NamedObject objectType, String description) throws JDMException {
        this.m_persistMgr.setDescription(objectName, objectType, description);
    }

    public void saveObject(String name, MiningObject object, boolean replace) throws JDMException {
        this.m_persistMgr.saveObject(name, object, replace);
    }

    public void removeObject(String name, NamedObject objectType) throws JDMException {
        this.m_persistMgr.removeObject(name, objectType);
    }

    public void renameObject(String oldName, String newName, NamedObject objectType) throws JDMException {
        this.m_persistMgr.renameObject(oldName, newName, objectType);
    }

    public MiningObject retrieveObject(String name, NamedObject objectType) throws JDMException {
        return this.m_lookupMgr.retrieveObject(name, objectType);
    }

    public MiningObject retrieveObject(String objectIdentifier) throws JDMException {
        return this.m_lookupMgr.retrieveObject(objectIdentifier);
    }

    public Collection retrieveObjects(Date createdAfter, Date createdBefore, NamedObject objectType) throws JDMException {
        return this.m_lookupMgr.retrieveObjects(createdAfter, createdBefore, objectType);
    }

    public Collection retrieveObjects(Date createdAfter, Date createdBefore, NamedObject objectType, Enum minorType) throws JDMException {
        return this.m_lookupMgr.retrieveObjects(objectType, minorType, createdAfter, createdBefore);
    }

    public Collection getObjectNames(NamedObject objectType) throws JDMException {
        return this.m_lookupMgr.getObjectNames(objectType);
    }

    public Collection getObjectNames(Date createdAfter, Date createdBefore, NamedObject objectType) throws JDMException {
        return this.m_lookupMgr.getObjectNames(createdAfter, createdBefore, objectType);
    }

    public Collection getObjectNames(Date createdAfter, Date createdBefore, NamedObject objectType, Enum minorType) throws JDMException {
        return this.m_lookupMgr.getObjectNames(objectType, minorType, createdAfter, createdBefore);
    }

    public Collection getModelNames(MiningFunction function, MiningAlgorithm algorithm, Date createdAfter, Date createdBefore) throws JDMException {
        return this.m_lookupMgr.getModelNames(function, algorithm, createdAfter, createdBefore);
    }

    public ResultSet getObjectNames(String schemaPattern, NamedObject objectType, String objectNamePattern, Enum minorType_1, Enum minorType_2) {
        String owner = schemaPattern == null ? null : this.m_validationHandler.validateTableColumnName(schemaPattern, "schemaPattern");
        String objectName = objectNamePattern == null && objectType == null ? null : this.m_validationHandler.validateObjectName(objectNamePattern, "objectNamePattern", objectType);
        String col_1_schema_name = " SCHEMA_NAME ";
        String col_2_type = " TYPE ";
        String col_3_name = " NAME ";
        String col_4_minor_type_1 = " MINOR_TYPE_1 ";
        String col_5_minor_type_2 = " MINOR_TYPE_2 ";
        String col_6_creation_date = " CREATION_DATE ";
        String col_7_description = " DESCRIPTION ";
        StringBuffer sqlQry = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        if (NamedObject.buildSettings.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.buildSettings.name() + "' as " + col_2_type).append(", t2.table_name as " + col_3_name).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END AS " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN NULL ELSE substr(t2.comments, (REGEXP_INSTR(t2.comments, '(;Description:)')+13), length(t2.comments)) END as " + col_7_description).append(" from ALL_OBJECTS t1, ALL_TAB_COMMENTS t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.table_name and t2.comments like 'BS_%' ").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction ? " and CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END = ? " : "").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
            if (objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction) {
                paramList.add(minorType_1.name());
            }
        }
        if (NamedObject.costMatrix.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.costMatrix.name() + "' as " + col_2_type).append(", t2.table_name as " + col_3_name).append(", NULL AS " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN NULL ELSE substr(t2.comments, (REGEXP_INSTR(t2.comments, '(;Description:)')+13), length(t2.comments)) END as " + col_7_description).append(" from ALL_OBJECTS t1, ALL_TAB_COMMENTS t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.table_name and t2.comments like 'CM_%' ").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
        }
        if (NamedObject.testMetrics.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.testMetrics.name() + "' as " + col_2_type).append(", t2.table_name as " + col_3_name).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END AS " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN NULL ELSE substr(t2.comments, (REGEXP_INSTR(t2.comments, '(;Description:)')+13), length(t2.comments)) END as " + col_7_description).append(" from ALL_OBJECTS t1, ALL_TAB_COMMENTS t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.table_name and t2.comments like 'TM_%' ").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction ? " and CASE REGEXP_INSTR(t2.comments, '(;Description:)') WHEN 0 THEN substr(t2.comments, 4, length(t2.comments)) ELSE substr(t2.comments, 4, (REGEXP_INSTR(t2.comments, '(;Description:)')-4)) END = ? " : "").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
            if (objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction) {
                paramList.add(minorType_1.name());
            }
        }
        if (NamedObject.task.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t2.owner as " + col_1_schema_name).append(", '" + NamedObject.task.name() + "' as " + col_2_type).append(", t2.job_name as " + col_3_name).append(", CASE 'SYS.' || t2.program_name WHEN 'SYS.JDM_BUILD_PROGRAM' THEN '" + MiningTask.buildTask.name()).append("'   WHEN 'SYS.JDM_TEST_PROGRAM' THEN '" + MiningTask.testTask.name()).append("'   WHEN 'SYS.JDM_SQL_APPLY_PROGRAM' THEN '" + MiningTask.applyTask.name()).append("'   WHEN 'SYS.JDM_XFORM_PROGRAM' THEN '" + OraMiningTask.transformTask.name()).append("'   WHEN 'SYS.JDM_IMPORT_PROGRAM' THEN '" + MiningTask.importTask.name()).append("'   WHEN 'SYS.JDM_EXPORT_PROGRAM' THEN '" + MiningTask.exportTask.name()).append("'   WHEN 'SYS.JDM_PREDICT_PROGRAM' THEN '" + OraMiningTask.predictTask.name()).append("'   WHEN 'SYS.JDM_EXPLAIN_PROGRAM' THEN '" + OraMiningTask.explainTask.name()).append("'   ELSE 'UNKNOWN' END as " + col_4_minor_type_1).append(", NULL AS " + col_5_minor_type_2).append(", t1.created as " + col_6_creation_date).append(", t2.comments as " + col_7_description).append(" from ALL_OBJECTS t1, all_scheduler_jobs t2 WHERE ").append(owner == null ? "" : " t1.owner like ? and ").append("t1.object_type='JOB' and ").append(objectName == null ? "" : " t1.object_name like ? and ").append(" t1.object_name = t2.job_name ").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningTask ? " and t2.program_name = '" + OraTask.getProgramName((MiningTask)minorType_1) + "' " : "").append(objectName == null ? " and t2.program_name like 'JDM%' " : "").append(objectType == null ? " UNION ALL " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
            if (objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction) {
                paramList.add(minorType_1.name());
            }
        }
        if (NamedObject.model.equals((Object)objectType) || objectType == null) {
            sqlQry.append("select t1.owner as " + col_1_schema_name).append(", '" + NamedObject.model.name() + "' as " + col_2_type).append(", t1.Model_NAME as " + col_3_name).append(", CASE t1.mining_function WHEN 'CLASSIFICATION' THEN '" + MiningFunction.classification.name()).append("'   WHEN 'REGRESSION' THEN '" + MiningFunction.regression.name()).append("'   WHEN 'ATTRIBUTE_IMPORTANCE' THEN '" + MiningFunction.attributeImportance.name()).append("'   WHEN 'ASSOCIATION' THEN '" + MiningFunction.association.name()).append("'   WHEN 'CLUSTERING' THEN '" + MiningFunction.clustering.name()).append("'   WHEN 'FEATURE_EXTRACTION' THEN '" + OraMiningFunction.featureExtraction.name()).append("'   ELSE t1.mining_function END as " + col_4_minor_type_1).append(", CASE t1.algorithm WHEN '" + "ALGO_ADAPTIVE_BAYES_NETWORK".substring(5) + "' THEN '" + OraMiningAlgorithm.adaptiveBayesNetwork.name()).append("'   WHEN '" + "ALGO_DECISION_TREE".substring(5) + "' THEN '" + MiningAlgorithm.decisionTree.name()).append("'   WHEN '" + "ALGO_NAIVE_BAYES".substring(5) + "' THEN '" + MiningAlgorithm.naiveBayes.name()).append("'   WHEN '" + "ALGO_SUPPORT_VECTOR_MACHINES".substring(5) + "' THEN CASE t1.mining_function WHEN '" + "CLASSIFICATION" + "' THEN '" + MiningAlgorithm.svmClassification.name() + "' ELSE '" + MiningAlgorithm.svmRegression.name() + "' END ").append("   WHEN '" + "ALGO_MINIMUM_DESCRIPTION_LENGTH".substring(5) + "' THEN '" + OraMiningAlgorithm.minimumDescriptionLength.name()).append("'   WHEN '" + "ALGO_APRIORI_ASSOCIATION_RULES".substring(5) + "' THEN '" + OraMiningAlgorithm.aprioriAssociationRules.name()).append("'   WHEN '" + "ALGO_KMEANS".substring(5) + "' THEN '" + MiningAlgorithm.kMeans.name()).append("'   WHEN '" + "ALGO_NONNEGATIVE_MATRIX_FACTOR".substring(5) + "' THEN '" + OraMiningAlgorithm.nonNegativeMatrixFactorization.name()).append("'   WHEN '" + "ALGO_O_CLUSTER".substring(5) + "' THEN '" + OraMiningAlgorithm.oCluster.name()).append("'   ELSE t1.algorithm END AS " + col_5_minor_type_2).append(", t1.CREATION_DATE as " + col_6_creation_date).append(", t1.comments as " + col_7_description).append(" from all_mining_models t1 ").append(owner == null && objectName == null && minorType_1 == null && minorType_2 == null ? "" : "  WHERE ").append(owner == null ? "" : " t1.owner like ? ").append(owner != null && objectName != null ? " and " : "").append(objectName == null ? "" : " t1.model_name like ? ").append((owner != null || objectName != null) && minorType_1 != null ? " and " : "").append(objectType != null && minorType_1 != null && minorType_1 instanceof MiningFunction ? " t1.mining_function = '" + OraPLSQLMappings.getPLSQLConstant((MiningFunction)minorType_1) + "' " : "").append((owner != null || objectName != null || minorType_1 != null) && minorType_2 != null ? " and " : "").append(objectType != null && minorType_2 != null && minorType_2 instanceof MiningAlgorithm ? " t1.algorithm = '" + OraPLSQLMappings.getPLSQLConstant((MiningAlgorithm)minorType_2).substring(5) + "' " : "");
            if (owner != null) {
                paramList.add(owner);
            }
            if (objectName != null) {
                paramList.add(objectName);
            }
        }
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = this.m_dbConn.prepareStatement(sqlQry.toString());
            for (int i = 0; i < paramList.size(); ++i) {
                pStmt.setString(i + 1, (String)paramList.get(i));
            }
            rs = pStmt.executeQuery();
            return rs;
        }
        catch (SQLException sqlExp) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            this.createRuntimeException(OraJDMBundleKeys.JDMR_RUNTIME_GENERIC_ERROR, null, sqlExp);
            return null;
        }
    }

    public Date getCreationDate(String objectName, NamedObject objectType) throws JDMException {
        return this.m_lookupMgr.getCreationDate(objectName, objectType);
    }

    public Collection retrieveModelObjects(MiningFunction function, MiningAlgorithm algorithm, Date createdAfter, Date createdBefore) throws JDMException {
        return this.m_lookupMgr.retrieveModelObjects(function, algorithm, createdAfter, createdBefore);
    }

    public ExecutionHandle getLastExecutionHandle(String taskName) throws JDMException {
        return this.m_lookupMgr.getLastExecutionHandle(taskName);
    }

    public ExecutionHandle[] getExecutionHandles(String taskName) throws JDMException {
        return this.m_lookupMgr.getExecutionHandles(taskName);
    }

    public ExecutionHandle execute(String taskName) throws JDMException {
        return this.m_taskMgr.execute(taskName);
    }

    public ExecutionStatus execute(Task task, Long timeout) throws JDMException {
        return this.m_taskMgr.execute(task, timeout);
    }

    public void requestModelLoad(String modelName) throws JDMException {
    }

    public void requestModelUnload(String modelName) throws JDMException {
    }

    public void requestDataLoad(String dataURI) throws JDMException {
    }

    public void requestDataUnload(String dataURI) throws JDMException {
    }

    public String[] getLoadedModels() {
        return null;
    }

    public String[] getLoadedData() throws JDMException {
        return null;
    }

    public boolean doesObjectExist(String objectName, NamedObject objectType) throws JDMException {
        return this.m_lookupMgr.doesObjectExist(objectName, objectType);
    }

    public void setLogger(Logger jdmLogger) {
        this.m_jdmLogger = jdmLogger;
    }

    public Logger getLogger() {
        return this.m_jdmLogger;
    }

    public void registerPersistanceManager(OraPersistanceManager persistMgr) {
        this.m_persistMgr = persistMgr;
    }

    public void registerTasktManager(OraTaskManager taskMgr) {
        this.m_taskMgr = taskMgr;
    }

    public void registerLookupManager(OraLookupManager lookupMgr) {
        this.m_lookupMgr = lookupMgr;
    }

    public void registerSupportManager(OraSupportManager supportMgr) {
        this.m_supportMgr = supportMgr;
    }

    public void registerHandlers(OraExceptionHandler exceptionHandler, OraValidationHandler validationHandler) {
        this.m_validationHandler = validationHandler;
        this.m_exceptionHandler = exceptionHandler;
        this.m_validationHandler.setExceptionHandler(exceptionHandler);
    }

    public java.sql.Connection getDatabaseConnection() {
        return this.m_dbConn;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) throws JDMException {
        this.m_validationHandler.validateNotNull(locale, "locale");
        this.m_locale = locale;
        try {
            this.setDBLocale(locale);
        }
        catch (Exception exp) {
            this.createException(OraJDMBundleKeys.JDM_GENERIC_ERROR, null, exp);
        }
        this.m_validationHandler.setLocale(this.m_locale);
        this.m_exceptionHandler.setLocale(this.m_locale);
    }

    public OraValidationHandler getValidationHandler() {
        return this.m_validationHandler;
    }

    public String getLocalizedMessage(String errorCode, Object[] params) {
        return this.m_exceptionHandler.getLocalizedMessage(errorCode, params);
    }

    public OraExceptionHandler getExceptionHandler() {
        return this.m_exceptionHandler;
    }

    public void createException(String errorCode, Object[] params, Throwable cause) throws JDMException {
        this.m_exceptionHandler.createException(errorCode, params, cause);
    }

    public void createRuntimeException(String errorCode, Object[] params, Throwable cause) {
        this.m_exceptionHandler.createRuntimeException(errorCode, params, cause);
    }

    public void createException(String errorCode, Object[] jdmMsgparams, Throwable cause, String vendorCode, Object[] vendorMsgParams) throws JDMException {
        this.m_exceptionHandler.createException(errorCode, jdmMsgparams, cause, vendorCode, vendorMsgParams);
    }

    public void createRuntimeException(String errorCode, Object[] jdmMsgparams, Throwable cause, String vendorCode, Object[] vendorMsgParams) {
        this.m_exceptionHandler.createRuntimeException(errorCode, jdmMsgparams, cause, vendorCode, vendorMsgParams);
    }

    public void unsupported(String featureName) {
        this.unsupported(featureName, "-1", null);
    }

    public void unsupported(String featureName, String featureDescriptionErrorCode, Object[] featureDescriptionParameters) {
        String featureDescription = "";
        if (featureDescriptionErrorCode == "-1") {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{featureName, featureDescription}, null);
        } else {
            this.createRuntimeException(OraJDMBundleKeys.JDMR_UNSUPPORTED_FEATURE, new String[]{featureName, featureDescription}, null, featureDescriptionErrorCode, featureDescriptionParameters);
        }
    }

    public boolean is102() {
        if (this.m_is102 == null) {
            this.getMetaData();
            String dmeVersion = this.m_connMetaData.getProviderDMEVersion();
            this.m_is102 = dmeVersion.indexOf("10.2") != -1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.m_is102;
    }

    public boolean isVersion(String versionNumber) {
        this.getMetaData();
        String dmeVersion = this.m_connMetaData.getProviderDMEVersion();
        return dmeVersion.indexOf(versionNumber) != -1;
    }

    public int getPatchsetVersion(String baseVersion) {
        this.getMetaData();
        String dmeVersion = this.m_connMetaData.getProviderDMEVersion();
        int versionIndex = dmeVersion.indexOf(baseVersion);
        int versionLength = baseVersion.length();
        if (versionIndex == -1) {
            return -1;
        }
        return Integer.parseInt(dmeVersion.substring(versionIndex + versionLength, versionIndex + versionLength + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDBLocale(Locale locale) throws SQLException {
        NLSLocale dbLocale = NLSLocale.getInstance();
        String nlsLang = dbLocale.getNLSLanguage(locale);
        String nlsTerritory = dbLocale.getNLSTerritory(locale);
        String alter_lang_qry = "ALTER SESSION SET NLS_LANGUAGE = '" + nlsLang + "'";
        String alter_territory_qry = "ALTER SESSION SET NLS_TERRITORY = '" + nlsTerritory + "'";
        PreparedStatement pStmtLang = null;
        PreparedStatement pStmtTerritory = null;
        try {
            pStmtLang = this.m_dbConn.prepareStatement(alter_lang_qry);
            pStmtLang.execute();
        }
        finally {
            if (pStmtLang != null) {
                pStmtLang.close();
            }
        }
        try {
            pStmtTerritory = this.m_dbConn.prepareStatement(alter_territory_qry);
            pStmtTerritory.execute();
        }
        finally {
            if (pStmtTerritory != null) {
                pStmtTerritory.close();
            }
        }
    }

    private static class OraConnectionMetaData
    implements ConnectionMetaData {
        private static final String JDM_API_VERSION = "JDM 1.1";
        private static final int MAJOR_VERSION_NUMBER = 1;
        private static final int MINOR_VERSION_NUMBER = 1;
        private static final String PROVIDER_NAME = "Oracle Corporation";
        private static final String PROVIDER_VERSION = "11.2.0.0.0 - Development";
        private String m_dmeVersion = null;
        private OraConnection m_dmeConn = null;

        OraConnectionMetaData(OraConnection dmeConn) {
            this.m_dmeConn = dmeConn;
        }

        public String getVersion() {
            return JDM_API_VERSION;
        }

        public int getMajorVersion() {
            return 1;
        }

        public int getMinorVersion() {
            return 1;
        }

        public String getProviderName() {
            return PROVIDER_NAME;
        }

        public String getProviderVersion() {
            return PROVIDER_VERSION;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getProviderDMEVersion() {
            if (this.m_dmeVersion == null) {
                PreparedStatement pStmt = null;
                ResultSet rs = null;
                String banner = null;
                java.sql.Connection dbConn = this.m_dmeConn.getDatabaseConnection();
                try {
                    pStmt = dbConn.prepareStatement("select * from ALL_REGISTRY_BANNERS where banner like '%Database Catalog%'");
                    rs = pStmt.executeQuery();
                    rs.next();
                    banner = rs.getString(1);
                }
                catch (SQLException sqlExp) {
                    sqlExp.printStackTrace();
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e1) {}
                    try {
                        if (pStmt != null) {
                            pStmt.close();
                        }
                    }
                    catch (SQLException e2) {}
                }
                this.m_dmeVersion = banner;
            }
            return this.m_dmeVersion;
        }
    }
}

